/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.access.external.rest.v2.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.access.external.rest.AccessExternalConfiguration;
import fr.gouv.vitam.access.internal.client.AccessInternalClient;
import fr.gouv.vitam.access.internal.client.AccessInternalClientFactory;
import fr.gouv.vitam.access.internal.common.exception.AccessInternalClientServerException;
import fr.gouv.vitam.common.dsl.schema.validator.SelectMultipleSchemaValidator;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.dip.DataObjectVersions;
import fr.gouv.vitam.common.model.export.ExportRequest;
import fr.gouv.vitam.common.model.export.dip.DipRequest;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.common.security.rest.SecureEndpointRegistry;
import fr.gouv.vitam.common.security.rest.Secured;
import fr.gouv.vitam.common.security.rest.Unsecured;
import fr.gouv.vitam.common.server.application.resources.ApplicationStatusResource;
import fr.gouv.vitam.common.utils.SupportedSedaVersions;
import fr.gouv.vitam.utils.SecurityProfilePermissions;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/access-external/v2")
@Tag(name="Access")
public class AccessExternalResourceV2
extends ApplicationStatusResource {
    private static final String PREDICATES_FAILED_EXCEPTION = "Predicates Failed Exception ";
    private static final String ACCESS_EXTERNAL_MODULE = "ACCESS_EXTERNAL";
    private static final String CODE_VITAM = "code_vitam";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AccessExternalResourceV2.class);
    private final SecureEndpointRegistry secureEndpointRegistry;
    private final AccessInternalClientFactory accessInternalClientFactory;
    private final AccessExternalConfiguration configuration;

    public AccessExternalResourceV2(SecureEndpointRegistry secureEndpointRegistry, AccessExternalConfiguration configuration) {
        this(secureEndpointRegistry, AccessInternalClientFactory.getInstance(), configuration);
    }

    public AccessExternalResourceV2(SecureEndpointRegistry secureEndpointRegistry, AccessInternalClientFactory accessInternalClientFactory, AccessExternalConfiguration configuration) {
        this.secureEndpointRegistry = secureEndpointRegistry;
        this.accessInternalClientFactory = accessInternalClientFactory;
        this.configuration = configuration;
        LOGGER.debug("AccessExternalResourceV2 initialized");
    }

    @Path(value="/")
    @OPTIONS
    @Produces(value={"application/json"})
    @Unsecured
    public Response listResourceEndpoints() {
        String resourcePath = AccessExternalResourceV2.class.getAnnotation(Path.class).value();
        List securedEndpointList = this.secureEndpointRegistry.getEndPointsByResourcePath(resourcePath);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)securedEndpointList).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/dipexport")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.DIPEXPORTV2_CREATE, description="G\u00e9n\u00e9rer le DIP \u00e0 partir d'un DSL")
    public Response exportDIP(DipRequest dipRequest) {
        try (AccessInternalClient client = this.accessInternalClientFactory.getClient();){
            SanityChecker.checkJsonAll((JsonNode)dipRequest.getDslRequest());
            DataObjectVersions exportDipGotParams = dipRequest.getDataObjectVersionToExport();
            if (exportDipGotParams != null && exportDipGotParams.dataHasBeenSetTwice()) {
                throw new InvalidParseOperationException("Malformed request, DIP export handles only one of dataObjectVersions or dataObjectVersionsPatterns");
            }
            SelectMultipleSchemaValidator validator = new SelectMultipleSchemaValidator();
            validator.validate(dipRequest.getDslRequest());
            if (dipRequest.getSedaVersion() != null && !SupportedSedaVersions.isSedaVersionValid((String)dipRequest.getSedaVersion())) {
                Response response = Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity(this.getErrorEntity(Response.Status.PRECONDITION_FAILED, "The Seda version is invalid!")).build();
                return response;
            }
            RequestResponse response = client.exportByUsageFilter(ExportRequest.from((DipRequest)dipRequest));
            if (response.isOk()) {
                Response response2 = Response.status((int)Response.Status.ACCEPTED.getStatusCode()).entity((Object)response).build();
                return response2;
            }
            Response response3 = response.toResponse();
            return response3;
        }
        catch (AccessInternalClientServerException e) {
            LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity(this.getErrorEntity(Response.Status.PRECONDITION_FAILED, e.getLocalizedMessage())).build();
        }
        catch (Exception e) {
            LOGGER.error("Technical Exception ", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getLocalizedMessage())).build();
        }
    }

    @Deprecated
    private VitamError<JsonNode> getErrorEntity(Response.Status status, String message) {
        String aMessage = message != null && !message.trim().isEmpty() ? message : (status.getReasonPhrase() != null ? status.getReasonPhrase() : status.name());
        return new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ACCESS_EXTERNAL_MODULE).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(aMessage);
    }
}

