/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.access.external.rest;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.access.internal.client.AccessInternalClient;
import fr.gouv.vitam.access.internal.client.AccessInternalClientFactory;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.parser.request.single.SelectParserSingle;
import fr.gouv.vitam.common.dsl.schema.Dsl;
import fr.gouv.vitam.common.dsl.schema.DslSchema;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.exception.AccessUnauthorizedException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.common.security.rest.Secured;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.utils.SecurityProfilePermissions;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/access-external/v1")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ApplicationPath(value="webresources")
@Tag(name="Access")
public class LogbookExternalResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogbookExternalResource.class);
    private static final String INVALID_ARGUMENT = "Invalid argument: ";
    private static final String CONTRACT_ACCESS_DOES_NOT_ALLOW = "Contract access does not allow ";
    private final AccessInternalClientFactory accessInternalClientFactory;

    public LogbookExternalResource() {
        this(AccessInternalClientFactory.getInstance());
    }

    public LogbookExternalResource(AccessInternalClientFactory accessInternalClientFactory) {
        this.accessInternalClientFactory = accessInternalClientFactory;
        LOGGER.debug("LogbookExternalResource initialized");
    }

    @GET
    @Path(value="/logbookoperations")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.LOGBOOKOPERATIONS_READ, description="Lister toutes les op\u00e9rations")
    public Response selectOperation(@Dsl(value=DslSchema.SELECT_SINGLE) JsonNode query) {
        Response response;
        block10: {
            AccessInternalClient client = this.accessInternalClientFactory.getClient();
            try {
                SanityChecker.checkJsonAll((JsonNode)query);
                RequestResponse result = client.selectOperation(query, true, true);
                int st = result.isOk() ? Response.Status.OK.getStatusCode() : result.getHttpCode();
                response = Response.status((int)st).entity((Object)result).build();
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (LogbookClientException e) {
                    LOGGER.error("Client exception while trying to search operations: ", (Throwable)e);
                    Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
                    return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_OPERATION_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(INVALID_ARGUMENT, (Throwable)e);
                    Response.Status status = Response.Status.PRECONDITION_FAILED;
                    return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_OPERATION_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
                }
                catch (AccessUnauthorizedException e) {
                    LOGGER.error(CONTRACT_ACCESS_DOES_NOT_ALLOW, (Throwable)e);
                    Response.Status status = Response.Status.UNAUTHORIZED;
                    return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_OPERATION_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
                }
            }
            client.close();
        }
        return response;
    }

    @GET
    @Path(value="/logbookoperations/{id_op}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.LOGBOOKOPERATIONS_ID_READ, description="R\u00e9cup\u00e9rer le journal d'une op\u00e9ration donn\u00e9e")
    public Response getOperationById(@PathParam(value="id_op") String operationId, @Dsl(value=DslSchema.GET_BY_ID) JsonNode queryDsl) {
        Response response;
        block11: {
            AccessInternalClient client = this.accessInternalClientFactory.getClient();
            try {
                SanityChecker.checkParameter((String[])new String[]{operationId});
                SanityChecker.checkJsonAll((JsonNode)queryDsl);
                RequestResponse result = client.selectOperationById(operationId, queryDsl, false, true);
                int st = result.isOk() ? Response.Status.OK.getStatusCode() : result.getHttpCode();
                response = Response.status((int)st).entity((Object)result).build();
                if (client == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (LogbookClientNotFoundException e) {
                    LOGGER.error("Client exception while trying to get operation by id: ", (Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_OPERATION_BY_ID_ERROR, (String)e.getLocalizedMessage()).setHttpCode(Response.Status.NOT_FOUND.getStatusCode()).toResponse();
                }
                catch (LogbookClientException e) {
                    LOGGER.error("Client exception while trying to get operation by id: ", (Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_OPERATION_BY_ID_ERROR, (String)e.getLocalizedMessage()).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).toResponse();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(INVALID_ARGUMENT, (Throwable)e);
                    Response.Status status = Response.Status.PRECONDITION_FAILED;
                    return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_OPERATION_BY_ID_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
                }
                catch (AccessUnauthorizedException e) {
                    LOGGER.error(CONTRACT_ACCESS_DOES_NOT_ALLOW, (Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_OPERATION_BY_ID_ERROR, (String)e.getLocalizedMessage()).setHttpCode(Response.Status.UNAUTHORIZED.getStatusCode()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @GET
    @Path(value="/logbookunitlifecycles/{id_lc}")
    @Secured(permission=SecurityProfilePermissions.LOGBOOKUNITLIFECYCLES_ID_READ, description="R\u00e9cup\u00e9rer le journal de cycle de vie d'une unit\u00e9 archivistique")
    @Produces(value={"application/json"})
    public Response getUnitLifeCycleById(@PathParam(value="id_lc") String unitLifeCycleId, @Dsl(value=DslSchema.GET_BY_ID) JsonNode queryDsl) {
        Response response;
        block11: {
            AccessInternalClient client = this.accessInternalClientFactory.getClient();
            try {
                SelectParserSingle parser = new SelectParserSingle();
                parser.parse(queryDsl);
                Select select = parser.getRequest();
                RequestResponse result = client.selectUnitLifeCycleById(unitLifeCycleId, (JsonNode)select.getFinalSelect());
                int st = result.isOk() ? Response.Status.OK.getStatusCode() : result.getHttpCode();
                response = Response.status((int)st).entity((Object)result).build();
                if (client == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (LogbookClientNotFoundException e) {
                    LOGGER.error("Client exception while trying to get lifecycle unit by id: ", (Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_UNIT_LIFECYCLE_BY_ID_ERROR, (String)e.getLocalizedMessage()).setHttpCode(Response.Status.NOT_FOUND.getStatusCode()).toResponse();
                }
                catch (LogbookClientException e) {
                    LOGGER.error("Client exception while trying to get lifecycle unit by id: ", (Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_UNIT_LIFECYCLE_BY_ID_ERROR, (String)e.getLocalizedMessage()).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).toResponse();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(INVALID_ARGUMENT, (Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_UNIT_LIFECYCLE_BY_ID_ERROR, (String)e.getLocalizedMessage()).setHttpCode(Response.Status.PRECONDITION_FAILED.getStatusCode()).toResponse();
                }
                catch (AccessUnauthorizedException e) {
                    LOGGER.error(CONTRACT_ACCESS_DOES_NOT_ALLOW, (Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_UNIT_LIFECYCLE_PERMISSION, (String)e.getLocalizedMessage()).setHttpCode(Response.Status.UNAUTHORIZED.getStatusCode()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @GET
    @Path(value="/logbookobjectslifecycles/{id_lc}")
    @Secured(permission=SecurityProfilePermissions.LOGBOOKOBJECTSLIFECYCLES_ID_READ, description="R\u00e9cup\u00e9rer le journal de cycle de vie d'un groupe d'objet")
    @Produces(value={"application/json"})
    public Response getObjectGroupLifeCycleById(@PathParam(value="id_lc") String objectGroupLifeCycleId, @Dsl(value=DslSchema.GET_BY_ID) JsonNode queryDsl) {
        Response response;
        block11: {
            AccessInternalClient client = this.accessInternalClientFactory.getClient();
            try {
                SelectParserSingle parser = new SelectParserSingle();
                parser.parse(queryDsl);
                Select select = parser.getRequest();
                RequestResponse result = client.selectObjectGroupLifeCycleById(objectGroupLifeCycleId, (JsonNode)select.getFinalSelect());
                int st = result.isOk() ? Response.Status.OK.getStatusCode() : result.getHttpCode();
                response = Response.status((int)st).entity((Object)result).build();
                if (client == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (LogbookClientNotFoundException e) {
                    LOGGER.error("Client exception while trying to get object group lifecycle by id: ", (Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_OBJECT_GROUP_LIFECYCLE_BY_ID_ERROR, (String)e.getLocalizedMessage()).setHttpCode(Response.Status.NOT_FOUND.getStatusCode()).toResponse();
                }
                catch (LogbookClientException e) {
                    LOGGER.error("Client exception while trying to get object group lifecycle by id: ", (Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_OBJECT_GROUP_LIFECYCLE_BY_ID_ERROR, (String)e.getLocalizedMessage()).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).toResponse();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(INVALID_ARGUMENT, (Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_OBJECT_GROUP_LIFECYCLE_BY_ID_ERROR, (String)e.getLocalizedMessage()).setHttpCode(Response.Status.PRECONDITION_FAILED.getStatusCode()).toResponse();
                }
                catch (AccessUnauthorizedException e) {
                    LOGGER.error(CONTRACT_ACCESS_DOES_NOT_ALLOW, (Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_OBJECT_GROUP_LIFECYCLE_PERMISSION, (String)e.getLocalizedMessage()).setHttpCode(Response.Status.UNAUTHORIZED.getStatusCode()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }
}

