/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.access.external.rest;

import com.google.common.base.Throwables;
import fr.gouv.vitam.access.external.rest.AccessExternalConfiguration;
import fr.gouv.vitam.access.external.rest.AccessExternalResource;
import fr.gouv.vitam.access.external.rest.AdminManagementExternalResource;
import fr.gouv.vitam.access.external.rest.HttpMethodOverrideFilter;
import fr.gouv.vitam.access.external.rest.LogbookExternalResource;
import fr.gouv.vitam.access.external.rest.v2.rest.AccessExternalResourceV2;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.dsl.schema.DslDynamicFeature;
import fr.gouv.vitam.common.security.rest.SecureEndpointRegistry;
import fr.gouv.vitam.common.security.rest.SecureEndpointScanner;
import fr.gouv.vitam.common.security.waf.SanityCheckerCommonFilter;
import fr.gouv.vitam.common.security.waf.SanityDynamicFeature;
import fr.gouv.vitam.common.serverv2.application.CommonBusinessApplication;
import fr.gouv.vitam.security.internal.filter.AuthorizationFilter;
import fr.gouv.vitam.security.internal.filter.InternalSecurityFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;

public class BusinessApplication
extends Application {
    private final CommonBusinessApplication commonBusinessApplication;
    private Set<Object> singletons;

    public BusinessApplication(@Context ServletConfig servletConfig) {
        String configurationFile = servletConfig.getInitParameter("vitam.configurationFile");
        SecureEndpointRegistry secureEndpointRegistry = new SecureEndpointRegistry();
        SecureEndpointScanner secureEndpointScanner = new SecureEndpointScanner(secureEndpointRegistry);
        try (InputStream yamlIS = PropertiesUtils.getConfigAsStream((String)configurationFile);){
            AccessExternalConfiguration configuration = (AccessExternalConfiguration)((Object)PropertiesUtils.readYaml((InputStream)yamlIS, AccessExternalConfiguration.class));
            this.commonBusinessApplication = new CommonBusinessApplication(true);
            AccessExternalResource accessExternalResource = new AccessExternalResource(secureEndpointRegistry, configuration);
            AccessExternalResourceV2 accessExternalResourceV2 = new AccessExternalResourceV2(secureEndpointRegistry, configuration);
            LogbookExternalResource logbookExternalResource = new LogbookExternalResource();
            AdminManagementExternalResource adminManagementExternalResource = new AdminManagementExternalResource(secureEndpointRegistry);
            this.singletons = new HashSet<Object>();
            this.singletons.add(new InternalSecurityFilter(configuration.isAllowSslClientHeader()));
            this.singletons.add(new AuthorizationFilter());
            this.singletons.addAll(this.commonBusinessApplication.getResources());
            this.singletons.add((Object)accessExternalResource);
            this.singletons.add((Object)accessExternalResourceV2);
            this.singletons.add(logbookExternalResource);
            this.singletons.add((Object)adminManagementExternalResource);
            this.singletons.add(new SanityCheckerCommonFilter());
            this.singletons.add(new SanityDynamicFeature());
            this.singletons.add(new HttpMethodOverrideFilter());
            this.singletons.add(secureEndpointScanner);
            this.singletons.add(new DslDynamicFeature());
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }
}

