/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.access.external.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.access.internal.client.AccessInternalClient;
import fr.gouv.vitam.access.internal.client.AccessInternalClientFactory;
import fr.gouv.vitam.access.internal.common.exception.AccessInternalClientNotFoundException;
import fr.gouv.vitam.access.internal.common.exception.AccessInternalClientServerException;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.alert.AlertServiceImpl;
import fr.gouv.vitam.common.client.IngestCollection;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Update;
import fr.gouv.vitam.common.database.parser.request.single.UpdateParserSingle;
import fr.gouv.vitam.common.dsl.schema.Dsl;
import fr.gouv.vitam.common.dsl.schema.DslSchema;
import fr.gouv.vitam.common.dsl.schema.ValidationException;
import fr.gouv.vitam.common.dsl.schema.validator.BatchProcessingQuerySchemaValidator;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.AccessUnauthorizedException;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.InternalServerException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.exception.VitamThreadAccessException;
import fr.gouv.vitam.common.exception.WorkflowNotFoundException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.AuditOptions;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.ProbativeValueRequest;
import fr.gouv.vitam.common.model.ProcessPause;
import fr.gouv.vitam.common.model.ProcessQuery;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseError;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitam.common.model.administration.ArchiveUnitProfileModel;
import fr.gouv.vitam.common.model.administration.ContextModel;
import fr.gouv.vitam.common.model.administration.IngestContractModel;
import fr.gouv.vitam.common.model.administration.ManagementContractModel;
import fr.gouv.vitam.common.model.administration.OntologyModel;
import fr.gouv.vitam.common.model.administration.ProfileModel;
import fr.gouv.vitam.common.model.administration.SecurityProfileModel;
import fr.gouv.vitam.common.model.administration.preservation.GriffinModel;
import fr.gouv.vitam.common.model.administration.preservation.PreservationScenarioModel;
import fr.gouv.vitam.common.model.administration.schema.SchemaInputModel;
import fr.gouv.vitam.common.model.audit.AuditReferentialOptions;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.common.security.rest.SecureEndpointRegistry;
import fr.gouv.vitam.common.security.rest.Secured;
import fr.gouv.vitam.common.security.rest.Unsecured;
import fr.gouv.vitam.common.server.application.resources.ApplicationStatusResource;
import fr.gouv.vitam.common.server.application.resources.VitamStatusService;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.common.stream.VitamAsyncInputStreamResponse;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.client.AdminManagementClient;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.functional.administration.common.exception.AdminManagementClientBadRequestException;
import fr.gouv.vitam.functional.administration.common.exception.AdminManagementClientServerException;
import fr.gouv.vitam.functional.administration.common.exception.DatabaseConflictException;
import fr.gouv.vitam.functional.administration.common.exception.FileRulesNotFoundException;
import fr.gouv.vitam.functional.administration.common.exception.ProfileNotFoundException;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialException;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialImportInProgressException;
import fr.gouv.vitam.functional.administration.common.exception.ReferentialNotFoundException;
import fr.gouv.vitam.ingest.internal.client.IngestInternalClient;
import fr.gouv.vitam.ingest.internal.client.IngestInternalClientFactory;
import fr.gouv.vitam.ingest.internal.common.exception.IngestInternalClientNotFoundException;
import fr.gouv.vitam.ingest.internal.common.exception.IngestInternalClientServerException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientAlreadyExistsException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.utils.SecurityProfilePermissions;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/admin-external/v1")
@ApplicationPath(value="webresources")
@Tag(name="Admin")
public class AdminManagementExternalResource
extends ApplicationStatusResource {
    private static final String IDENTIFIER = "Identifier";
    private static final String ATTACHEMENT_FILENAME = "attachment; filename=rapport.json";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AdminManagementExternalResource.class);
    private static final String ACCESS_EXTERNAL_MODULE = "ADMIN_EXTERNAL";
    @Deprecated
    private static final String CODE_VITAM = "code_vitam";
    private static final String HTML_CONTENT_MSG_ERROR = "document has toxic HTML content";
    private static final String DOCUMENT_IS_MANDATORY = "document is a mandatory parameter";
    private static final String JSON_SELECT_IS_MANDATORY = "Json select is a mandatory parameter";
    private static final String SUCCESSFULLY_IMPORTED = "Successfully imported";
    private static final String FORMAT_ID_MANDATORY = "formatId is a mandatory parameter";
    private static final String UNEXPECTED_ERROR = "Unexpected error was thrown : ";
    public static final String UNIT_SCHEMA = "/schema/unit";
    public static final String OBJECTGROUP_SCHEMA = "/schema/objectgroup";
    private final SecureEndpointRegistry secureEndpointRegistry;
    private static final AlertService alertService = new AlertServiceImpl();
    private final AdminManagementClientFactory adminManagementClientFactory;
    private final IngestInternalClientFactory ingestInternalClientFactory;
    private final AccessInternalClientFactory accessInternalClientFactory;

    AdminManagementExternalResource(SecureEndpointRegistry secureEndpointRegistry) {
        this.secureEndpointRegistry = secureEndpointRegistry;
        LOGGER.debug("init Admin Management Resource server");
        this.adminManagementClientFactory = AdminManagementClientFactory.getInstance();
        this.ingestInternalClientFactory = IngestInternalClientFactory.getInstance();
        this.accessInternalClientFactory = AccessInternalClientFactory.getInstance();
    }

    @VisibleForTesting
    AdminManagementExternalResource(VitamStatusService statusService, SecureEndpointRegistry secureEndpointRegistry, AdminManagementClientFactory adminManagementClientFactory, IngestInternalClientFactory ingestInternalClientFactory, AccessInternalClientFactory accessInternalClientFactory) {
        super(statusService);
        this.secureEndpointRegistry = secureEndpointRegistry;
        this.adminManagementClientFactory = adminManagementClientFactory;
        this.ingestInternalClientFactory = ingestInternalClientFactory;
        this.accessInternalClientFactory = accessInternalClientFactory;
    }

    @Path(value="/")
    @OPTIONS
    @Produces(value={"application/json"})
    @Unsecured
    public Response listResourceEndpoints() {
        String resourcePath = AdminManagementExternalResource.class.getAnnotation(Path.class).value();
        List securedEndpointList = this.secureEndpointRegistry.getEndPointsByResourcePath(resourcePath);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)securedEndpointList).build();
    }

    @Path(value="/formatsfilecheck")
    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/octet-stream"})
    @Secured(permission=SecurityProfilePermissions.FORMATSFILE_CHECK, isAdminOnly=true, description="V\u00e9rifier si le r\u00e9f\u00e9rentiel des formats que l'on souhaite importer est valide")
    public Response checkDocument(InputStream document) {
        ParametersChecker.checkParameter((String)"xmlPronom is a mandatory parameter", (Object[])new Object[]{document});
        return this.asyncCheckFormat(document);
    }

    @Path(value="/rulesfilecheck")
    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/octet-stream"})
    @Secured(permission=SecurityProfilePermissions.RULESFILE_CHECK, description="V\u00e9rifier si le r\u00e9f\u00e9rentiel de r\u00e8gles de gestions que l'on souhaite importer est valide")
    public Response checkRules(InputStream document) {
        try {
            return this.asyncDownloadErrorReportRules(document);
        }
        catch (InvalidParseOperationException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Path(value="/agenciesfilecheck")
    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/octet-stream"})
    @Secured(permission=SecurityProfilePermissions.AGENCIESFILE_CHECK, description="V\u00e9rifier si le r\u00e9f\u00e9rentiel de services producteurs que l'on souhaite importer est valide")
    public Response checkAgencies(InputStream document) {
        return this.asyncDownloadErrorReportAgencies(document);
    }

    private Response asyncCheckFormat(InputStream document) {
        VitamAsyncInputStreamResponse vitamAsyncInputStreamResponse;
        block8: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                Response response = client.checkFormat(document);
                vitamAsyncInputStreamResponse = new VitamAsyncInputStreamResponse(response);
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ReferentialException e) {
                    LOGGER.error((Throwable)e);
                    StreamUtils.closeSilently((InputStream)document);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return vitamAsyncInputStreamResponse;
    }

    private Response asyncDownloadErrorReportRules(InputStream document) throws InvalidParseOperationException {
        VitamAsyncInputStreamResponse vitamAsyncInputStreamResponse;
        block9: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                Response response = client.checkRulesFile(document);
                Map headers = VitamAsyncInputStreamResponse.getDefaultMapFromResponse((Response)response);
                headers.put("Content-Disposition", ATTACHEMENT_FILENAME);
                vitamAsyncInputStreamResponse = new VitamAsyncInputStreamResponse(response, (Response.Status)response.getStatusInfo(), headers);
                if (client == null) break block9;
            }
            catch (Throwable response) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            response.addSuppressed(throwable);
                        }
                    }
                    throw response;
                }
                catch (AdminManagementClientBadRequestException e) {
                    VitamError error = new VitamError(VitamCode.ADMIN_EXTERNAL_BAD_REQUEST.getItem()).setMessage(VitamCode.ADMIN_EXTERNAL_BAD_REQUEST.getMessage()).setState(StatusCode.KO.name()).setCode(VitamCodeHelper.getCode((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST)).setContext(ACCESS_EXTERNAL_MODULE).setDescription(VitamCode.ADMIN_EXTERNAL_BAD_REQUEST.getMessage());
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)JsonHandler.writeToInpustream((Object)error)).build();
                }
                catch (Exception e) {
                    return this.asyncResponseResume(e, document);
                }
            }
            client.close();
        }
        return vitamAsyncInputStreamResponse;
    }

    private Response asyncDownloadErrorReportAgencies(InputStream document) {
        VitamAsyncInputStreamResponse vitamAsyncInputStreamResponse;
        block9: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                Response response = client.checkAgenciesFile(document);
                Map headers = VitamAsyncInputStreamResponse.getDefaultMapFromResponse((Response)response);
                headers.put("Content-Disposition", ATTACHEMENT_FILENAME);
                vitamAsyncInputStreamResponse = new VitamAsyncInputStreamResponse(response, (Response.Status)response.getStatusInfo(), headers);
                if (client == null) break block9;
            }
            catch (Throwable response) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            response.addSuppressed(throwable);
                        }
                    }
                    throw response;
                }
                catch (AdminManagementClientBadRequestException e) {
                    VitamError error = new VitamError(VitamCode.ADMIN_EXTERNAL_BAD_REQUEST.getItem()).setMessage(VitamCode.ADMIN_EXTERNAL_BAD_REQUEST.getMessage()).setState(StatusCode.KO.name()).setCode(VitamCodeHelper.getCode((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST)).setContext(ACCESS_EXTERNAL_MODULE).setDescription(VitamCode.ADMIN_EXTERNAL_BAD_REQUEST.getMessage());
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorStream(error)).build();
                }
                catch (Exception e) {
                    return this.asyncResponseResume(e, document);
                }
            }
            client.close();
        }
        return vitamAsyncInputStreamResponse;
    }

    private Response asyncResponseResume(Exception e, InputStream document) {
        LOGGER.error((Throwable)e);
        StreamUtils.closeSilently((InputStream)document);
        return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toStreamResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/formats")
    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.FORMATS_CREATE, description="Importer un r\u00e9f\u00e9rentiel des formats", isAdminOnly=true)
    public Response importFormat(@Context HttpHeaders headers, @Context UriInfo uriInfo, InputStream document) {
        String filename = headers.getHeaderString("X-Filename");
        try {
            Response response;
            block15: {
                AdminManagementClient client = this.adminManagementClientFactory.getClient();
                try {
                    ParametersChecker.checkParameter((String)DOCUMENT_IS_MANDATORY, (Object[])new Object[]{document});
                    Response.Status status = client.importFormat(document, filename);
                    response = Response.status((Response.Status)status).build();
                    if (client == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (DatabaseConflictException e) {
                        LOGGER.error((Throwable)e);
                        Response response2 = VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_CONFLICT, (String)e.getMessage()).toResponse();
                        return response2;
                    }
                    catch (ReferentialImportInProgressException e) {
                        LOGGER.warn((Throwable)e);
                        Response response3 = VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_FORBIDDEN, (String)e.getMessage()).toResponse();
                        return response3;
                    }
                    catch (ReferentialException | IllegalArgumentException e) {
                        LOGGER.error(e);
                        Response response4 = VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                        return response4;
                    }
                }
                client.close();
            }
            return response;
        }
        finally {
            StreamUtils.closeSilently((InputStream)document);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/rules")
    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.RULES_CREATE, description="Importer un r\u00e9f\u00e9rentiel des r\u00e8gles de gestion")
    public Response importRulesFile(@Context HttpHeaders headers, InputStream document) {
        String filename = headers.getHeaderString("X-Filename");
        File file = PropertiesUtils.fileFromTmpFolder((String)"tmpRuleFile");
        try {
            ParametersChecker.checkParameter((String)DOCUMENT_IS_MANDATORY, (Object[])new Object[]{document});
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                StreamUtils.copy((InputStream)document, (OutputStream)fileOutputStream);
            }
            SanityChecker.checkHTMLFile((File)file);
            fileOutputStream = this.importRuleFile(filename, file);
            return fileOutputStream;
        }
        catch (IOException | IllegalArgumentException e) {
            LOGGER.error((Throwable)e);
            Response response = VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
            return response;
        }
        catch (InvalidParseOperationException e) {
            alertService.createAlert("Rules contain an HTML injection");
            LOGGER.error((Throwable)e);
            Response response = VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)HTML_CONTENT_MSG_ERROR).toResponse();
            return response;
        }
        finally {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                LOGGER.error((Throwable)e);
            }
            StreamUtils.closeSilently((InputStream)document);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Response importRuleFile(String filename, File file) throws IOException {
        try (AdminManagementClient client = this.adminManagementClientFactory.getClient();){
            Response response;
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                Response.Status status = client.importRulesFile((InputStream)fileInputStream, filename);
                response = Response.status((Response.Status)status).build();
            }
            return response;
        }
        catch (DatabaseConflictException e) {
            LOGGER.error((Throwable)e);
            return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_CONFLICT, (String)e.getMessage()).toResponse();
        }
        catch (ReferentialImportInProgressException e) {
            LOGGER.warn((Throwable)e);
            return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_FORBIDDEN, (String)e.getMessage()).toResponse();
        }
        catch (ReferentialException e) {
            LOGGER.error((Throwable)e);
            return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
        }
    }

    private Response downloadTraceabilityOperationFile(String operationId) {
        VitamAsyncInputStreamResponse vitamAsyncInputStreamResponse;
        block11: {
            AccessInternalClient client = this.accessInternalClientFactory.getClient();
            try {
                Response response = client.downloadTraceabilityFile(operationId);
                Map headers = VitamAsyncInputStreamResponse.getDefaultMapFromResponse((Response)response);
                vitamAsyncInputStreamResponse = new VitamAsyncInputStreamResponse(response, Response.Status.OK, headers);
                if (client == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | IllegalArgumentException e) {
                    LOGGER.error(e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED, (String)e.getMessage()).toStreamResponse();
                }
                catch (AccessInternalClientServerException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toStreamResponse();
                }
                catch (AccessInternalClientNotFoundException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_NOT_FOUND, (String)e.getMessage()).toStreamResponse();
                }
                catch (AccessUnauthorizedException e) {
                    LOGGER.error("Contract access does not allow ", (Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_UNAUTHORIZED, (String)e.getMessage()).toStreamResponse();
                }
            }
            client.close();
        }
        return vitamAsyncInputStreamResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Path(value="/ingestcontracts")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.INGESTCONTRACTS_CREATE_JSON, description="Importer des contrats d'entr\u00e9es dans le r\u00e9f\u00e9rentiel")
    public Response importIngestContracts(JsonNode select) {
        ParametersChecker.checkParameter((String)JSON_SELECT_IS_MANDATORY, (Object[])new Object[]{select});
        try (AdminManagementClient client = this.adminManagementClientFactory.getClient();){
            Response.Status status222 = client.importIngestContracts((List)JsonHandler.getFromStringAsTypeReference((String)select.toString(), (TypeReference)new TypeReference<List<IngestContractModel>>(){}));
            if (Response.Status.BAD_REQUEST.getStatusCode() == status222.getStatusCode()) {
                Response response = VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)Response.Status.BAD_REQUEST.getReasonPhrase()).toResponse();
                return response;
            }
            Response throwable = Response.status((Response.Status)status222).entity((Object)SUCCESSFULLY_IMPORTED).build();
            return throwable;
        }
        catch (ReferentialException e) {
            LOGGER.error((Throwable)e);
            return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
        }
        catch (InvalidFormatException | InvalidParseOperationException e) {
            LOGGER.error(e);
            VitamError error = new VitamError(VitamCode.ACCESS_EXTERNAL_INVALID_JSON.getItem()).setMessage(VitamCode.ACCESS_EXTERNAL_INVALID_JSON.getMessage()).setState(StatusCode.KO.name()).setCode(VitamCodeHelper.getCode((VitamCode)VitamCode.ACCESS_EXTERNAL_INVALID_JSON)).setContext(ACCESS_EXTERNAL_MODULE).setDescription(VitamCode.ACCESS_EXTERNAL_INVALID_JSON.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Path(value="/accesscontracts")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.ACCESSCONTRACTS_CREATE_JSON, description="Importer des contrats d'acc\u00e8s dans le r\u00e9f\u00e9rentiel")
    public Response importAccessContracts(JsonNode contract) {
        ParametersChecker.checkParameter((String)JSON_SELECT_IS_MANDATORY, (Object[])new Object[]{contract});
        try (AdminManagementClient client = this.adminManagementClientFactory.getClient();){
            Response.Status status222 = client.importAccessContracts((List)JsonHandler.getFromStringAsTypeReference((String)contract.toString(), (TypeReference)new TypeReference<List<AccessContractModel>>(){}));
            if (Response.Status.BAD_REQUEST.getStatusCode() == status222.getStatusCode()) {
                Response response = VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)Response.Status.BAD_REQUEST.getReasonPhrase()).toResponse();
                return response;
            }
            Response throwable = Response.status((Response.Status)status222).entity((Object)SUCCESSFULLY_IMPORTED).build();
            return throwable;
        }
        catch (ReferentialException e) {
            LOGGER.error((Throwable)e);
            return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
        }
        catch (InvalidFormatException | InvalidParseOperationException e) {
            LOGGER.error(e);
            VitamError error = new VitamError(VitamCode.ACCESS_EXTERNAL_INVALID_JSON.getItem()).setMessage(VitamCode.ACCESS_EXTERNAL_INVALID_JSON.getMessage()).setState(StatusCode.KO.name()).setCode(VitamCodeHelper.getCode((VitamCode)VitamCode.ACCESS_EXTERNAL_INVALID_JSON)).setContext(ACCESS_EXTERNAL_MODULE).setDescription(VitamCode.ACCESS_EXTERNAL_INVALID_JSON.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Path(value="/managementcontracts")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.MANAGEMENTCONTRACTS_CREATE_JSON, description="Importer des contrats de gestion dans le r\u00e9f\u00e9rentiel")
    public Response importManagementContracts(JsonNode contract) {
        ParametersChecker.checkParameter((String)JSON_SELECT_IS_MANDATORY, (Object[])new Object[]{contract});
        try (AdminManagementClient client = this.adminManagementClientFactory.getClient();){
            Response.Status status222 = client.importManagementContracts((List)JsonHandler.getFromStringAsTypeReference((String)contract.toString(), (TypeReference)new TypeReference<List<ManagementContractModel>>(){}));
            if (Response.Status.BAD_REQUEST.getStatusCode() == status222.getStatusCode()) {
                Response response = VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)Response.Status.BAD_REQUEST.getReasonPhrase()).toResponse();
                return response;
            }
            Response throwable = Response.status((Response.Status)status222).entity((Object)SUCCESSFULLY_IMPORTED).build();
            return throwable;
        }
        catch (ReferentialException e) {
            LOGGER.error((Throwable)e);
            return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
        }
        catch (InvalidFormatException | InvalidParseOperationException e) {
            LOGGER.error(e);
            VitamError error = new VitamError(VitamCode.ACCESS_EXTERNAL_INVALID_JSON.getItem()).setMessage(VitamCode.ACCESS_EXTERNAL_INVALID_JSON.getMessage()).setState(StatusCode.KO.name()).setCode(VitamCodeHelper.getCode((VitamCode)VitamCode.ACCESS_EXTERNAL_INVALID_JSON)).setContext(ACCESS_EXTERNAL_MODULE).setDescription(VitamCode.ACCESS_EXTERNAL_INVALID_JSON.getMessage());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error).build();
        }
    }

    @Path(value="/contexts")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.CONTEXTS_CREATE_JSON, description="Importer des contextes dans le r\u00e9f\u00e9rentiel", isAdminOnly=true)
    public Response importContexts(JsonNode select) {
        Response response;
        block8: {
            ParametersChecker.checkParameter((String)JSON_SELECT_IS_MANDATORY, (Object[])new Object[]{select});
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                Response.Status status = client.importContexts((List)JsonHandler.getFromStringAsTypeReference((String)select.toString(), (TypeReference)new TypeReference<List<ContextModel>>(){}));
                response = Response.status((Response.Status)status).entity((Object)SUCCESSFULLY_IMPORTED).build();
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidFormatException | InvalidParseOperationException | ReferentialException e) {
                    LOGGER.error(e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/profiles")
    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.PROFILES_CREATE_BINARY, description="Importer des profils dans le r\u00e9f\u00e9rentiel")
    public Response createProfiles(InputStream document) {
        try {
            Response response;
            block15: {
                AdminManagementClient client = this.adminManagementClientFactory.getClient();
                try {
                    ParametersChecker.checkParameter((String)DOCUMENT_IS_MANDATORY, (Object[])new Object[]{document});
                    JsonNode json2 = JsonHandler.getFromInputStream((InputStream)document);
                    SanityChecker.checkJsonAll((JsonNode)json2);
                    RequestResponse requestResponse = client.createProfiles((List)JsonHandler.getFromStringAsTypeReference((String)json2.toString(), (TypeReference)new TypeReference<List<ProfileModel>>(){}));
                    response = Response.status((int)requestResponse.getStatus()).entity((Object)requestResponse).build();
                    if (client == null) break block15;
                }
                catch (Throwable json2) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable) {
                                json2.addSuppressed(throwable);
                            }
                        }
                        throw json2;
                    }
                    catch (ReferentialException | IllegalArgumentException e) {
                        LOGGER.error(e);
                        Response json2 = VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                        return json2;
                    }
                    catch (InvalidParseOperationException e) {
                        LOGGER.error((Throwable)e);
                        VitamError error = new VitamError(VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED.getItem()).setMessage(VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED.getMessage()).setState(StatusCode.KO.name()).setCode(VitamCodeHelper.getCode((VitamCode)VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED)).setContext(ACCESS_EXTERNAL_MODULE).setDescription(VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED.getMessage());
                        Response response2 = Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)error).build();
                        return response2;
                    }
                    catch (InvalidFormatException e) {
                        LOGGER.error((Throwable)e);
                        VitamError error = new VitamError(VitamCode.ACCESS_EXTERNAL_INVALID_JSON.getItem()).setMessage(VitamCode.ACCESS_EXTERNAL_INVALID_JSON.getMessage()).setState(StatusCode.KO.name()).setCode(VitamCodeHelper.getCode((VitamCode)VitamCode.ACCESS_EXTERNAL_INVALID_JSON)).setContext(ACCESS_EXTERNAL_MODULE).setDescription(VitamCode.ACCESS_EXTERNAL_INVALID_JSON.getMessage());
                        Response response3 = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error).build();
                        return response3;
                    }
                }
                client.close();
            }
            return response;
        }
        finally {
            StreamUtils.closeSilently((InputStream)document);
        }
    }

    @Path(value="/profiles")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.PROFILES_CREATE_JSON, description="Ecrire un profil dans le r\u00e9f\u00e9rentiel")
    public Response createProfiles(JsonNode select) {
        Response response;
        block8: {
            ParametersChecker.checkParameter((String)JSON_SELECT_IS_MANDATORY, (Object[])new Object[]{select});
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                SanityChecker.checkJsonAll((JsonNode)select);
                RequestResponse requestResponse = client.createProfiles((List)JsonHandler.getFromStringAsTypeReference((String)select.toString(), (TypeReference)new TypeReference<List<ProfileModel>>(){}));
                response = Response.status((int)requestResponse.getStatus()).entity((Object)requestResponse).build();
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidFormatException | InvalidParseOperationException | ReferentialException e) {
                    LOGGER.error(e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/archiveunitprofiles")
    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.ARCHIVEUNITPROFILES_CREATE_BINARY, description="Importer un ou plusieurs document types dans le r\u00e9f\u00e9rentiel")
    public Response createArchiveUnitProfiles(InputStream document) {
        try {
            Response response;
            block15: {
                AdminManagementClient client = this.adminManagementClientFactory.getClient();
                try {
                    ParametersChecker.checkParameter((String)DOCUMENT_IS_MANDATORY, (Object[])new Object[]{document});
                    JsonNode json = JsonHandler.getFromInputStream((InputStream)document);
                    SanityChecker.checkJsonAll((JsonNode)json);
                    RequestResponse requestResponse = client.createArchiveUnitProfiles((List)JsonHandler.getFromStringAsTypeReference((String)json.toString(), (TypeReference)new TypeReference<List<ArchiveUnitProfileModel>>(){}));
                    response = Response.status((int)requestResponse.getStatus()).entity((Object)requestResponse).build();
                    if (client == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ReferentialException | IllegalArgumentException e) {
                        LOGGER.error(e);
                        Response response2 = VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                        return response2;
                    }
                    catch (InvalidParseOperationException e) {
                        LOGGER.error((Throwable)e);
                        Response response3 = VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED, (String)e.getMessage()).setState(StatusCode.KO.name()).setContext(ACCESS_EXTERNAL_MODULE).toResponse();
                        return response3;
                    }
                    catch (InvalidFormatException e) {
                        LOGGER.error((Throwable)e);
                        Response response4 = VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_INVALID_JSON, (String)e.getMessage()).setState(StatusCode.KO.name()).toResponse();
                        return response4;
                    }
                }
                client.close();
            }
            return response;
        }
        finally {
            StreamUtils.closeSilently((InputStream)document);
        }
    }

    @Path(value="/archiveunitprofiles")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.ARCHIVEUNITPROFILES_CREATE_JSON, description="Ecrire un ou plusieurs document type dans le r\u00e9f\u00e9rentiel")
    public Response createArchiveUnitProfiles(JsonNode select) {
        Response response;
        block8: {
            ParametersChecker.checkParameter((String)JSON_SELECT_IS_MANDATORY, (Object[])new Object[]{select});
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                SanityChecker.checkJsonAll((JsonNode)select);
                RequestResponse requestResponse = client.createArchiveUnitProfiles((List)JsonHandler.getFromStringAsTypeReference((String)select.toString(), (TypeReference)new TypeReference<List<ArchiveUnitProfileModel>>(){}));
                response = Response.status((int)requestResponse.getStatus()).entity((Object)requestResponse).build();
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidFormatException | InvalidParseOperationException | ReferentialException e) {
                    LOGGER.error(e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/profiles/{id:.+}")
    @PUT
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.PROFILES_ID_UPDATE_BINAIRE, description="Importer un fichier xsd ou rng dans un profil")
    public Response importProfileFile(@Context UriInfo uriInfo, @PathParam(value="id") String profileMetadataId, InputStream profileFile) {
        try {
            Response response;
            block15: {
                AdminManagementClient client = this.adminManagementClientFactory.getClient();
                try {
                    ParametersChecker.checkParameter((String)"profileFile stream is a mandatory parameter", (Object[])new Object[]{profileFile});
                    ParametersChecker.checkParameter((String)profileMetadataId, (String[])new String[]{"The profile id is mandatory"});
                    RequestResponse requestResponse = client.importProfileFile(profileMetadataId, profileFile);
                    response = Response.status((int)requestResponse.getStatus()).entity((Object)requestResponse).build();
                    if (client == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (DatabaseConflictException e) {
                        LOGGER.error((Throwable)e);
                        Response response2 = VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_CONFLICT, (String)e.getMessage()).toResponse();
                        return response2;
                    }
                    catch (ReferentialException e) {
                        LOGGER.error((Throwable)e);
                        Response response3 = VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                        return response3;
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.error((Throwable)e);
                        Response response4 = VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED, (String)e.getMessage()).toResponse();
                        return response4;
                    }
                }
                client.close();
            }
            return response;
        }
        finally {
            StreamUtils.closeSilently((InputStream)profileFile);
        }
    }

    @GET
    @Path(value="/profiles/{id:.+}")
    @Produces(value={"application/octet-stream"})
    @Secured(permission=SecurityProfilePermissions.PROFILES_ID_READ_BINARY, description="T\u00e9lecharger le fichier xsd ou rng attach\u00e9 \u00e0 un profil")
    public Response downloadProfileFile(@PathParam(value="id") String fileId) {
        ParametersChecker.checkParameter((String)"Profile id should be filled", (String[])new String[]{fileId});
        return this.asyncDownloadProfileFile(fileId);
    }

    @GET
    @Path(value="/traceability/{id}/datafiles")
    @Produces(value={"application/octet-stream"})
    @Secured(permission=SecurityProfilePermissions.TRACEABILITY_ID_READ, description="T\u00e9l\u00e9charger le logbook s\u00e9curis\u00e9 attach\u00e9 \u00e0 une op\u00e9ration de s\u00e9curisation")
    public Response downloadTraceabilityFile(@PathParam(value="id") String fileId) {
        try {
            ParametersChecker.checkParameter((String)"Traceability operation should be filled", (String[])new String[]{fileId});
            return this.downloadTraceabilityOperationFile(fileId);
        }
        catch (VitamThreadAccessException | IllegalArgumentException e) {
            LOGGER.error(e);
            return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED, (String)e.getMessage()).toStreamResponse();
        }
    }

    private Response asyncDownloadProfileFile(String profileMetadataId) {
        VitamAsyncInputStreamResponse vitamAsyncInputStreamResponse;
        block9: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                Response response = client.downloadProfileFile(profileMetadataId);
                Map headers = VitamAsyncInputStreamResponse.getDefaultMapFromResponse((Response)response);
                vitamAsyncInputStreamResponse = new VitamAsyncInputStreamResponse(response, Response.Status.OK, headers);
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ProfileNotFoundException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_NOT_FOUND, (String)e.getMessage()).toStreamResponse();
                }
                catch (AdminManagementClientServerException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toStreamResponse();
                }
            }
            client.close();
        }
        return vitamAsyncInputStreamResponse;
    }

    @Path(value="/formats")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.FORMATS_READ, description="Lister le contenu du r\u00e9f\u00e9rentiel des formats")
    public Response getFormats(@Dsl(value=DslSchema.SELECT_SINGLE) JsonNode select) {
        Response response;
        block11: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                SanityChecker.checkJsonAll((JsonNode)select);
                RequestResponse result = client.getFormats(select);
                int st = result.isOk() ? Response.Status.OK.getStatusCode() : result.getHttpCode();
                response = Response.status((int)st).entity((Object)result).build();
                if (client == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileRulesNotFoundException | ReferentialNotFoundException e) {
                    LOGGER.error(e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_NOT_FOUND, (String)e.getMessage()).toResponse();
                }
                catch (ReferentialException | IOException e) {
                    LOGGER.error(e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/rules")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.RULES_READ, description="Lister le contenu du r\u00e9f\u00e9rentiel des r\u00e8gles de gestion")
    public Response getRules(@Dsl(value=DslSchema.SELECT_SINGLE) JsonNode select) {
        Response response;
        block11: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                SanityChecker.checkJsonAll((JsonNode)select);
                JsonNode result = client.getRules(select);
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                if (client == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileRulesNotFoundException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_NOT_FOUND, (String)e.getMessage()).toResponse();
                }
                catch (ReferentialException | IOException e) {
                    LOGGER.error(e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/ingestcontracts")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.INGESTCONTRACTS_READ, description="Lister le contenu du r\u00e9f\u00e9rentiel des contrats d'entr\u00e9e")
    public Response findIngestContracts(@Dsl(value=DslSchema.SELECT_SINGLE) JsonNode select) {
        Response response;
        block10: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                SanityChecker.checkJsonAll((JsonNode)select);
                RequestResponse result = client.findIngestContracts(select);
                int st = result.isOk() ? Response.Status.OK.getStatusCode() : result.getHttpCode();
                response = Response.status((int)st).entity((Object)result).build();
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ReferentialException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/accesscontracts")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.ACCESSCONTRACTS_READ, description="Lister le contenu du r\u00e9f\u00e9rentiel des contrats d'acc\u00e8s")
    public Response findAccessContracts(@Dsl(value=DslSchema.SELECT_SINGLE) JsonNode select) {
        Response response;
        block10: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                SanityChecker.checkJsonAll((JsonNode)select);
                RequestResponse result = client.findAccessContracts(select);
                int st = result.isOk() ? Response.Status.OK.getStatusCode() : result.getHttpCode();
                response = Response.status((int)st).entity((Object)result).build();
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ReferentialException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/managementcontracts")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.MANAGEMENTCONTRACTS_READ, description="Lister le contenu du r\u00e9f\u00e9rentiel des contrats de gestion")
    public Response findManagementContracts(@Dsl(value=DslSchema.SELECT_SINGLE) JsonNode select) {
        Response response;
        block10: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                SanityChecker.checkJsonAll((JsonNode)select);
                RequestResponse result = client.findManagementContracts(select);
                int st = result.isOk() ? Response.Status.OK.getStatusCode() : result.getHttpCode();
                response = Response.status((int)st).entity((Object)result).build();
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ReferentialException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/profiles")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.PROFILES_READ, description="Lister le contenu du r\u00e9f\u00e9rentiel des profils")
    public Response findProfiles(@Dsl(value=DslSchema.SELECT_SINGLE) JsonNode select) {
        Response response;
        block10: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                SanityChecker.checkJsonAll((JsonNode)select);
                RequestResponse result = client.findProfiles(select);
                int st = result.isOk() ? Response.Status.OK.getStatusCode() : result.getHttpCode();
                response = Response.status((int)st).entity((Object)result).build();
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ReferentialException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/archiveunitprofiles")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.ARCHIVEUNITPROFILES_READ, description="Lister le contenu du r\u00e9f\u00e9rentiel des document types")
    public Response findArchiveUnitProfiles(@Dsl(value=DslSchema.SELECT_SINGLE) JsonNode select) {
        Response response;
        block10: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                SanityChecker.checkJsonAll((JsonNode)select);
                RequestResponse result = client.findArchiveUnitProfiles(select);
                int st = result.isOk() ? Response.Status.OK.getStatusCode() : result.getHttpCode();
                response = Response.status((int)st).entity((Object)result).build();
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ReferentialException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/contexts")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.CONTEXTS_READ, description="Lister le contenu du r\u00e9f\u00e9rentiel des contextes")
    public Response findContexts(@Dsl(value=DslSchema.SELECT_SINGLE) JsonNode select) {
        Response response;
        block10: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                SanityChecker.checkJsonAll((JsonNode)select);
                RequestResponse result = client.findContexts(select);
                int st = result.isOk() ? Response.Status.OK.getStatusCode() : result.getHttpCode();
                response = Response.status((int)st).entity((Object)result).build();
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ReferentialException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/agencies")
    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.AGENCIES_CREATE, description="Importer un r\u00e9f\u00e9rentiel des services producteurs")
    public Response importAgenciesFile(@Context HttpHeaders headers, InputStream document) {
        String filename = headers.getHeaderString("X-Filename");
        File file = PropertiesUtils.fileFromTmpFolder((String)"tmpRuleFile");
        try {
            ParametersChecker.checkParameter((String)DOCUMENT_IS_MANDATORY, (Object[])new Object[]{document});
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                StreamUtils.copy((InputStream)document, (OutputStream)fileOutputStream);
            }
            SanityChecker.checkHTMLFile((File)file);
            fileOutputStream = this.importAgenciesFile(filename, file);
            return fileOutputStream;
        }
        catch (IOException | IllegalArgumentException e) {
            LOGGER.error((Throwable)e);
            Response response = VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
            return response;
        }
        catch (InvalidParseOperationException e) {
            alertService.createAlert("Agencies contain an HTML injection");
            LOGGER.error((Throwable)e);
            Response response = VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
            return response;
        }
        finally {
            try {
                Files.delete(file.toPath());
            }
            catch (IOException e) {
                LOGGER.error((Throwable)e);
            }
            StreamUtils.closeSilently((InputStream)document);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Response importAgenciesFile(String filename, File file) throws IOException {
        try (AdminManagementClient client = this.adminManagementClientFactory.getClient();){
            Response response;
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                Response.Status status = client.importAgenciesFile((InputStream)fileInputStream, filename);
                response = Response.status((Response.Status)status).build();
            }
            return response;
        }
        catch (ReferentialException e) {
            LOGGER.error((Throwable)e);
            return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
        }
    }

    @Path(value="/agencies/{id_document:.+}")
    @GET
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.AGENCIES_ID_READ, description="Trouver un service producteur avec son identifier")
    public Response findAgencyByID(@PathParam(value="id_document") String documentId) {
        Response response;
        block11: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                ParametersChecker.checkParameter((String)"documentId is a mandatory parameter", (String[])new String[]{documentId});
                SanityChecker.checkParameter((String[])new String[]{documentId});
                RequestResponse requestResponse = client.getAgencyById(documentId);
                int st = requestResponse.isOk() ? Response.Status.OK.getStatusCode() : requestResponse.getHttpCode();
                response = Response.status((int)st).entity((Object)requestResponse).build();
                if (client == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ReferentialNotFoundException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_NOT_FOUND, (String)e.getMessage()).toResponse();
                }
                catch (ReferentialException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/agencies")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.AGENCIES_READ, description="Lister le contenu du r\u00e9f\u00e9rentiel des services producteurs")
    public Response findAgencies(@Dsl(value=DslSchema.SELECT_SINGLE) JsonNode select) throws IOException {
        Response response;
        block10: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                SanityChecker.checkJsonAll((JsonNode)select);
                JsonNode result = client.getAgencies(select);
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ReferentialException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/accessionregisters")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.ACCESSIONREGISTERS_READ, description="Lister le contenu du r\u00e9f\u00e9rentiel des registres des fonds")
    public Response getAccessionRegister(@Dsl(value=DslSchema.SELECT_SINGLE) JsonNode select) {
        Response response;
        block12: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                SanityChecker.checkJsonAll((JsonNode)select);
                RequestResponse result = client.getAccessionRegister(select);
                int st = result.isOk() ? Response.Status.OK.getStatusCode() : result.getHttpCode();
                response = Response.status((int)st).entity((Object)result).build();
                if (client == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileRulesNotFoundException | ReferentialNotFoundException e) {
                    LOGGER.error(e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_NOT_FOUND, (String)e.getMessage()).toResponse();
                }
                catch (ReferentialException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
                catch (AccessUnauthorizedException e) {
                    LOGGER.error("Access contract does not allow ", (Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_UNAUTHORIZED, (String)e.getMessage()).toResponse();
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="accessionregisterdetails")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.ACCESSIONREGISTER_DETAILS_READ, description="Lister le contenu du r\u00e9f\u00e9rentiel d\u00e9tails des registres des fonds")
    public Response getAccessionRegisterDetails(@Dsl(value=DslSchema.SELECT_SINGLE) JsonNode select) {
        Response response;
        block11: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                SanityChecker.checkJsonAll((JsonNode)select);
                RequestResponse result = client.getAccessionRegisterDetail(select);
                int st = result.isOk() ? Response.Status.OK.getStatusCode() : result.getHttpCode();
                response = Response.status((int)st).entity((Object)result).build();
                if (client == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileRulesNotFoundException | ReferentialNotFoundException e) {
                    LOGGER.error(e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_NOT_FOUND, (String)e.getMessage()).toResponse();
                }
                catch (ReferentialException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @GET
    @Path(value="accessionregisterssymbolic")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.ACCESSIONREGISTERSSYMBOLIC_READ, description="Get accession register symbolic")
    public Response getAccessionRegisterSymbolic(@Dsl(value=DslSchema.SELECT_SINGLE) JsonNode select) {
        Response response;
        block8: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                SanityChecker.checkJsonAll((JsonNode)select);
                Integer tenant = VitamThreadUtils.getVitamSession().getTenantId();
                RequestResponse result = client.getAccessionRegisterSymbolic(tenant, select);
                response = Response.status((int)result.getHttpCode()).entity((Object)result).build();
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_GET_ACCESSION_REGISTER_SYMBOLIC_ERROR, (String)e.getMessage()).setHttpCode(VitamCode.ACCESS_EXTERNAL_GET_ACCESSION_REGISTER_SYMBOLIC_ERROR.getStatus().getStatusCode()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/formats/{id_document:.+}")
    @GET
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.FORMATS_ID_READ, description="Lire un format donn\u00e9")
    public Response findFormatByID(@PathParam(value="id_document") String documentId) {
        Response response;
        block12: {
            try {
                ParametersChecker.checkParameter((String)FORMAT_ID_MANDATORY, (String[])new String[]{documentId});
                SanityChecker.checkParameter((String[])new String[]{documentId});
            }
            catch (InvalidParseOperationException | IllegalArgumentException e) {
                LOGGER.error(e);
                return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED, (String)e.getMessage()).toResponse();
            }
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                JsonNode result = client.getFormatByID(documentId);
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                if (client == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ReferentialNotFoundException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_NOT_FOUND, (String)e.getMessage()).toResponse();
                }
                catch (ReferentialException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/rules/{id_document:.+}")
    @GET
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.RULES_ID_READ, description="Lire une r\u00e8gle de gestion donn\u00e9e")
    public Response findRuleByID(@PathParam(value="id_document") String documentId) {
        Response response;
        block12: {
            try {
                ParametersChecker.checkParameter((String)FORMAT_ID_MANDATORY, (String[])new String[]{documentId});
                SanityChecker.checkParameter((String[])new String[]{documentId});
            }
            catch (InvalidParseOperationException | IllegalArgumentException e) {
                LOGGER.error(e);
                return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED, (String)e.getMessage()).toResponse();
            }
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                JsonNode result = client.getRuleByID(documentId);
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                if (client == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileRulesNotFoundException e) {
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_NOT_FOUND, (String)e.getMessage()).toResponse();
                }
                catch (ReferentialException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/ingestcontracts/{id_document:.+}")
    @GET
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.INGESTCONTRACTS_ID_READ, description="Lire un contrat d'entr\u00e9e donn\u00e9")
    public Response findIngestContractsByID(@PathParam(value="id_document") String documentId) {
        Response response;
        block12: {
            try {
                ParametersChecker.checkParameter((String)FORMAT_ID_MANDATORY, (String[])new String[]{documentId});
                SanityChecker.checkParameter((String[])new String[]{documentId});
            }
            catch (InvalidParseOperationException | IllegalArgumentException e) {
                LOGGER.error(e);
                return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED, (String)e.getMessage()).toResponse();
            }
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                RequestResponse requestResponse = client.findIngestContractsByID(documentId);
                int st = requestResponse.isOk() ? Response.Status.OK.getStatusCode() : requestResponse.getHttpCode();
                response = Response.status((int)st).entity((Object)requestResponse).build();
                if (client == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ReferentialNotFoundException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_NOT_FOUND, (String)e.getMessage()).toResponse();
                }
                catch (ReferentialException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/accesscontracts/{id_document:.+}")
    @GET
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.ACCESSCONTRACTS_ID_READ, description="Lire un contrat d'acc\u00e8s donn\u00e9")
    public Response findAccessContractsByID(@PathParam(value="id_document") String documentId) {
        Response response;
        block12: {
            try {
                ParametersChecker.checkParameter((String)FORMAT_ID_MANDATORY, (String[])new String[]{documentId});
                SanityChecker.checkParameter((String[])new String[]{documentId});
            }
            catch (InvalidParseOperationException | IllegalArgumentException e) {
                LOGGER.error(e);
                return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED, (String)e.getMessage()).toResponse();
            }
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                RequestResponse requestResponse = client.findAccessContractsByID(documentId);
                int st = requestResponse.isOk() ? Response.Status.OK.getStatusCode() : requestResponse.getHttpCode();
                response = Response.status((int)st).entity((Object)requestResponse).build();
                if (client == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ReferentialNotFoundException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_NOT_FOUND, (String)e.getMessage()).toResponse();
                }
                catch (ReferentialException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/managementcontracts/{id_document:.+}")
    @GET
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.MANAGEMENTCONTRACTS_ID_READ, description="Lire un contrat de gestion donn\u00e9")
    public Response findManagementContractsByID(@PathParam(value="id_document") String documentId) {
        Response response;
        block12: {
            try {
                ParametersChecker.checkParameter((String)FORMAT_ID_MANDATORY, (String[])new String[]{documentId});
                SanityChecker.checkParameter((String[])new String[]{documentId});
            }
            catch (InvalidParseOperationException | IllegalArgumentException e) {
                LOGGER.error(e);
                return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED, (String)e.getMessage()).toResponse();
            }
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                RequestResponse requestResponse = client.findManagementContractsByID(documentId);
                int st = requestResponse.isOk() ? Response.Status.OK.getStatusCode() : requestResponse.getHttpCode();
                response = Response.status((int)st).entity((Object)requestResponse).build();
                if (client == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ReferentialNotFoundException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_NOT_FOUND, (String)e.getMessage()).toResponse();
                }
                catch (ReferentialException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/profiles/{id_document:.+}")
    @GET
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.PROFILES_ID_READ_JSON, description="Lire un profil donn\u00e9")
    public Response findProfilesByID(@PathParam(value="id_document") String documentId) {
        Response response;
        block12: {
            try {
                ParametersChecker.checkParameter((String)FORMAT_ID_MANDATORY, (String[])new String[]{documentId});
                SanityChecker.checkParameter((String[])new String[]{documentId});
            }
            catch (InvalidParseOperationException | IllegalArgumentException e) {
                LOGGER.error(e);
                return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED, (String)e.getMessage()).toResponse();
            }
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                RequestResponse requestResponse = client.findProfilesByID(documentId);
                int st = requestResponse.isOk() ? Response.Status.OK.getStatusCode() : requestResponse.getHttpCode();
                response = Response.status((int)st).entity((Object)requestResponse).build();
                if (client == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ReferentialNotFoundException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_NOT_FOUND, (String)e.getMessage()).toResponse();
                }
                catch (ReferentialException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/archiveunitprofiles/{id_document:.+}")
    @GET
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.ARCHIVEUNITPROFILES_ID_READ_JSON, description="Lire un document type donn\u00e9")
    public Response findArchiveUnitProfilesByID(@PathParam(value="id_document") String documentId) {
        Response response;
        block12: {
            try {
                ParametersChecker.checkParameter((String)"Archive unit profile ID is a mandatory parameter", (String[])new String[]{documentId});
                SanityChecker.checkParameter((String[])new String[]{documentId});
            }
            catch (InvalidParseOperationException | IllegalArgumentException e) {
                LOGGER.error(e);
                return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED, (String)e.getMessage()).toResponse();
            }
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                RequestResponse requestResponse = client.findArchiveUnitProfilesByID(documentId);
                int st = requestResponse.isOk() ? Response.Status.OK.getStatusCode() : requestResponse.getHttpCode();
                response = Response.status((int)st).entity((Object)requestResponse).build();
                if (client == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ReferentialNotFoundException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_NOT_FOUND, (String)e.getMessage()).toResponse();
                }
                catch (ReferentialException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/contexts/{id_document:.+}")
    @GET
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.CONTEXTS_ID_READ, description="Lire un contexte donn\u00e9")
    public Response findContextById(@PathParam(value="id_document") String documentId) {
        Response response;
        block12: {
            try {
                ParametersChecker.checkParameter((String)FORMAT_ID_MANDATORY, (String[])new String[]{documentId});
                SanityChecker.checkParameter((String[])new String[]{documentId});
            }
            catch (InvalidParseOperationException | IllegalArgumentException e) {
                LOGGER.error(e);
                return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED, (String)e.getMessage()).toResponse();
            }
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                RequestResponse requestResponse = client.findContextById(documentId);
                int st = requestResponse.isOk() ? Response.Status.OK.getStatusCode() : requestResponse.getHttpCode();
                response = Response.status((int)st).entity((Object)requestResponse).build();
                if (client == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ReferentialNotFoundException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_NOT_FOUND, (String)e.getMessage()).toResponse();
                }
                catch (ReferentialException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/contexts/{identifier:.+}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.CONTEXTS_ID_UPDATE, description="Effectuer une mise \u00e0 jour sur un contexte", isAdminOnly=true)
    public Response updateContext(@PathParam(value="identifier") String identifier, @Dsl(value=DslSchema.UPDATE_BY_ID) JsonNode queryDsl) throws AdminManagementClientServerException, InvalidParseOperationException {
        Response response;
        block10: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                UpdateParserSingle updateParserSingle = new UpdateParserSingle();
                updateParserSingle.parse(queryDsl);
                Update update = updateParserSingle.getRequest();
                update.setQuery((Query)QueryHelper.eq((String)IDENTIFIER, (String)identifier));
                RequestResponse response2 = client.updateContext(identifier, (JsonNode)update.getFinalUpdate());
                response = this.getResponse(response2);
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ReferentialNotFoundException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_CONTEXT_NOT_FOUND, (String)e.getMessage()).setHttpCode(Response.Status.NOT_FOUND.getStatusCode()).toResponse();
                }
                catch (InvalidCreateOperationException | InvalidParseOperationException | AdminManagementClientServerException e) {
                    LOGGER.error(e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_UPDATE_CONTEXT_ERROR, (String)e.getMessage()).toResponse();
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_UPDATE_CONTEXT_ERROR, (String)e.getMessage()).setHttpCode(Response.Status.PRECONDITION_FAILED.getStatusCode()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/profiles/{identifier:.+}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.PROFILES_ID_UPDATE_JSON, description="Effectuer une mise \u00e0 jour sur un profil")
    public Response updateProfile(@PathParam(value="identifier") String identifier, @Dsl(value=DslSchema.UPDATE_BY_ID) JsonNode queryDsl) throws AdminManagementClientServerException, InvalidParseOperationException {
        Response response;
        block10: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                UpdateParserSingle updateParserSingle = new UpdateParserSingle();
                updateParserSingle.parse(queryDsl);
                Update update = updateParserSingle.getRequest();
                update.setQuery((Query)QueryHelper.eq((String)IDENTIFIER, (String)identifier));
                RequestResponse response2 = client.updateProfile(identifier, (JsonNode)update.getFinalUpdate());
                response = this.getResponse(response2);
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidCreateOperationException | InvalidParseOperationException | AdminManagementClientBadRequestException e) {
                    LOGGER.error(e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_UPDATE_PROFILE_ERROR, (String)e.getMessage()).toResponse();
                }
                catch (ReferentialNotFoundException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_PROFILE_NOT_FOUND, (String)e.getMessage()).setHttpCode(Response.Status.NOT_FOUND.getStatusCode()).toResponse();
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_UPDATE_PROFILE_ERROR, (String)e.getMessage()).setHttpCode(Response.Status.PRECONDITION_FAILED.getStatusCode()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/archiveunitprofiles/{identifier:.+}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.ARCHIVEUNITPROFILES_ID_UPDATE_JSON, description="Effectuer une mise \u00e0 jour sur un document type")
    public Response updateArchiveUnitProfile(@PathParam(value="identifier") String identifier, @Dsl(value=DslSchema.UPDATE_BY_ID) JsonNode queryDsl) throws AdminManagementClientServerException {
        Response response;
        block10: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                UpdateParserSingle updateParserSingle = new UpdateParserSingle();
                updateParserSingle.parse(queryDsl);
                Update update = updateParserSingle.getRequest();
                update.setQuery((Query)QueryHelper.eq((String)IDENTIFIER, (String)identifier));
                RequestResponse response2 = client.updateArchiveUnitProfile(identifier, (JsonNode)update.getFinalUpdate());
                response = this.getResponse(response2);
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ReferentialNotFoundException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_PROFILE_NOT_FOUND, (String)e.getMessage()).setHttpCode(Response.Status.NOT_FOUND.getStatusCode()).toResponse();
                }
                catch (InvalidCreateOperationException | InvalidParseOperationException e) {
                    LOGGER.error(e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_UPDATE_PROFILE_ERROR, (String)e.getMessage()).toResponse();
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_UPDATE_PROFILE_ERROR, (String)e.getMessage()).setHttpCode(Response.Status.PRECONDITION_FAILED.getStatusCode()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/accesscontracts/{identifier:.+}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.ACCESSCONTRACTS_ID_UPDATE, description="Effectuer une mise \u00e0 jour sur un contrat d'acc\u00e8s")
    public Response updateAccessContract(@PathParam(value="identifier") String identifier, @Dsl(value=DslSchema.UPDATE_BY_ID) JsonNode queryDsl) throws AdminManagementClientServerException {
        Response response;
        block10: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                UpdateParserSingle updateParserSingle = new UpdateParserSingle();
                updateParserSingle.parse(queryDsl);
                Update update = updateParserSingle.getRequest();
                update.setQuery((Query)QueryHelper.eq((String)IDENTIFIER, (String)identifier));
                RequestResponse response2 = client.updateAccessContract(identifier, (JsonNode)update.getFinalUpdate());
                response = this.getResponse(response2);
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidCreateOperationException | InvalidParseOperationException | AdminManagementClientBadRequestException e) {
                    LOGGER.error(e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_UPDATE_ACCESS_CONTRACT_ERROR, (String)e.getMessage()).toResponse();
                }
                catch (ReferentialNotFoundException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.CONTRACT_NOT_FOUND_ERROR, (String)e.getMessage()).setHttpCode(Response.Status.NOT_FOUND.getStatusCode()).toResponse();
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_UPDATE_ACCESS_CONTRACT_ERROR, (String)e.getMessage()).setHttpCode(Response.Status.PRECONDITION_FAILED.getStatusCode()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/ingestcontracts/{identifier:.+}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.INGESTCONTRACTS_ID_UPDATE, description="Effectuer une mise \u00e0 jour sur un contrat d'entr\u00e9e")
    public Response updateIngestContract(@PathParam(value="identifier") String identifier, @Dsl(value=DslSchema.UPDATE_BY_ID) JsonNode queryDsl) throws AdminManagementClientServerException {
        Response response;
        block10: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                UpdateParserSingle updateParserSingle = new UpdateParserSingle();
                updateParserSingle.parse(queryDsl);
                Update update = updateParserSingle.getRequest();
                update.setQuery((Query)QueryHelper.eq((String)IDENTIFIER, (String)identifier));
                RequestResponse response2 = client.updateIngestContract(identifier, (JsonNode)update.getFinalUpdate());
                response = this.getResponse(response2);
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidCreateOperationException | InvalidParseOperationException | AdminManagementClientBadRequestException e) {
                    LOGGER.error(e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_UPDATE_INGEST_CONTRACT_ERROR, (String)e.getMessage()).toResponse();
                }
                catch (ReferentialNotFoundException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.CONTRACT_NOT_FOUND_ERROR, (String)e.getMessage()).setHttpCode(Response.Status.NOT_FOUND.getStatusCode()).toResponse();
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_UPDATE_INGEST_CONTRACT_ERROR, (String)e.getMessage()).setHttpCode(Response.Status.PRECONDITION_FAILED.getStatusCode()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/managementcontracts/{identifier:.+}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.MANAGEMENTCONTRACTS_ID_UPDATE, description="Effectuer une mise \u00e0 jour sur un contrat de gestion")
    public Response updateManagementContract(@PathParam(value="identifier") String identifier, @Dsl(value=DslSchema.UPDATE_BY_ID) JsonNode queryDsl) {
        Response response;
        block10: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                UpdateParserSingle updateParserSingle = new UpdateParserSingle();
                updateParserSingle.parse(queryDsl);
                Update update = updateParserSingle.getRequest();
                update.setQuery((Query)QueryHelper.eq((String)IDENTIFIER, (String)identifier));
                RequestResponse response2 = client.updateManagementContract(identifier, (JsonNode)update.getFinalUpdate());
                response = this.getResponse(response2);
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ReferentialNotFoundException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.CONTRACT_NOT_FOUND_ERROR, (String)e.getMessage()).setHttpCode(Response.Status.NOT_FOUND.getStatusCode()).toResponse();
                }
                catch (InvalidCreateOperationException | InvalidParseOperationException | AdminManagementClientServerException e) {
                    LOGGER.error(e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_UPDATE_MANAGEMENT_CONTRACT_ERROR, (String)e.getMessage()).toResponse();
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_UPDATE_MANAGEMENT_CONTRACT_ERROR, (String)e.getMessage()).setHttpCode(Response.Status.PRECONDITION_FAILED.getStatusCode()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @GET
    @Path(value="/accessionregisters/{id_document}/accessionregisterdetails")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.ACCESSIONREGISTERS_ID_ACCESSIONREGISTERDETAILS_READ, description="Lister les d\u00e9tails d'un registre de fonds")
    public Response findAccessionRegisterDetail(@PathParam(value="id_document") String originatingAgency, @Dsl(value=DslSchema.SELECT_SINGLE) JsonNode select) {
        Response response;
        block10: {
            ParametersChecker.checkParameter((String)"accession register id is a mandatory parameter", (String[])new String[]{originatingAgency});
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                SanityChecker.checkJsonAll((JsonNode)select);
                RequestResponse result = client.getAccessionRegisterDetail(originatingAgency, select);
                int st = result.isOk() ? Response.Status.OK.getStatusCode() : result.getHttpCode();
                response = Response.status((int)st).entity((Object)result).build();
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ReferentialNotFoundException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_GET_ACCESSION_REGISTER_DETAIL_ERROR, (String)e.getMessage()).setHttpCode(Response.Status.NOT_FOUND.getStatusCode()).toResponse();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
                catch (Exception e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @POST
    @Path(value="/traceabilitychecks")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.TRACEABILITYCHECKS_CREATE, description="Tester l'int\u00e9grit\u00e9 d'un journal s\u00e9curis\u00e9")
    @Deprecated
    public Response checkOperationTraceability(@Dsl(value=DslSchema.SELECT_SINGLE) JsonNode query) {
        return this.linkedCheckOperationTraceability(query);
    }

    @POST
    @Path(value="/traceability/linkedchecks")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.TRACEABILITYLINKEDCHECKS_CREATE, description="Tester l'int\u00e9grit\u00e9 d'un journal s\u00e9curis\u00e9")
    public Response linkedCheckOperationTraceability(@Dsl(value=DslSchema.SELECT_SINGLE) JsonNode query) {
        Response response;
        block10: {
            AccessInternalClient client = this.accessInternalClientFactory.getClient();
            try {
                ParametersChecker.checkParameter((String)"checks operation Logbook traceability parameters", (Object[])new Object[]{query});
                SanityChecker.checkJsonAll((JsonNode)query);
                RequestResponse result = client.linkedCheckTraceability(query);
                int statusCode = result.isOk() ? Response.Status.OK.getStatusCode() : result.getHttpCode();
                response = Response.status((int)statusCode).entity((Object)result).build();
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | IllegalArgumentException e) {
                    LOGGER.error(e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
                catch (LogbookClientException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
                }
                catch (AccessUnauthorizedException e) {
                    LOGGER.error("Contract access does not allow ", (Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_UNAUTHORIZED, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @POST
    @Path(value="/audits/referential")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.REFERENTIALAUDIT_CHECK, description="Lancer un audit de r\u00e9f\u00e9rentiel")
    public Response launchReferentialAudit(AuditReferentialOptions options) {
        Response response;
        block8: {
            ParametersChecker.checkParameter((String)"audit options", (Object[])new Object[]{options});
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                RequestResponse result = client.launchReferentialAudit(options);
                int st = result.isOk() ? Response.Status.OK.getStatusCode() : result.getHttpCode();
                response = Response.status((int)st).entity((Object)result).build();
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AdminManagementClientServerException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @POST
    @Path(value="/audits")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.AUDITS_CREATE, description="Lancer un audit de l'existance des objets")
    public Response launchAudit(AuditOptions options) {
        Response response;
        block10: {
            ParametersChecker.checkParameter((String)"audit options", (Object[])new Object[]{options});
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                RequestResponse result;
                if (options.getQuery() != null) {
                    SanityChecker.checkJsonAll((JsonNode)options.getQuery());
                    BatchProcessingQuerySchemaValidator validator = new BatchProcessingQuerySchemaValidator();
                    validator.validate(options.getQuery());
                }
                int st = (result = client.launchAuditWorkflow(options, true)).isOk() ? Response.Status.OK.getStatusCode() : result.getHttpCode();
                response = Response.status((int)st).entity((Object)result).build();
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ValidationException | InvalidParseOperationException | AdminManagementClientServerException e) {
                    LOGGER.error(e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
                catch (IOException e) {
                    LOGGER.error("Technical exception", (Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/securityprofiles")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.SECURITYPROFILES_CREATE_JSON, isAdminOnly=true, description="Importer des profiles de s\u00e9curit\u00e9 dans le r\u00e9f\u00e9rentiel")
    public Response importSecurityProfiles(JsonNode document) {
        Response response;
        block8: {
            ParametersChecker.checkParameter((String)"Json document is a mandatory parameter", (Object[])new Object[]{document});
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                SanityChecker.checkJsonAll((JsonNode)document);
                Response.Status status = client.importSecurityProfiles((List)JsonHandler.getFromStringAsTypeReference((String)document.toString(), (TypeReference)new TypeReference<List<SecurityProfileModel>>(){}));
                response = Response.status((Response.Status)status).build();
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidFormatException | InvalidParseOperationException | ReferentialException e) {
                    LOGGER.error(e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @POST
    @Path(value="/probativevalueexport")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.PROBATIVEVALUE_CREATE, description="Lancer un export du relev\u00e9 de valeur probante")
    public Response exportProbativeValue(ProbativeValueRequest probativeValueRequest) {
        Response response;
        block8: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                SanityChecker.checkJsonAll((JsonNode)probativeValueRequest.getDslQuery());
                RequestResponse result = client.exportProbativeValue(probativeValueRequest);
                int st = result.isOk() ? Response.Status.OK.getStatusCode() : result.getHttpCode();
                response = Response.status((int)st).entity((Object)result).build();
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | AdminManagementClientServerException e) {
                    LOGGER.error(e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/securityprofiles")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.SECURITYPROFILES_READ, description="Lister le contenu du r\u00e9f\u00e9rentiel des profiles de s\u00e9curit\u00e9")
    public Response findSecurityProfiles(@Dsl(value=DslSchema.SELECT_SINGLE) JsonNode select) {
        Response response;
        block10: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                SanityChecker.checkJsonAll((JsonNode)select);
                RequestResponse result = client.findSecurityProfiles(select);
                int st = result.isOk() ? Response.Status.OK.getStatusCode() : result.getHttpCode();
                response = Response.status((int)st).entity((Object)result).build();
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ReferentialException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/securityprofiles/{identifier}")
    @GET
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.SECURITYPROFILES_ID_READ, description="Lire un profile de s\u00e9curit\u00e9 donn\u00e9")
    public Response findSecurityProfileByIdentifier(@PathParam(value="identifier") String identifier) {
        Response response;
        block11: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                ParametersChecker.checkParameter((String)"identifier is a mandatory parameter", (String[])new String[]{identifier});
                RequestResponse requestResponse = client.findSecurityProfileByIdentifier(identifier);
                int st = requestResponse.isOk() ? Response.Status.OK.getStatusCode() : requestResponse.getHttpCode();
                response = Response.status((int)st).entity((Object)requestResponse).build();
                if (client == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ReferentialNotFoundException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_NOT_FOUND, (String)e.getMessage()).toResponse();
                }
                catch (ReferentialException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/securityprofiles/{identifier}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.SECURITYPROFILES_ID_UPDATE, isAdminOnly=true, description="Effectuer une mise \u00e0 jour sur un profil de s\u00e9curit\u00e9")
    public Response updateSecurityProfile(@PathParam(value="identifier") String identifier, @Dsl(value=DslSchema.UPDATE_BY_ID) JsonNode queryDsl) throws AdminManagementClientServerException {
        Response response;
        block10: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                UpdateParserSingle updateParserSingle = new UpdateParserSingle();
                updateParserSingle.parse(queryDsl);
                Update update = updateParserSingle.getRequest();
                update.setQuery((Query)QueryHelper.eq((String)IDENTIFIER, (String)identifier));
                RequestResponse response2 = client.updateSecurityProfile(identifier, (JsonNode)update.getFinalUpdateById());
                response = this.getResponse(response2);
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidCreateOperationException | InvalidParseOperationException | AdminManagementClientBadRequestException e) {
                    LOGGER.error(e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_UPDATE_SECURITY_PROFILE_ERROR, (String)e.getMessage()).toResponse();
                }
                catch (ReferentialNotFoundException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SECURITY_PROFILE_NOT_FOUND, (String)e.getMessage()).setHttpCode(Response.Status.PRECONDITION_FAILED.getStatusCode()).toResponse();
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_UPDATE_SECURITY_PROFILE_ERROR, (String)e.getMessage()).setHttpCode(Response.Status.PRECONDITION_FAILED.getStatusCode()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @GET
    @Path(value="/operations")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.OPERATIONS_READ, description="R\u00e9cup\u00e9rer les informations sur une op\u00e9ration donn\u00e9e")
    public Response listOperationsDetails(@Context HttpHeaders headers, ProcessQuery query) {
        Response response;
        block8: {
            IngestInternalClient client = this.ingestInternalClientFactory.getClient();
            try {
                response = client.listOperationsDetails(query).toResponse();
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientException e) {
                    LOGGER.error(UNEXPECTED_ERROR + e.getMessage(), (Throwable)e);
                    return Response.serverError().entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_CLIENT_ERROR, (String)e.getLocalizedMessage())).build();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="operations/{id}")
    @HEAD
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.OPERATIONS_ID_READ_STATUS, description="R\u00e9cup\u00e9rer le code HTTP d'une op\u00e9ration donn\u00e9e")
    public Response getWorkFlowExecutionStatus(@PathParam(value="id") String id) {
        Response response;
        block13: {
            IngestInternalClient ingestInternalClient = this.ingestInternalClientFactory.getClient();
            try {
                SanityChecker.checkParameter((String[])new String[]{id});
                ItemStatus itemStatus = ingestInternalClient.getOperationProcessStatus(id);
                Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.ACCEPTED);
                if (ProcessState.COMPLETED.equals((Object)itemStatus.getGlobalState())) {
                    builder.status(Response.Status.OK);
                } else {
                    builder.status(Response.Status.ACCEPTED);
                }
                response = builder.header("X-Global-Execution-State", (Object)itemStatus.getGlobalState()).header("X-Global-Execution-Status", (Object)itemStatus.getGlobalStatus()).header("X-Context-Id", (Object)itemStatus.getLogbookTypeProcess()).build();
                if (ingestInternalClient == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (ingestInternalClient != null) {
                        try {
                            ingestInternalClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | IllegalArgumentException e) {
                    LOGGER.error(e);
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
                }
                catch (WorkflowNotFoundException e) {
                    LOGGER.error((Throwable)e);
                    return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                }
                catch (InternalServerException | VitamClientException e) {
                    LOGGER.error(e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                }
                catch (BadRequestException e) {
                    LOGGER.error((Throwable)e);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
            }
            ingestInternalClient.close();
        }
        return response;
    }

    @Path(value="operations/{id}")
    @GET
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.OPERATIONS_ID_READ, description="R\u00e9cup\u00e9rer le statut d'une op\u00e9ration donn\u00e9e")
    public Response getOperationProcessExecutionDetails(@PathParam(value="id") String id) {
        Response response;
        block9: {
            IngestInternalClient ingestInternalClient = this.ingestInternalClientFactory.getClient();
            try {
                response = ingestInternalClient.getOperationProcessExecutionDetails(id).toResponse();
                if (ingestInternalClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ingestInternalClient != null) {
                        try {
                            ingestInternalClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("Illegal argument: ", (Throwable)e);
                    Response.Status status = Response.Status.PRECONDITION_FAILED;
                    return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.INGEST_EXTERNAL_GET_OPERATION_PROCESS_DETAIL_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
                }
                catch (VitamClientException e) {
                    LOGGER.error(UNEXPECTED_ERROR + e.getMessage(), (Throwable)e);
                    Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
                    return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.INGEST_EXTERNAL_GET_OPERATION_PROCESS_DETAIL_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
                }
            }
            ingestInternalClient.close();
        }
        return response;
    }

    @Path(value="operations/{id}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.OPERATIONS_ID_UPDATE, description="Changer le statut d'une op\u00e9ration donn\u00e9e")
    public Response updateWorkFlowStatus(@Context HttpHeaders headers, @PathParam(value="id") String id) {
        ParametersChecker.checkParameter((String)"ACTION Request must not be null", (Object[])new Object[]{headers.getRequestHeader("X-ACTION")});
        String xAction = (String)headers.getRequestHeader("X-ACTION").get(0);
        return this.updateOperationActionProcessAsync(id, xAction);
    }

    private Response updateOperationActionProcessAsync(String operationId, String action) {
        Response response;
        block9: {
            IngestInternalClient ingestInternalClient = this.ingestInternalClientFactory.getClient();
            try {
                VitamThreadUtils.getVitamSession().setRequestId(operationId);
                RequestResponse itemStatusRequestResponse = ingestInternalClient.updateOperationActionProcess(action, operationId);
                response = itemStatusRequestResponse.toResponse();
                if (ingestInternalClient == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ingestInternalClient != null) {
                        try {
                            ingestInternalClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ProcessingException e) {
                    LOGGER.error("Unauthorized action for update ", (Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.INGEST_EXTERNAL_UNAUTHORIZED, (String)e.getLocalizedMessage()).toResponse();
                }
                catch (VitamClientException e) {
                    LOGGER.error("Client exception while trying to update operation process ", (Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.INGEST_EXTERNAL_INTERNAL_CLIENT_ERROR, (String)e.getLocalizedMessage()).toResponse();
                }
            }
            ingestInternalClient.close();
        }
        return response;
    }

    @Path(value="operations/{id}")
    @DELETE
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.OPERATIONS_ID_DELETE, description="Annuler une op\u00e9ration donn\u00e9e")
    public Response interruptWorkFlowExecution(@PathParam(value="id") String id) {
        VitamError vitamError;
        block10: {
            Response response;
            block9: {
                ParametersChecker.checkParameter((String)"operationId must not be null", (String[])new String[]{id});
                IngestInternalClient ingestInternalClient = this.ingestInternalClientFactory.getClient();
                try {
                    SanityChecker.checkParameter((String[])new String[]{id});
                    VitamThreadUtils.getVitamSession().setRequestId(id);
                    RequestResponse requestResponse = ingestInternalClient.cancelOperationProcessExecution(id);
                    response = requestResponse.toResponse();
                    if (ingestInternalClient == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (ingestInternalClient != null) {
                            try {
                                ingestInternalClient.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InvalidParseOperationException | IllegalArgumentException e) {
                        LOGGER.error("Illegal argument: ", e);
                        vitamError = VitamCodeHelper.toVitamError((VitamCode)VitamCode.INGEST_EXTERNAL_ILLEGAL_ARGUMENT, (String)e.getLocalizedMessage());
                        break block10;
                    }
                    catch (VitamClientException e) {
                        LOGGER.error("Client exception while trying to cancel operation: ", (Throwable)e);
                        vitamError = VitamCodeHelper.toVitamError((VitamCode)VitamCode.INGEST_EXTERNAL_INTERNAL_CLIENT_ERROR, (String)e.getLocalizedMessage());
                    }
                }
                ingestInternalClient.close();
            }
            return response;
        }
        return Response.status((int)vitamError.getHttpCode()).entity((Object)vitamError).build();
    }

    @GET
    @Path(value="/workflows")
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.WORKFLOWS_READ, description="R\u00e9cup\u00e9rer la liste des t\u00e2ches des workflows")
    public Response getWorkflowDefinitions(@Context HttpHeaders headers) {
        Response response;
        block8: {
            IngestInternalClient client = this.ingestInternalClientFactory.getClient();
            try {
                response = client.getWorkflowDefinitions().toResponse();
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientException e) {
                    LOGGER.error(UNEXPECTED_ERROR + e.getMessage(), (Throwable)e);
                    return Response.serverError().entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.INGEST_EXTERNAL_INTERNAL_CLIENT_ERROR, (String)e.getLocalizedMessage())).build();
                }
            }
            client.close();
        }
        return response;
    }

    @GET
    @Path(value="/rulesreport/{opId}")
    @Produces(value={"application/octet-stream"})
    @Secured(permission=SecurityProfilePermissions.RULESREPORT_ID_READ, description="R\u00e9cup\u00e9rer le rapport pour une op\u00e9ration d'import de r\u00e8gles de gestion")
    public Response downloadRulesReportAsStream(@PathParam(value="opId") String opId) {
        return this.downloadObjectAsync(opId, IngestCollection.RULES);
    }

    @GET
    @Path(value="/batchreport/{opId}")
    @Produces(value={"application/octet-stream"})
    @Secured(permission=SecurityProfilePermissions.BATCHREPORT_ID_READ, description="R\u00e9cup\u00e9rer le rapport pour un traitement de masse (Elimination, Preservation, Audit, Mise \u00e0 jour)")
    public Response downloadBatchReportAsStream(@PathParam(value="opId") String opId) {
        return this.downloadObjectAsync(opId, IngestCollection.BATCH_REPORT);
    }

    @GET
    @Path(value="/distributionreport/{opId}")
    @Produces(value={"application/octet-stream"})
    @Secured(permission=SecurityProfilePermissions.DISTRIBUTIONREPORT_ID_READ, description="R\u00e9cup\u00e9rer le rapport pour une op\u00e9ration de mise \u00e0 jour de masse distribu\u00e9e")
    public Response downloadDistributionReportAsStream(@PathParam(value="opId") String opId) {
        return this.downloadObjectAsync(opId, IngestCollection.DISTRIBUTIONREPORTS);
    }

    @GET
    @Path(value="/rulesreferential/{opId}")
    @Produces(value={"application/octet-stream"})
    @Secured(permission=SecurityProfilePermissions.RULESREFERENTIAL_ID_READ, description="R\u00e9cup\u00e9rer le r\u00e9f\u00e9rentiel pour une op\u00e9ration d'import de r\u00e8gles de gestion")
    public Response downloadAgenciesCsvAsStream(@PathParam(value="opId") String opId) {
        return this.downloadObjectAsync(opId, IngestCollection.REFERENTIAL_RULES_CSV);
    }

    @GET
    @Path(value="/agenciesreferential/{opId}")
    @Produces(value={"application/octet-stream"})
    @Secured(permission=SecurityProfilePermissions.AGENCIESREFERENTIAL_ID_READ, description="R\u00e9cup\u00e9rer le r\u00e9f\u00e9rentiel pour une op\u00e9ration d'import des service agents")
    public Response downloadRulesCsvAsStream(@PathParam(value="opId") String opId) {
        return this.downloadObjectAsync(opId, IngestCollection.REFERENTIAL_AGENCIES_CSV);
    }

    private Response downloadObjectAsync(String objectId, IngestCollection collection) {
        VitamAsyncInputStreamResponse vitamAsyncInputStreamResponse;
        block11: {
            IngestInternalClient ingestInternalClient = this.ingestInternalClientFactory.getClient();
            try {
                Response response = ingestInternalClient.downloadObjectAsync(objectId, collection);
                vitamAsyncInputStreamResponse = new VitamAsyncInputStreamResponse(response);
                if (ingestInternalClient == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (ingestInternalClient != null) {
                        try {
                            ingestInternalClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error("IllegalArgumentException was thrown : ", (Throwable)e);
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorStream(VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getLocalizedMessage()))).build();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error("Predicates Failed Exception", (Throwable)e);
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)this.getErrorStream(VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED, (String)e.getLocalizedMessage()))).build();
                }
                catch (IngestInternalClientServerException e) {
                    LOGGER.error("Internal Server Exception ", (Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorStream(VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage()))).build();
                }
                catch (IngestInternalClientNotFoundException e) {
                    LOGGER.error("Request resources does not exits", (Throwable)e);
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.getErrorStream(VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_NOT_FOUND, (String)e.getLocalizedMessage()))).build();
                }
            }
            ingestInternalClient.close();
        }
        return vitamAsyncInputStreamResponse;
    }

    private InputStream getErrorStream(VitamError vitamError) {
        try {
            return JsonHandler.writeToInpustream((Object)vitamError);
        }
        catch (InvalidParseOperationException e) {
            return new ByteArrayInputStream("{ 'message' : 'Invalid VitamError message' }".getBytes());
        }
    }

    @Path(value="/evidenceaudit")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.EVIDENCEAUDIT_CHECK, description="Audit de tra\u00e7abilit\u00e9 d'unit\u00e9s archivistiques")
    public Response checkEvidenceAudit(@Dsl(value=DslSchema.SELECT_MULTIPLE) JsonNode select) {
        Response response;
        block8: {
            ParametersChecker.checkParameter((String)"mandatory parameter", (Object[])new Object[]{select});
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                RequestResponse result = client.evidenceAudit(select);
                int st = result.isOk() ? Response.Status.OK.getStatusCode() : result.getHttpCode();
                response = Response.status((int)st).entity((Object)result).build();
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AdminManagementClientServerException e) {
                    LOGGER.error(UNEXPECTED_ERROR + e.getMessage(), (Throwable)e);
                    return Response.serverError().entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_UNIT_TRACREABILITY_AUDIT, (String)e.getLocalizedMessage())).build();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/rectificationaudit")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.RECTIFICATIONAUDIT_CHECK, description="rectification de donn\u00e9es suite a un audit")
    public Response rectificationAudit(String operationId) {
        Response response;
        block8: {
            ParametersChecker.checkParameter((String)"mandatory parameter", (String[])new String[]{operationId});
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                RequestResponse result = client.rectificationAudit(operationId);
                int st = result.isOk() ? Response.Status.OK.getStatusCode() : result.getHttpCode();
                response = Response.status((int)st).entity((Object)result).build();
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AdminManagementClientServerException e) {
                    LOGGER.error(UNEXPECTED_ERROR + e.getMessage(), (Throwable)e);
                    return Response.serverError().entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_UNIT_TRACREABILITY_AUDIT, (String)e.getLocalizedMessage())).build();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/ontologies")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.ONTOLOGIES_CREATE_JSON, description="Importer les ontologies dans le r\u00e9f\u00e9rentiel")
    public Response importOntologies(@HeaderParam(value="Force-Update") boolean forceUpdate, JsonNode ontologies) {
        Response response;
        block9: {
            ParametersChecker.checkParameter((String)"Json ontologies is a mandatory parameter", (Object[])new Object[]{ontologies});
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                SanityChecker.checkJsonAll((JsonNode)ontologies);
                RequestResponse requestResponse = client.importOntologies(forceUpdate, (List)JsonHandler.getFromStringAsTypeReference((String)ontologies.toString(), (TypeReference)new TypeReference<List<OntologyModel>>(){}));
                response = Response.status((int)requestResponse.getStatus()).entity((Object)requestResponse).build();
                if (client == null) break block9;
            }
            catch (Throwable requestResponse) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            requestResponse.addSuppressed(throwable);
                        }
                    }
                    throw requestResponse;
                }
                catch (ReferentialException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
                catch (InvalidFormatException | InvalidParseOperationException e) {
                    LOGGER.error(e);
                    VitamError error = new VitamError(VitamCode.ACCESS_EXTERNAL_INVALID_JSON.getItem()).setMessage(VitamCode.ACCESS_EXTERNAL_INVALID_JSON.getMessage()).setState(StatusCode.KO.name()).setCode(VitamCodeHelper.getCode((VitamCode)VitamCode.ACCESS_EXTERNAL_INVALID_JSON)).setContext(ACCESS_EXTERNAL_MODULE).setDescription(VitamCode.ACCESS_EXTERNAL_INVALID_JSON.getMessage());
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error).build();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/ontologies")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.ONTOLOGIES_READ, description="Lister le contenu du r\u00e9f\u00e9rentiel des ontologies")
    public Response findOntologies(@Dsl(value=DslSchema.SELECT_SINGLE) JsonNode select) {
        Response response;
        block9: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                SanityChecker.checkJsonAll((JsonNode)select);
                RequestResponse result = client.findOntologies(select);
                int st = result.isOk() ? Response.Status.OK.getStatusCode() : result.getHttpCode();
                response = Response.status((int)st).entity((Object)result).build();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/ontologies/{id_document:.+}")
    @GET
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.ONTOLOGIES_ID_READ_JSON, description="Lire une ontologie")
    public Response findOntologiesByID(@PathParam(value="id_document") String documentId) {
        Response response;
        block12: {
            try {
                ParametersChecker.checkParameter((String)"Ontology ID is a mandatory parameter", (String[])new String[]{documentId});
                SanityChecker.checkParameter((String[])new String[]{documentId});
            }
            catch (InvalidParseOperationException | IllegalArgumentException e) {
                LOGGER.error(e);
                return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED, (String)e.getMessage()).toResponse();
            }
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                RequestResponse requestResponse = client.findOntologyByID(documentId);
                int st = requestResponse.isOk() ? Response.Status.OK.getStatusCode() : requestResponse.getHttpCode();
                response = Response.status((int)st).entity((Object)requestResponse).build();
                if (client == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ReferentialNotFoundException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_NOT_FOUND, (String)e.getMessage()).toResponse();
                }
                catch (ReferentialException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/forcepause")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.FORCEPAUSE_CHECK, description="Force la pause sur un type d'operation et/ou sur un tenant")
    public Response forcePause(ProcessPause info) {
        Response response;
        block8: {
            ParametersChecker.checkParameter((String)"Json ProcessPause is a mandatory parameter", (Object[])new Object[]{info});
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                RequestResponse requestResponse = client.forcePause(info);
                response = Response.status((int)requestResponse.getStatus()).entity((Object)requestResponse).build();
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AdminManagementClientServerException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/removeforcepause")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.REMOVEFORCEPAUSE_CHECK, description="Retire la pause sur un type d'operation et/ou sur un tenant")
    public Response removeForcePause(ProcessPause info) {
        Response response;
        block8: {
            ParametersChecker.checkParameter((String)"Json ProcessPause is a mandatory parameter", (Object[])new Object[]{info});
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                RequestResponse requestResponse = client.removeForcePause(info);
                response = Response.status((int)requestResponse.getStatus()).entity((Object)requestResponse).build();
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AdminManagementClientServerException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @POST
    @Path(value="/griffin")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.GRIFFINS_CREATE, isAdminOnly=true, description="Import du griffon")
    public Response importGriffin(JsonNode griffins) throws AdminManagementClientServerException {
        Response response;
        block9: {
            ParametersChecker.checkParameter((String)"Json griffin is a mandatory parameter", (Object[])new Object[]{griffins});
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                SanityChecker.checkJsonAll((JsonNode)griffins);
                RequestResponse requestResponse = client.importGriffins((List)JsonHandler.getFromStringAsTypeReference((String)griffins.toString(), (TypeReference)new TypeReference<List<GriffinModel>>(){}));
                response = Response.status((int)requestResponse.getStatus()).entity((Object)requestResponse).build();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidFormatException | InvalidParseOperationException | AdminManagementClientBadRequestException e) {
                    return this.buildErrorResponse(VitamCode.PRESERVATION_VALIDATION_ERROR, e.getMessage());
                }
                catch (ReferentialException e) {
                    return this.buildErrorResponse(VitamCode.PRESERVATION_INTERNAL_ERROR, e.getMessage());
                }
            }
            client.close();
        }
        return response;
    }

    @GET
    @Path(value="/griffin")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.GRIFFINS_READ, description="Lister le contenu du r\u00e9f\u00e9rentiel des griffons")
    public Response findGriffin(@Dsl(value=DslSchema.SELECT_SINGLE) JsonNode select) throws AdminManagementClientServerException {
        Response response;
        block9: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                SanityChecker.checkJsonAll((JsonNode)select);
                RequestResponse result = client.findGriffin(select);
                int st = result.isOk() ? Response.Status.OK.getStatusCode() : result.getHttpCode();
                response = Response.status((int)st).entity((Object)result).build();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ReferentialException e) {
                    LOGGER.error((Throwable)e);
                    return this.buildErrorResponse(VitamCode.PRESERVATION_INTERNAL_ERROR, e.getMessage());
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error((Throwable)e);
                    return this.buildErrorResponse(VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, e.getMessage());
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/preservationScenario")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.PRESERVATIONSCENARIOS_READ, description="Lister le contenu du r\u00e9f\u00e9rentiel des pr\u00e9servation sc\u00e9narios")
    public Response findPreservationScenarios(@Dsl(value=DslSchema.SELECT_SINGLE) JsonNode select) {
        Response response;
        block10: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                SanityChecker.checkJsonAll((JsonNode)select);
                RequestResponse result = client.findPreservation(select);
                int st = result.isOk() ? Response.Status.OK.getStatusCode() : result.getHttpCode();
                response = Response.status((int)st).entity((Object)result).build();
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ReferentialException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_PRECONDITION_FAILED, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @POST
    @Path(value="/preservationScenario")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.PRESERVATIONSCENARIOS_CREATE, description="Import des perservation sc\u00e9narios")
    public Response importPreservationScenario(JsonNode preservationScenarios) {
        Response response;
        block9: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                ParametersChecker.checkParameter((String)"Json preservationScenarios is a mandatory parameter", (Object[])new Object[]{preservationScenarios});
                SanityChecker.checkJsonAll((JsonNode)preservationScenarios);
                RequestResponse requestResponse = client.importPreservationScenarios((List)JsonHandler.getFromStringAsTypeReference((String)preservationScenarios.toString(), (TypeReference)new TypeReference<List<PreservationScenarioModel>>(){}));
                response = Response.status((int)requestResponse.getStatus()).entity((Object)requestResponse).build();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidFormatException | InvalidParseOperationException | AdminManagementClientBadRequestException e) {
                    return this.buildErrorResponse(VitamCode.PRESERVATION_VALIDATION_ERROR, e.getMessage());
                }
                catch (ReferentialException e) {
                    return this.buildErrorResponse(VitamCode.PRESERVATION_INTERNAL_ERROR, e.getMessage());
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/griffin/{id_document:.+}")
    @GET
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.GRIFFIN_READ, description="lecture d'un griffin par identifier")
    public Response findGriffinByID(@PathParam(value="id_document") String documentId) {
        try {
            ParametersChecker.checkParameter((String)"Griffin ID is a  mandatory parameter", (String[])new String[]{documentId});
            SanityChecker.checkParameter((String[])new String[]{documentId});
            return this.findGriffin(documentId);
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.warn(e);
            return this.buildErrorResponse(VitamCode.PRESERVATION_VALIDATION_ERROR, e.getMessage());
        }
        catch (ReferentialNotFoundException e) {
            LOGGER.error((Throwable)e);
            LOGGER.error((Throwable)e);
            return this.buildErrorResponse(VitamCode.REFERENTIAL_NOT_FOUND, e.getMessage());
        }
        catch (ReferentialException e) {
            LOGGER.error((Throwable)e);
            return this.buildErrorResponse(VitamCode.PRESERVATION_INTERNAL_ERROR, e.getMessage());
        }
    }

    private Response findGriffin(@PathParam(value="id_document") String documentId) throws InvalidParseOperationException, ReferentialNotFoundException, AdminManagementClientServerException {
        try (AdminManagementClient client = this.adminManagementClientFactory.getClient();){
            RequestResponse requestResponse = client.findGriffinByID(documentId);
            int st = requestResponse.isOk() ? Response.Status.OK.getStatusCode() : requestResponse.getHttpCode();
            Response response = Response.status((int)st).entity((Object)requestResponse).build();
            return response;
        }
    }

    @Path(value="/preservationScenario/{id_document:.+}")
    @GET
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.PRESERVATIONSCENARIO_READ, description="lecture d'un scenario par identifier")
    public Response findPreservationByID(@PathParam(value="id_document") String documentId) {
        try {
            ParametersChecker.checkParameter((String)"Preservation ID is a  mandatory parameter", (String[])new String[]{documentId});
            SanityChecker.checkParameter((String[])new String[]{documentId});
            return this.findPreservation(documentId);
        }
        catch (InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.warn(e);
            return this.buildErrorResponse(VitamCode.PRESERVATION_VALIDATION_ERROR, e.getMessage());
        }
        catch (ReferentialNotFoundException e) {
            LOGGER.error((Throwable)e);
            return this.buildErrorResponse(VitamCode.REFERENTIAL_NOT_FOUND, e.getMessage());
        }
        catch (ReferentialException e) {
            LOGGER.error((Throwable)e);
            return this.buildErrorResponse(VitamCode.PRESERVATION_INTERNAL_ERROR, e.getMessage());
        }
    }

    private Response findPreservation(@PathParam(value="id_document") String documentId) throws InvalidParseOperationException, ReferentialNotFoundException, AdminManagementClientServerException {
        try (AdminManagementClient client = this.adminManagementClientFactory.getClient();){
            RequestResponse requestResponse = client.findPreservationByID(documentId);
            int status = requestResponse.isOk() ? Response.Status.OK.getStatusCode() : requestResponse.getHttpCode();
            Response response = Response.status((int)status).entity((Object)requestResponse).build();
            return response;
        }
    }

    private Response buildErrorResponse(VitamCode vitamCode, String message) {
        return Response.status((Response.Status)vitamCode.getStatus()).entity((Object)(new RequestResponseError().setError(new VitamError(VitamCodeHelper.getCode((VitamCode)vitamCode)).setContext(vitamCode.getService().getName()).setState(vitamCode.getDomain().getName()).setMessage(vitamCode.getMessage()).setDescription(vitamCode.getMessage())).toString() + message)).build();
    }

    @POST
    @Path(value="/logbookoperations")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.LOGBOOKOPERATIONS_CREATE, description="Cr\u00e9er une op\u00e9ration externe")
    public Response createExternalOperation(LogbookOperationParameters operation) {
        Response response;
        block11: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                if ((long)JsonHandler.writeValueAsBytes((JsonNode)JsonHandler.toJsonNode((Object)operation)).length >= VitamConfiguration.getOperationMaxSizeForExternal()) {
                    throw new IllegalArgumentException("The size of this operation is too big");
                }
                Response.Status status = client.createExternalOperation(operation);
                response = Response.status((Response.Status)status).build();
                if (client == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AdminManagementClientServerException e) {
                    LOGGER.error("Admin Management Client exception while trying to create logbookoperations: ", (Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.LOGBOOK_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage()).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).toResponse();
                }
                catch (LogbookClientAlreadyExistsException e) {
                    LOGGER.error("Logbook Client exception while trying to create logbookoperations: ", (Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.LOGBOOK_EXTERNAL_CONFLICT, (String)e.getLocalizedMessage()).setHttpCode(Response.Status.CONFLICT.getStatusCode()).toResponse();
                }
                catch (BadRequestException | InvalidParseOperationException | IllegalArgumentException e) {
                    LOGGER.error("Bad request while trying to create logbookoperations: ", e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.LOGBOOK_EXTERNAL_BAD_REQUEST, (String)e.getLocalizedMessage()).setHttpCode(Response.Status.BAD_REQUEST.getStatusCode()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @GET
    @Path(value="jobs")
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.JOB_READ, description="r\u00e9cuperer la liste des jobs")
    public Response findJobs() {
        Response response;
        block8: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                RequestResponse jobs = client.findJobs();
                response = Response.ok((Object)jobs).build();
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AdminManagementClientServerException e) {
                    LOGGER.error("Cannot retrieve all jobs ", (Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.LOGBOOK_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage()).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/schema/unit")
    @GET
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.UNIT_SCHEMA_READ, description="r\u00e9cuperer le sch\u00e9ma des unit\u00e9s archivestiques")
    public Response unitSchema() {
        Response response;
        block8: {
            AdminManagementClient adminManagementClient = this.adminManagementClientFactory.getClient();
            try {
                RequestResponse schema = adminManagementClient.getUnitSchema();
                response = Response.ok((Object)schema).build();
                if (adminManagementClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (adminManagementClient != null) {
                        try {
                            adminManagementClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AdminManagementClientServerException e) {
                    LOGGER.error("Cannot retrieve unit schema ", (Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage()).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).toResponse();
                }
            }
            adminManagementClient.close();
        }
        return response;
    }

    @Path(value="/schema/unit")
    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.UNIT_SCHEMA_DELETE, description="Supprimer un ou plusieurs sch\u00e9mas li\u00e9s \u00e0 des unit\u00e9s archivistiques")
    public Response deleteUnitExternalSchema(List<String> paths) {
        Response response;
        block10: {
            ParametersChecker.checkParameter((String)"Missing paths", (Object[])new Object[]{paths});
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                Response.Status status = client.deleteUnitExternalSchemas(paths);
                response = Response.status((Response.Status)status).build();
                if (client == null) break block10;
            }
            catch (Throwable status) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            status.addSuppressed(throwable);
                        }
                    }
                    throw status;
                }
                catch (ReferentialException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error((Throwable)e);
                    VitamError error = new VitamError(VitamCode.ACCESS_EXTERNAL_INVALID_JSON.getItem()).setMessage(VitamCode.ACCESS_EXTERNAL_INVALID_JSON.getMessage()).setState(StatusCode.KO.name()).setCode(VitamCodeHelper.getCode((VitamCode)VitamCode.ACCESS_EXTERNAL_INVALID_JSON)).setContext(ACCESS_EXTERNAL_MODULE).setDescription(VitamCode.ACCESS_EXTERNAL_INVALID_JSON.getMessage());
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error).build();
                }
                catch (Exception e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/schema/unit")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.UNIT_SCHEMA_CREATE, description="Importer des schemas externes dans le r\u00e9f\u00e9rentiel")
    public Response importUnitExternalSchema(JsonNode externalSchema) {
        Response response;
        block10: {
            AdminManagementClient client = this.adminManagementClientFactory.getClient();
            try {
                ParametersChecker.checkParameter((String)"Json unit external schema is a mandatory parameter", (Object[])new Object[]{externalSchema});
                SanityChecker.checkJsonAll((JsonNode)externalSchema);
                Response.Status status = client.importUnitExternalSchema((List)JsonHandler.getFromJsonNode((JsonNode)externalSchema, (TypeReference)new TypeReference<List<SchemaInputModel>>(){}));
                response = Response.status((Response.Status)status).build();
                if (client == null) break block10;
            }
            catch (Throwable status) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            status.addSuppressed(throwable);
                        }
                    }
                    throw status;
                }
                catch (ReferentialException e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_BAD_REQUEST, (String)e.getMessage()).toResponse();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error((Throwable)e);
                    VitamError error = new VitamError(VitamCode.ACCESS_EXTERNAL_INVALID_JSON.getItem()).setMessage(VitamCode.ACCESS_EXTERNAL_INVALID_JSON.getMessage()).setState(StatusCode.KO.name()).setCode(VitamCodeHelper.getCode((VitamCode)VitamCode.ACCESS_EXTERNAL_INVALID_JSON)).setContext(ACCESS_EXTERNAL_MODULE).setDescription(VitamCode.ACCESS_EXTERNAL_INVALID_JSON.getMessage());
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error).build();
                }
                catch (Exception e) {
                    LOGGER.error((Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ADMIN_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getMessage()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/schema/objectgroup")
    @GET
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.OBJECTGROUP_SCHEMA_READ, description="r\u00e9cuperer le sch\u00e9ma des groupes d'objets")
    public Response objectGroupSchema() {
        Response response;
        block8: {
            AdminManagementClient adminManagementClient = this.adminManagementClientFactory.getClient();
            try {
                RequestResponse objectGroupSchema = adminManagementClient.getObjectGroupSchema();
                response = Response.ok((Object)objectGroupSchema).build();
                if (adminManagementClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (adminManagementClient != null) {
                        try {
                            adminManagementClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AdminManagementClientServerException e) {
                    LOGGER.error("Cannot retrieve object group schema ", (Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.LOGBOOK_EXTERNAL_INTERNAL_SERVER_ERROR, (String)e.getLocalizedMessage()).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).toResponse();
                }
            }
            adminManagementClient.close();
        }
        return response;
    }

    private <T> Response getResponse(RequestResponse<T> response) {
        if (response.isOk()) {
            return Response.status((Response.Status)Response.Status.OK).entity(response).build();
        }
        VitamError error = (VitamError)response;
        return Response.status((int)error.getHttpCode()).entity(response).build();
    }
}

