/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.access.external.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.access.external.rest.AccessExternalConfiguration;
import fr.gouv.vitam.access.internal.client.AccessInternalClient;
import fr.gouv.vitam.access.internal.client.AccessInternalClientFactory;
import fr.gouv.vitam.access.internal.common.exception.AccessInternalClientIllegalOperationException;
import fr.gouv.vitam.access.internal.common.exception.AccessInternalClientNotFoundException;
import fr.gouv.vitam.access.internal.common.exception.AccessInternalClientServerException;
import fr.gouv.vitam.access.internal.common.exception.AccessInternalClientUnavailableDataFromAsyncOfferException;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.multiple.SelectMultiQuery;
import fr.gouv.vitam.common.database.builder.request.multiple.UpdateMultiQuery;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.database.parser.request.multiple.UpdateParserMultiple;
import fr.gouv.vitam.common.dsl.schema.Dsl;
import fr.gouv.vitam.common.dsl.schema.DslSchema;
import fr.gouv.vitam.common.dsl.schema.ValidationException;
import fr.gouv.vitam.common.dsl.schema.validator.BatchProcessingQuerySchemaValidator;
import fr.gouv.vitam.common.dsl.schema.validator.SelectMultipleSchemaValidator;
import fr.gouv.vitam.common.error.DomainName;
import fr.gouv.vitam.common.error.ServiceName;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.AccessUnauthorizedException;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.ExpectationFailedClientException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.NoWritingPermissionException;
import fr.gouv.vitam.common.exception.VitamClientException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.DeleteGotVersionsRequest;
import fr.gouv.vitam.common.model.PreservationRequest;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseError;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.DataObjectVersionType;
import fr.gouv.vitam.common.model.elimination.EliminationRequestBody;
import fr.gouv.vitam.common.model.export.ExportRequest;
import fr.gouv.vitam.common.model.export.transfer.TransferRequest;
import fr.gouv.vitam.common.model.massupdate.MassUpdateUnitRuleRequest;
import fr.gouv.vitam.common.model.revertupdate.RevertUpdateOptions;
import fr.gouv.vitam.common.model.storage.AccessRequestReference;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.common.security.rest.SecureEndpointRegistry;
import fr.gouv.vitam.common.security.rest.Secured;
import fr.gouv.vitam.common.security.rest.Unsecured;
import fr.gouv.vitam.common.server.application.HttpHeaderHelper;
import fr.gouv.vitam.common.server.application.VitamHttpHeader;
import fr.gouv.vitam.common.server.application.resources.ApplicationStatusResource;
import fr.gouv.vitam.common.stream.VitamAsyncInputStreamResponse;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.common.utils.SupportedSedaVersions;
import fr.gouv.vitam.utils.SecurityProfilePermissions;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.CollectionUtils;

@Path(value="/access-external/v1")
@Tag(name="Access")
public class AccessExternalResource
extends ApplicationStatusResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AccessExternalResource.class);
    private static final String PREDICATES_FAILED_EXCEPTION = "Predicates Failed Exception ";
    private static final String ACCESS_EXTERNAL_MODULE = "ACCESS_EXTERNAL";
    private static final String CODE_VITAM = "code_vitam";
    private static final String CONTRACT_ACCESS_NOT_ALLOW = "Contract access does not allow ";
    private static final String UNIT_NOT_FOUND = "Unit not found";
    private static final String REQ_RES_DOES_NOT_EXIST = "Request resource does not exist";
    private static final String OBJECT_TAG = "#object";
    private static final String REQUEST_UNAUTHORIZED = "Request unauthorized ";
    private static final String NO_SEARCH_QUERY = "No search query specified, this is mandatory";
    private static final String UNITS_COUNT_EXCEED_THRESHOLD = "The number of units exceed threshold";
    private static final String OBJECTS_COUNT_EXCEED_THRESHOLD = "The number of objects exceed threshold";
    private static final String STREAM_UNITS_LIMIT_REACHED = "You reach the limit of stream units. try next day";
    private static final String STREAM_OBJECTS_LIMIT_REACHED = "You reach the limit of stream objects. try next day";
    private static final String TECHNICAL_EXCEPTION = "Technical Exception ";
    private static final String COULD_NOT_VALIDATE_REQUEST = "Could not validate request";
    private static final String REQUEST_RESOURCES_DOES_NOT_EXISTS = "Request resources does not exits";
    private static final String WRITING_PERMISSIONS_INVALID = "Writing permission invalid";
    private static final String ERROR_ON_PRESERVATION = "Error on preservation request";
    private static final String UNAUTHORIZED_DSL_PARAMETER = "DSL parameter is unauthorized";
    private static final String QUALIFIERS = "#qualifiers";
    private static final String VERSIONS = "versions";
    private static final String UNIT_UPS = "#unitups";
    private static final String PERSISTENT_IDENTIFIERS = "PersistentIdentifier";
    private static final String PERSISTENT_IDENTIFIER_CONTENT = "PersistentIdentifierContent";
    public static final String DATA_OBJECT_VERSION = "DataObjectVersion";
    private final SecureEndpointRegistry secureEndpointRegistry;
    private final AccessInternalClientFactory accessInternalClientFactory;
    private final AccessExternalConfiguration configuration;
    private Map<Integer, List<String>> objectGroupBlackListedFieldsForVisualizationByTenant;

    AccessExternalResource(SecureEndpointRegistry secureEndpointRegistry, AccessExternalConfiguration configuration) {
        this(secureEndpointRegistry, AccessInternalClientFactory.getInstance(), configuration);
    }

    @VisibleForTesting
    AccessExternalResource(SecureEndpointRegistry secureEndpointRegistry, AccessInternalClientFactory accessInternalClientFactory, AccessExternalConfiguration configuration) {
        this.secureEndpointRegistry = secureEndpointRegistry;
        this.accessInternalClientFactory = accessInternalClientFactory;
        this.configuration = configuration;
        this.objectGroupBlackListedFieldsForVisualizationByTenant = configuration.getObjectGroupBlackListedFieldsForVisualizationByTenant();
    }

    @Path(value="/")
    @OPTIONS
    @Produces(value={"application/json"})
    @Unsecured
    public Response listResourceEndpoints() {
        String resourcePath = AccessExternalResource.class.getAnnotation(Path.class).value();
        List securedEndpointList = this.secureEndpointRegistry.getEndPointsByResourcePath(resourcePath);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)securedEndpointList).build();
    }

    @GET
    @Path(value="/units")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.UNITS_READ, description="R\u00e9cup\u00e9rer la liste des unit\u00e9s archivistiques")
    @Operation(description="Requ\u00eate qui retourne des r\u00e9sultats contenant des Unit\u00e9s d'archives. La requ\u00eate utilise le langage de requ\u00eate DSL de type **recherche multiple (SELECT MULTIPLE)** de Vitam en entr\u00e9e et retourne une liste d'Unit\u00e9s d'archives selon le DSL Vitam en cas de succ\u00e8s.", requestBody=@RequestBody(description="A SELECT MULTIPLE query.", content={@Content(examples={@ExampleObject(value="{\"$projection\":{\"$fields\":{\"#id\":1}}}")})}), parameters={@Parameter(name="X-Access-Contract-Id", in=ParameterIn.HEADER, description="The contract name", required=true, example="ACC-0001"), @Parameter(name="X-Tenant-Id", in=ParameterIn.HEADER, description="The tenant id", required=true, example="1")}, responses={@ApiResponse(responseCode="200", description="Renvoie la liste des r\u00e9sultats d'Unit\u00e9s d'archives correspondant \u00e0 la requ\u00eate DSL", content={@Content(examples={@ExampleObject(value="{\"httpCode\":200,\"$hits\":{\"total\":1,\"offset\":0,\"limit\":125,\"size\":1},\"$results\":[{\"#id\":\"aeaqaaaaaahftfesaabpcalqddm7ndiaaacq\"}],\"$facetResults\":[],\"$context\":{\"$roots\":[],\"$query\":[{\"$or\":[{\"$match\":{\"Title\":\"ratp\"}},{\"$match\":{\"Title_.fr\":\"ratp\"}},{\"$match\":{\"Description\":\"ratp\"}}]}],\"$filter\":{\"$orderby\":{\"TransactedDate\":1}},\"$projection\":{\"$fields\":{\"#id\":1}},\"$facets\":[]}}")})}), @ApiResponse(responseCode="412", description="Precondition failed."), @ApiResponse(responseCode="500", description="Internal Server Error."), @ApiResponse(responseCode="404", description="Not found."), @ApiResponse(responseCode="401", description="Un authorized."), @ApiResponse(responseCode="400", description="Bad request.")})
    public Response getUnits(@Dsl(value=DslSchema.SELECT_MULTIPLE) JsonNode queryJson) {
        Response response;
        block13: {
            AccessInternalClient client = this.accessInternalClientFactory.getClient();
            try {
                SanityChecker.checkJsonAll((JsonNode)queryJson);
                SelectMultipleSchemaValidator.checkAuthorizeTrackTotalHits((JsonNode)queryJson, (boolean)this.configuration.isAuthorizeTrackTotalHits());
                RequestResponse result = client.selectUnits(queryJson);
                int st = result.isOk() ? Response.Status.OK.getStatusCode() : result.getHttpCode();
                response = Response.status((int)st).entity((Object)result).build();
                if (client == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
                    Response.Status status = Response.Status.PRECONDITION_FAILED;
                    return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_UNITS_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
                }
                catch (AccessInternalClientServerException e) {
                    LOGGER.error(REQUEST_UNAUTHORIZED, (Throwable)e);
                    Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
                    return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_UNITS_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
                }
                catch (AccessInternalClientNotFoundException e) {
                    LOGGER.error(REQ_RES_DOES_NOT_EXIST, (Throwable)e);
                    Response.Status status = Response.Status.NOT_FOUND;
                    return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_UNITS_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
                }
                catch (AccessUnauthorizedException e) {
                    LOGGER.error(CONTRACT_ACCESS_NOT_ALLOW, (Throwable)e);
                    Response.Status status = Response.Status.UNAUTHORIZED;
                    return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_UNITS_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
                }
                catch (BadRequestException e) {
                    LOGGER.error(NO_SEARCH_QUERY, (Throwable)e);
                    Response.Status status = Response.Status.BAD_REQUEST;
                    return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_UNITS_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
                }
                catch (ValidationException e) {
                    LOGGER.error(UNAUTHORIZED_DSL_PARAMETER, (Throwable)e);
                    Response.Status status = Response.Status.UNAUTHORIZED;
                    return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_UNITS_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
                }
            }
            client.close();
        }
        return response;
    }

    @GET
    @Path(value="/units/unitpid/{persistentIdentifier:.+}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.UNITS_PERSISTENT_IDENTIFIER_READ, description="R\u00e9cup\u00e9rer une unit\u00e9 archivistique par identifiant p\u00e9renne")
    @Operation(description="Requ\u00eate qui retourne une unit\u00e9 d'archives correspondante \u00e0 l'identifiant p\u00e9renne fourni en entr\u00e9e.", parameters={@Parameter(name="X-Access-Contract-Id", in=ParameterIn.HEADER, description="The contract name", required=true, example="ACC-0001"), @Parameter(name="X-Tenant-Id", in=ParameterIn.HEADER, description="The tenant id", required=true, example="1")}, responses={@ApiResponse(responseCode="200", description="Renvoie l'Unit\u00e9 d'archives correspondant \u00e0 l'identifiant p\u00e9renne fourni.", content={@Content(examples={@ExampleObject(value="{\"httpCode\":200,\"$hits\":{\"total\":1,\"offset\":0,\"limit\":125,\"size\":1},\"$results\":[{\"#id\":\"aeaqaaaaaahftfesaabpcalqddm7ndiaaacq\"}],\"$facetResults\":[],\"$context\":{\"$roots\":[],\"$query\":[{\"$or\":[{\"$match\":{\"Title\":\"ratp\"}},{\"$match\":{\"Title_.fr\":\"ratp\"}},{\"$match\":{\"Description\":\"ratp\"}}]}],\"$filter\":{\"$orderby\":{\"TransactedDate\":1}},\"$projection\":{\"$fields\":{\"#id\":1}},\"$facets\":[]}}")})}), @ApiResponse(responseCode="404", description="Not found."), @ApiResponse(responseCode="301", description="Moved to another system."), @ApiResponse(responseCode="410", description="Deleted."), @ApiResponse(responseCode="500", description="Internal Server Error."), @ApiResponse(responseCode="401", description="Un authorized.")})
    public Response getUnitByPersistentIdentifier(@PathParam(value="persistentIdentifier") String persistentIdentifier, @Dsl(value=DslSchema.GET_BY_ID) JsonNode queryJson) {
        String exceptionMessage;
        Response.Status status;
        block15: {
            Response response;
            block14: {
                try {
                    SanityChecker.checkJsonAll((JsonNode)queryJson);
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.warn(COULD_NOT_VALIDATE_REQUEST, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity(this.getErrorEntity(Response.Status.PRECONDITION_FAILED, e.getLocalizedMessage())).build();
                }
                AccessInternalClient client = this.accessInternalClientFactory.getClient();
                try {
                    response = client.selectUnitsByUnitPersistentIdentifier(persistentIdentifier, queryJson);
                    if (client == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (InvalidParseOperationException e) {
                        LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
                        status = Response.Status.PRECONDITION_FAILED;
                        exceptionMessage = e.getLocalizedMessage();
                        break block15;
                    }
                    catch (AccessInternalClientServerException e) {
                        LOGGER.error(REQUEST_UNAUTHORIZED, (Throwable)e);
                        status = Response.Status.INTERNAL_SERVER_ERROR;
                        exceptionMessage = e.getLocalizedMessage();
                        break block15;
                    }
                    catch (AccessInternalClientNotFoundException e) {
                        LOGGER.error(REQ_RES_DOES_NOT_EXIST, (Throwable)e);
                        status = Response.Status.NOT_FOUND;
                        exceptionMessage = e.getLocalizedMessage();
                        break block15;
                    }
                    catch (AccessUnauthorizedException e) {
                        LOGGER.error(CONTRACT_ACCESS_NOT_ALLOW, (Throwable)e);
                        status = Response.Status.UNAUTHORIZED;
                        exceptionMessage = e.getLocalizedMessage();
                        break block15;
                    }
                    catch (BadRequestException e) {
                        LOGGER.error(NO_SEARCH_QUERY, (Throwable)e);
                        status = Response.Status.BAD_REQUEST;
                        exceptionMessage = e.getLocalizedMessage();
                    }
                }
                client.close();
            }
            return response;
        }
        return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_UNITS_ERROR, (String)exceptionMessage).setHttpCode(status.getStatusCode())).build();
    }

    @GET
    @Path(value="/units/stream")
    @Consumes(value={"application/json"})
    @Produces(value={"application/octet-stream"})
    @Secured(permission=SecurityProfilePermissions.UNITS_STREAM, description="R\u00e9cup\u00e9rer la liste des unit\u00e9s archivistiques")
    @Operation(description="Requ\u00eate qui retourne un stream des r\u00e9sultats contenant des Unit\u00e9s d'archives. La requ\u00eate utilise le langage de requ\u00eate DSL de type **recherche multiple (SELECT MULTIPLE)** de Vitam en entr\u00e9e et retourne une liste d'Unit\u00e9s d'archives selon le DSL Vitam en cas de succ\u00e8s.", requestBody=@RequestBody(description="A SELECT MULTIPLE query.", content={@Content(examples={@ExampleObject(value="{\"$projection\":{\"$fields\":{\"#id\":1}}}")})}), parameters={@Parameter(name="X-Access-Contract-Id", in=ParameterIn.HEADER, description="The contract name", required=true, example="ACC-0001"), @Parameter(name="X-Tenant-Id", in=ParameterIn.HEADER, description="The tenant id", required=true, example="1")}, responses={@ApiResponse(responseCode="200", description="Renvoie un stream contient la liste des r\u00e9sultats d'Unit\u00e9s d'archives correspondant \u00e0 la requ\u00eate DSL", content={@Content(examples={@ExampleObject(value="{\"httpCode\":200,\"$hits\":{\"total\":1,\"offset\":0,\"limit\":125,\"size\":1},\"$results\":[{\"#id\":\"aeaqaaaaaahftfesaabpcalqddm7ndiaaacq\"}],\"$facetResults\":[],\"$context\":{\"$roots\":[],\"$query\":[{\"$or\":[{\"$match\":{\"Title\":\"ratp\"}},{\"$match\":{\"Title_.fr\":\"ratp\"}},{\"$match\":{\"Description\":\"ratp\"}}]}],\"$filter\":{\"$orderby\":{\"TransactedDate\":1}},\"$projection\":{\"$fields\":{\"#id\":1}},\"$facets\":[]}}")})}), @ApiResponse(responseCode="417", description="Expectation Failed."), @ApiResponse(responseCode="500", description="Internal Server Error.")})
    public Response streamUnits(@Dsl(value=DslSchema.SELECT_MULTIPLE) JsonNode queryJson) {
        VitamAsyncInputStreamResponse vitamAsyncInputStreamResponse;
        block12: {
            AccessInternalClient client = this.accessInternalClientFactory.getClient();
            try {
                SanityChecker.checkJsonAll((JsonNode)queryJson);
                SelectMultipleSchemaValidator.validateStreamQuery((JsonNode)queryJson);
                Response response = client.streamUnits(queryJson);
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Content-Type", "application/octet-stream");
                headers.put("X-Units-Count", response.getHeaderString("X-Units-Count"));
                headers.put("X-Content-Length", response.getHeaderString("X-Content-Length"));
                vitamAsyncInputStreamResponse = new VitamAsyncInputStreamResponse(response, Response.Status.OK, headers);
                if (client == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ValidationException e) {
                    LOGGER.error(UNAUTHORIZED_DSL_PARAMETER, (Throwable)e);
                    Response.Status status = Response.Status.UNAUTHORIZED;
                    return Response.status((Response.Status)status).build();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
                    Response.Status status = Response.Status.PRECONDITION_FAILED;
                    return Response.status((Response.Status)status).build();
                }
                catch (ExpectationFailedClientException e) {
                    LOGGER.error(UNITS_COUNT_EXCEED_THRESHOLD, (Throwable)e);
                    Response.Status status = Response.Status.EXPECTATION_FAILED;
                    return Response.status((Response.Status)status).build();
                }
                catch (AccessUnauthorizedException e) {
                    LOGGER.error(STREAM_UNITS_LIMIT_REACHED, (Throwable)e);
                    Response.Status status = Response.Status.UNAUTHORIZED;
                    return Response.status((Response.Status)status).build();
                }
                catch (AccessInternalClientServerException e) {
                    LOGGER.error(REQUEST_UNAUTHORIZED, (Throwable)e);
                    Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
                    return Response.status((Response.Status)status).build();
                }
            }
            client.close();
        }
        return vitamAsyncInputStreamResponse;
    }

    @GET
    @Path(value="/objects/stream")
    @Consumes(value={"application/json"})
    @Produces(value={"application/octet-stream"})
    @Secured(permission=SecurityProfilePermissions.OBJECTS_STREAM, description="R\u00e9cup\u00e9rer la liste des objects groups")
    @Operation(description="Requ\u00eate qui retourne un stream des r\u00e9sultats contenant des Group d'objets. La requ\u00eate utilise le langage de requ\u00eate DSL de type **recherche multiple (SELECT MULTIPLE)** de Vitam en entr\u00e9e et retourne une liste d'objects selon le DSL Vitam en cas de succ\u00e8s.", requestBody=@RequestBody(description="A SELECT MULTIPLE query.", content={@Content(examples={@ExampleObject(value="{\"$projection\":{\"$fields\":{\"#id\":1}}}")})}), parameters={@Parameter(name="X-Access-Contract-Id", in=ParameterIn.HEADER, description="The contract name", required=true, example="ACC-0001"), @Parameter(name="X-Tenant-Id", in=ParameterIn.HEADER, description="The tenant id", required=true, example="1")}, responses={@ApiResponse(responseCode="200", description="Renvoie un stream contient la liste des r\u00e9sultats d'objets correspondant \u00e0 la requ\u00eate DSL", content={@Content(examples={@ExampleObject(value="{\"httpCode\":200,\"$hits\":{\"total\":1,\"offset\":0,\"limit\":125,\"size\":1},\"$results\":[{\"#id\":\"aeaqaaaaaahftfesaabpcalqddm7ndiaaacq\"}],\"$facetResults\":[],\"$context\":{\"$roots\":[],\"$query\":[{\"$or\":[{\"$match\":{\"Title\":\"ratp\"}},{\"$match\":{\"Title_.fr\":\"ratp\"}},{\"$match\":{\"Description\":\"ratp\"}}]}],\"$filter\":{\"$orderby\":{\"TransactedDate\":1}},\"$projection\":{\"$fields\":{\"#id\":1}},\"$facets\":[]}}")})}), @ApiResponse(responseCode="417", description="Expectation Failed."), @ApiResponse(responseCode="500", description="Internal Server Error.")})
    public Response streamObjects(@Dsl(value=DslSchema.SELECT_MULTIPLE) JsonNode queryJson) {
        VitamAsyncInputStreamResponse vitamAsyncInputStreamResponse;
        block12: {
            AccessInternalClient client = this.accessInternalClientFactory.getClient();
            try {
                SanityChecker.checkJsonAll((JsonNode)queryJson);
                SelectMultipleSchemaValidator.validateStreamQuery((JsonNode)queryJson);
                Response response = client.streamObjects(queryJson);
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Content-Type", "application/octet-stream");
                headers.put("X-Objects-Count", response.getHeaderString("X-Objects-Count"));
                headers.put("X-Content-Length", response.getHeaderString("X-Content-Length"));
                vitamAsyncInputStreamResponse = new VitamAsyncInputStreamResponse(response, Response.Status.OK, headers);
                if (client == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ValidationException e) {
                    LOGGER.error(UNAUTHORIZED_DSL_PARAMETER, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).build();
                }
                catch (ExpectationFailedClientException e) {
                    LOGGER.error(OBJECTS_COUNT_EXCEED_THRESHOLD, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.EXPECTATION_FAILED).build();
                }
                catch (AccessUnauthorizedException e) {
                    LOGGER.error(STREAM_OBJECTS_LIMIT_REACHED, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                }
                catch (AccessInternalClientServerException e) {
                    LOGGER.error(REQUEST_UNAUTHORIZED, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
                }
            }
            client.close();
        }
        return vitamAsyncInputStreamResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/dipexport")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.DIPEXPORT_CREATE, description="G\u00e9n\u00e9rer le DIP \u00e0 partir d'un DSL")
    public Response exportDIP(@Dsl(value=DslSchema.SELECT_MULTIPLE) JsonNode queryJson) {
        try (AccessInternalClient client = this.accessInternalClientFactory.getClient();){
            SanityChecker.checkJsonAll((JsonNode)queryJson);
            RequestResponse response2 = client.exportDIP(queryJson);
            if (response2.isOk()) {
                Response response3 = Response.status((int)Response.Status.ACCEPTED.getStatusCode()).entity((Object)response2).build();
                return response3;
            }
            Response response = response2.toResponse();
            return response;
        }
        catch (AccessInternalClientServerException e) {
            LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity(this.getErrorEntity(Response.Status.PRECONDITION_FAILED, e.getLocalizedMessage())).build();
        }
        catch (Exception e) {
            LOGGER.error(TECHNICAL_EXCEPTION, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getLocalizedMessage())).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/transfers")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.TRANSFERS_CREATE, description="G\u00e9n\u00e9rer le SIP pour transfer \u00e0 partir d'un DSL")
    public Response transfer(TransferRequest transferRequest) {
        try (AccessInternalClient client = this.accessInternalClientFactory.getClient();){
            SanityChecker.checkJsonAll((JsonNode)transferRequest.getDslRequest());
            SelectMultipleSchemaValidator validator = new SelectMultipleSchemaValidator();
            validator.validate(transferRequest.getDslRequest());
            if (transferRequest.getSedaVersion() != null && !SupportedSedaVersions.isSedaVersionValid((String)transferRequest.getSedaVersion())) {
                Response response = Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity(this.getErrorEntity(Response.Status.PRECONDITION_FAILED, "The Seda version is invalid!")).build();
                return response;
            }
            RequestResponse response = client.exportByUsageFilter(ExportRequest.from((TransferRequest)transferRequest));
            if (response.isOk()) {
                Response response2 = Response.status((int)Response.Status.ACCEPTED.getStatusCode()).entity((Object)response).build();
                return response2;
            }
            Response response3 = response.toResponse();
            return response3;
        }
        catch (AccessInternalClientServerException e) {
            LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity(this.getErrorEntity(Response.Status.PRECONDITION_FAILED, e.getLocalizedMessage())).build();
        }
        catch (Exception e) {
            LOGGER.error(TECHNICAL_EXCEPTION, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getLocalizedMessage())).build();
        }
    }

    @POST
    @Path(value="/transfers/reply")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.TRANSFERS_REPLY, description="Start transfer reply workflow.")
    public Response transferReply(InputStream transferReply) {
        Response response;
        block8: {
            AccessInternalClient client = this.accessInternalClientFactory.getClient();
            try {
                response = client.startTransferReplyWorkflow(transferReply).toResponse();
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error((Throwable)e);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getLocalizedMessage())).build();
                }
            }
            client.close();
        }
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/transfers/{id}/sip")
    @Produces(value={"application/octet-stream"})
    @Secured(permission=SecurityProfilePermissions.TRANSFERS_ID_SIP_READ, description="R\u00e9cup\u00e9rer le SIP du transfer")
    public Response findTransferByID(@PathParam(value="id") String id) {
        try (AccessInternalClient client = this.accessInternalClientFactory.getClient();){
            Response response2 = client.findTransferSIPByID(id);
            if (response2.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                VitamAsyncInputStreamResponse vitamAsyncInputStreamResponse = new VitamAsyncInputStreamResponse(response2, Response.Status.OK, MediaType.APPLICATION_OCTET_STREAM_TYPE);
                return vitamAsyncInputStreamResponse;
            }
            Response response = response2;
            return response;
        }
        catch (AccessInternalClientServerException e) {
            LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
            Response.Status status = Response.Status.PRECONDITION_FAILED;
            return Response.status((Response.Status)status).entity(this.getErrorEntity(status, e.getLocalizedMessage())).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/reclassification")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.RECLASSIFICATION_UPDATE, description="Mise \u00e0 jour d'arborescence des unit\u00e9s archivistiques")
    public Response reclassification(@Dsl(value=DslSchema.RECLASSIFICATION_QUERY) JsonNode queryJson) {
        ParametersChecker.checkParameter((String)"Missing reclassification request", (Object[])new Object[]{queryJson});
        try (AccessInternalClient client = this.accessInternalClientFactory.getClient();){
            RequestResponse response2 = client.reclassification(queryJson);
            if (response2.isOk()) {
                Response response3 = Response.status((int)Response.Status.ACCEPTED.getStatusCode()).entity((Object)response2).build();
                return response3;
            }
            Response response = response2.toResponse();
            return response;
        }
        catch (AccessInternalClientServerException e) {
            LOGGER.error(Response.Status.PRECONDITION_FAILED.getReasonPhrase(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity(this.getErrorEntity(Response.Status.PRECONDITION_FAILED, e.getLocalizedMessage())).build();
        }
        catch (Exception e) {
            LOGGER.error(TECHNICAL_EXCEPTION, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getLocalizedMessage())).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/elimination/analysis")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.ELIMINATION_ANALYSIS, description="Analyse de l'\u00e9limination d'unit\u00e9s archivistiques")
    public Response startEliminationAnalysis(EliminationRequestBody eliminationRequestBody) {
        try {
            ParametersChecker.checkParameter((String)"Missing dslRequest request", (Object[])new Object[]{eliminationRequestBody.getDslRequest()});
            ParametersChecker.checkDateParam((String)"Bad formatted date", (String)eliminationRequestBody.getDate());
            BatchProcessingQuerySchemaValidator validator = new BatchProcessingQuerySchemaValidator();
            validator.validate(eliminationRequestBody.getDslRequest());
        }
        catch (ValidationException | IOException | IllegalArgumentException e) {
            LOGGER.warn(COULD_NOT_VALIDATE_REQUEST, e);
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity(this.getErrorEntity(Response.Status.PRECONDITION_FAILED, e.getLocalizedMessage())).build();
        }
        try (AccessInternalClient client = this.accessInternalClientFactory.getClient();){
            RequestResponse response2 = client.startEliminationAnalysis(eliminationRequestBody);
            if (response2.isOk()) {
                Response response3 = Response.status((int)Response.Status.ACCEPTED.getStatusCode()).entity((Object)response2).build();
                return response3;
            }
            Response response = response2.toResponse();
            return response;
        }
        catch (AccessInternalClientServerException e) {
            LOGGER.error(Response.Status.PRECONDITION_FAILED.getReasonPhrase(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity(this.getErrorEntity(Response.Status.PRECONDITION_FAILED, e.getLocalizedMessage())).build();
        }
        catch (Exception e) {
            LOGGER.error(TECHNICAL_EXCEPTION, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getLocalizedMessage())).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/elimination/action")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.ELIMINATION_ACTION, description="Elimination d\u00e9finitive d'unit\u00e9s archivistiques")
    public Response startEliminationAction(EliminationRequestBody eliminationRequestBody) {
        try {
            ParametersChecker.checkParameter((String)"Missing dslRequest request", (Object[])new Object[]{eliminationRequestBody.getDslRequest()});
            ParametersChecker.checkDateParam((String)"Bad formatted date", (String)eliminationRequestBody.getDate());
            BatchProcessingQuerySchemaValidator validator = new BatchProcessingQuerySchemaValidator();
            validator.validate(eliminationRequestBody.getDslRequest());
        }
        catch (ValidationException | IOException | IllegalArgumentException e) {
            LOGGER.warn(COULD_NOT_VALIDATE_REQUEST, e);
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity(this.getErrorEntity(Response.Status.PRECONDITION_FAILED, e.getLocalizedMessage())).build();
        }
        try (AccessInternalClient client = this.accessInternalClientFactory.getClient();){
            RequestResponse response2 = client.startEliminationAction(eliminationRequestBody);
            if (response2.isOk()) {
                Response response3 = Response.status((int)Response.Status.ACCEPTED.getStatusCode()).entity((Object)response2).build();
                return response3;
            }
            Response response = response2.toResponse();
            return response;
        }
        catch (AccessInternalClientServerException e) {
            LOGGER.error(Response.Status.PRECONDITION_FAILED.getReasonPhrase(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity(this.getErrorEntity(Response.Status.PRECONDITION_FAILED, e.getLocalizedMessage())).build();
        }
        catch (Exception e) {
            LOGGER.error(TECHNICAL_EXCEPTION, (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getLocalizedMessage())).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/dipexport/{id}/dip")
    @Produces(value={"application/octet-stream"})
    @Secured(permission=SecurityProfilePermissions.DIPEXPORT_ID_DIP_READ, description="R\u00e9cup\u00e9rer le DIP")
    public Response findExportByID(@PathParam(value="id") String id) {
        try (AccessInternalClient client = this.accessInternalClientFactory.getClient();){
            Response response2 = client.findExportByID(id);
            if (response2.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                VitamAsyncInputStreamResponse vitamAsyncInputStreamResponse = new VitamAsyncInputStreamResponse(response2, Response.Status.OK, MediaType.APPLICATION_OCTET_STREAM_TYPE);
                return vitamAsyncInputStreamResponse;
            }
            Response response = response2;
            return response;
        }
        catch (AccessInternalClientServerException e) {
            LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
            Response.Status status = Response.Status.PRECONDITION_FAILED;
            return Response.status((Response.Status)status).entity(this.getErrorEntity(status, e.getLocalizedMessage())).build();
        }
    }

    @GET
    @Path(value="/units/{idu}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.UNITS_ID_READ_JSON, description="Obtenir le d\u00e9tail d'une unit\u00e9 archivistique au format json")
    public Response getUnitById(@Dsl(value=DslSchema.GET_BY_ID) JsonNode queryJson, @PathParam(value="idu") String idUnit) {
        Response response;
        block12: {
            ParametersChecker.checkParameter((String)"unit id is required", (String[])new String[]{idUnit});
            AccessInternalClient client = this.accessInternalClientFactory.getClient();
            try {
                int st;
                SanityChecker.checkParameter((String[])new String[]{idUnit});
                SelectParserMultiple selectParserMultiple = new SelectParserMultiple();
                selectParserMultiple.parse(queryJson);
                SelectMultiQuery selectMultiQuery = selectParserMultiple.getRequest();
                selectMultiQuery.addQueries(new Query[]{QueryHelper.eq((String)VitamFieldsHelper.id(), (String)idUnit)});
                RequestResponse result = client.selectUnits((JsonNode)selectMultiQuery.getFinalSelect());
                int n = st = result.isOk() ? Response.Status.OK.getStatusCode() : result.getHttpCode();
                if (!(result instanceof VitamError) && (((RequestResponseOK)result).getResults() == null || ((RequestResponseOK)result).getResults().isEmpty())) {
                    throw new AccessInternalClientNotFoundException(UNIT_NOT_FOUND);
                }
                response = Response.status((int)st).entity((Object)result).build();
                if (client == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidCreateOperationException | BadRequestException | InvalidParseOperationException e) {
                    LOGGER.debug(PREDICATES_FAILED_EXCEPTION, e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_UNIT_BY_ID_ERROR, (String)e.getLocalizedMessage()).setHttpCode(Response.Status.PRECONDITION_FAILED.getStatusCode()).toResponse();
                }
                catch (AccessInternalClientServerException e) {
                    LOGGER.error("Unauthorized request Exception ", (Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_UNIT_BY_ID_ERROR, (String)e.getLocalizedMessage()).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).toResponse();
                }
                catch (AccessInternalClientNotFoundException e) {
                    LOGGER.debug(REQUEST_RESOURCES_DOES_NOT_EXISTS, (Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_UNIT_BY_ID_ERROR, (String)e.getLocalizedMessage()).setHttpCode(Response.Status.NOT_FOUND.getStatusCode()).toResponse();
                }
                catch (AccessUnauthorizedException e) {
                    LOGGER.error(CONTRACT_ACCESS_NOT_ALLOW, (Throwable)e);
                    return VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_UNIT_BY_ID_ERROR, (String)e.getLocalizedMessage()).setHttpCode(Response.Status.UNAUTHORIZED.getStatusCode()).toResponse();
                }
            }
            client.close();
        }
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    @PUT
    @Path(value="/units/{idu}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.UNITS_ID_UPDATE, description="R\u00e9aliser la mise \u00e0 jour d'une unit\u00e9 archivistique")
    public Response updateUnitById(@Dsl(value=DslSchema.UPDATE_BY_ID) JsonNode queryJson, @PathParam(value="idu") String idUnit) {
        try (AccessInternalClient client = this.accessInternalClientFactory.getClient();){
            UpdateParserMultiple updateParserMultiple = new UpdateParserMultiple();
            updateParserMultiple.parse(queryJson);
            UpdateMultiQuery updateMultiQuery = updateParserMultiple.getRequest();
            updateMultiQuery.addRoots(new String[]{idUnit});
            RequestResponse response2 = client.updateUnitbyId((JsonNode)updateMultiQuery.getFinalUpdate(), idUnit);
            if (!response2.isOk() && response2 instanceof VitamError) {
                VitamError error = (VitamError)response2;
                Response response3 = this.buildErrorFromError(VitamCode.ACCESS_EXTERNAL_UPDATE_UNIT_BY_ID_ERROR, error.getMessage(), (VitamError<JsonNode>)error);
                return response3;
            }
            Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)response2).build();
            return response;
        }
        catch (InvalidParseOperationException e) {
            LOGGER.debug(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_UPDATE_UNIT_BY_ID_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
        }
        catch (AccessInternalClientServerException e) {
            LOGGER.debug(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase(), (Throwable)e);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_UPDATE_UNIT_BY_ID_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
        }
        catch (AccessInternalClientNotFoundException e) {
            LOGGER.debug(REQUEST_RESOURCES_DOES_NOT_EXISTS, (Throwable)e);
            Response.Status status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_UNIT_NOT_FOUND, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
        }
        catch (NoWritingPermissionException e) {
            LOGGER.debug(WRITING_PERMISSIONS_INVALID, (Throwable)e);
            Response.Status status = Response.Status.METHOD_NOT_ALLOWED;
            return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_UPDATE_UNIT_BY_ID_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
        }
        catch (AccessUnauthorizedException e) {
            LOGGER.debug(CONTRACT_ACCESS_NOT_ALLOW, (Throwable)e);
            Response.Status status = Response.Status.UNAUTHORIZED;
            return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_UPDATE_UNIT_BY_ID_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/units/{idu}/objects")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.UNITS_ID_OBJECTS_READ_JSON, description="T\u00e9l\u00e9charger le groupe d'objet technique de l'unit\u00e9 archivistique donn\u00e9e")
    public Response getObjectGroupMetadataByUnitId(@Context HttpHeaders headers, @PathParam(value="idu") String unitId, @Dsl(value=DslSchema.GET_BY_ID) JsonNode queryJson) {
        try (AccessInternalClient client = this.accessInternalClientFactory.getClient();){
            int st;
            SanityChecker.checkJsonAll((JsonNode)queryJson);
            String idObjectGroup = this.idObjectGroup(unitId);
            if (idObjectGroup == null) {
                throw new AccessInternalClientNotFoundException("ObjectGroup of Unit not found");
            }
            RequestResponse selectedObjectGroupsByUnit = client.selectObjectbyId(queryJson, idObjectGroup);
            if (!((RequestResponseOK)selectedObjectGroupsByUnit).getResults().isEmpty()) {
                this.excludeBlackListedFieldsForGot(((RequestResponseOK)selectedObjectGroupsByUnit).getResults());
            }
            int n = st = selectedObjectGroupsByUnit.isOk() ? Response.Status.OK.getStatusCode() : selectedObjectGroupsByUnit.getHttpCode();
            if (!selectedObjectGroupsByUnit.isOk()) {
                VitamError error = (VitamError)selectedObjectGroupsByUnit;
                Response response2 = this.buildErrorFromError(VitamCode.ACCESS_EXTERNAL_SELECT_OBJECT_BY_ID_ERROR, error.getMessage(), (VitamError<JsonNode>)error);
                return response2;
            }
            if (((RequestResponseOK)selectedObjectGroupsByUnit).getResults() == null) throw new AccessInternalClientNotFoundException(UNIT_NOT_FOUND);
            if (((RequestResponseOK)selectedObjectGroupsByUnit).getResults().isEmpty()) {
                throw new AccessInternalClientNotFoundException(UNIT_NOT_FOUND);
            }
            Response response = Response.status((int)st).entity((Object)selectedObjectGroupsByUnit).build();
            return response;
        }
        catch (InvalidCreateOperationException | BadRequestException | InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.debug(e);
            Response.Status status = Response.Status.PRECONDITION_FAILED;
            return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_OBJECT_BY_ID_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
        }
        catch (AccessInternalClientServerException e) {
            LOGGER.error((Throwable)e);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_OBJECT_BY_ID_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
        }
        catch (AccessInternalClientNotFoundException e) {
            LOGGER.debug((Throwable)e);
            Response.Status status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_OBJECT_BY_ID_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
        }
        catch (AccessUnauthorizedException e) {
            LOGGER.error(CONTRACT_ACCESS_NOT_ALLOW, (Throwable)e);
            Response.Status status = Response.Status.UNAUTHORIZED;
            return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_OBJECT_BY_ID_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
        }
    }

    @GET
    @Path(value="/units/{idu}/objects")
    @Consumes(value={"application/json"})
    @Produces(value={"application/octet-stream"})
    @Secured(permission=SecurityProfilePermissions.UNITS_ID_OBJECTS_READ_BINARY, description="T\u00e9lecharger un objet")
    public Response getDataObjectByUnitId(@Context HttpHeaders headers, @PathParam(value="idu") String unitId) {
        try {
            String idObjectGroup = this.idObjectGroup(unitId);
            if (idObjectGroup == null) {
                throw new AccessInternalClientNotFoundException("ObjectGroup of Unit not found");
            }
            MultivaluedMap multipleMap = headers.getRequestHeaders();
            return this.asyncObjectStream((MultivaluedMap<String, String>)multipleMap, idObjectGroup, unitId);
        }
        catch (InvalidCreateOperationException | BadRequestException | InvalidParseOperationException e) {
            LOGGER.debug(PREDICATES_FAILED_EXCEPTION, e);
            Response.Status status = Response.Status.PRECONDITION_FAILED;
            return Response.status((Response.Status)status).entity((Object)this.getErrorStream((VitamError<JsonNode>)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_DATA_OBJECT_BY_UNIT_ID_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode()))).build();
        }
        catch (AccessInternalClientServerException e) {
            LOGGER.error("Unauthorized request Exception ", (Throwable)e);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)this.getErrorStream((VitamError<JsonNode>)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_DATA_OBJECT_BY_UNIT_ID_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode()))).build();
        }
        catch (AccessInternalClientNotFoundException e) {
            LOGGER.debug(REQUEST_RESOURCES_DOES_NOT_EXISTS, (Throwable)e);
            Response.Status status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)this.getErrorStream((VitamError<JsonNode>)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_DATA_OBJECT_BY_UNIT_ID_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode()))).build();
        }
        catch (AccessUnauthorizedException e) {
            LOGGER.error(CONTRACT_ACCESS_NOT_ALLOW, (Throwable)e);
            Response.Status status = Response.Status.UNAUTHORIZED;
            return Response.status((Response.Status)status).entity((Object)this.getErrorStream((VitamError<JsonNode>)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_DATA_OBJECT_BY_UNIT_ID_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode()))).build();
        }
    }

    @GET
    @Path(value="/objects/unitpid/{persistentIdentifier:.+}")
    @Produces(value={"application/octet-stream"})
    @Secured(permission=SecurityProfilePermissions.OBJECTS_PERSISTENT_IDENTIFIER_OBJECTS_READ_BINARY, description="T\u00e9l\u00e9charger un objet")
    @Operation(description="Requ\u00eate qui retourne un stream du premier objet qui correspond aux crit\u00e8res . ", parameters={@Parameter(name="X-Access-Contract-Id", in=ParameterIn.HEADER, description="The contract name", required=true, example="ACC-0001"), @Parameter(name="X-Tenant-Id", in=ParameterIn.HEADER, description="The tenant id", required=true, example="1")}, responses={@ApiResponse(responseCode="200", description="Renvoie un stream contient l'objet correspondant aux crit\u00e8res li\u00e9s \u00e0 l'unit\u00e9 avec l'identifiant p\u00e9renne \u00e0 la requ\u00eate DSL et l'identifiant p\u00e9renne"), @ApiResponse(responseCode="417", description="Expectation Failed."), @ApiResponse(responseCode="301", description="Moved to another system."), @ApiResponse(responseCode="410", description="Deleted."), @ApiResponse(responseCode="500", description="Internal Server Error.")})
    public Response getDataObjectByUnitPersistentIdentifier(@Context HttpHeaders headers, @PathParam(value="persistentIdentifier") String persistentIdentifier, @DefaultValue(value="BinaryMaster") @QueryParam(value="qualifier") String qualifier, @QueryParam(value="version") Integer version) {
        Response response;
        block10: {
            AccessInternalClient client = this.accessInternalClientFactory.getClient();
            try {
                ParametersChecker.checkParameter((String)"Missing persistent identifier", (String[])new String[]{persistentIdentifier});
                DataObjectVersionType dataObjectVersionType = DataObjectVersionType.fromName((String)qualifier);
                if (dataObjectVersionType == null) {
                    throw new IllegalArgumentException("Could not identify DataObjectVersionType with value " + qualifier);
                }
                response = client.downloadObjectsByUnitPersistentIdentifier(persistentIdentifier, qualifier, version);
                if (client == null) break block10;
            }
            catch (Throwable dataObjectVersionType) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            dataObjectVersionType.addSuppressed(throwable);
                        }
                    }
                    throw dataObjectVersionType;
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warn(COULD_NOT_VALIDATE_REQUEST, (Throwable)e);
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity(this.getErrorEntity(Response.Status.PRECONDITION_FAILED, e.getLocalizedMessage())).build();
                }
                catch (VitamClientException e) {
                    VitamError vitamError = e.getVitamError();
                    int statusCode = vitamError.getStatus();
                    return Response.status((int)statusCode).entity((Object)e).build();
                }
            }
            client.close();
        }
        return response;
    }

    @GET
    @Path(value="/objects/objectpid/{persistentIdentifier:.+}")
    @Produces(value={"application/octet-stream"})
    @Secured(permission=SecurityProfilePermissions.OBJECTS_PERSISTENT_IDENTIFIER_READ_BINARY, description="T\u00e9l\u00e9charger un objet par son identifiant p\u00e9renne")
    @Operation(description="Requ\u00eate qui retourne un stream du premier objet qui correspond aux crit\u00e8res.", parameters={@Parameter(name="X-Access-Contract-Id", in=ParameterIn.HEADER, description="The contract name", required=true, example="ACC-0001"), @Parameter(name="X-Tenant-Id", in=ParameterIn.HEADER, description="The tenant id", required=true, example="1")}, responses={@ApiResponse(responseCode="200", description="Renvoie un stream contient l'objet correspondant \u00e0 l'identifiant p\u00e9renne"), @ApiResponse(responseCode="417", description="Expectation Failed."), @ApiResponse(responseCode="301", description="Moved to another system."), @ApiResponse(responseCode="410", description="Deleted."), @ApiResponse(responseCode="500", description="Internal Server Error.")})
    public Response getDataObjectByObjectPersistentIdentifier(@Context HttpHeaders headers, @PathParam(value="persistentIdentifier") String persistentIdentifier) throws InvalidParseOperationException {
        Response response;
        block8: {
            ParametersChecker.checkParameter((String)"Persistent identifier must not be blank or defined", (String[])new String[]{persistentIdentifier});
            SanityChecker.checkParameter((String[])new String[]{persistentIdentifier});
            AccessInternalClient client = this.accessInternalClientFactory.getClient();
            try {
                response = client.downloadObjectByPersistentIdentifier(persistentIdentifier);
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (VitamClientException e) {
                    VitamError vitamError = e.getVitamError();
                    int statusCode = vitamError.getStatus();
                    return Response.status((int)statusCode).entity((Object)e).build();
                }
            }
            client.close();
        }
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/objects/objectpid/{persistentIdentifier:.+}")
    @Operation(description="Requ\u00eate qui retourne la liste des objets qui correspondent aux crit\u00e8res d'identifiant p\u00e9renne . ", parameters={@Parameter(name="X-Access-Contract-Id", in=ParameterIn.HEADER, description="The contract name", required=true, example="ACC-0001"), @Parameter(name="X-Tenant-Id", in=ParameterIn.HEADER, description="The tenant id", required=true, example="1")}, responses={@ApiResponse(responseCode="200", description="Renvoie la liste des objets correspondants aux crit\u00e8res li\u00e9s \u00e0 la requ\u00eate DSL et l'identifiant p\u00e9renne de l'objet"), @ApiResponse(responseCode="417", description="Expectation Failed."), @ApiResponse(responseCode="301", description="Moved to another system."), @ApiResponse(responseCode="410", description="Deleted."), @ApiResponse(responseCode="500", description="Internal Server Error.")})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.OBJECTS_PERSISTENT_IDENTIFIER_READ, description="R\u00e9cup\u00e9rer la liste des objets par identifiant p\u00e9renne")
    public Response getObjectsByPersistentIdentifier(@PathParam(value="persistentIdentifier") String persistentIdentifier, @Dsl(value=DslSchema.GET_BY_ID) JsonNode queryJson) {
        String exceptionMessage;
        Response.Status status;
        try {
            SanityChecker.checkJsonAll((JsonNode)queryJson);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.warn(COULD_NOT_VALIDATE_REQUEST, (Throwable)e);
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity(this.getErrorEntity(Response.Status.PRECONDITION_FAILED, e.getLocalizedMessage())).build();
        }
        try (AccessInternalClient client = this.accessInternalClientFactory.getClient();){
            RequestResponse response2 = client.selectObjectsByObjectPersistentIdentifier(persistentIdentifier, queryJson);
            if (!response2.isOk()) throw new AccessInternalClientNotFoundException(REQ_RES_DOES_NOT_EXIST);
            List results = ((RequestResponseOK)response2).getResults();
            if (!results.isEmpty()) {
                this.excludeBlackListedFieldsForGot(results);
            }
            Response response = Response.status((int)Response.Status.OK.getStatusCode()).entity((Object)response2).build();
            return response;
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
            status = Response.Status.PRECONDITION_FAILED;
            exceptionMessage = e.getLocalizedMessage();
            return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_UNITS_ERROR, (String)exceptionMessage).setHttpCode(status.getStatusCode())).build();
        }
        catch (AccessInternalClientServerException e) {
            LOGGER.error(REQUEST_UNAUTHORIZED, (Throwable)e);
            status = Response.Status.INTERNAL_SERVER_ERROR;
            exceptionMessage = e.getLocalizedMessage();
            return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_UNITS_ERROR, (String)exceptionMessage).setHttpCode(status.getStatusCode())).build();
        }
        catch (AccessInternalClientNotFoundException e) {
            LOGGER.error(REQ_RES_DOES_NOT_EXIST, (Throwable)e);
            status = Response.Status.NOT_FOUND;
            exceptionMessage = e.getLocalizedMessage();
            return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_UNITS_ERROR, (String)exceptionMessage).setHttpCode(status.getStatusCode())).build();
        }
        catch (AccessUnauthorizedException e) {
            LOGGER.error(CONTRACT_ACCESS_NOT_ALLOW, (Throwable)e);
            status = Response.Status.UNAUTHORIZED;
            exceptionMessage = e.getLocalizedMessage();
            return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_UNITS_ERROR, (String)exceptionMessage).setHttpCode(status.getStatusCode())).build();
        }
        catch (BadRequestException e) {
            LOGGER.error(NO_SEARCH_QUERY, (Throwable)e);
            status = Response.Status.BAD_REQUEST;
            exceptionMessage = e.getLocalizedMessage();
        }
        return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_UNITS_ERROR, (String)exceptionMessage).setHttpCode(status.getStatusCode())).build();
    }

    @POST
    @Path(value="/units/{idu}/objects/accessRequests")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.UNITS_ID_OBJECTS_ACCESS_REQUESTS_CREATE, description="Cr\u00e9er une demande d'acc\u00e8s \u00e0 un objet persist\u00e9 sur une offre froide (bande magn\u00e9tique)")
    public Response createObjectAccessRequestByUnitId(@Context HttpHeaders headers, @PathParam(value="idu") String unitId) {
        Response response;
        block13: {
            Optional<Response> errorResponse = this.checkQualifierAndVersionHeaders((MultivaluedMap<String, String>)headers.getRequestHeaders(), VitamCode.ACCESS_EXTERNAL_CREATE_OBJECT_ACCESS_REQUEST);
            if (errorResponse.isPresent()) {
                return errorResponse.get();
            }
            String idObjectGroup = this.idObjectGroup(unitId);
            if (idObjectGroup == null) {
                throw new AccessInternalClientNotFoundException("ObjectGroup of Unit not found");
            }
            String xQualifier = headers.getHeaderString("X-Qualifier");
            String xVersion = headers.getHeaderString("X-Version");
            int version = Integer.parseInt(xVersion);
            AccessInternalClient client = this.accessInternalClientFactory.getClient();
            try {
                Optional objectAccessRequest = client.createObjectAccessRequest(idObjectGroup, xQualifier, version);
                RequestResponseOK requestResponseOK = new RequestResponseOK();
                objectAccessRequest.ifPresent(arg_0 -> ((RequestResponseOK)requestResponseOK).addResult(arg_0));
                requestResponseOK.setHttpCode(Response.Status.OK.getStatusCode());
                response = requestResponseOK.toResponse();
                if (client == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidCreateOperationException | BadRequestException | InvalidParseOperationException e) {
                    LOGGER.error(PREDICATES_FAILED_EXCEPTION, e);
                    Response.Status status = Response.Status.PRECONDITION_FAILED;
                    return Response.status((Response.Status)status).entity((Object)this.getErrorStream((VitamError<JsonNode>)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_CREATE_OBJECT_ACCESS_REQUEST, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode()))).build();
                }
                catch (AccessInternalClientNotFoundException e) {
                    LOGGER.warn(REQUEST_RESOURCES_DOES_NOT_EXISTS, (Throwable)e);
                    Response.Status status = Response.Status.NOT_FOUND;
                    return Response.status((Response.Status)status).entity((Object)this.getErrorStream((VitamError<JsonNode>)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_CREATE_OBJECT_ACCESS_REQUEST, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode()))).build();
                }
                catch (AccessUnauthorizedException e) {
                    LOGGER.error(CONTRACT_ACCESS_NOT_ALLOW, (Throwable)e);
                    Response.Status status = Response.Status.UNAUTHORIZED;
                    return Response.status((Response.Status)status).entity((Object)this.getErrorStream((VitamError<JsonNode>)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_CREATE_OBJECT_ACCESS_REQUEST, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode()))).build();
                }
                catch (Exception e) {
                    LOGGER.error("Internal server error ", (Throwable)e);
                    Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
                    return Response.status((Response.Status)status).entity((Object)this.getErrorStream((VitamError<JsonNode>)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_CREATE_OBJECT_ACCESS_REQUEST, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode()))).build();
                }
            }
            client.close();
        }
        return response;
    }

    @GET
    @Path(value="/accessRequests/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.ACCESS_REQUESTS_CHECK, description="V\u00e9rifier l'\u00e9tat d'un ensemble de demandes d'acc\u00e8s sur une offre froide (bande magn\u00e9tique)")
    public Response checkAccessRequestStatuses(List<AccessRequestReference> accessRequestReferences) {
        Response response;
        block13: {
            ParametersChecker.checkParameter((String)"Access requests required", (Object[])new Object[]{accessRequestReferences});
            if (accessRequestReferences.isEmpty()) {
                throw new IllegalArgumentException("Empty query");
            }
            for (AccessRequestReference accessRequestReference : accessRequestReferences) {
                ParametersChecker.checkParameter((String)"Access requests required", (Object[])new Object[]{accessRequestReference});
                ParametersChecker.checkParameter((String)"Required accessRequestId", (String[])new String[]{accessRequestReference.getAccessRequestId()});
                ParametersChecker.checkParameter((String)"Required storageStrategyId", (String[])new String[]{accessRequestReference.getStorageStrategyId()});
            }
            int distinctAccessRequestIds = accessRequestReferences.stream().map(AccessRequestReference::getAccessRequestId).collect(Collectors.toSet()).size();
            if (accessRequestReferences.size() != distinctAccessRequestIds) {
                throw new IllegalArgumentException("Duplicate access request ids " + accessRequestReferences);
            }
            AccessInternalClient client = this.accessInternalClientFactory.getClient();
            try {
                List statusByAccessRequests = client.checkAccessRequestStatuses(accessRequestReferences);
                response = new RequestResponseOK().setHttpCode(Response.Status.OK.getStatusCode()).addAllResults(statusByAccessRequests).toResponse();
                if (client == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
                    Response.Status status = Response.Status.PRECONDITION_FAILED;
                    return Response.status((Response.Status)status).entity((Object)this.getErrorStream((VitamError<JsonNode>)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_CHECK_OBJECT_ACCESS_REQUEST_STATUSES, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode()))).build();
                }
                catch (AccessInternalClientIllegalOperationException e) {
                    LOGGER.error("Illegal operation on Access Request", (Throwable)e);
                    Response.Status status = Response.Status.NOT_ACCEPTABLE;
                    return Response.status((Response.Status)status).entity((Object)this.getErrorStream((VitamError<JsonNode>)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_CHECK_OBJECT_ACCESS_REQUEST_STATUSES, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode()))).build();
                }
                catch (Exception e) {
                    LOGGER.error("Unexpected error while checking Access Request statuses", (Throwable)e);
                    Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
                    return Response.status((Response.Status)status).entity((Object)this.getErrorStream((VitamError<JsonNode>)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_CHECK_OBJECT_ACCESS_REQUEST_STATUSES, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode()))).build();
                }
            }
            client.close();
        }
        return response;
    }

    @DELETE
    @Path(value="/accessRequests/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.ACCESS_REQUESTS_REMOVE, description="Supprimer une demande d'acc\u00e8s \u00e0 un objet persist\u00e9 sur une offre froide (bande magn\u00e9tique)")
    public Response removeAccessRequest(AccessRequestReference accessRequestReference) {
        try {
            ParametersChecker.checkParameter((String)"Required objectAccessRequest", (Object[])new Object[]{accessRequestReference});
            ParametersChecker.checkParameter((String)"Required accessRequestId", (String[])new String[]{accessRequestReference.getAccessRequestId()});
            ParametersChecker.checkParameter((String)"Required strategyId", (String[])new String[]{accessRequestReference.getStorageStrategyId()});
            try (AccessInternalClient client = this.accessInternalClientFactory.getClient();){
                client.removeAccessRequest(accessRequestReference);
            }
            return new RequestResponseOK().setHttpCode(Response.Status.OK.getStatusCode()).toResponse();
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
            Response.Status status = Response.Status.PRECONDITION_FAILED;
            return Response.status((Response.Status)status).entity((Object)this.getErrorStream((VitamError<JsonNode>)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_REMOVE_OBJECT_ACCESS_REQUEST, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode()))).build();
        }
        catch (AccessInternalClientIllegalOperationException e) {
            LOGGER.error("Illegal operation on Access Request", (Throwable)e);
            Response.Status status = Response.Status.NOT_ACCEPTABLE;
            return Response.status((Response.Status)status).entity((Object)this.getErrorStream((VitamError<JsonNode>)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_REMOVE_OBJECT_ACCESS_REQUEST, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode()))).build();
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error while removing Access Request " + accessRequestReference, (Throwable)e);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)this.getErrorStream((VitamError<JsonNode>)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_REMOVE_OBJECT_ACCESS_REQUEST, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode()))).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/units")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.UNITS_UPDATE, description="Mise \u00e0 jour en masse des unit\u00e9s archivistiques")
    public Response massUpdateUnits(@Dsl(value=DslSchema.MASS_UPDATE) JsonNode queryJson) {
        try (AccessInternalClient client = this.accessInternalClientFactory.getClient();){
            UpdateParserMultiple updateParserMultiple = new UpdateParserMultiple();
            updateParserMultiple.parse(queryJson);
            UpdateMultiQuery updateMultiQuery = updateParserMultiple.getRequest();
            RequestResponse response2 = client.updateUnits((JsonNode)updateMultiQuery.getFinalUpdate());
            if (!response2.isOk() && response2 instanceof VitamError) {
                VitamError error = (VitamError)response2;
                Response response3 = this.buildErrorFromError(VitamCode.ACCESS_EXTERNAL_MASS_UPDATE_ERROR, error.getMessage(), (VitamError<JsonNode>)error);
                return response3;
            }
            Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)response2).build();
            return response;
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_MASS_UPDATE_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
        }
        catch (AccessInternalClientServerException e) {
            LOGGER.error("Internal request error ", (Throwable)e);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_MASS_UPDATE_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
        }
        catch (NoWritingPermissionException e) {
            LOGGER.error(WRITING_PERMISSIONS_INVALID, (Throwable)e);
            Response.Status status = Response.Status.METHOD_NOT_ALLOWED;
            return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_MASS_UPDATE_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
        }
        catch (AccessUnauthorizedException e) {
            LOGGER.error(CONTRACT_ACCESS_NOT_ALLOW, (Throwable)e);
            Response.Status status = Response.Status.UNAUTHORIZED;
            return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_MASS_UPDATE_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/revert/units")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.REVERT_UPDATE, description="Restauration des metadonn\u00e9es essentielles")
    public Response revertUpdateUnits(RevertUpdateOptions revertUpdateOptions) {
        try (AccessInternalClient client = this.accessInternalClientFactory.getClient();){
            SanityChecker.checkJsonAll((JsonNode)revertUpdateOptions.getDslRequest());
            BatchProcessingQuerySchemaValidator validator = new BatchProcessingQuerySchemaValidator();
            validator.validate(revertUpdateOptions.getDslRequest());
            RequestResponse response2 = client.revertUnits(revertUpdateOptions);
            if (!response2.isOk() && response2 instanceof VitamError) {
                VitamError error = (VitamError)response2;
                Response response3 = this.buildErrorFromError(VitamCode.ACCESS_EXTERNAL_REVERT_UPDATE_ERROR, error.getMessage(), (VitamError<JsonNode>)error);
                return response3;
            }
            Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)response2).build();
            return response;
        }
        catch (ValidationException | InvalidParseOperationException e) {
            LOGGER.error(PREDICATES_FAILED_EXCEPTION, e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_REVERT_UPDATE_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
        }
        catch (AccessInternalClientServerException | IOException e) {
            LOGGER.error("Internal request error ", e);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_REVERT_UPDATE_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
        }
        catch (NoWritingPermissionException e) {
            LOGGER.error(WRITING_PERMISSIONS_INVALID, (Throwable)e);
            Response.Status status = Response.Status.METHOD_NOT_ALLOWED;
            return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_REVERT_UPDATE_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
        }
        catch (AccessUnauthorizedException e) {
            LOGGER.error(CONTRACT_ACCESS_NOT_ALLOW, (Throwable)e);
            Response.Status status = Response.Status.UNAUTHORIZED;
            return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_REVERT_UPDATE_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/units/rules")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.UNITS_RULES_UPDATE, description="Mise \u00e0 jour en masse des r\u00e8gles de gestion")
    public Response massUpdateUnitsRules(MassUpdateUnitRuleRequest massUpdateUnitRuleRequest) {
        try {
            BatchProcessingQuerySchemaValidator validator = new BatchProcessingQuerySchemaValidator();
            validator.validate(massUpdateUnitRuleRequest.getDslRequest());
        }
        catch (ValidationException e) {
            LOGGER.warn(COULD_NOT_VALIDATE_REQUEST, (Throwable)e);
            return e.getVitamError().toResponse();
        }
        catch (IOException e) {
            LOGGER.warn("Can not read Dsl query", (Throwable)e);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.GLOBAL_INTERNAL_SERVER_ERROR, (String)"Can not read Dsl query").setHttpCode(status.getStatusCode())).build();
        }
        try (AccessInternalClient client = this.accessInternalClientFactory.getClient();){
            RequestResponse response2 = client.updateUnitsRules(massUpdateUnitRuleRequest);
            if (!response2.isOk() && response2 instanceof VitamError) {
                VitamError error = (VitamError)response2;
                Response response3 = this.buildErrorFromError(VitamCode.ACCESS_EXTERNAL_MASS_UPDATE_ERROR, error.getMessage(), (VitamError<JsonNode>)error);
                return response3;
            }
            Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)response2).build();
            return response;
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_MASS_UPDATE_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
        }
        catch (AccessInternalClientServerException e) {
            LOGGER.error("Internal request error ", (Throwable)e);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_MASS_UPDATE_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
        }
        catch (NoWritingPermissionException e) {
            LOGGER.error(WRITING_PERMISSIONS_INVALID, (Throwable)e);
            Response.Status status = Response.Status.METHOD_NOT_ALLOWED;
            return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_MASS_UPDATE_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
        }
        catch (AccessUnauthorizedException e) {
            LOGGER.error(CONTRACT_ACCESS_NOT_ALLOW, (Throwable)e);
            Response.Status status = Response.Status.UNAUTHORIZED;
            return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_MASS_UPDATE_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="/units/bulk")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.UNITS_BULK_UPDATE, description="Mise \u00e0 jour par lot de requ\u00eates unitaires des unit\u00e9s archivistiques")
    public Response bulkAtomicUpdateUnits(@Dsl(value=DslSchema.BULK_UPDATE) JsonNode updateQueriesJson) {
        try (AccessInternalClient client = this.accessInternalClientFactory.getClient();){
            RequestResponse response2 = client.bulkAtomicUpdateUnits(updateQueriesJson);
            if (!response2.isOk() && response2 instanceof VitamError) {
                VitamError error = (VitamError)response2;
                Response response3 = this.buildErrorFromError(VitamCode.ACCESS_EXTERNAL_BULK_ATOMIC_UPDATE_ERROR, error.getMessage(), (VitamError<JsonNode>)error);
                return response3;
            }
            Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)response2).build();
            return response;
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_BULK_ATOMIC_UPDATE_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
        }
        catch (AccessInternalClientServerException e) {
            LOGGER.error("Internal request error ", (Throwable)e);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_BULK_ATOMIC_UPDATE_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
        }
        catch (NoWritingPermissionException e) {
            LOGGER.error(WRITING_PERMISSIONS_INVALID, (Throwable)e);
            Response.Status status = Response.Status.METHOD_NOT_ALLOWED;
            return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_BULK_ATOMIC_UPDATE_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
        }
        catch (AccessUnauthorizedException e) {
            LOGGER.error(CONTRACT_ACCESS_NOT_ALLOW, (Throwable)e);
            Response.Status status = Response.Status.UNAUTHORIZED;
            return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_BULK_ATOMIC_UPDATE_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
        }
    }

    @Path(value="/units/computedInheritedRules")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.COMPUTEINHERITEDRULES_ACTION, description="Lancer le processus de calcul des r\u00e8gles h\u00e9rit\u00e9 pour la recherche")
    public Response startComputeInheritedRules(@Dsl(value=DslSchema.BATCH_PROCESSING) JsonNode dslQuery) {
        Response response;
        block8: {
            AccessInternalClient client = this.accessInternalClientFactory.getClient();
            try {
                RequestResponse requestResponse = client.startComputeInheritedRules(dslQuery);
                int st = requestResponse.isOk() ? Response.Status.OK.getStatusCode() : requestResponse.getHttpCode();
                response = Response.status((int)st).entity((Object)requestResponse).build();
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessInternalClientServerException e) {
                    LOGGER.error(ERROR_ON_PRESERVATION, (Throwable)e);
                    Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
                    return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_CLIENT_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/units/computedInheritedRules")
    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.COMPUTEINHERITEDRULES_DELETE, description="Lancer le processus de Suppression calcul des r\u00e8gles h\u00e9rit\u00e9 pour la recherche")
    public Response deleteComputeInheritedRules(@Dsl(value=DslSchema.BATCH_PROCESSING) JsonNode dslQuery) {
        Response response;
        block8: {
            AccessInternalClient client = this.accessInternalClientFactory.getClient();
            try {
                RequestResponse requestResponse = client.deleteComputeInheritedRules(dslQuery);
                int st = requestResponse.isOk() ? Response.Status.OK.getStatusCode() : requestResponse.getHttpCode();
                response = Response.status((int)st).entity((Object)requestResponse).build();
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessInternalClientServerException e) {
                    LOGGER.error(ERROR_ON_PRESERVATION, (Throwable)e);
                    Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
                    return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_CLIENT_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
                }
            }
            client.close();
        }
        return response;
    }

    @GET
    @Path(value="/unitsWithInheritedRules")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.UNITSWITHINHERITEDRULES_READ, description="R\u00e9cup\u00e9rer la liste des unit\u00e9s archivistiques avec leurs r\u00e8gles de gestion h\u00e9rit\u00e9es")
    public Response selectUnitsWithInheritedRules(@Dsl(value=DslSchema.SELECT_MULTIPLE) JsonNode queryJson) {
        Response response;
        block12: {
            AccessInternalClient client = this.accessInternalClientFactory.getClient();
            try {
                RequestResponse result = client.selectUnitsWithInheritedRules(queryJson);
                int st = result.isOk() ? Response.Status.OK.getStatusCode() : result.getHttpCode();
                response = Response.status((int)st).entity((Object)result).build();
                if (client == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
                    Response.Status status = Response.Status.PRECONDITION_FAILED;
                    return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_UNITS_WITH_INHERITED_RULES_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
                }
                catch (AccessInternalClientServerException e) {
                    LOGGER.error(REQUEST_UNAUTHORIZED, (Throwable)e);
                    Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
                    return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_UNITS_WITH_INHERITED_RULES_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
                }
                catch (AccessInternalClientNotFoundException e) {
                    LOGGER.error(REQ_RES_DOES_NOT_EXIST, (Throwable)e);
                    Response.Status status = Response.Status.NOT_FOUND;
                    return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_UNITS_WITH_INHERITED_RULES_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
                }
                catch (AccessUnauthorizedException e) {
                    LOGGER.error(CONTRACT_ACCESS_NOT_ALLOW, (Throwable)e);
                    Response.Status status = Response.Status.UNAUTHORIZED;
                    return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_UNITS_WITH_INHERITED_RULES_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
                }
                catch (BadRequestException e) {
                    LOGGER.error(NO_SEARCH_QUERY, (Throwable)e);
                    Response.Status status = Response.Status.BAD_REQUEST;
                    return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_UNITS_WITH_INHERITED_RULES_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
                }
            }
            client.close();
        }
        return response;
    }

    private JsonNode findUnitByPersistentIdentifier(String persistentIdentifier, List<String> projectionFields) throws InvalidParseOperationException, AccessInternalClientServerException, AccessInternalClientNotFoundException, AccessUnauthorizedException, BadRequestException, InvalidCreateOperationException {
        ParametersChecker.checkParameter((String)"persistent Identifier is required", (String[])new String[]{persistentIdentifier});
        try (AccessInternalClient client = this.accessInternalClientFactory.getClient();){
            SelectParserMultiple query = new SelectParserMultiple();
            SelectMultiQuery selectMultiQuery = query.getRequest();
            selectMultiQuery.addQueries(new Query[]{QueryHelper.and().add(new Query[]{QueryHelper.eq((String)"PersistentIdentifier.PersistentIdentifierContent", (String)persistentIdentifier), QueryHelper.exists((String)OBJECT_TAG)})});
            selectMultiQuery.addUsedProjection(new String[]{VitamFieldsHelper.id()});
            if (projectionFields != null && !projectionFields.isEmpty()) {
                for (String projectionField : projectionFields) {
                    selectMultiQuery.addUsedProjection(new String[]{projectionField});
                }
            }
            RequestResponse response = client.selectUnits((JsonNode)selectMultiQuery.getFinalSelect());
            SanityChecker.checkJsonAll((JsonNode)response.toJsonNode());
            if (response.isOk()) {
                JsonNode jsonNode = (JsonNode)((RequestResponseOK)response).getFirstResult();
                return jsonNode;
            }
            throw new AccessInternalClientNotFoundException(UNIT_NOT_FOUND);
        }
    }

    private String idObjectGroup(String idu) throws InvalidParseOperationException, AccessInternalClientServerException, AccessInternalClientNotFoundException, AccessUnauthorizedException, BadRequestException, InvalidCreateOperationException {
        ParametersChecker.checkParameter((String)"unit id is required", (String[])new String[]{idu});
        try (AccessInternalClient client = this.accessInternalClientFactory.getClient();){
            SelectMultiQuery select = new SelectMultiQuery();
            select.addUsedProjection(new String[]{OBJECT_TAG});
            select.addQueries(new Query[]{QueryHelper.eq((String)VitamFieldsHelper.id(), (String)idu)});
            RequestResponse response = client.selectUnits((JsonNode)select.getFinalSelect());
            SanityChecker.checkJsonAll((JsonNode)response.toJsonNode());
            if (response.isOk()) {
                JsonNode unit = (JsonNode)((RequestResponseOK)response).getFirstResult();
                if (unit == null || unit.findValue(OBJECT_TAG) == null) {
                    throw new AccessInternalClientNotFoundException("Unit with objectGroup not found");
                }
                String string = unit.findValue(OBJECT_TAG).textValue();
                return string;
            }
            throw new AccessInternalClientNotFoundException(UNIT_NOT_FOUND);
        }
    }

    private Optional<Response> checkQualifierAndVersionHeaders(MultivaluedMap<String, String> multipleMap, VitamCode vitamCode) {
        try {
            if (!multipleMap.containsKey((Object)"X-Qualifier") || !multipleMap.containsKey((Object)"X-Version")) {
                LOGGER.error("At least one required header is missing. Required headers: (" + VitamHttpHeader.QUALIFIER.name() + ", " + VitamHttpHeader.VERSION.name() + ")");
                return Optional.ofNullable(Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)this.getErrorStream((VitamError<JsonNode>)VitamCodeHelper.toVitamError((VitamCode)vitamCode, (String)"QUALIFIER or VERSION missing").setHttpCode(Response.Status.PRECONDITION_FAILED.getStatusCode()))).build());
            }
            Integer.parseInt((String)multipleMap.getFirst((Object)"X-Version"));
        }
        catch (IllegalArgumentException e) {
            LOGGER.error((Throwable)e);
            return Optional.ofNullable(Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)this.getErrorStream((VitamError<JsonNode>)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_DATA_OBJECT_BY_UNIT_ID_ERROR, (String)e.getLocalizedMessage()).setHttpCode(Response.Status.PRECONDITION_FAILED.getStatusCode()))).build());
        }
        return Optional.empty();
    }

    private Response asyncObjectStream(MultivaluedMap<String, String> multipleMap, String idObjectGroup, String unitId) {
        Optional<Response> errorResponse = this.checkQualifierAndVersionHeaders(multipleMap, VitamCode.ACCESS_EXTERNAL_SELECT_DATA_OBJECT_BY_UNIT_ID_ERROR);
        if (errorResponse.isPresent()) {
            return errorResponse.get();
        }
        String xQualifier = (String)((List)multipleMap.get((Object)"X-Qualifier")).get(0);
        String xVersion = (String)((List)multipleMap.get((Object)"X-Version")).get(0);
        HttpHeaderHelper.checkVitamHeadersMap(multipleMap);
        return this.asyncObjectStream(xQualifier, xVersion, idObjectGroup, unitId);
    }

    private Response asyncObjectStream(String xQualifier, String xVersion, String idObjectGroup, String unitId) {
        VitamAsyncInputStreamResponse vitamAsyncInputStreamResponse;
        block12: {
            AccessInternalClient client = this.accessInternalClientFactory.getClient();
            try {
                Response response = client.getObject(idObjectGroup, xQualifier, Integer.parseInt(xVersion), unitId);
                Map headers = VitamAsyncInputStreamResponse.getDefaultMapFromResponse((Response)response);
                headers.put("X-Qualifier", xQualifier);
                headers.put("X-Version", xVersion);
                vitamAsyncInputStreamResponse = new VitamAsyncInputStreamResponse(response, Response.Status.OK, headers);
                if (client == null) break block12;
            }
            catch (Throwable response) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable) {
                            response.addSuppressed(throwable);
                        }
                    }
                    throw response;
                }
                catch (InvalidParseOperationException | IllegalArgumentException exc) {
                    LOGGER.error(exc);
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)this.getErrorStream((VitamError<JsonNode>)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_DATA_OBJECT_BY_UNIT_ID_ERROR, (String)exc.getLocalizedMessage()).setHttpCode(Response.Status.PRECONDITION_FAILED.getStatusCode()))).build();
                }
                catch (AccessInternalClientUnavailableDataFromAsyncOfferException e) {
                    String msg = "Object is not currently available from async offer. Access request required";
                    LOGGER.warn(msg, (Throwable)e);
                    return Response.status((int)460).entity((Object)this.getErrorStream((VitamError<JsonNode>)new VitamError("UNAVAILABLE_DATA_FROM_ASYNC_OFFER").setContext(ServiceName.EXTERNAL_ACCESS.getName()).setHttpCode(460).setState(DomainName.STORAGE.getName()).setMessage(msg).setDescription(e.getLocalizedMessage()))).build();
                }
                catch (AccessInternalClientServerException exc) {
                    LOGGER.error(exc.getMessage(), (Throwable)exc);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorStream((VitamError<JsonNode>)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_DATA_OBJECT_BY_UNIT_ID_ERROR, (String)exc.getLocalizedMessage()).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()))).build();
                }
                catch (AccessInternalClientNotFoundException exc) {
                    LOGGER.warn(exc.getMessage(), (Throwable)exc);
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.getErrorStream((VitamError<JsonNode>)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_DATA_OBJECT_BY_UNIT_ID_ERROR, (String)exc.getLocalizedMessage()).setHttpCode(Response.Status.NOT_FOUND.getStatusCode()))).build();
                }
                catch (AccessUnauthorizedException exc) {
                    LOGGER.error(exc.getMessage(), (Throwable)exc);
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.getErrorStream((VitamError<JsonNode>)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_DATA_OBJECT_BY_UNIT_ID_ERROR, (String)exc.getLocalizedMessage()).setHttpCode(Response.Status.UNAUTHORIZED.getStatusCode()))).build();
                }
            }
            client.close();
        }
        return vitamAsyncInputStreamResponse;
    }

    @Deprecated
    private VitamError<JsonNode> getErrorEntity(Response.Status status, String message) {
        String aMessage = message != null && !message.trim().isEmpty() ? message : (status.getReasonPhrase() != null ? status.getReasonPhrase() : status.name());
        return new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ACCESS_EXTERNAL_MODULE).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(aMessage);
    }

    private InputStream getErrorStream(VitamError<JsonNode> vitamError) {
        try {
            return JsonHandler.writeToInpustream(vitamError);
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new ByteArrayInputStream("{ 'message' : 'Invalid VitamError message' }".getBytes());
        }
    }

    private Response buildErrorFromError(VitamCode vitamCode, String message, VitamError<JsonNode> oldVitamError) {
        LOGGER.info("Description: " + message);
        VitamError newVitamError = new VitamError(VitamCodeHelper.getCode((VitamCode)vitamCode)).setContext(vitamCode.getService().getName()).setState(vitamCode.getDomain().getName()).setMessage(vitamCode.getMessage()).setDescription(message);
        oldVitamError.addToErrors(newVitamError);
        return Response.status((Response.Status)vitamCode.getStatus()).entity((Object)new RequestResponseError().setError(oldVitamError).toString()).build();
    }

    @GET
    @Path(value="/objects")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.OBJECTS_READ, description="R\u00e9cup\u00e9rer la liste des groupes d'objets")
    public Response getObjects(@Dsl(value=DslSchema.SELECT_MULTIPLE) JsonNode queryJson) {
        Response response;
        block14: {
            AccessInternalClient client = this.accessInternalClientFactory.getClient();
            try {
                SanityChecker.checkJsonAll((JsonNode)queryJson);
                SelectMultipleSchemaValidator.checkAuthorizeTrackTotalHits((JsonNode)queryJson, (boolean)this.configuration.isAuthorizeTrackTotalHits());
                RequestResponse selectedObjectGroups = client.selectObjects(queryJson);
                if (!((RequestResponseOK)selectedObjectGroups).getResults().isEmpty()) {
                    this.excludeBlackListedFieldsForGot(((RequestResponseOK)selectedObjectGroups).getResults());
                }
                int st = selectedObjectGroups.isOk() ? Response.Status.OK.getStatusCode() : selectedObjectGroups.getHttpCode();
                response = Response.status((int)st).entity((Object)selectedObjectGroups).build();
                if (client == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
                    Response.Status status = Response.Status.PRECONDITION_FAILED;
                    return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_OBJECTS_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
                }
                catch (AccessInternalClientServerException e) {
                    LOGGER.error(REQUEST_UNAUTHORIZED, (Throwable)e);
                    Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
                    return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_OBJECTS_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
                }
                catch (AccessInternalClientNotFoundException e) {
                    LOGGER.error(REQ_RES_DOES_NOT_EXIST, (Throwable)e);
                    Response.Status status = Response.Status.NOT_FOUND;
                    return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_OBJECTS_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
                }
                catch (AccessUnauthorizedException e) {
                    LOGGER.error(CONTRACT_ACCESS_NOT_ALLOW, (Throwable)e);
                    Response.Status status = Response.Status.UNAUTHORIZED;
                    return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_OBJECTS_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
                }
                catch (BadRequestException e) {
                    LOGGER.error(NO_SEARCH_QUERY, (Throwable)e);
                    Response.Status status = Response.Status.BAD_REQUEST;
                    return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_OBJECTS_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
                }
                catch (ValidationException e) {
                    LOGGER.error(UNAUTHORIZED_DSL_PARAMETER, (Throwable)e);
                    Response.Status status = Response.Status.UNAUTHORIZED;
                    return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_SELECT_OBJECTS_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
                }
            }
            client.close();
        }
        return response;
    }

    private void excludeBlackListedFieldsForGot(List<JsonNode> gotResults) {
        if (this.objectGroupBlackListedFieldsForVisualizationByTenant != null && !this.objectGroupBlackListedFieldsForVisualizationByTenant.isEmpty()) {
            List<String> fieldsToExcludeForCurrentTenant = this.objectGroupBlackListedFieldsForVisualizationByTenant.get(VitamThreadUtils.getVitamSession().getTenantId());
            if (CollectionUtils.isNotEmpty(fieldsToExcludeForCurrentTenant)) {
                gotResults.forEach(got -> fieldsToExcludeForCurrentTenant.forEach(fieldToExclude -> {
                    Iterator gotFields = got.deepCopy().fields();
                    while (gotFields.hasNext()) {
                        Map.Entry nextGotField = (Map.Entry)gotFields.next();
                        JsonHandler.removeFieldFromNode((JsonNode)got, (String)fieldToExclude, (JsonNode)((JsonNode)nextGotField.getValue()));
                    }
                }));
            } else {
                LOGGER.debug("No BlackList Fields of ObjectGroup are declared for tenant " + VitamThreadUtils.getVitamSession().getTenantId());
            }
        }
    }

    @Path(value="/storageaccesslog")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/octet-stream"})
    @Secured(permission=SecurityProfilePermissions.STORAGEACCESSLOG_READ_BINARY, description="T\u00e9l\u00e9charger les journaux d'acc\u00e8s")
    public Response getAccessLog(JsonNode params) {
        VitamAsyncInputStreamResponse vitamAsyncInputStreamResponse;
        block11: {
            AccessInternalClient client = this.accessInternalClientFactory.getClient();
            try {
                Response response = client.downloadAccessLogFile(params);
                Map headers = VitamAsyncInputStreamResponse.getDefaultMapFromResponse((Response)response);
                vitamAsyncInputStreamResponse = new VitamAsyncInputStreamResponse(response, Response.Status.OK, headers);
                if (client == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error(PREDICATES_FAILED_EXCEPTION, (Throwable)e);
                    Response.Status status = Response.Status.PRECONDITION_FAILED;
                    return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_GET_ACCESS_LOG, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
                }
                catch (AccessInternalClientServerException e) {
                    LOGGER.error(REQUEST_UNAUTHORIZED, (Throwable)e);
                    Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
                    return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_GET_ACCESS_LOG, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
                }
                catch (AccessInternalClientNotFoundException e) {
                    LOGGER.error(REQ_RES_DOES_NOT_EXIST, (Throwable)e);
                    Response.Status status = Response.Status.NOT_FOUND;
                    return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_GET_ACCESS_LOG, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
                }
                catch (AccessUnauthorizedException e) {
                    LOGGER.error(CONTRACT_ACCESS_NOT_ALLOW, (Throwable)e);
                    Response.Status status = Response.Status.UNAUTHORIZED;
                    return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_GET_ACCESS_LOG, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
                }
            }
            client.close();
        }
        return vitamAsyncInputStreamResponse;
    }

    @Path(value="/preservation")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.PRESERVATION_UPDATE, description="Lancer le processus de pr\u00e9servation")
    public Response startPreservation(PreservationRequest preservationRequest) {
        Response response;
        block8: {
            AccessInternalClient client = this.accessInternalClientFactory.getClient();
            try {
                RequestResponse requestResponse = client.startPreservation(preservationRequest);
                int st = requestResponse.isOk() ? Response.Status.OK.getStatusCode() : requestResponse.getHttpCode();
                response = Response.status((int)st).entity((Object)requestResponse).build();
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (AccessInternalClientServerException e) {
                    LOGGER.error(ERROR_ON_PRESERVATION, (Throwable)e);
                    Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
                    return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_CLIENT_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
                }
            }
            client.close();
        }
        return response;
    }

    @Path(value="/deleteGotVersions")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Secured(permission=SecurityProfilePermissions.DELETE_GOT_VERSIONS, description="Suppression des version de GOTs")
    public Response deleteGotVersions(DeleteGotVersionsRequest deleteGotVersionsRequest) {
        Response response;
        block9: {
            AccessInternalClient client = this.accessInternalClientFactory.getClient();
            try {
                ParametersChecker.checkParameter((String)"Missing request", (Object[])new Object[]{deleteGotVersionsRequest});
                ParametersChecker.checkParameter((String)"Missing dslQuery in request", (Object[])new Object[]{deleteGotVersionsRequest.getDslQuery()});
                BatchProcessingQuerySchemaValidator validator = new BatchProcessingQuerySchemaValidator();
                validator.validate(deleteGotVersionsRequest.getDslQuery());
                RequestResponse requestResponse = client.deleteGotVersions(deleteGotVersionsRequest);
                int st = requestResponse.isOk() ? Response.Status.OK.getStatusCode() : requestResponse.getHttpCode();
                response = Response.status((int)st).entity((Object)requestResponse).build();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ValidationException | IOException | IllegalArgumentException e) {
                    LOGGER.warn(COULD_NOT_VALIDATE_REQUEST, e);
                    return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity(this.getErrorEntity(Response.Status.PRECONDITION_FAILED, e.getLocalizedMessage())).build();
                }
                catch (AccessInternalClientServerException e) {
                    LOGGER.error("Error on deleting got versions request", (Throwable)e);
                    Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
                    return Response.status((Response.Status)status).entity((Object)VitamCodeHelper.toVitamError((VitamCode)VitamCode.ACCESS_EXTERNAL_CLIENT_ERROR, (String)e.getLocalizedMessage()).setHttpCode(status.getStatusCode())).build();
                }
            }
            client.close();
        }
        return response;
    }
}

