/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.access.internal.client;

import fr.gouv.vitam.access.internal.client.AccessInternalClient;
import fr.gouv.vitam.access.internal.client.AccessInternalClientMock;
import fr.gouv.vitam.access.internal.client.AccessInternalClientRest;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.client.VitamClientFactory;
import fr.gouv.vitam.common.client.configuration.ClientConfiguration;
import fr.gouv.vitam.common.client.configuration.ClientConfigurationImpl;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.io.File;
import java.io.IOException;

public class AccessInternalClientFactory
extends VitamClientFactory<AccessInternalClient> {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AccessInternalClientFactory.class);
    private static final String CONFIGURATION_FILENAME = "access-internal-client.conf";
    private static final AccessInternalClientFactory ACCESS_CLIENT_FACTORY = new AccessInternalClientFactory();
    private static final String RESOURCE_PATH = "/access-internal/v1";

    private AccessInternalClientFactory() {
        super(AccessInternalClientFactory.changeConfigurationFile(CONFIGURATION_FILENAME), RESOURCE_PATH, false);
    }

    public static final AccessInternalClientFactory getInstance() {
        return ACCESS_CLIENT_FACTORY;
    }

    public AccessInternalClient getClient() {
        AccessInternalClient client;
        switch (this.getVitamClientType()) {
            case MOCK: {
                client = new AccessInternalClientMock();
                break;
            }
            case PRODUCTION: {
                client = new AccessInternalClientRest(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Log type unknown");
            }
        }
        return client;
    }

    static final ClientConfiguration changeConfigurationFile(String configurationPath) {
        ClientConfiguration configuration = null;
        if (configurationPath != null) {
            try {
                configuration = (ClientConfiguration)PropertiesUtils.readYaml((File)PropertiesUtils.findFile((String)configurationPath), ClientConfigurationImpl.class);
            }
            catch (IOException fnf) {
                LOGGER.debug("Error when retrieving configuration file {}, using mock", (Object)CONFIGURATION_FILENAME, (Object)fnf);
            }
        }
        if (configuration == null) {
            LOGGER.error("Error when retrieving configuration file {}, using mock", (Object)CONFIGURATION_FILENAME);
        }
        return configuration;
    }

    static final void changeMode(ClientConfiguration configuration) {
        AccessInternalClientFactory.getInstance().initialisation(configuration, AccessInternalClientFactory.getInstance().getResourcePath());
    }
}

