/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.dsl.schema.validator;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.dsl.schema.DslSchema;
import fr.gouv.vitam.common.dsl.schema.ValidationException;
import fr.gouv.vitam.common.dsl.schema.Validator;
import fr.gouv.vitam.common.dsl.schema.meta.Schema;
import fr.gouv.vitam.common.dsl.schema.validator.DslValidator;
import fr.gouv.vitam.common.dsl.schema.validator.UpdateByIdSchemaValidator;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.io.IOException;
import java.io.InputStream;

public class UpdateMultipleSchemaValidator
implements DslValidator {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(UpdateByIdSchemaValidator.class);
    private final Schema schema;

    public UpdateMultipleSchemaValidator() throws IOException {
        LOGGER.debug("Loading schema {} from {}", (Object)DslSchema.MASS_UPDATE.name(), (Object)DslSchema.MASS_UPDATE.getFilename());
        try (InputStream schemaSource = PropertiesUtils.getResourceAsStream((String)DslSchema.MASS_UPDATE.getFilename());){
            this.schema = Schema.getSchema().loadTypes(schemaSource).build();
        }
    }

    @Override
    public void validate(JsonNode dsl) throws ValidationException {
        Validator.validate(this.schema, "DSL", dsl);
    }
}

