/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.dsl.schema.meta;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.dsl.schema.ValidationErrorMessage;
import fr.gouv.vitam.common.dsl.schema.meta.Format;
import fr.gouv.vitam.common.dsl.schema.meta.Schema;
import fr.gouv.vitam.common.dsl.schema.meta.ValidatorEngine;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;

public class AnyKeyFormat
extends Format {
    private Format itemType;

    @Override
    protected void resolve(Schema schema) {
        this.itemType.setReportingType(this);
    }

    public void setItemtype(Format keyType) {
        this.itemType = keyType;
    }

    @Override
    public void validate(JsonNode node, Consumer<String> fieldReport, ValidatorEngine validator) {
        if (!node.isObject()) {
            validator.reportError(this, node, ValidationErrorMessage.Code.WRONG_JSON_TYPE, node.getNodeType().name());
            return;
        }
        Iterator it = node.fields();
        while (it.hasNext()) {
            Map.Entry item = (Map.Entry)it.next();
            String name = (String)item.getKey();
            validator.pushContext(name);
            fieldReport.accept(name);
            validator.validate(this.itemType, (JsonNode)item.getValue(), null);
            validator.popContext();
        }
    }

    @Override
    public void walk(Consumer<Format> consumer) {
        consumer.accept(this);
        this.itemType.walk(consumer);
    }

    @Override
    public String debugInfo() {
        return "{[key]: " + this.itemType.debugInfo() + "}";
    }
}

