/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.logbook.administration.audit.core;

import com.fasterxml.jackson.databind.JsonNode;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.alert.AlertServiceImpl;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamDBException;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.administration.audit.exception.LogbookAuditException;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookMongoDbName;
import fr.gouv.vitam.logbook.common.server.exception.LogbookDatabaseException;
import fr.gouv.vitam.logbook.operations.api.LogbookOperations;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;

public class LogbookAuditAdministration {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogbookAuditAdministration.class);
    private final LogbookOperations logbookOperations;
    private final AlertService alertService;

    public LogbookAuditAdministration(LogbookOperations logbookOperations) {
        this(logbookOperations, (AlertService)new AlertServiceImpl());
    }

    public LogbookAuditAdministration(LogbookOperations logbookOperations, AlertService alertService) {
        this.logbookOperations = logbookOperations;
        this.alertService = alertService;
    }

    public int auditTraceability(String type, int amount, ChronoUnit unit) throws LogbookAuditException {
        Select selectQuery = new Select();
        try {
            LocalDateTime startDateTime = LocalDateUtil.now().minus(amount, unit);
            selectQuery.setQuery((Query)QueryHelper.and().add(new Query[]{QueryHelper.eq((String)LogbookMongoDbName.eventTypeProcess.getDbname(), (String)LogbookTypeProcess.TRACEABILITY.name()), QueryHelper.eq((String)LogbookMongoDbName.eventType.getDbname(), (String)type), QueryHelper.gte((String)LogbookMongoDbName.eventDateTime.getDbname(), (String)LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)startDateTime))}));
            List ops = this.logbookOperations.selectOperations((JsonNode)selectQuery.getFinalSelect());
            int nbLog = ops.size();
            if (nbLog == 0) {
                String error = String.format("No %s traceability found for tenant %d in the last %d %s", type, VitamThreadUtils.getVitamSession().getTenantId(), amount, unit);
                LOGGER.error(error);
                this.alertService.createAlert(error);
            }
            return nbLog;
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | VitamDBException | LogbookDatabaseException e) {
            throw new LogbookAuditException(e.getMessage());
        }
    }
}

