/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.cas.container.swift;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.MetadatasObject;
import fr.gouv.vitam.common.storage.ContainerInformation;
import fr.gouv.vitam.common.storage.StorageConfiguration;
import fr.gouv.vitam.common.storage.cas.container.api.ContentAddressableStorageJcloudsAbstract;
import fr.gouv.vitam.common.storage.cas.container.api.MetadatasStorageObject;
import fr.gouv.vitam.common.storage.constants.ErrorMessage;
import fr.gouv.vitam.common.storage.constants.StorageProvider;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.openstack.swift.v1.SwiftApi;
import org.jclouds.openstack.swift.v1.domain.Account;
import org.jclouds.openstack.swift.v1.domain.SwiftObject;
import org.jclouds.openstack.swift.v1.features.AccountApi;
import org.jclouds.openstack.swift.v1.features.ContainerApi;

public class OpenstackSwift
extends ContentAddressableStorageJcloudsAbstract {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(OpenstackSwift.class);
    private static final String CONTAINER_API_IS_NULL = "container api is null";
    private static final String ACCOUNT_API_IS_NULL = "Account api is null";
    private static final String SWIFT_IS_NULL = "swift is null";
    private int maxResults = 10000;
    private SwiftApi swiftApi;
    private ContainerApi containerApi;
    private AccountApi accountApi;

    public OpenstackSwift(StorageConfiguration configuration) {
        super(configuration);
    }

    public OpenstackSwift(StorageConfiguration configuration, SwiftApi swiftApi, ContainerApi containerApi, AccountApi accountApi) {
        super(configuration);
        this.swiftApi = swiftApi;
        this.containerApi = containerApi;
        this.accountApi = accountApi;
    }

    public ContainerInformation getContainerInformation(String containerName) throws ContentAddressableStorageNotFoundException {
        ParametersChecker.checkParameter((String)"Container name may not be null", (String[])new String[]{containerName});
        ContainerInformation containerInformation = new ContainerInformation();
        Account account = this.getAccountApi().get();
        if (account != null) {
            containerInformation.setUsableSpace(-1L);
        }
        return containerInformation;
    }

    public BlobStoreContext getContext(StorageConfiguration configuration) {
        ContextBuilder contextBuilder = this.getContextBuilder(configuration);
        return (BlobStoreContext)contextBuilder.buildApi(BlobStoreContext.class);
    }

    public void closeContext() {
        this.close();
    }

    public void close() {
        this.context.close();
    }

    private ContextBuilder getContextBuilder(StorageConfiguration configuration) {
        Object swiftUserName = StringUtils.isBlank((CharSequence)configuration.getSwiftUser()) ? configuration.getSwiftDomain() : configuration.getSwiftDomain() + ":" + configuration.getSwiftUser();
        ContextBuilder contextBuilder = ContextBuilder.newBuilder((String)configuration.getProvider()).endpoint(configuration.getSwiftKeystoneAuthUrl()).credentials((String)swiftUserName, configuration.getSwiftPassword());
        if (StorageProvider.SWIFT_AUTH_V1.getValue().equalsIgnoreCase(configuration.getProvider())) {
            Properties overrides = new Properties();
            overrides.setProperty("jclouds.keystone.credential-type", "tempAuthCredentials");
            overrides.setProperty("jclouds.swift.tempAuth.headerUser", "X-Auth-User");
            overrides.setProperty("jclouds.swift.tempAuth.headerPass", "X-Auth-Key");
            overrides.setProperty("jclouds.max-connections-per-context", String.valueOf(configuration.getSwiftMaxConnectionsPerRoute()));
            overrides.setProperty("jclouds.max-connections-per-host", String.valueOf(configuration.getSwiftMaxConnections()));
            overrides.setProperty("jclouds.connection-timeout", String.valueOf(configuration.getSwiftConnectionTimeout()));
            overrides.setProperty("jclouds.so-timeout", String.valueOf(configuration.getSwiftReadTimeout()));
            overrides.setProperty("jclouds.user-threads", String.valueOf(configuration.getSwiftMaxConnections()));
            contextBuilder.overrides(overrides);
        }
        return contextBuilder;
    }

    public void createContainer(String containerName) {
        LOGGER.info("- create container CEPH : " + containerName);
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_NAME_IS_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName});
        try {
            this.getContainerApi().create(containerName);
        }
        finally {
            this.closeContext();
        }
    }

    private ContainerApi getContainerApi() {
        this.containerApi = this.getSwiftAPi().getContainerApi((String)this.swiftApi.getConfiguredRegions().iterator().next());
        if (this.containerApi == null) {
            LOGGER.error(CONTAINER_API_IS_NULL);
            throw new IllegalArgumentException(CONTAINER_API_IS_NULL);
        }
        return this.containerApi;
    }

    private AccountApi getAccountApi() {
        if (this.accountApi == null) {
            this.accountApi = this.getSwiftAPi().getAccountApi((String)this.swiftApi.getConfiguredRegions().iterator().next());
        }
        if (this.accountApi == null) {
            LOGGER.error(ACCOUNT_API_IS_NULL);
            throw new IllegalArgumentException(ACCOUNT_API_IS_NULL);
        }
        return this.accountApi;
    }

    private SwiftApi getSwiftAPi() {
        try {
            StorageConfiguration configuration = this.getConfiguration();
            if (configuration != null && this.swiftApi == null) {
                ContextBuilder contextBuilder = this.getContextBuilder(configuration);
                this.swiftApi = (SwiftApi)contextBuilder.buildApi(SwiftApi.class);
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
        if (this.swiftApi == null) {
            LOGGER.error(SWIFT_IS_NULL);
            throw new IllegalArgumentException(SWIFT_IS_NULL);
        }
        return this.swiftApi;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public MetadatasObject getObjectMetadata(String containerName, String objectId, boolean noCache) throws ContentAddressableStorageException {
        ParametersChecker.checkParameter((String)ErrorMessage.CONTAINER_OBJECT_NAMES_ARE_A_MANDATORY_PARAMETER.getMessage(), (String[])new String[]{containerName, objectId});
        MetadatasStorageObject result = new MetadatasStorageObject();
        result.setType(containerName.split("_")[1]);
        result.setLastAccessDate(null);
        SwiftObject swiftobject = this.getSwiftAPi().getObjectApi((String)this.swiftApi.getConfiguredRegions().iterator().next(), containerName).get(objectId);
        if (swiftobject == null) {
            throw new ContentAddressableStorageNotFoundException("The Object" + objectId + " can not be found for the container " + containerName);
        }
        result.setObjectName(objectId);
        result.setDigest(this.getObjectDigest(containerName, objectId, VitamConfiguration.getDefaultDigestType(), noCache));
        result.setFileSize(swiftobject.getPayload().getContentMetadata().getContentLength().longValue());
        result.setLastModifiedDate(swiftobject.getLastModified().toString());
        return result;
    }
}

