/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.access.internal.serve.filter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.access.internal.serve.exception.MissingAccessContractIdException;
import fr.gouv.vitam.common.database.builder.query.BooleanQuery;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamThreadAccessException;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.client.AdminManagementClient;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.functional.administration.common.exception.AdminManagementClientServerException;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;

public class AccessContractIdHeaderHelper {
    private static final String ACTIVE_STATUS = "ACTIVE";

    private AccessContractIdHeaderHelper() {
        throw new UnsupportedOperationException("Helper class");
    }

    public static void manageAccessContractFromHeader(MultivaluedMap<String, String> requestHeaders, AdminManagementClientFactory adminManagementClientFactory) throws MissingAccessContractIdException {
        try (AdminManagementClient client = adminManagementClientFactory.getClient();){
            String headerAccessContractId = (String)requestHeaders.getFirst((Object)"X-Access-Contract-Id");
            if (headerAccessContractId == null) {
                throw new MissingAccessContractIdException("Missing access contract header X-Access-Contract-Id");
            }
            JsonNode queryDsl = AccessContractIdHeaderHelper.getQueryDsl(headerAccessContractId);
            RequestResponse response = client.findAccessContracts(queryDsl);
            if (!response.isOk()) {
                VitamError vitamError = (VitamError)response;
                throw new MissingAccessContractIdException(vitamError.getMessage() + " : " + vitamError.getDescription());
            }
            if (((RequestResponseOK)response).getResults().size() == 0) {
                throw new MissingAccessContractIdException(headerAccessContractId + " not found in the system");
            }
            List contracts = ((RequestResponseOK)response).getResults();
            VitamThreadUtils.getVitamSession().setContract((AccessContractModel)contracts.get(0));
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | VitamThreadAccessException | AdminManagementClientServerException e) {
            throw new MissingAccessContractIdException("Got an exception while trying to check the access contract in the current session ; exception was : {}", e);
        }
    }

    private static JsonNode getQueryDsl(String headerAccessContractId) throws InvalidCreateOperationException {
        Select select = new Select();
        BooleanQuery query = QueryHelper.and().add(new Query[]{QueryHelper.eq((String)"Identifier", (String)headerAccessContractId), QueryHelper.eq((String)"Status", (String)ACTIVE_STATUS)});
        select.setQuery((Query)query);
        ObjectNode queryDsl = select.getFinalSelect();
        return queryDsl;
    }
}

