/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.access.internal.serve.filter;

import fr.gouv.vitam.access.internal.serve.exception.MissingAccessContractIdException;
import fr.gouv.vitam.access.internal.serve.filter.AccessContractIdHeaderHelper;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

@PreMatching
@Priority(value=2000)
public class AccessContractIdContainerFilter
implements ContainerRequestFilter {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AccessContractIdContainerFilter.class);

    public void filter(ContainerRequestContext requestContext) {
        if (requestContext.getUriInfo().getPath().contains("/status") || requestContext.getUriInfo().getPath().contains("/operations")) {
            return;
        }
        try {
            AccessContractIdHeaderHelper.manageAccessContractFromHeader((MultivaluedMap<String, String>)requestContext.getHeaders(), AdminManagementClientFactory.getInstance());
        }
        catch (MissingAccessContractIdException e) {
            LOGGER.error((Throwable)((Object)e));
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)JsonHandler.createObjectNode().put("Error", e.getMessage())).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }
}

