/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.access.internal.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.access.internal.api.AccessInternalModule;
import fr.gouv.vitam.access.internal.common.exception.AccessInternalExecutionException;
import fr.gouv.vitam.access.internal.core.AccessInternalModuleImpl;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.accesslog.AccessLogInfoModel;
import fr.gouv.vitam.common.accesslog.AccessLogUtils;
import fr.gouv.vitam.common.database.builder.query.Query;
import fr.gouv.vitam.common.database.builder.query.QueryHelper;
import fr.gouv.vitam.common.database.builder.query.VitamFieldsHelper;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.builder.request.single.Select;
import fr.gouv.vitam.common.database.parser.request.single.SelectParserSingle;
import fr.gouv.vitam.common.database.utils.AccessContractRestrictionHelper;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamDBException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.common.stream.VitamAsyncInputStreamResponse;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.logbook.common.exception.LogbookClientException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.model.TraceabilityEvent;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookMongoDbName;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookOperation;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClient;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClientFactory;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClientFactory;
import fr.gouv.vitam.storage.engine.client.StorageClient;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.client.exception.StorageServerClientException;
import fr.gouv.vitam.storage.engine.client.exception.StorageUnavailableDataFromAsyncOfferClientException;
import fr.gouv.vitam.storage.engine.common.exception.StorageNotFoundException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/access-internal/v1")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ApplicationPath(value="webresources")
@Tag(name="Access")
public class LogbookInternalResourceImpl {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogbookInternalResourceImpl.class);
    private static final String LOGBOOK_MODULE = "LOGBOOK";
    private static final String CODE_VITAM = "code_vitam";
    private static final String EVENT_ID_PROCESS = "evIdProc";
    private static final String DSLQUERY_TO_CHECK_TRACEABILITY_OPERATION_NOT_FOUND = "DSL Query to start traceability check was not found.";
    private final AccessInternalModule accessModule;
    private final ProcessingManagementClientFactory processingManagementClientFactory;
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;
    private final WorkspaceClientFactory workspaceClientFactory;

    LogbookInternalResourceImpl() {
        this.accessModule = new AccessInternalModuleImpl();
        this.processingManagementClientFactory = ProcessingManagementClientFactory.getInstance();
        this.logbookOperationsClientFactory = LogbookOperationsClientFactory.getInstance();
        this.workspaceClientFactory = WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM);
        LOGGER.debug("LogbookExternalResource initialized");
    }

    @VisibleForTesting
    LogbookInternalResourceImpl(LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory, LogbookOperationsClientFactory logbookOperationsClientFactory, StorageClientFactory storageClientFactory, WorkspaceClientFactory workspaceClientFactory, AdminManagementClientFactory adminManagementClientFactory, MetaDataClientFactory metaDataClientFactory, ProcessingManagementClientFactory processingManagementClientFactory) {
        this.accessModule = new AccessInternalModuleImpl(logbookLifeCyclesClientFactory, logbookOperationsClientFactory, storageClientFactory, workspaceClientFactory, adminManagementClientFactory, metaDataClientFactory);
        this.processingManagementClientFactory = processingManagementClientFactory;
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
        this.workspaceClientFactory = workspaceClientFactory;
        LOGGER.debug("LogbookExternalResource initialized");
    }

    @GET
    @Path(value="/operations/{id_op}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getOperationById(@PathParam(value="id_op") String operationId, JsonNode queryDsl, @HeaderParam(value="X-Sliced-Operations") boolean sliced, @HeaderParam(value="X-Cross-Tenant") boolean crossTenant) {
        Response response;
        block10: {
            LogbookOperationsClient client = this.logbookOperationsClientFactory.getClient();
            try {
                SanityChecker.checkJsonAll((JsonNode)queryDsl);
                SanityChecker.checkParameter((String[])new String[]{operationId});
                JsonNode result = client.selectOperationById(operationId, queryDsl, sliced, crossTenant);
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                if (client == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (LogbookClientNotFoundException e) {
                    LOGGER.error((Throwable)e);
                    Response.Status status = Response.Status.NOT_FOUND;
                    return Response.status((Response.Status)status).entity((Object)this.getErrorEntity(status, e.getMessage())).build();
                }
                catch (LogbookClientException e) {
                    LOGGER.error((Throwable)e);
                    Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
                    return Response.status((Response.Status)status).entity((Object)this.getErrorEntity(status, e.getMessage())).build();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error((Throwable)e);
                    Response.Status status = Response.Status.PRECONDITION_FAILED;
                    return Response.status((Response.Status)status).entity((Object)this.getErrorEntity(status, e.getMessage())).build();
                }
            }
            client.close();
        }
        return response;
    }

    @GET
    @Path(value="/operations")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response selectOperation(JsonNode query, @HeaderParam(value="X-Sliced-Operations") boolean sliced, @HeaderParam(value="X-Cross-Tenant") boolean crossTenant) {
        Response response;
        block9: {
            LogbookOperationsClient client = this.logbookOperationsClientFactory.getClient();
            try {
                SelectParserSingle parser = new SelectParserSingle();
                parser.parse(query);
                parser.getRequest().reset();
                JsonNode result = client.selectOperation(query, sliced, crossTenant);
                response = Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (LogbookClientException e) {
                    LOGGER.error((Throwable)e);
                    Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
                    return Response.status((Response.Status)status).entity((Object)this.getErrorEntity(status, e.getMessage())).build();
                }
                catch (InvalidParseOperationException e) {
                    LOGGER.error((Throwable)e);
                    Response.Status status = Response.Status.PRECONDITION_FAILED;
                    return Response.status((Response.Status)status).entity((Object)this.getErrorEntity(status, e.getMessage())).build();
                }
            }
            client.close();
        }
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/unitlifecycles/{id_lc}")
    @Produces(value={"application/json"})
    public Response getUnitLifeCycleById(@PathParam(value="id_lc") String unitLifeCycleId, JsonNode queryDsl) {
        try (LogbookLifeCyclesClient client = LogbookLifeCyclesClientFactory.getInstance().getClient();){
            SanityChecker.checkParameter((String[])new String[]{unitLifeCycleId});
            SanityChecker.checkJsonAll((JsonNode)queryDsl);
            Select unitQuery = new Select();
            unitQuery.setQuery((Query)QueryHelper.eq((String)VitamFieldsHelper.id(), (String)unitLifeCycleId));
            JsonNode unitResult = this.accessModule.selectUnit(AccessContractRestrictionHelper.applyAccessContractRestrictionForUnitForSelect((JsonNode)unitQuery.getFinalSelect(), (AccessContractModel)VitamThreadUtils.getVitamSession().getContract()));
            if (unitResult.get("$hits").get("total").toString().equals("0")) {
                Response response2 = Response.status((int)Response.Status.UNAUTHORIZED.getStatusCode()).entity((Object)this.getErrorEntity(Response.Status.UNAUTHORIZED, "Acc\u00e8s refus\u00e9")).build();
                return response2;
            }
            JsonNode result = client.selectUnitLifeCycleById(unitLifeCycleId, queryDsl);
            Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
            return response;
        }
        catch (LogbookClientNotFoundException e) {
            LOGGER.error((Throwable)e);
            Response.Status status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)this.getErrorEntity(status, e.getMessage())).build();
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | LogbookClientException e) {
            LOGGER.error(e);
            Response.Status status = Response.Status.PRECONDITION_FAILED;
            return Response.status((Response.Status)status).entity((Object)this.getErrorEntity(status, e.getMessage())).build();
        }
        catch (AccessInternalExecutionException | VitamDBException e) {
            LOGGER.error(e);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)this.getErrorEntity(status, e.getMessage())).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/objectgrouplifecycles/{id_lc}")
    @Produces(value={"application/json"})
    public Response getObjectGroupLifeCycleById(@PathParam(value="id_lc") String objectGroupLifeCycleId, JsonNode queryDsl) {
        try (LogbookLifeCyclesClient client = LogbookLifeCyclesClientFactory.getInstance().getClient();){
            SanityChecker.checkParameter((String[])new String[]{objectGroupLifeCycleId});
            SanityChecker.checkJsonAll((JsonNode)queryDsl);
            Select gotQuery = new Select();
            gotQuery.setQuery((Query)QueryHelper.eq((String)VitamFieldsHelper.id(), (String)objectGroupLifeCycleId));
            JsonNode gotResult = this.accessModule.selectObjects(AccessContractRestrictionHelper.applyAccessContractRestrictionForObjectGroupForSelect((JsonNode)gotQuery.getFinalSelect(), (AccessContractModel)VitamThreadUtils.getVitamSession().getContract()));
            if (gotResult.get("$hits").get("total").toString().equals("0")) {
                Response response2 = Response.status((int)Response.Status.UNAUTHORIZED.getStatusCode()).entity((Object)this.getErrorEntity(Response.Status.UNAUTHORIZED, "Acc\u00e8s refus\u00e9")).build();
                return response2;
            }
            JsonNode result = client.selectObjectGroupLifeCycleById(objectGroupLifeCycleId, queryDsl);
            Response response = Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
            return response;
        }
        catch (LogbookClientNotFoundException e) {
            LOGGER.error((Throwable)e);
            Response.Status status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)this.getErrorEntity(status, e.getMessage())).build();
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | LogbookClientException e) {
            LOGGER.error(e);
            Response.Status status = Response.Status.PRECONDITION_FAILED;
            return Response.status((Response.Status)status).entity((Object)this.getErrorEntity(status, e.getMessage())).build();
        }
        catch (AccessInternalExecutionException | VitamDBException e) {
            LOGGER.error(e);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)this.getErrorEntity(status, e.getMessage())).build();
        }
    }

    private InputStream getErrorStream(Response.Status status, String message) {
        String aMessage = message != null && !message.trim().isEmpty() ? message : (status.getReasonPhrase() != null ? status.getReasonPhrase() : status.name());
        try {
            return JsonHandler.writeToInpustream((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK_MODULE).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(aMessage));
        }
        catch (InvalidParseOperationException e) {
            return new ByteArrayInputStream("{ 'message' : 'Invalid VitamError message' }".getBytes());
        }
    }

    private VitamError getErrorEntity(Response.Status status, String message) {
        String aMessage = message != null && !message.trim().isEmpty() ? message : (status.getReasonPhrase() != null ? status.getReasonPhrase() : status.name());
        return new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(LOGBOOK_MODULE).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(aMessage);
    }

    /*
     * Exception decompiling
     */
    @POST
    @Path(value="/traceability/linkedcheck")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response linkedCheckOperationTraceability(JsonNode query) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/traceability/{idOperation}/content")
    @Produces(value={"application/octet-stream"})
    public Response downloadTraceabilityOperation(@PathParam(value="idOperation") String operationId) {
        LogbookOperation operationToCheck = null;
        try (LogbookOperationsClient logbookOperationsClient = this.logbookOperationsClientFactory.getClient();){
            SelectParserSingle parser = new SelectParserSingle();
            Select select = new Select();
            parser.parse((JsonNode)select.getFinalSelect());
            parser.addCondition((Query)QueryHelper.eq((String)EVENT_ID_PROCESS, (String)operationId));
            RequestResponseOK requestResponseOK = RequestResponseOK.getFromJsonNode((JsonNode)logbookOperationsClient.selectOperationById(operationId));
            List foundOperation = requestResponseOK.getResults();
            if (foundOperation == null || foundOperation.size() != 1) {
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorStream(Response.Status.BAD_REQUEST, "Operation not found")).build();
                return response;
            }
            operationToCheck = new LogbookOperation((JsonNode)foundOperation.get(0));
            String operationType = (String)operationToCheck.get((Object)LogbookMongoDbName.eventTypeProcess.getDbname());
            if (!LogbookTypeProcess.TRACEABILITY.equals((Object)LogbookTypeProcess.valueOf((String)operationType))) {
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorStream(Response.Status.BAD_REQUEST, "Not a traceability operation")).build();
                return response;
            }
        }
        catch (LogbookClientNotFoundException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorStream(Response.Status.BAD_REQUEST, "Operation not found")).build();
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | LogbookClientException | IllegalArgumentException e) {
            LOGGER.error(e.getMessage(), e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorStream(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage())).build();
        }
        try (StorageClient storageClient = StorageClientFactory.getInstance().getClient();){
            TraceabilityEvent traceabilityEvent = (TraceabilityEvent)JsonHandler.getFromString((String)((String)operationToCheck.get((Object)LogbookMongoDbName.eventDetailData.getDbname())), TraceabilityEvent.class);
            String fileName = traceabilityEvent.getFileName();
            DataCategory dataCategory = this.getDataCategory(traceabilityEvent);
            AccessLogInfoModel logInfo = AccessLogUtils.getNoLogAccessLog();
            Response response = storageClient.getContainerAsync(VitamConfiguration.getDefaultStrategy(), fileName, dataCategory, logInfo);
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                HashMap<String, Object> headers = new HashMap<String, Object>();
                headers.put("Content-Type", "application/octet-stream");
                headers.put("Content-Disposition", "filename=" + fileName);
                VitamAsyncInputStreamResponse vitamAsyncInputStreamResponse = new VitamAsyncInputStreamResponse(response, Response.Status.OK, headers);
                return vitamAsyncInputStreamResponse;
            }
            Response.Status status = (Response.Status)response.getStatusInfo();
            storageClient.consumeAnyEntityAndClose(response);
            Response response2 = Response.status((Response.Status)status).build();
            return response2;
        }
        catch (InvalidParseOperationException | StorageServerClientException | StorageUnavailableDataFromAsyncOfferClientException | StorageNotFoundException e) {
            LOGGER.error(e.getMessage(), e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorStream(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage())).build();
        }
    }

    private DataCategory getDataCategory(TraceabilityEvent traceabilityEvent) {
        if (traceabilityEvent.getLogType() == null) {
            throw new IllegalStateException("Missing traceability event type");
        }
        switch (traceabilityEvent.getLogType()) {
            case OPERATION: 
            case UNIT_LIFECYCLE: 
            case OBJECTGROUP_LIFECYCLE: {
                return DataCategory.LOGBOOK;
            }
            case STORAGE: {
                return DataCategory.STORAGETRACEABILITY;
            }
        }
        throw new IllegalStateException("Invalid traceability event type " + traceabilityEvent.getLogType());
    }
}

