/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.access.internal.rest;

import fr.gouv.vitam.access.internal.common.model.AccessInternalConfiguration;
import fr.gouv.vitam.access.internal.rest.AccessInternalResourceImpl;
import fr.gouv.vitam.access.internal.rest.LogbookInternalResourceImpl;
import fr.gouv.vitam.access.internal.serve.filter.AccessContractIdContainerFilter;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.serverv2.application.CommonBusinessApplication;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClientFactory;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClientFactory;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;

public class BusinessApplication
extends Application {
    private final CommonBusinessApplication commonBusinessApplication;
    private Set<Object> singletons;
    private LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory;
    private LogbookOperationsClientFactory logbookOperationsClientFactory;
    private StorageClientFactory storageClientFactory;
    private WorkspaceClientFactory workspaceClientFactory;
    private AdminManagementClientFactory adminManagementClientFactory;
    private MetaDataClientFactory metaDataClientFactory;
    private ProcessingManagementClientFactory processingManagementClientFactory;

    public BusinessApplication(LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory, LogbookOperationsClientFactory logbookOperationsClientFactory, StorageClientFactory storageClientFactory, WorkspaceClientFactory workspaceClientFactory, AdminManagementClientFactory adminManagementClientFactory, MetaDataClientFactory metaDataClientFactory, ProcessingManagementClientFactory processingManagementClientFactory) {
        this.logbookLifeCyclesClientFactory = logbookLifeCyclesClientFactory;
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
        this.storageClientFactory = storageClientFactory;
        this.workspaceClientFactory = workspaceClientFactory;
        this.processingManagementClientFactory = processingManagementClientFactory;
        this.adminManagementClientFactory = adminManagementClientFactory;
        this.metaDataClientFactory = metaDataClientFactory;
        this.commonBusinessApplication = new CommonBusinessApplication();
        this.singletons = new HashSet<Object>();
        this.singletons.addAll(this.commonBusinessApplication.getResources());
        this.prepare(null);
    }

    public BusinessApplication(@Context ServletConfig servletConfig) {
        String configurationFile = servletConfig.getInitParameter("vitam.configurationFile");
        try (InputStream yamlIS = PropertiesUtils.getConfigAsStream((String)configurationFile);){
            AccessInternalConfiguration accessInternalConfiguration = (AccessInternalConfiguration)PropertiesUtils.readYaml((InputStream)yamlIS, AccessInternalConfiguration.class);
            this.commonBusinessApplication = new CommonBusinessApplication();
            this.singletons = new HashSet<Object>();
            this.singletons.addAll(this.commonBusinessApplication.getResources());
            this.prepare(accessInternalConfiguration);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void prepare(AccessInternalConfiguration accessInternalConfiguration) {
        if (null != accessInternalConfiguration) {
            this.singletons.add((Object)new AccessInternalResourceImpl(accessInternalConfiguration));
            this.singletons.add(new LogbookInternalResourceImpl());
        } else {
            this.singletons.add((Object)new AccessInternalResourceImpl(this.logbookLifeCyclesClientFactory, this.logbookOperationsClientFactory, this.storageClientFactory, this.workspaceClientFactory, this.adminManagementClientFactory, this.metaDataClientFactory, this.processingManagementClientFactory));
            this.singletons.add(new LogbookInternalResourceImpl(this.logbookLifeCyclesClientFactory, this.logbookOperationsClientFactory, this.storageClientFactory, this.workspaceClientFactory, this.adminManagementClientFactory, this.metaDataClientFactory, this.processingManagementClientFactory));
        }
        this.singletons.add(new AccessContractIdContainerFilter());
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }
}

