/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.access.internal.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.access.internal.api.AccessInternalModule;
import fr.gouv.vitam.access.internal.api.AccessInternalResource;
import fr.gouv.vitam.access.internal.common.exception.AccessInternalException;
import fr.gouv.vitam.access.internal.common.exception.AccessInternalExecutionException;
import fr.gouv.vitam.access.internal.common.exception.AccessInternalIllegalOperationException;
import fr.gouv.vitam.access.internal.common.exception.AccessInternalRuleExecutionException;
import fr.gouv.vitam.access.internal.common.exception.AccessInternalUnavailableDataFromAsyncOfferException;
import fr.gouv.vitam.access.internal.common.model.AccessInternalConfiguration;
import fr.gouv.vitam.access.internal.core.AccessInternalModuleImpl;
import fr.gouv.vitam.access.internal.core.identifier.exception.PersistentIdentifierNotFoundException;
import fr.gouv.vitam.access.internal.core.identifier.query.PersistentIdentifierMultiQueryFactory;
import fr.gouv.vitam.access.internal.core.identifier.search.PurgedPersistentIdentifierSearchService;
import fr.gouv.vitam.access.internal.core.permission.DownloadPermissionValidator;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.client.CustomVitamHttpStatusCode;
import fr.gouv.vitam.common.database.builder.request.exception.InvalidCreateOperationException;
import fr.gouv.vitam.common.database.parser.request.multiple.SelectParserMultiple;
import fr.gouv.vitam.common.database.utils.AccessContractRestrictionHelper;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.exception.AccessUnauthorizedException;
import fr.gouv.vitam.common.exception.BadRequestException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.UpdatePermissionException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.DeleteGotVersionsRequest;
import fr.gouv.vitam.common.model.PreservationRequest;
import fr.gouv.vitam.common.model.ProcessAction;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseError;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.VitamSession;
import fr.gouv.vitam.common.model.administration.AccessContractModel;
import fr.gouv.vitam.common.model.dip.DataObjectVersions;
import fr.gouv.vitam.common.model.elimination.EliminationRequestBody;
import fr.gouv.vitam.common.model.export.ExportRequest;
import fr.gouv.vitam.common.model.export.ExportType;
import fr.gouv.vitam.common.model.identifier.PurgedCollectionType;
import fr.gouv.vitam.common.model.massupdate.MassUpdateUnitRuleRequest;
import fr.gouv.vitam.common.model.objectgroup.ObjectGroupResponse;
import fr.gouv.vitam.common.model.revertupdate.RevertUpdateOptions;
import fr.gouv.vitam.common.model.storage.AccessRequestReference;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.common.server.application.HttpHeaderHelper;
import fr.gouv.vitam.common.server.application.VitamHttpHeader;
import fr.gouv.vitam.common.server.application.resources.ApplicationStatusResource;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.functional.administration.client.AdminManagementClientFactory;
import fr.gouv.vitam.logbook.common.parameters.Contexts;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.lifecycles.client.LogbookLifeCyclesClientFactory;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.metadata.api.exception.MetaDataNotFoundException;
import fr.gouv.vitam.metadata.api.exception.MetadataScrollLimitExceededException;
import fr.gouv.vitam.metadata.api.exception.MetadataScrollThresholdExceededException;
import fr.gouv.vitam.metadata.client.MetaDataClientFactory;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClientFactory;
import fr.gouv.vitam.storage.engine.client.StorageClientFactory;
import fr.gouv.vitam.storage.engine.common.exception.StorageNotFoundException;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.ParseException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

@Path(value="/access-internal/v1")
@Tag(name="Access")
public class AccessInternalResourceImpl
extends ApplicationStatusResource
implements AccessInternalResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AccessInternalResourceImpl.class);
    private static final String UNITS = "units";
    private static final String UNITS_URI = "/units";
    private static final String UNITS_ATOMIC_BULK_URI = "/units/atomicbulk";
    private static final String UNITS_RULES_URI = "/units/rules";
    private static final String ACCESS_CONTRACT = "AccessContract";
    private static final String REQUEST_IS_NOT_AN_UPDATE_OPERATION = "Request is not an update operation";
    private static final String WRITE_PERMISSION_NOT_ALLOWED = "Write permission not allowed";
    private static final String EMPTY_QUERY_IS_IMPOSSIBLE = "Empty query is impossible";
    private static final String DEBUG = "DEBUG {}";
    private static final String QUERY_FILE = "query.json";
    private static final String ACCESS_CONTRACT_FILE = "accessContract.json";
    private static final String END_OF_EXECUTION_OF_DSL_VITAM_FROM_ACCESS = "End of execution of DSL Vitam from Access";
    private static final String EXECUTION_OF_DSL_VITAM_FROM_ACCESS_ONGOING = "Execution of DSL Vitam from Access ongoing...";
    private static final String BAD_REQUEST_EXCEPTION = "Bad request Exception ";
    private static final String NOT_FOUND_EXCEPTION = "Not Found Exception ";
    private static final String ACCESS_MODULE = "ACCESS";
    private static final String CODE_VITAM = "code_vitam";
    private static final String ACCESS_RESOURCE_INITIALIZED = "AccessResource initialized";
    private static final String START_SELECT_UNITS_DEBUG_MSG = "DEBUG: start selectUnits {}";
    private final AccessInternalModule accessModule;
    private final ProcessingManagementClientFactory processingManagementClientFactory;
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;
    private final WorkspaceClientFactory workspaceClientFactory;
    private final DownloadPermissionValidator downloadPermissionValidator = new DownloadPermissionValidator();

    public AccessInternalResourceImpl(AccessInternalConfiguration configuration) {
        this((AccessInternalModule)new AccessInternalModuleImpl(), LogbookOperationsClientFactory.getInstance(), WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM), ProcessingManagementClientFactory.getInstance());
        WorkspaceClientFactory.changeMode((String)configuration.getUrlWorkspace(), (WorkspaceType)WorkspaceType.VITAM);
        ProcessingManagementClientFactory.changeConfigurationUrl((String)configuration.getUrlProcessing());
    }

    @VisibleForTesting
    AccessInternalResourceImpl(LogbookLifeCyclesClientFactory logbookLifeCyclesClientFactory, LogbookOperationsClientFactory logbookOperationsClientFactory, StorageClientFactory storageClientFactory, WorkspaceClientFactory workspaceClientFactory, AdminManagementClientFactory adminManagementClientFactory, MetaDataClientFactory metaDataClientFactory, ProcessingManagementClientFactory processingManagementClientFactory) {
        this((AccessInternalModule)new AccessInternalModuleImpl(logbookLifeCyclesClientFactory, logbookOperationsClientFactory, storageClientFactory, workspaceClientFactory, adminManagementClientFactory, metaDataClientFactory), logbookOperationsClientFactory, workspaceClientFactory, processingManagementClientFactory);
    }

    @VisibleForTesting
    private AccessInternalResourceImpl(AccessInternalModule accessModule, LogbookOperationsClientFactory logbookOperationsClientFactory, WorkspaceClientFactory workspaceClientFactory, ProcessingManagementClientFactory processingManagementClientFactory) {
        this.accessModule = accessModule;
        LOGGER.debug(ACCESS_RESOURCE_INITIALIZED);
        this.processingManagementClientFactory = processingManagementClientFactory;
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
        this.workspaceClientFactory = workspaceClientFactory;
    }

    @GET
    @Path(value="/units")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getUnits(JsonNode queryDsl) {
        LOGGER.debug(EXECUTION_OF_DSL_VITAM_FROM_ACCESS_ONGOING);
        JsonNode result = null;
        LOGGER.debug(START_SELECT_UNITS_DEBUG_MSG, (Object)queryDsl);
        try {
            SanityChecker.checkJsonAll((JsonNode)queryDsl);
            this.checkEmptyQuery(queryDsl);
            result = this.accessModule.selectUnit(AccessContractRestrictionHelper.applyAccessContractRestrictionForUnitForSelect((JsonNode)queryDsl, (AccessContractModel)VitamThreadUtils.getVitamSession().getContract()));
            LOGGER.debug(DEBUG, (Object)result);
            this.resetQuery(result, queryDsl);
            LOGGER.debug(END_OF_EXECUTION_OF_DSL_VITAM_FROM_ACCESS);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            LOGGER.error(BAD_REQUEST_EXCEPTION, e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)this.getErrorEntity(status, e.getMessage())).build();
        }
        catch (BadRequestException e) {
            LOGGER.error(EMPTY_QUERY_IS_IMPOSSIBLE, (Throwable)e);
            return this.buildErrorResponse(VitamCode.GLOBAL_EMPTY_QUERY, null);
        }
        catch (Exception ve) {
            LOGGER.error((Throwable)ve);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(UNITS).setState(CODE_VITAM).setMessage(ve.getMessage()).setDescription(status.getReasonPhrase())).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @GET
    @Path(value="/units/unitpid/{persistentIdentifier:.+}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getUnitsByUnitPersistentIdentifier(@PathParam(value="persistentIdentifier") String persistentIdentifier, JsonNode selectQuery) {
        JsonNode result;
        LOGGER.debug(EXECUTION_OF_DSL_VITAM_FROM_ACCESS_ONGOING);
        LOGGER.debug(START_SELECT_UNITS_DEBUG_MSG, (Object)selectQuery);
        try {
            result = this.accessModule.selectUnit((JsonNode)PersistentIdentifierMultiQueryFactory.createSelectMultiQuery((PurgedCollectionType)PurgedCollectionType.UNIT, (String)persistentIdentifier, (JsonNode)selectQuery).getFinalSelect());
            LOGGER.debug(DEBUG, (Object)result);
            LOGGER.debug(END_OF_EXECUTION_OF_DSL_VITAM_FROM_ACCESS);
            if (RequestResponse.isRequestResponseEmpty((JsonNode)result)) {
                JsonNode jsonNode = this.accessModule.selectPurgedPersistentIdentifier(persistentIdentifier, PurgedCollectionType.UNIT);
                ((ObjectNode)result).set("$history", jsonNode);
                ((ObjectNode)result).remove("$context");
            }
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error(BAD_REQUEST_EXCEPTION, (Throwable)e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)this.getErrorEntity(status, e.getMessage())).build();
        }
        catch (Exception ve) {
            LOGGER.error((Throwable)ve);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(UNITS).setState(CODE_VITAM).setMessage(ve.getMessage()).setDescription(status.getReasonPhrase())).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @GET
    @Path(value="/objects/unitpid/{persistentIdentifier:.+}")
    @Produces(value={"application/octet-stream", "application/json"})
    public Response downloadObjectsByUnitPersistentIdentifier(@PathParam(value="persistentIdentifier") String unitPersistentIdentifier, @DefaultValue(value="BinaryMaster") @QueryParam(value="qualifier") String qualifier, @QueryParam(value="version") Integer version) {
        try {
            this.downloadPermissionValidator.validate();
            return this.accessModule.getObjectByUnitPersistentIdentifier(unitPersistentIdentifier, qualifier, version);
        }
        catch (InvalidParseOperationException | MetaDataNotFoundException e) {
            Optional optionalPurgedPersistentIdentifier = new PurgedPersistentIdentifierSearchService().search(unitPersistentIdentifier, PurgedCollectionType.OBJECT).stream().findFirst();
            Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.NOT_FOUND);
            if (optionalPurgedPersistentIdentifier.isPresent()) {
                return responseBuilder.entity(optionalPurgedPersistentIdentifier.get()).build();
            }
            throw new PersistentIdentifierNotFoundException();
        }
        catch (AccessInternalException | StorageNotFoundException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage())).build();
        }
        catch (AccessUnauthorizedException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.getErrorStream(Response.Status.UNAUTHORIZED, e.getMessage())).build();
        }
    }

    @GET
    @Path(value="/objects/objectpid/{persistentIdentifier:.+}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getObjectsByObjectPersistentIdentifier(@PathParam(value="persistentIdentifier") String persistentIdentifier, JsonNode selectQuery) {
        try {
            this.downloadPermissionValidator.validate();
            ObjectGroupResponse objectGroupResponse = this.accessModule.findOneObjectGroupByPersistentId(persistentIdentifier, selectQuery);
            RequestResponseOK payload = new RequestResponseOK(selectQuery, List.of(objectGroupResponse), 1);
            return Response.ok((Object)payload).build();
        }
        catch (MetaDataNotFoundException e) {
            LOGGER.warn(e.getLocalizedMessage());
        }
        catch (AccessUnauthorizedException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)e).build();
        }
        try {
            JsonNode history = this.accessModule.selectPurgedPersistentIdentifier(persistentIdentifier, PurgedCollectionType.OBJECT);
            JsonNode payload = new RequestResponseOK().toJsonNode();
            ((ObjectNode)payload).set("$history", history);
            ((ObjectNode)payload).remove("$context");
            return Response.ok((Object)payload).build();
        }
        catch (InvalidParseOperationException e) {
            LOGGER.error(BAD_REQUEST_EXCEPTION, (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorEntity(Response.Status.BAD_REQUEST, e.getMessage())).build();
        }
        catch (Exception ve) {
            LOGGER.error((Throwable)ve);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new VitamError(Response.Status.INTERNAL_SERVER_ERROR.name()).setHttpCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).setContext(UNITS).setState(CODE_VITAM).setMessage(ve.getMessage()).setDescription(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase())).build();
        }
    }

    @GET
    @Path(value="/objects/objectpid/{persistentIdentifier:.+}")
    @Produces(value={"application/octet-stream", "application/json"})
    public Response downloadObjectByPersistentIdentifier(@PathParam(value="persistentIdentifier") String persistentIdentifier) {
        try {
            this.downloadPermissionValidator.validate();
            return this.accessModule.getObjectByPersistentIdentifier(persistentIdentifier);
        }
        catch (MetaDataNotFoundException e) {
            Optional optionalPurgedPersistentIdentifier = new PurgedPersistentIdentifierSearchService().search(persistentIdentifier, PurgedCollectionType.OBJECT).stream().findFirst();
            Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.NOT_FOUND);
            if (optionalPurgedPersistentIdentifier.isPresent()) {
                return responseBuilder.entity(optionalPurgedPersistentIdentifier.get()).build();
            }
            throw new PersistentIdentifierNotFoundException();
        }
        catch (AccessInternalException | StorageNotFoundException e) {
            LOGGER.error(e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorEntity(Response.Status.INTERNAL_SERVER_ERROR, e.getMessage())).build();
        }
        catch (AccessUnauthorizedException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.getErrorStream(Response.Status.UNAUTHORIZED, e.getMessage())).build();
        }
    }

    @GET
    @Path(value="/units/stream")
    @Consumes(value={"application/json"})
    @Produces(value={"application/octet-stream"})
    public Response streamUnits(JsonNode queryDsl) {
        try {
            SanityChecker.checkJsonAll((JsonNode)queryDsl);
            this.checkEmptyQuery(queryDsl);
            return this.accessModule.streamUnits(AccessContractRestrictionHelper.applyAccessContractRestrictionForUnitForSelect((JsonNode)queryDsl, (AccessContractModel)VitamThreadUtils.getVitamSession().getContract()));
        }
        catch (MetadataScrollThresholdExceededException e) {
            return Response.status((Response.Status)Response.Status.EXPECTATION_FAILED).build();
        }
        catch (MetadataScrollLimitExceededException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception ve) {
            LOGGER.error((Throwable)ve);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/objects/stream")
    @Consumes(value={"application/json"})
    @Produces(value={"application/octet-stream"})
    public Response streamObjects(JsonNode queryDsl) {
        try {
            SanityChecker.checkJsonAll((JsonNode)queryDsl);
            this.checkEmptyQuery(queryDsl);
            JsonNode jsonNode = AccessContractRestrictionHelper.applyAccessContractRestrictionForObjectGroupForSelect((JsonNode)queryDsl, (AccessContractModel)VitamThreadUtils.getVitamSession().getContract());
            return this.accessModule.streamObjects(jsonNode);
        }
        catch (MetadataScrollThresholdExceededException e) {
            return Response.status((Response.Status)Response.Status.EXPECTATION_FAILED).build();
        }
        catch (MetadataScrollLimitExceededException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception ve) {
            LOGGER.error((Throwable)ve);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="/unitsWithInheritedRules")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response selectUnitsWithInheritedRules(JsonNode queryDsl) {
        JsonNode result;
        LOGGER.debug(EXECUTION_OF_DSL_VITAM_FROM_ACCESS_ONGOING);
        LOGGER.debug("DEBUG: start selectUnitsWithInheritedRules {}", (Object)queryDsl);
        try {
            SanityChecker.checkJsonAll((JsonNode)queryDsl);
            this.checkEmptyQuery(queryDsl);
            result = this.accessModule.selectUnitsWithInheritedRules(AccessContractRestrictionHelper.applyAccessContractRestrictionForUnitForSelect((JsonNode)queryDsl, (AccessContractModel)VitamThreadUtils.getVitamSession().getContract()));
            LOGGER.debug(DEBUG, (Object)result);
            this.resetQuery(result, queryDsl);
            LOGGER.debug(END_OF_EXECUTION_OF_DSL_VITAM_FROM_ACCESS);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            LOGGER.error(BAD_REQUEST_EXCEPTION, e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)this.getErrorEntity(status, e.getMessage())).build();
        }
        catch (BadRequestException e) {
            LOGGER.error(EMPTY_QUERY_IS_IMPOSSIBLE, (Throwable)e);
            return this.buildErrorResponse(VitamCode.GLOBAL_EMPTY_QUERY, null);
        }
        catch (Exception ve) {
            LOGGER.error((Throwable)ve);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(UNITS).setState(CODE_VITAM).setMessage(ve.getMessage()).setDescription(status.getReasonPhrase())).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    @POST
    @Path(value="/dipexport")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response exportDIP(JsonNode dslRequest) {
        ExportRequest exportRequest = new ExportRequest();
        exportRequest.setDataObjectVersionToExport(new DataObjectVersions(Set.of()));
        exportRequest.setDslRequest(dslRequest);
        exportRequest.setExportWithLogBookLFC(false);
        exportRequest.setExportWithoutObjects(false);
        exportRequest.setExportType(ExportType.MinimalArchiveDeliveryRequestReply);
        return this.exportByRequest(exportRequest, false);
    }

    @POST
    @Path(value="/export/usagefilter")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response exportByUsageFilter(ExportRequest exportRequest) {
        return this.exportByRequest(exportRequest, true);
    }

    /*
     * Exception decompiling
     */
    private Response exportByRequest(ExportRequest exportRequest, boolean applyFilter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addRightsStatementIdentifier(LogbookOperationParameters initParameters) {
        ObjectNode rightsStatementIdentifier = JsonHandler.createObjectNode();
        rightsStatementIdentifier.put(ACCESS_CONTRACT, VitamThreadUtils.getVitamSession().getContract().getIdentifier());
        initParameters.putParameterValue(LogbookParameterName.rightsStatementIdentifier, rightsStatementIdentifier.toString());
    }

    /*
     * Exception decompiling
     */
    @POST
    @Path(value="/transfers/reply")
    @Consumes(value={"application/xml"})
    @Produces(value={"application/json"})
    public Response transferReply(InputStream transferReply) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @GET
    @Path(value="/dipexport/{id}/dip")
    @Consumes(value={"application/octet-stream"})
    public Response findDIPByID(@PathParam(value="id") String id) {
        try {
            return this.accessModule.findDIPByOperationId(id);
        }
        catch (AccessInternalExecutionException e) {
            LOGGER.error(BAD_REQUEST_EXCEPTION, (Throwable)e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)this.getErrorEntity(status, e.getMessage())).build();
        }
    }

    @GET
    @Path(value="/transferexport/{id}/sip")
    @Consumes(value={"application/octet-stream"})
    public Response findTransferSIPByID(@PathParam(value="id") String id) {
        try {
            return this.accessModule.findTransferSIPByOperationId(id);
        }
        catch (AccessInternalExecutionException e) {
            LOGGER.error(BAD_REQUEST_EXCEPTION, (Throwable)e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)this.getErrorEntity(status, e.getMessage())).build();
        }
    }

    @POST
    @Path(value="/reclassification")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response startReclassificationWorkflow(JsonNode reclassificationRequestJson) {
        return this.startReclassificationWorkflow(reclassificationRequestJson, ProcessAction.RESUME);
    }

    /*
     * Exception decompiling
     */
    public Response startReclassificationWorkflow(JsonNode reclassificationRequestJson, ProcessAction processAction) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @POST
    @Path(value="/elimination/analysis")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response startEliminationAnalysisWorkflow(EliminationRequestBody eliminationRequestBody) {
        return this.startEliminationWorkflow(eliminationRequestBody, Contexts.ELIMINATION_ANALYSIS);
    }

    @POST
    @Path(value="/elimination/action")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response startEliminationActionWorkflow(EliminationRequestBody eliminationRequestBody) {
        return this.startEliminationWorkflow(eliminationRequestBody, Contexts.ELIMINATION_ACTION);
    }

    /*
     * Exception decompiling
     */
    private Response startEliminationWorkflow(EliminationRequestBody eliminationRequestBody, Contexts eliminationWorkflowContext) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @GET
    @Path(value="/units/{id_unit}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getUnitById(JsonNode queryDsl, @PathParam(value="id_unit") String idUnit) {
        LOGGER.debug(EXECUTION_OF_DSL_VITAM_FROM_ACCESS_ONGOING);
        try {
            SanityChecker.checkJsonAll((JsonNode)queryDsl);
            SanityChecker.checkParameter((String[])new String[]{idUnit});
            JsonNode result = this.accessModule.selectUnitbyId(AccessContractRestrictionHelper.applyAccessContractRestrictionForUnitForSelect((JsonNode)queryDsl, (AccessContractModel)VitamThreadUtils.getVitamSession().getContract()), idUnit);
            this.resetQuery(result, queryDsl);
            LOGGER.debug(END_OF_EXECUTION_OF_DSL_VITAM_FROM_ACCESS);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            LOGGER.error(BAD_REQUEST_EXCEPTION, e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)this.getErrorEntity(status, e.getMessage())).build();
        }
        catch (AccessInternalExecutionException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            Response.Status status = Response.Status.METHOD_NOT_ALLOWED;
            return Response.status((Response.Status)status).entity((Object)this.getErrorEntity(status, e.getMessage())).build();
        }
        catch (MetaDataNotFoundException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            Response.Status status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)this.getErrorEntity(status, e.getMessage())).build();
        }
    }

    @PUT
    @Path(value="/units/{id_unit}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateUnitById(JsonNode queryDsl, @PathParam(value="id_unit") String idUnit, @HeaderParam(value="X-Request-Id") String requestId) {
        LOGGER.debug(EXECUTION_OF_DSL_VITAM_FROM_ACCESS_ONGOING);
        try {
            SanityChecker.checkJsonAll((JsonNode)queryDsl);
            SanityChecker.checkParameter((String[])new String[]{idUnit});
            SanityChecker.checkParameter((String[])new String[]{requestId});
            this.accessModule.checkClassificationLevel(queryDsl);
            JsonNode result = this.accessModule.updateUnitById(AccessContractRestrictionHelper.applyAccessContractRestrictionForUnitForUpdate((JsonNode)queryDsl, (AccessContractModel)VitamThreadUtils.getVitamSession().getContract()), idUnit, requestId);
            LOGGER.debug(END_OF_EXECUTION_OF_DSL_VITAM_FROM_ACCESS);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | IllegalArgumentException e) {
            LOGGER.error(BAD_REQUEST_EXCEPTION, e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)this.getErrorEntity(status, e.getMessage())).build();
        }
        catch (AccessInternalRuleExecutionException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildErrorResponse(VitamCode.ACCESS_INTERNAL_UPDATE_UNIT_CHECK_RULES, e.getMessage());
        }
        catch (UpdatePermissionException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildErrorResponse(VitamCode.UPDATE_UNIT_PERMISSION, e.getMessage());
        }
        catch (AccessInternalExecutionException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)this.getErrorEntity(status, e.getMessage())).build();
        }
        catch (MetaDataNotFoundException e) {
            LOGGER.error(NOT_FOUND_EXCEPTION, (Throwable)e);
            Response.Status status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)this.getErrorEntity(status, e.getMessage())).build();
        }
    }

    @GET
    @Path(value="/objects/{id_object_group}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getObjectGroup(@PathParam(value="id_object_group") String idObjectGroup, JsonNode query) {
        try {
            SanityChecker.checkJsonAll((JsonNode)query);
            SanityChecker.checkParameter((String[])new String[]{idObjectGroup});
            JsonNode result = this.accessModule.selectObjectGroupById(AccessContractRestrictionHelper.applyAccessContractExceptRuleRestrictionsForObjectGroupForSelect((JsonNode)query, (AccessContractModel)VitamThreadUtils.getVitamSession().getContract()), idObjectGroup);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException | IllegalArgumentException exc) {
            LOGGER.error(exc);
            Response.Status status = Response.Status.PRECONDITION_FAILED;
            return Response.status((Response.Status)status).entity((Object)this.getErrorEntity(status, exc.getMessage())).build();
        }
        catch (AccessInternalExecutionException exc) {
            LOGGER.error((Throwable)exc);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)this.getErrorEntity(status, exc.getMessage())).build();
        }
        catch (MetaDataNotFoundException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            Response.Status status = Response.Status.NOT_FOUND;
            return Response.status((Response.Status)status).entity((Object)this.getErrorEntity(status, e.getMessage())).build();
        }
    }

    private Optional<Response> checkObjectQualifierAndUsageParams(MultivaluedMap<String, String> multipleMap, String idObjectGroup) {
        if (!(multipleMap.containsKey((Object)"X-Tenant-Id") && multipleMap.containsKey((Object)"X-Qualifier") && multipleMap.containsKey((Object)"X-Version"))) {
            LOGGER.error("At least one required header is missing. Required headers: (" + VitamHttpHeader.TENANT_ID.name() + ", " + VitamHttpHeader.QUALIFIER.name() + ", " + VitamHttpHeader.VERSION.name() + ")");
            return Optional.of(Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)this.getErrorStream(Response.Status.PRECONDITION_FAILED, "At least one required header is missing. Required headers: (" + VitamHttpHeader.TENANT_ID.name() + ", " + VitamHttpHeader.QUALIFIER.name() + ", " + VitamHttpHeader.VERSION.name() + ")")).build());
        }
        String xQualifier = (String)((List)multipleMap.get((Object)"X-Qualifier")).get(0);
        String xVersion = (String)((List)multipleMap.get((Object)"X-Version")).get(0);
        if (!VitamThreadUtils.getVitamSession().getContract().isEveryDataObjectVersion().booleanValue() && !this.validUsage(xQualifier.split("_")[0])) {
            return Optional.of(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.getErrorStream(Response.Status.UNAUTHORIZED, "Qualifier not allowed")).build());
        }
        try {
            SanityChecker.checkHeadersMap(multipleMap);
            HttpHeaderHelper.checkVitamHeadersMap(multipleMap);
            SanityChecker.checkParameter((String[])new String[]{idObjectGroup});
            Integer.parseInt(xVersion);
            return Optional.empty();
        }
        catch (InvalidParseOperationException | IllegalArgumentException | IllegalStateException exc) {
            LOGGER.error(exc);
            return Optional.of(Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)this.getErrorStream(Response.Status.PRECONDITION_FAILED, exc.getMessage())).build());
        }
    }

    private Response asyncObjectStream(MultivaluedMap<String, String> multipleMap, String idObjectGroup, String idUnit) {
        Optional<Response> errorResponse = this.checkObjectQualifierAndUsageParams(multipleMap, idObjectGroup);
        if (errorResponse.isPresent()) {
            return errorResponse.get();
        }
        String xQualifier = (String)((List)multipleMap.get((Object)"X-Qualifier")).get(0);
        String xVersion = (String)((List)multipleMap.get((Object)"X-Version")).get(0);
        int version = Integer.parseInt(xVersion);
        try {
            this.downloadPermissionValidator.validate();
            return this.accessModule.getOneObjectFromObjectGroup(idObjectGroup, xQualifier, version, idUnit);
        }
        catch (InvalidParseOperationException | IllegalArgumentException exc) {
            LOGGER.error(exc);
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)this.getErrorStream(Response.Status.PRECONDITION_FAILED, exc.getMessage())).build();
        }
        catch (AccessInternalExecutionException exc) {
            LOGGER.error(exc.getMessage(), (Throwable)exc);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorStream(Response.Status.INTERNAL_SERVER_ERROR, exc.getMessage())).build();
        }
        catch (AccessInternalUnavailableDataFromAsyncOfferException e) {
            LOGGER.warn("Object " + xQualifier + "_" + xVersion + " of ObjectGroup: " + idObjectGroup + " / UnitId: " + idUnit + " is not currently available from async offer. Access request required", (Throwable)e);
            return Response.status((int)CustomVitamHttpStatusCode.UNAVAILABLE_DATA_FROM_ASYNC_OFFER.getStatusCode()).build();
        }
        catch (MetaDataNotFoundException | StorageNotFoundException exc) {
            LOGGER.warn(exc);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.getErrorStream(Response.Status.NOT_FOUND, exc.getMessage())).build();
        }
        catch (AccessUnauthorizedException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.getErrorStream(Response.Status.UNAUTHORIZED, e.getMessage())).build();
        }
    }

    private boolean validUsage(String s) {
        VitamSession vitamSession = VitamThreadUtils.getVitamSession();
        Set versions = vitamSession.getContract().getDataObjectVersion();
        if (versions.isEmpty()) {
            return true;
        }
        for (String version : versions) {
            if (!version.equals(s)) continue;
            return true;
        }
        return false;
    }

    private void checkEmptyQuery(JsonNode queryDsl) throws InvalidParseOperationException, BadRequestException {
        SelectParserMultiple parser = new SelectParserMultiple();
        parser.parse(queryDsl.deepCopy());
        if (parser.getRequest().getNbQueries() == 0 && parser.getRequest().getRoots().isEmpty()) {
            throw new BadRequestException("Query cant be empty");
        }
    }

    @GET
    @Path(value="/objects/{id_object_group}/{id_unit}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/octet-stream"})
    public Response getObjectStreamAsync(@Context HttpHeaders headers, @PathParam(value="id_object_group") String idObjectGroup, @PathParam(value="id_unit") String idUnit) {
        MultivaluedMap multipleMap = headers.getRequestHeaders();
        return this.asyncObjectStream((MultivaluedMap<String, String>)multipleMap, idObjectGroup, idUnit);
    }

    @POST
    @Path(value="/objects/{id_object_group}/accessRequest")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createObjectAccessRequestIfRequired(@Context HttpHeaders headers, @PathParam(value="id_object_group") String idObjectGroup) {
        MultivaluedMap multipleMap = headers.getRequestHeaders();
        Optional<Response> errorResponse = this.checkObjectQualifierAndUsageParams((MultivaluedMap<String, String>)multipleMap, idObjectGroup);
        if (errorResponse.isPresent()) {
            return errorResponse.get();
        }
        try {
            String xQualifier = headers.getHeaderString("X-Qualifier");
            int version = Integer.parseInt(headers.getHeaderString("X-Version"));
            Optional objectAccessRequest = this.accessModule.createObjectAccessRequestIfRequired(idObjectGroup, xQualifier, version);
            RequestResponseOK requestResponseOK = new RequestResponseOK();
            objectAccessRequest.ifPresent(arg_0 -> ((RequestResponseOK)requestResponseOK).addResult(arg_0));
            requestResponseOK.setHttpCode(Response.Status.OK.getStatusCode());
            return requestResponseOK.toResponse();
        }
        catch (InvalidParseOperationException | IllegalArgumentException | IllegalStateException exc) {
            LOGGER.error(exc);
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)this.getErrorStream(Response.Status.PRECONDITION_FAILED, exc.getMessage())).build();
        }
        catch (MetaDataNotFoundException exc) {
            LOGGER.error((Throwable)exc);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.getErrorStream(Response.Status.NOT_FOUND, exc.getMessage())).build();
        }
        catch (Exception exc) {
            LOGGER.error(exc.getMessage(), (Throwable)exc);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorStream(Response.Status.INTERNAL_SERVER_ERROR, exc.getMessage())).build();
        }
    }

    @GET
    @Path(value="/accessRequests/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response checkAccessRequestStatuses(@Context HttpHeaders headers, List<AccessRequestReference> accessRequestReferences) {
        try {
            ParametersChecker.checkParameter((String)"Tenant required", (String[])new String[]{headers.getHeaderString("X-Tenant-Id")});
            if (accessRequestReferences.isEmpty()) {
                throw new IllegalArgumentException("Empty query");
            }
            for (AccessRequestReference accessRequestReference : accessRequestReferences) {
                ParametersChecker.checkParameter((String)"Access requests required", (Object[])new Object[]{accessRequestReference});
                ParametersChecker.checkParameter((String)"Required accessRequestId", (String[])new String[]{accessRequestReference.getAccessRequestId()});
                ParametersChecker.checkParameter((String)"Required storageStrategyId", (String[])new String[]{accessRequestReference.getStorageStrategyId()});
            }
            List statusByAccessRequests = this.accessModule.checkAccessRequestStatuses(accessRequestReferences);
            return new RequestResponseOK().addAllResults(statusByAccessRequests).setHttpCode(Response.Status.OK.getStatusCode()).toResponse();
        }
        catch (IllegalArgumentException | IllegalStateException exc) {
            LOGGER.error((Throwable)exc);
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)this.getErrorStream(Response.Status.PRECONDITION_FAILED, exc.getMessage())).build();
        }
        catch (AccessInternalIllegalOperationException exc) {
            LOGGER.error((Throwable)exc);
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)this.getErrorStream(Response.Status.NOT_ACCEPTABLE, exc.getMessage())).build();
        }
        catch (Exception exc) {
            LOGGER.error(exc.getMessage(), (Throwable)exc);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorStream(Response.Status.INTERNAL_SERVER_ERROR, exc.getMessage())).build();
        }
    }

    @DELETE
    @Path(value="/accessRequests/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response removeAccessRequest(@Context HttpHeaders headers, AccessRequestReference accessRequestReference) {
        try {
            ParametersChecker.checkParameter((String)"Tenant required", (String[])new String[]{headers.getHeaderString("X-Tenant-Id")});
            ParametersChecker.checkParameter((String)"Access request required", (Object[])new Object[]{accessRequestReference});
            ParametersChecker.checkParameter((String)"Required accessRequestId", (String[])new String[]{accessRequestReference.getAccessRequestId()});
            ParametersChecker.checkParameter((String)"Required storageStrategyId", (String[])new String[]{accessRequestReference.getStorageStrategyId()});
            this.accessModule.removeAccessRequest(accessRequestReference.getStorageStrategyId(), accessRequestReference.getAccessRequestId());
            return new RequestResponseOK().setHttpCode(Response.Status.OK.getStatusCode()).toResponse();
        }
        catch (IllegalArgumentException exc) {
            LOGGER.error((Throwable)exc);
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)this.getErrorStream(Response.Status.PRECONDITION_FAILED, exc.getMessage())).build();
        }
        catch (AccessInternalIllegalOperationException exc) {
            LOGGER.error((Throwable)exc);
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).entity((Object)this.getErrorStream(Response.Status.NOT_ACCEPTABLE, exc.getMessage())).build();
        }
        catch (Exception exc) {
            LOGGER.error(exc.getMessage(), (Throwable)exc);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorStream(Response.Status.INTERNAL_SERVER_ERROR, exc.getMessage())).build();
        }
    }

    @GET
    @Path(value="/storageaccesslog")
    @Consumes(value={"application/json"})
    @Produces(value={"application/octet-stream"})
    public Response getAccessLogStreamAsync(@Context HttpHeaders headers, JsonNode params) {
        MultivaluedMap multipleMap = headers.getRequestHeaders();
        if (!multipleMap.containsKey((Object)"X-Tenant-Id")) {
            LOGGER.error("Header is missing. Required headers: (" + VitamHttpHeader.TENANT_ID.name() + ")");
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)this.getErrorStream(Response.Status.PRECONDITION_FAILED, "Header is missing. Required headers: (" + VitamHttpHeader.TENANT_ID.name() + ")")).build();
        }
        try {
            Integer tenantId = ParameterHelper.getTenantParameter();
            ParametersChecker.checkParameter((String)"You must specify a valid tenant", (Object[])new Object[]{tenantId});
            return this.accessModule.getAccessLog(params);
        }
        catch (IllegalArgumentException exc) {
            LOGGER.error((Throwable)exc);
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)this.getErrorStream(Response.Status.PRECONDITION_FAILED, exc.getMessage())).build();
        }
        catch (ParseException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorStream(Response.Status.BAD_REQUEST, e.getMessage())).build();
        }
        catch (AccessInternalExecutionException exc) {
            LOGGER.error(exc.getMessage(), (Throwable)exc);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.getErrorStream(Response.Status.INTERNAL_SERVER_ERROR, exc.getMessage())).build();
        }
        catch (StorageNotFoundException exc) {
            LOGGER.error((Throwable)exc);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.getErrorStream(Response.Status.NOT_FOUND, exc.getMessage())).build();
        }
    }

    /*
     * Exception decompiling
     */
    @POST
    @Path(value="/units")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response massUpdateUnits(JsonNode queryDsl) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @POST
    @Path(value="/units/rules")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response massUpdateUnitsRules(MassUpdateUnitRuleRequest massUpdateUnitRuleRequest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @POST
    @Path(value="/units/atomicbulk")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response bulkAtomicUpdateUnits(JsonNode query) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @POST
    @Path(value="/revert/units")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response revertUpdateUnits(RevertUpdateOptions revertUpdateOptions) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isAuthorized() {
        if (VitamThreadUtils.getVitamSession().getContract().getWritingPermission() == null || VitamThreadUtils.getVitamSession().getContract().getWritingRestrictedDesc() == null) {
            return false;
        }
        return VitamThreadUtils.getVitamSession().getContract().getWritingPermission() != false && VitamThreadUtils.getVitamSession().getContract().getWritingRestrictedDesc() == false;
    }

    /*
     * Exception decompiling
     */
    @Path(value="/units/computedInheritedRules")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response startComputeInheritedRules(JsonNode dslQuery) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Path(value="/units/computedInheritedRules")
    @DELETE
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteComputeInheritedRules(JsonNode dslQuery) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private VitamError getErrorEntity(Response.Status status, String message) {
        String msg = this.getErrorStreamMessage(status, message);
        return new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ACCESS_MODULE).setState(CODE_VITAM).setMessage(msg).setDescription(msg);
    }

    private InputStream getErrorStream(Response.Status status, String message) {
        String msg = this.getErrorStreamMessage(status, message);
        try {
            return JsonHandler.writeToInpustream((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(ACCESS_MODULE).setState(CODE_VITAM).setMessage(status.getReasonPhrase()).setDescription(msg));
        }
        catch (InvalidParseOperationException e) {
            return new ByteArrayInputStream("{ 'message' : 'Invalid VitamError message' }".getBytes());
        }
    }

    private String getErrorStreamMessage(Response.Status status, String message) {
        if (message != null && !message.trim().isEmpty()) {
            return message;
        }
        if (status.getReasonPhrase() != null) {
            return status.getReasonPhrase();
        }
        return status.name();
    }

    private Response buildErrorResponse(VitamCode vitamCode, String description) {
        if (description == null) {
            description = vitamCode.getMessage();
        }
        return Response.status((Response.Status)vitamCode.getStatus()).entity((Object)new RequestResponseError().setError(new VitamError(VitamCodeHelper.getCode((VitamCode)vitamCode)).setContext(vitamCode.getService().getName()).setState(vitamCode.getDomain().getName()).setMessage(vitamCode.getMessage()).setDescription(description)).toString()).build();
    }

    private void resetQuery(JsonNode result, JsonNode queryDsl) {
        if (result != null && result.has("$context")) {
            ((ObjectNode)result).set("$context", queryDsl);
        }
    }

    @GET
    @Path(value="/objects")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getObjects(JsonNode queryDsl) {
        LOGGER.debug(EXECUTION_OF_DSL_VITAM_FROM_ACCESS_ONGOING);
        JsonNode result = null;
        LOGGER.debug("DEBUG: start selectObjects {}", (Object)queryDsl);
        try {
            SanityChecker.checkJsonAll((JsonNode)queryDsl);
            this.checkEmptyQuery(queryDsl);
            result = this.accessModule.selectObjects(AccessContractRestrictionHelper.applyAccessContractRestrictionForObjectGroupForSelect((JsonNode)queryDsl, (AccessContractModel)VitamThreadUtils.getVitamSession().getContract()));
            LOGGER.debug(DEBUG, (Object)result);
            this.resetQuery(result, queryDsl);
            LOGGER.debug(END_OF_EXECUTION_OF_DSL_VITAM_FROM_ACCESS);
        }
        catch (InvalidCreateOperationException | InvalidParseOperationException e) {
            LOGGER.error(BAD_REQUEST_EXCEPTION, e);
            Response.Status status = Response.Status.BAD_REQUEST;
            return Response.status((Response.Status)status).entity((Object)this.getErrorEntity(status, e.getMessage())).build();
        }
        catch (BadRequestException e) {
            LOGGER.error(EMPTY_QUERY_IS_IMPOSSIBLE, (Throwable)e);
            return this.buildErrorResponse(VitamCode.GLOBAL_EMPTY_QUERY, null);
        }
        catch (Exception ve) {
            LOGGER.error((Throwable)ve);
            Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)new VitamError(status.name()).setHttpCode(status.getStatusCode()).setContext(UNITS).setState(CODE_VITAM).setMessage(ve.getMessage()).setDescription(status.getReasonPhrase())).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    /*
     * Exception decompiling
     */
    @Path(value="/preservation")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response startPreservation(PreservationRequest preservationRequest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Path(value="/deleteGotVersions")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deleteGotVersions(DeleteGotVersionsRequest deleteGotVersionsRequest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

