/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.management.client;

import fr.gouv.vitam.common.client.AbstractMockClient;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.ProcessPause;
import fr.gouv.vitam.common.model.ProcessQuery;
import fr.gouv.vitam.common.model.ProcessState;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.processing.Action;
import fr.gouv.vitam.common.model.processing.ActionDefinition;
import fr.gouv.vitam.common.model.processing.Distribution;
import fr.gouv.vitam.common.model.processing.DistributionKind;
import fr.gouv.vitam.common.model.processing.IOParameter;
import fr.gouv.vitam.common.model.processing.ProcessBehavior;
import fr.gouv.vitam.common.model.processing.ProcessDetail;
import fr.gouv.vitam.common.model.processing.ProcessingUri;
import fr.gouv.vitam.common.model.processing.Step;
import fr.gouv.vitam.common.model.processing.WorkFlow;
import fr.gouv.vitam.processing.common.ProcessingEntry;
import fr.gouv.vitam.processing.common.model.WorkerBean;
import fr.gouv.vitam.processing.management.client.ProcessingManagementClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.core.Response;

public class ProcessingManagementClientMock
extends AbstractMockClient
implements ProcessingManagementClient {
    private static final String FAKE_EXECUTION_STATUS = "Fake";

    ProcessingManagementClientMock() {
    }

    @Override
    public ItemStatus getOperationProcessStatus(String id) {
        ArrayList<Integer> status = new ArrayList<Integer>();
        status.add(0);
        status.add(0);
        status.add(1);
        status.add(0);
        status.add(0);
        status.add(0);
        return new ItemStatus("FakeId", "FakeMessage", StatusCode.OK, status, Collections.emptyMap(), null, null);
    }

    @Override
    public RequestResponse<ItemStatus> getOperationProcessExecutionDetails(String id) {
        ArrayList<Integer> status = new ArrayList<Integer>();
        status.add(0);
        status.add(0);
        status.add(1);
        status.add(0);
        status.add(0);
        status.add(0);
        ItemStatus itemStatus = new ItemStatus("FakeId", "FakeMessage", StatusCode.OK, status, Collections.emptyMap(), null, null);
        return new RequestResponseOK().addResult((Object)itemStatus).setHttpCode(StatusCode.OK.getEquivalentHttpStatus().getStatusCode());
    }

    @Override
    public RequestResponse<ItemStatus> cancelOperationProcessExecution(String id) {
        ArrayList<Integer> status = new ArrayList<Integer>();
        status.add(0);
        status.add(0);
        status.add(1);
        status.add(0);
        status.add(0);
        status.add(0);
        ItemStatus itemStatus = new ItemStatus("FakeId", "FakeMessage", StatusCode.OK, status, Collections.emptyMap(), null, null);
        return new RequestResponseOK().addResult((Object)itemStatus);
    }

    @Override
    public RequestResponse<ItemStatus> updateOperationActionProcess(String actionId, String operationId) {
        return new RequestResponseOK();
    }

    @Override
    public RequestResponse<ItemStatus> executeOperationProcess(String operationId, String workflow, String actionId) {
        return new RequestResponseOK().addHeader("X-Global-Execution-State", FAKE_EXECUTION_STATUS);
    }

    @Override
    public void registerWorker(String familyId, String workerId, WorkerBean workerDescription) {
    }

    @Override
    public void unregisterWorker(String familyId, String workerId) {
    }

    @Override
    public void initVitamProcess(String container, String workflowId) {
    }

    @Override
    public RequestResponse<ProcessDetail> listOperationsDetails(ProcessQuery query) {
        ProcessDetail pw = new ProcessDetail();
        pw.setOperationId(GUIDFactory.newOperationLogbookGUID((int)0).toString());
        pw.setGlobalState(ProcessState.RUNNING.toString());
        pw.setStepStatus(StatusCode.STARTED.toString());
        return new RequestResponseOK().addResult((Object)pw);
    }

    @Override
    public RequestResponse<WorkFlow> getWorkflowDefinitions() {
        ArrayList<WorkFlow> workflowDefinitions = new ArrayList<WorkFlow>();
        WorkFlow workflow = new WorkFlow();
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.getAction("CHECK_DIGEST", ProcessBehavior.BLOCKING, new ArrayList<IOParameter>(Arrays.asList(new IOParameter().setName("algo").setUri(new ProcessingUri("VALUE", "SHA-512")))), null));
        actions.add(this.getAction("OG_OBJECTS_FORMAT_CHECK", ProcessBehavior.BLOCKING, null, null));
        ArrayList<Step> steps = new ArrayList<Step>();
        steps.add(new Step().setWorkerGroupId("DefaultWorker").setStepName("STP_OG_CHECK_AND_TRANSFORME").setBehavior(ProcessBehavior.BLOCKING).setDistribution(new Distribution().setKind(DistributionKind.LIST_ORDERING_IN_FILE).setElement("ObjectGroup")).setActions(actions));
        workflow.setId("DefaultIngestWorkflow");
        workflow.setIdentifier("PROCESS_SIP_UNITARY");
        workflow.setName("Default Ingest Workflow");
        workflow.setTypeProc("INGEST");
        workflow.setComment("DefaultIngestWorkflow comment");
        workflow.setSteps(steps);
        workflowDefinitions.add(workflow);
        return new RequestResponseOK().addResult(workflowDefinitions).setHttpCode(Response.Status.OK.getStatusCode());
    }

    @Override
    public Optional<WorkFlow> getWorkflowDetails(String WorkflowIdentifier) {
        throw new IllegalStateException("Method getWorkflowDetails not implemented");
    }

    @Override
    public void initVitamProcess(ProcessingEntry entry) {
    }

    private Action getAction(String actionKey, ProcessBehavior actionBehavior, List<IOParameter> in, List<IOParameter> out) {
        ActionDefinition actionDefinition = new ActionDefinition();
        actionDefinition.setActionKey(actionKey);
        actionDefinition.setBehavior(actionBehavior);
        actionDefinition.setIn(in);
        actionDefinition.setOut(out);
        return new Action().setActionDefinition(actionDefinition);
    }

    @Override
    public RequestResponse<ProcessPause> forcePause(ProcessPause info) {
        return new RequestResponseOK().addResult((Object)info).setHttpCode(Response.Status.OK.getStatusCode());
    }

    @Override
    public RequestResponse<ProcessPause> removeForcePause(ProcessPause info) {
        return new RequestResponseOK().addResult((Object)info).setHttpCode(Response.Status.OK.getStatusCode());
    }
}

