/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.storagetraceability;

import fr.gouv.vitam.common.accesslog.AccessLogUtils;
import fr.gouv.vitam.storage.engine.common.exception.StorageException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.OfferLog;
import fr.gouv.vitam.storage.engine.common.model.Order;
import fr.gouv.vitam.storage.engine.server.distribution.StorageDistribution;
import fr.gouv.vitam.storage.engine.server.storagetraceability.OfferLogIterator;
import java.util.Iterator;
import javax.ws.rs.core.Response;

public class TraceabilityStorageService {
    private static final Integer GET_LAST_BASE = 100;
    public static final String TRACEABILITY_ORIGIN = "traceability";
    private final StorageDistribution distribution;

    public TraceabilityStorageService(StorageDistribution distribution) {
        this.distribution = distribution;
    }

    public Iterator<OfferLog> getLastSavedStorageLogIterator(String strategyId) {
        return new OfferLogIterator(strategyId, Order.DESC, DataCategory.STORAGELOG, this.distribution, GET_LAST_BASE);
    }

    public String getLastTraceabilityZip(String strategyId) {
        OfferLogIterator offerLogIterator = new OfferLogIterator(strategyId, Order.DESC, DataCategory.STORAGETRACEABILITY, this.distribution, 1);
        if (!offerLogIterator.hasNext()) {
            return null;
        }
        return ((OfferLog)offerLogIterator.next()).getFileName();
    }

    public Response getObject(String strategyId, String objectId, DataCategory category) throws StorageException {
        return this.distribution.getContainerByCategory(strategyId, TRACEABILITY_ORIGIN, objectId, category, AccessLogUtils.getNoLogAccessLog());
    }
}

