/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.storagetraceability;

import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.iterables.BulkBufferingEntryIterator;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.storage.engine.common.exception.StorageException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.OfferLog;
import fr.gouv.vitam.storage.engine.common.model.Order;
import fr.gouv.vitam.storage.engine.server.distribution.StorageDistribution;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class OfferLogIterator
extends BulkBufferingEntryIterator<OfferLog> {
    private final String strategyId;
    private final StorageDistribution distribution;
    private final Order order;
    private final DataCategory dataCategory;
    private final int chunkSize;
    private Long lastOffset;

    public OfferLogIterator(String strategyId, Order order, DataCategory dataCategory, StorageDistribution distribution, int chunkSize) {
        super(chunkSize);
        this.strategyId = strategyId;
        this.order = order;
        this.dataCategory = dataCategory;
        this.distribution = distribution;
        this.chunkSize = chunkSize;
        this.lastOffset = null;
    }

    protected List<OfferLog> loadNextChunk(int chunkSize) {
        try {
            RequestResponse<OfferLog> response = this.distribution.getOfferLogs(this.strategyId, this.dataCategory, this.lastOffset, this.chunkSize, this.order);
            if (!response.isOk()) {
                throw new VitamRuntimeException("Could not list offer log");
            }
            List buffer = ((RequestResponseOK)response).getResults();
            if (CollectionUtils.isNotEmpty((Collection)buffer)) {
                switch (this.order) {
                    case ASC: {
                        this.lastOffset = ((OfferLog)buffer.get(buffer.size() - 1)).getSequence() + 1L;
                        break;
                    }
                    case DESC: {
                        this.lastOffset = ((OfferLog)buffer.get(buffer.size() - 1)).getSequence() - 1L;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid order " + this.order);
                    }
                }
            }
            return buffer;
        }
        catch (StorageException e) {
            throw new VitamRuntimeException((Throwable)e);
        }
    }
}

