/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.storagetraceability;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import fr.gouv.vitam.common.CommonMediaType;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.alert.AlertServiceImpl;
import fr.gouv.vitam.common.digest.Digest;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.json.CanonicalJsonFormatter;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogLevel;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.security.merkletree.MerkleTreeAlgo;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.logbook.common.exception.LogbookClientAlreadyExistsException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.common.exception.TraceabilityException;
import fr.gouv.vitam.logbook.common.model.TraceabilityEvent;
import fr.gouv.vitam.logbook.common.model.TraceabilityFile;
import fr.gouv.vitam.logbook.common.model.TraceabilityStatistics;
import fr.gouv.vitam.logbook.common.model.TraceabilityType;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationsClientHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.common.traceability.LogbookTraceabilityHelper;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.storage.engine.common.exception.StorageException;
import fr.gouv.vitam.storage.engine.common.exception.StorageNotFoundException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.OfferLog;
import fr.gouv.vitam.storage.engine.common.model.request.ObjectDescription;
import fr.gouv.vitam.storage.engine.server.distribution.StorageDistribution;
import fr.gouv.vitam.storage.engine.server.storagetraceability.StorageFileNameHelper;
import fr.gouv.vitam.storage.engine.server.storagetraceability.StorageTraceabilityData;
import fr.gouv.vitam.storage.engine.server.storagetraceability.TraceabilityStorageService;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.common.compress.VitamArchiveStreamFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.Iterator;
import javax.ws.rs.core.Response;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.io.IOUtils;

public class LogbookStorageTraceabilityHelper
implements LogbookTraceabilityHelper {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(LogbookStorageTraceabilityHelper.class);
    private static final AlertService alertService = new AlertServiceImpl();
    private static final String STORAGE_SECURISATION_STORAGE = "STORAGE_SECURISATION_STORAGE";
    public static final String STP_STORAGE_SECURISATION = "STP_STORAGE_SECURISATION";
    private static final String TIMESTAMP = "STORAGE_SECURISATION_TIMESTAMP";
    private static final String ZIP_NAME = "StorageTraceability";
    private final LogbookOperationsClient logbookOperationsClient;
    private final TraceabilityStorageService traceabilityLogbookService;
    private final WorkspaceClient workspaceClient;
    private final StorageDistribution distribution;
    private final GUID operationID;
    private final int delay;
    private StorageTraceabilityData lastTraceabilityData = null;
    private LocalDateTime traceabilityStartDate;
    private LocalDateTime traceabilityEndDate;
    private int fileCount = 0;
    private Boolean isLastEventInit = false;
    private String previousStartDate = null;
    private byte[] previousTimestampToken = null;

    public LogbookStorageTraceabilityHelper(LogbookOperationsClient logbookOperations, WorkspaceClient workspaceClient, TraceabilityStorageService traceabilityLogbookService, StorageDistribution distribution, GUID operationID, int overlapDelayInSeconds) {
        this.logbookOperationsClient = logbookOperations;
        this.workspaceClient = workspaceClient;
        this.traceabilityLogbookService = traceabilityLogbookService;
        this.distribution = distribution;
        this.operationID = operationID;
        this.delay = overlapDelayInSeconds;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initialize() throws TraceabilityException {
        this.traceabilityEndDate = LocalDateUtil.now();
        String fileName = this.traceabilityLogbookService.getLastTraceabilityZip(VitamConfiguration.getDefaultStrategy());
        if (fileName == null) {
            this.lastTraceabilityData = null;
            this.traceabilityStartDate = INITIAL_START_DATE;
            return;
        }
        Response response = null;
        try {
            response = this.traceabilityLogbookService.getObject(VitamConfiguration.getDefaultStrategy(), fileName, DataCategory.STORAGETRACEABILITY);
            try (InputStream stream = (InputStream)response.readEntity(InputStream.class);
                 ArchiveInputStream archiveInputStream = new VitamArchiveStreamFactory().createArchiveInputStream(CommonMediaType.ZIP_TYPE, stream);){
                ArchiveEntry entry = null;
                while (entry == null || !"token.tsp".equals(entry.getName())) {
                    entry = archiveInputStream.getNextEntry();
                    if (entry != null) continue;
                    throw new TraceabilityException("Can't find token.tsp file in ZIP");
                }
                LocalDateTime date = StorageFileNameHelper.parseDateFromStorageTraceabilityFileName(fileName);
                this.lastTraceabilityData = new StorageTraceabilityData(IOUtils.toByteArray((InputStream)archiveInputStream), date.minusSeconds(this.delay));
                this.traceabilityStartDate = this.lastTraceabilityData.startDate;
            }
        }
        catch (IOException e) {
            try {
                throw new TraceabilityException("Unable to read ZIP", (Throwable)e);
                catch (ArchiveException e2) {
                    throw new TraceabilityException("Unable to create Archive Stream", (Throwable)e2);
                }
                catch (StorageNotFoundException e3) {
                    alertService.createAlert(VitamLogLevel.ERROR, "Traceability ZIP file not found '" + fileName + "'. File may be corrupted OR have been DELETED?");
                    throw new TraceabilityException("Traceability ZIP file not found '" + fileName + "'. File may be corrupted OR have been DELETED?");
                }
                catch (StorageException e4) {
                    throw new TraceabilityException("Unable to get last traceability information", (Throwable)e4);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.consumeAnyEntityAndClose(response);
                throw throwable;
            }
        }
        StreamUtils.consumeAnyEntityAndClose((Response)response);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveDataInZip(MerkleTreeAlgo algo, TraceabilityFile file) throws IOException, TraceabilityException {
        String fileName;
        Iterator<OfferLog> traceabilityIterator = this.traceabilityLogbookService.getLastSavedStorageLogIterator(VitamConfiguration.getDefaultStrategy());
        file.initStoreLog();
        while (traceabilityIterator.hasNext() && !StorageFileNameHelper.parseDateFromStorageLogFileName(fileName = traceabilityIterator.next().getFileName()).isBefore(this.traceabilityStartDate)) {
            Digest digest = new Digest(VitamConfiguration.getDefaultDigestType());
            Response response = null;
            InputStream stream = null;
            try {
                response = this.traceabilityLogbookService.getObject(VitamConfiguration.getDefaultStrategy(), fileName, DataCategory.STORAGELOG);
                stream = (InputStream)response.readEntity(InputStream.class);
                byte[] hash = digest.update(stream).digest();
                ObjectNode fileInfo = JsonHandler.createObjectNode();
                fileInfo.put("FileName", fileName);
                fileInfo.put("Hash", hash);
                byte[] bytes = CanonicalJsonFormatter.serializeToByteArray((JsonNode)fileInfo);
                file.storeLog(bytes);
                algo.addLeaf(bytes);
                ++this.fileCount;
            }
            catch (StorageNotFoundException e) {
                try {
                    alertService.createAlert(VitamLogLevel.ERROR, "Traceability LOG file not found '" + fileName + "'. File may be corrupted OR have been DELETED?");
                    throw new TraceabilityException("Traceability LOG file not found '" + fileName + "'. File may be corrupted OR have been DELETED?", (Throwable)e);
                    catch (StorageException e2) {
                        throw new TraceabilityException("Unable to get the given object " + fileName, (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    StreamUtils.closeSilently(stream);
                    StreamUtils.consumeAnyEntityAndClose((Response)response);
                    throw throwable;
                }
            }
            StreamUtils.closeSilently((InputStream)stream);
            StreamUtils.consumeAnyEntityAndClose((Response)response);
        }
        file.closeStoreLog();
    }

    public String getPreviousStartDate() throws InvalidParseOperationException {
        if (!this.isLastEventInit.booleanValue()) {
            this.extractPreviousEvent();
        }
        return this.previousStartDate;
    }

    public byte[] getPreviousTimestampToken() throws InvalidParseOperationException {
        if (!this.isLastEventInit.booleanValue()) {
            this.extractPreviousEvent();
        }
        return this.previousTimestampToken;
    }

    public String getPreviousMonthStartDate() {
        return null;
    }

    public byte[] getPreviousMonthTimestampToken() {
        return null;
    }

    public String getPreviousYearStartDate() {
        return null;
    }

    public byte[] getPreviousYearTimestampToken() {
        return null;
    }

    public void startTraceability() throws TraceabilityException {
        LogbookOperationParameters logbookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)this.operationID, (String)STP_STORAGE_SECURISATION, (GUID)this.operationID, (LogbookTypeProcess)LogbookTypeProcess.TRACEABILITY, (StatusCode)StatusCode.STARTED, null, null, (GUID)this.operationID);
        LogbookOperationsClientHelper.checkLogbookParameters((LogbookOperationParameters)logbookParameters);
        try {
            this.logbookOperationsClient.create(new LogbookOperationParameters[]{logbookParameters});
        }
        catch (LogbookClientAlreadyExistsException | LogbookClientBadRequestException | LogbookClientServerException e) {
            throw new TraceabilityException("unable to create traceability logbook", e);
        }
        this.initialize();
    }

    public void createLogbookOperationEvent(Integer tenantId, String eventType, StatusCode status, TraceabilityEvent event) throws TraceabilityException {
        GUID eventId = GUIDFactory.newEventGUID((int)tenantId);
        LogbookOperationParameters logbookOperationParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)eventId, (String)eventType, (GUID)this.operationID, (LogbookTypeProcess)LogbookTypeProcess.TRACEABILITY, (StatusCode)status, null, null, (GUID)this.operationID);
        LogbookOperationsClientHelper.checkLogbookParameters((LogbookOperationParameters)logbookOperationParameters);
        if (event != null) {
            String eventData = JsonHandler.unprettyPrint((Object)event);
            logbookOperationParameters.putParameterValue(LogbookParameterName.eventDetailData, eventData);
            ObjectNode masterData = JsonHandler.createObjectNode();
            masterData.put("eventDetailData", eventData);
            logbookOperationParameters.putParameterValue(LogbookParameterName.masterData, JsonHandler.unprettyPrint((Object)masterData));
        }
        try {
            this.logbookOperationsClient.update(new LogbookOperationParameters[]{logbookOperationParameters});
        }
        catch (LogbookClientBadRequestException | LogbookClientNotFoundException | LogbookClientServerException e) {
            throw new TraceabilityException("unable to update traceability logbook", e);
        }
    }

    public void saveEmpty(Integer tenantId) throws TraceabilityException {
        this.createLogbookOperationEvent(tenantId, STP_STORAGE_SECURISATION, StatusCode.WARNING, null);
    }

    public void storeAndDeleteZip(Integer tenant, String strategyId, File zipFile, String fileName, TraceabilityEvent event) throws TraceabilityException {
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(zipFile));){
            String containerName = VitamThreadUtils.getVitamSession().getRequestId();
            this.workspaceClient.createContainer(containerName);
            this.workspaceClient.putObject(containerName, fileName, (InputStream)inputStream);
            ObjectDescription description = new ObjectDescription();
            description.setWorkspaceContainerGUID(containerName);
            description.setWorkspaceObjectURI(fileName);
            try {
                this.distribution.storeDataInAllOffers(strategyId, fileName, description, DataCategory.STORAGETRACEABILITY, null);
                this.workspaceClient.deleteContainer(containerName, true);
                this.createLogbookOperationEvent(tenant, STORAGE_SECURISATION_STORAGE, StatusCode.OK, event);
            }
            catch (StorageException | ContentAddressableStorageNotFoundException e) {
                LOGGER.error("unable to store zip file", e);
                this.createLogbookOperationEvent(tenant, STORAGE_SECURISATION_STORAGE, StatusCode.FATAL, event);
                throw new TraceabilityException(e);
            }
        }
        catch (ContentAddressableStorageServerException | IOException e) {
            LOGGER.error("unable to create container", e);
            this.createLogbookOperationEvent(tenant, STORAGE_SECURISATION_STORAGE, StatusCode.FATAL, event);
            throw new TraceabilityException(e);
        }
        finally {
            if (!zipFile.delete()) {
                LOGGER.error("Unable to delete zipFile");
            }
        }
    }

    public String getStepName() {
        return STP_STORAGE_SECURISATION;
    }

    public String getTimestampStepName() {
        return TIMESTAMP;
    }

    public String getZipName() {
        return "StorageTraceability_" + this.operationID.getId();
    }

    public TraceabilityType getTraceabilityType() {
        return TraceabilityType.STORAGE;
    }

    public boolean getMaxEntriesReached() {
        return false;
    }

    public TraceabilityStatistics getTraceabilityStatistics() {
        return null;
    }

    public long getDataSize() {
        return this.fileCount;
    }

    public String getTraceabilityStartDate() {
        return LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)this.traceabilityStartDate);
    }

    public String getTraceabilityEndDate() {
        return LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)this.traceabilityEndDate);
    }

    private void extractPreviousEvent() {
        if (this.lastTraceabilityData != null) {
            this.previousTimestampToken = this.lastTraceabilityData.token;
            this.previousStartDate = LocalDateUtil.getFormattedDateTimeForMongo((LocalDateTime)this.lastTraceabilityData.startDate);
        }
        this.isLastEventInit = true;
    }
}

