/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.storagelog.parameters;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.storage.engine.server.storagelog.parameters.StorageLogStructure;
import fr.gouv.vitam.storage.engine.server.storagelog.parameters.StorageLogbookOutcome;
import fr.gouv.vitam.storage.engine.server.storagelog.parameters.StorageLogbookParameterName;
import fr.gouv.vitam.storage.engine.server.storagelog.parameters.StorageLogbookParametersSerializer;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

@JsonSerialize(using=StorageLogbookParametersSerializer.class)
public class StorageLogbookParameters
implements StorageLogStructure {
    private static final String MANDATORY_PARAMETER_CAN_NOT_BE_NULL_OR_EMPTY = "Mandatory parameters can not be null or empty";
    private static final Set<StorageLogbookParameterName> mandatoryParametersForCreate = new HashSet<StorageLogbookParameterName>(Arrays.asList(StorageLogbookParameterName.objectIdentifier, StorageLogbookParameterName.digest, StorageLogbookParameterName.digestAlgorithm, StorageLogbookParameterName.size, StorageLogbookParameterName.agentIdentifiers, StorageLogbookParameterName.dataCategory, StorageLogbookParameterName.eventType, StorageLogbookParameterName.outcome));
    private static final Set<StorageLogbookParameterName> mandatoryParametersForDelete = new HashSet<StorageLogbookParameterName>(Arrays.asList(StorageLogbookParameterName.objectIdentifier, StorageLogbookParameterName.agentIdentifiers, StorageLogbookParameterName.dataCategory, StorageLogbookParameterName.eventType, StorageLogbookParameterName.outcome));
    @JsonIgnore
    private final Map<StorageLogbookParameterName, String> mapParameters = new TreeMap<StorageLogbookParameterName, String>();

    private StorageLogbookParameters(Map<StorageLogbookParameterName, String> mapParameters) {
        this.mapParameters.putAll(mapParameters);
    }

    public static StorageLogbookParameters createLogParameters(String objectIdentifier, String dataCategory, String digest, String digestAlgorithm, String size, String agentIdentifiers, String agentIdentifierRequester, StorageLogbookOutcome outcome) {
        TreeMap<StorageLogbookParameterName, String> mandatoryParameters = new TreeMap<StorageLogbookParameterName, String>();
        mandatoryParameters.put(StorageLogbookParameterName.eventDateTime, LocalDateUtil.nowFormatted());
        mandatoryParameters.put(StorageLogbookParameterName.outcome, outcome.name());
        mandatoryParameters.put(StorageLogbookParameterName.objectIdentifier, objectIdentifier);
        mandatoryParameters.put(StorageLogbookParameterName.dataCategory, dataCategory);
        mandatoryParameters.put(StorageLogbookParameterName.objectGroupIdentifier, "objGId NA");
        mandatoryParameters.put(StorageLogbookParameterName.digest, digest);
        mandatoryParameters.put(StorageLogbookParameterName.digestAlgorithm, digestAlgorithm);
        mandatoryParameters.put(StorageLogbookParameterName.size, size);
        mandatoryParameters.put(StorageLogbookParameterName.eventType, "CREATE");
        mandatoryParameters.put(StorageLogbookParameterName.xRequestId, VitamThreadUtils.getVitamSession().getRequestId());
        mandatoryParameters.put(StorageLogbookParameterName.agentIdentifiers, agentIdentifiers);
        mandatoryParameters.put(StorageLogbookParameterName.tenantId, ParameterHelper.getTenantParameter().toString());
        mandatoryParameters.put(StorageLogbookParameterName.agentIdentifierRequester, agentIdentifierRequester);
        return StorageLogbookParameters.buildCreateLogParameters(mandatoryParameters);
    }

    static StorageLogbookParameters buildCreateLogParameters(Map<StorageLogbookParameterName, String> mapParameters) {
        StorageLogbookParameters.checkMandatoryParameters(mapParameters, mandatoryParametersForCreate);
        return new StorageLogbookParameters(mapParameters);
    }

    public static StorageLogbookParameters buildDeleteLogParameters(Map<StorageLogbookParameterName, String> mapParameters) {
        StorageLogbookParameters.checkMandatoryParameters(mapParameters, mandatoryParametersForDelete);
        return new StorageLogbookParameters(mapParameters);
    }

    @JsonIgnore
    public LocalDateTime getEventDateTime() {
        String date = this.mapParameters.get((Object)StorageLogbookParameterName.eventDateTime);
        return LocalDateUtil.parseMongoFormattedDate((String)date);
    }

    @JsonIgnore
    public StorageLogbookParameters setStatus(StorageLogbookOutcome outcome) {
        this.mapParameters.put(StorageLogbookParameterName.outcome, outcome.name());
        return this;
    }

    @JsonIgnore
    public StorageLogbookOutcome getStatus() {
        String status = this.mapParameters.get((Object)StorageLogbookParameterName.outcome);
        return StorageLogbookOutcome.valueOf(status);
    }

    private static void checkMandatoryParameters(Map<StorageLogbookParameterName, String> mapParameters, Set<StorageLogbookParameterName> mandatoryParameters) throws IllegalArgumentException {
        for (StorageLogbookParameterName s : mandatoryParameters) {
            ParametersChecker.checkParameter((String)MANDATORY_PARAMETER_CAN_NOT_BE_NULL_OR_EMPTY, (String[])new String[]{mapParameters.get((Object)s)});
        }
    }

    @Override
    @JsonIgnore
    public Map<StorageLogbookParameterName, String> getMapParameters() {
        return this.mapParameters;
    }
}

