/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.storagelog;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.alert.AlertServiceImpl;
import fr.gouv.vitam.storage.engine.server.rest.StorageConfiguration;
import fr.gouv.vitam.storage.engine.server.storagelog.ReadOnlyStorageLog;
import fr.gouv.vitam.storage.engine.server.storagelog.StorageLog;
import fr.gouv.vitam.storage.engine.server.storagelog.StorageLogService;
import java.io.IOException;
import java.nio.file.Paths;

public final class StorageLogFactory {
    private static StorageLog instance;

    public static synchronized StorageLog getInstance(StorageConfiguration storageConfiguration) throws IOException {
        if (storageConfiguration.isReadOnly().booleanValue()) {
            return new ReadOnlyStorageLog((AlertService)new AlertServiceImpl());
        }
        if (instance == null) {
            instance = new StorageLogService(VitamConfiguration.getTenants(), Paths.get(storageConfiguration.getLoggingDirectory(), new String[0]));
        }
        return instance;
    }

    @VisibleForTesting
    public static synchronized void resetForTesting() {
        instance = null;
    }
}

