/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.storagelog;

import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.VitamAutoCloseable;
import fr.gouv.vitam.storage.engine.server.storagelog.parameters.StorageLogStructure;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class StorageLogAppender
implements VitamAutoCloseable {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(StorageLogAppender.class);
    private final Writer writer;
    private final String lineSeparator = "\n";

    public StorageLogAppender(Path filePath) throws IOException {
        OutputStream outputStream = this.openStream(filePath);
        this.writer = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
    }

    private OutputStream openStream(Path path) throws IOException {
        try {
            return Files.newOutputStream(path, StandardOpenOption.CREATE_NEW, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            throw new IOException(String.format("Cannot open storage log file %s", path.toFile().getAbsolutePath()), e);
        }
    }

    public void append(StorageLogStructure parameters) throws IOException {
        this.writer.append(JsonHandler.unprettyPrint(parameters.getMapParameters()));
        this.writer.append("\n");
        this.writer.flush();
    }

    public void close() {
        try {
            if (this.writer != null) {
                this.writer.flush();
                this.writer.close();
            }
        }
        catch (IOException ex) {
            LOGGER.warn("Could not close stream", (Throwable)ex);
        }
    }
}

