/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.spi.mapper;

import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.logging.SysErrLogger;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.storage.engine.common.exception.StorageDriverMapperException;
import fr.gouv.vitam.storage.engine.server.spi.mapper.DriverMapper;
import fr.gouv.vitam.storage.engine.server.spi.mapper.FileDriverMapperConfiguration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class FileDriverMapper
implements DriverMapper {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(FileDriverMapper.class);
    private static final String DRIVER_MAPPING_CONF_FILE = "driver-mapping.conf";
    private static FileDriverMapperConfiguration configuration;
    private static final FileDriverMapper INSTANCE;

    private FileDriverMapper() {
        try {
            configuration = (FileDriverMapperConfiguration)PropertiesUtils.readYaml((File)PropertiesUtils.findFile((String)DRIVER_MAPPING_CONF_FILE), FileDriverMapperConfiguration.class);
        }
        catch (IOException exc) {
            LOGGER.error(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_DRIVER_MAPPING_INITIALIZE, (Object[])new Object[0]), (Throwable)exc);
        }
    }

    public static FileDriverMapper getInstance() throws StorageDriverMapperException {
        if (configuration == null) {
            throw new StorageDriverMapperException(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_DRIVER_MAPPING_INITIALIZE, (Object[])new Object[0]));
        }
        return INSTANCE;
    }

    @Override
    public List<String> getOffersFor(String driverName) throws StorageDriverMapperException {
        try {
            return this.getOfferIdsFrom(this.getDriverFile(driverName));
        }
        catch (FileNotFoundException exc) {
            SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)exc);
            LOGGER.warn("Configuration file not found for {}, then return empty list", (Object)driverName);
            return new ArrayList<String>();
        }
        catch (IOException exc) {
            String log = VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_DRIVER_MAPPER_FILE_CONTENT, (Object[])new Object[]{driverName});
            LOGGER.error(log);
            throw new StorageDriverMapperException(log, (Throwable)exc);
        }
    }

    @Override
    public void addOfferTo(String offerId, String driverName) throws StorageDriverMapperException {
        List<String> offerIds = this.getOfferIdsList(driverName);
        offerIds = this.addOfferTo(offerId, offerIds);
        this.persistDriverMapping(driverName, offerIds);
    }

    @Override
    public void addOffersTo(List<String> offersIdsToAdd, String driverName) throws StorageDriverMapperException {
        List<String> offerIds = this.getOfferIdsList(driverName);
        for (String offerIdToAdd : offersIdsToAdd) {
            offerIds = this.addOfferTo(offerIdToAdd, offerIds);
        }
        this.persistDriverMapping(driverName, offerIds);
    }

    @Override
    public void removeOfferTo(String offerId, String driverName) throws StorageDriverMapperException {
        List<String> offerIds = this.getOfferIdsList(driverName);
        offerIds = this.removeOfferTo(offerId, offerIds);
        this.persistDriverMapping(driverName, offerIds);
    }

    @Override
    public void removeOffersTo(List<String> offersIdsToRemove, String driverName) throws StorageDriverMapperException {
        List<String> offerIds = this.getOfferIdsList(driverName);
        for (String offerIdToRemove : offersIdsToRemove) {
            offerIds = this.removeOfferTo(offerIdToRemove, offerIds);
        }
        this.persistDriverMapping(driverName, offerIds);
    }

    private File getDriverFile(String driverName) throws FileNotFoundException {
        return PropertiesUtils.findFile((String)(configuration.getDriverMappingPath() + driverName));
    }

    private List<String> getOfferIdsFrom(File fileDriverMapping) throws IOException {
        String content = com.google.common.io.Files.readFirstLine((File)fileDriverMapping, (Charset)Charset.defaultCharset());
        return content == null ? new ArrayList<String>() : Pattern.compile(configuration.getDelimiter()).splitAsStream(content).collect(Collectors.toList());
    }

    private List<String> addOfferTo(String offerId, List<String> offerMapping) {
        int index = offerMapping.indexOf(offerId);
        if (index >= 0) {
            LOGGER.warn("Offer ID {} already associated to the driver !", (Object)offerId);
        } else {
            offerMapping.add(offerId);
        }
        return offerMapping;
    }

    private List<String> removeOfferTo(String offerId, List<String> offerMapping) {
        int index = offerMapping.indexOf(offerId);
        if (index >= 0) {
            offerMapping.remove(index);
        } else {
            LOGGER.warn("Offer ID {} not found ! Cannot remove it in mapping configuration", (Object)offerId);
        }
        return offerMapping;
    }

    private String getContentFrom(List<String> offerIds) {
        return offerIds.stream().collect(Collectors.joining(";"));
    }

    private List<String> getOfferIdsList(String driverName) throws StorageDriverMapperException {
        List<String> offerIds = null;
        try {
            offerIds = this.getOfferIdsFrom(this.getDriverFile(driverName));
        }
        catch (FileNotFoundException exc) {
            SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)exc);
            LOGGER.warn("Configuration file not found for {}, then return empty list", (Object)driverName);
        }
        catch (IOException exc) {
            String log = VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_DRIVER_MAPPER_FILE_CONTENT, (Object[])new Object[]{driverName});
            LOGGER.error(log);
            throw new StorageDriverMapperException(log, (Throwable)exc);
        }
        if (offerIds == null) {
            offerIds = new ArrayList<String>();
        }
        return offerIds;
    }

    private void persistDriverMapping(String driverName, List<String> offerIds) throws StorageDriverMapperException {
        try {
            Files.write(Paths.get(configuration.getDriverMappingPath() + driverName, new String[0]), this.getContentFrom(offerIds).getBytes(), new OpenOption[0]);
        }
        catch (IOException exc) {
            String log = VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_DRIVER_MAPPING_SAVE, (Object[])new Object[]{driverName});
            LOGGER.error(log + " File: " + Paths.get(configuration.getDriverMappingPath() + driverName, new String[0]).toAbsolutePath());
            throw new StorageDriverMapperException(log, (Throwable)exc);
        }
    }

    static {
        INSTANCE = new FileDriverMapper();
    }
}

