/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.spi;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.storage.driver.Driver;
import fr.gouv.vitam.storage.engine.common.exception.StorageDriverMapperException;
import fr.gouv.vitam.storage.engine.common.exception.StorageDriverNotFoundException;
import fr.gouv.vitam.storage.engine.common.exception.StorageException;
import fr.gouv.vitam.storage.engine.common.referential.StorageOfferProviderFactory;
import fr.gouv.vitam.storage.engine.common.referential.model.StorageOffer;
import fr.gouv.vitam.storage.engine.server.spi.DriverManagerConfiguration;
import fr.gouv.vitam.storage.engine.server.spi.mapper.DriverMapper;
import fr.gouv.vitam.storage.engine.server.spi.mapper.FileDriverMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;

public class DriverManager {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(DriverManager.class);
    private static final Map<String, Driver> drivers = new ConcurrentHashMap<String, Driver>();
    private static final String DRIVER_MANAGER_CONF_FILE = "driver-location.conf";
    private static Optional<DriverMapper> mapper;

    private static void loadOffersIdsFor(Driver driver) {
        if (mapper.isPresent()) {
            try {
                List<String> offersIds = mapper.get().getOffersFor(driver.getClass().getName());
                for (String offerId : offersIds) {
                    StorageOffer offer = StorageOfferProviderFactory.getDefaultProvider().getStorageOffer(offerId, true);
                    if (offer.isEnabled()) {
                        Properties parameters = new Properties();
                        parameters.putAll((Map<?, ?>)offer.getParameters());
                        driver.addOffer(offer, parameters);
                        continue;
                    }
                    LOGGER.warn("Disabled Offer %s will not be add to driver's offer %s", (Object)offerId, (Object)driver.getName());
                }
            }
            catch (StorageException exc) {
                LOGGER.warn("The driver mapper failed to load offers IDs for driver name {}", (Object)driver.getClass().getName(), (Object)exc);
            }
        }
    }

    private static void addOffersToDriver(Driver driver, List<String> offersIds) throws StorageDriverMapperException {
        ParametersChecker.checkParameter((String)"Offers id list cannot be null", (Object[])new Object[]{offersIds});
        for (String offerId : offersIds) {
            boolean done;
            try {
                StorageOffer offer = StorageOfferProviderFactory.getDefaultProvider().getStorageOffer(offerId, true);
                Properties parameters = new Properties();
                parameters.putAll((Map<?, ?>)offer.getParameters());
                done = driver.addOffer(offer, parameters);
            }
            catch (StorageException e) {
                LOGGER.error((Throwable)e);
                throw new StorageDriverMapperException((Throwable)e);
            }
            if (done) continue;
            LOGGER.warn("Cannot append to the driver {} with name {} the offer ID {}, offer already define", new Object[]{driver, driver.getClass().getName(), offerId});
        }
        DriverManager.persistAddOffers(offersIds, driver.getClass().getName());
    }

    public static Driver addDriver(Driver driver) {
        if (null == driver) {
            throw new IllegalArgumentException("Driver parameter mustn't be null");
        }
        if (drivers.containsKey(driver.getClass().getName())) {
            throw new IllegalArgumentException("Driver already exists");
        }
        return drivers.put(driver.getClass().getName(), driver);
    }

    private static URLClassLoader getUrlClassLoader() {
        File conf = null;
        try {
            conf = PropertiesUtils.findFile((String)DRIVER_MANAGER_CONF_FILE);
        }
        catch (FileNotFoundException exc) {
            LOGGER.warn("Not configuration file found. Only use standard class loader (systemClassLoader)", (Throwable)exc);
        }
        URLClassLoader ucl = null;
        if (conf != null) {
            File dir;
            File[] fDir;
            DriverManagerConfiguration configuration = null;
            try {
                configuration = (DriverManagerConfiguration)PropertiesUtils.readYaml((File)conf, DriverManagerConfiguration.class);
            }
            catch (IOException exc) {
                LOGGER.warn("cannot read configuration file for storage driver. Only use standard class loader (systemClassLoader)", (Throwable)exc);
            }
            if (configuration != null && (fDir = (dir = new File(configuration.getDriverLocation())).listFiles(file -> file.getPath().toLowerCase().endsWith(".jar"))) != null) {
                URL[] urls = new URL[fDir.length];
                for (int i = 0; i < fDir.length; ++i) {
                    try {
                        urls[i] = fDir[i].toURI().toURL();
                        continue;
                    }
                    catch (MalformedURLException exc) {
                        LOGGER.warn("Class loader error for {}, driver not loaded", (Object)fDir[i].getName());
                    }
                }
                ucl = new URLClassLoader(urls);
            }
        }
        return ucl;
    }

    private DriverManager() {
    }

    public static void changeDriverMapper(DriverMapper newMapper) {
        ParametersChecker.checkParameter((String)"The mapper cannot be null", (Object[])new Object[]{newMapper});
        mapper = Optional.of(newMapper);
    }

    public static void addOfferToDriver(String name, String offerId) throws StorageDriverMapperException {
        Driver selectedDriver = null;
        for (String driverName : drivers.keySet()) {
            Driver driver = drivers.get(driverName);
            if (driver.hasOffer(offerId) && !driverName.equals(name)) {
                throw new StorageDriverMapperException("The offer " + offerId + " already attached to the driver " + driverName + " => can't attach offer to the driver " + name);
            }
            if (!driverName.equals(name)) continue;
            selectedDriver = driver;
        }
        if (null != selectedDriver) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(offerId);
            DriverManager.addOffersToDriver(selectedDriver, list);
        }
    }

    public static void addOffersToDriver(String name, List<String> offerIds) throws StorageDriverMapperException {
        for (String driverName : drivers.keySet()) {
            Driver driver = drivers.get(driverName);
            for (String s : offerIds) {
                if (!driver.hasOffer(s) || driverName.equals(name)) continue;
                throw new StorageDriverMapperException("The offer " + s + " already attached to the driver " + driverName + " => can't attach offer to the driver " + name);
            }
            if (!driverName.equals(name)) continue;
            DriverManager.addOffersToDriver(driver, offerIds);
            break;
        }
    }

    public static void removeOffer(String offerId) throws StorageDriverMapperException, StorageDriverNotFoundException {
        Driver driver = DriverManager.getDriverFor(offerId);
        if (driver.removeOffer(offerId)) {
            ArrayList<String> offersIds = new ArrayList<String>();
            offersIds.add(offerId);
            DriverManager.persistRemoveOffers(offersIds, driver.getClass().getName());
        } else {
            LOGGER.warn("Cannot remove no suitable driver associated to the offer ID {}", (Object)offerId);
        }
    }

    public static Driver getDriverFor(String offerId) throws StorageDriverNotFoundException {
        for (String driverName : drivers.keySet()) {
            Driver driver = drivers.get(driverName);
            if (!driver.hasOffer(offerId)) continue;
            return driver;
        }
        LOGGER.error("No suitable driver for offer ID : " + offerId);
        throw new StorageDriverNotFoundException("No suitable driver for offer ID : " + offerId);
    }

    private static void persistAddOffers(List<String> offersIds, String driverName) throws StorageDriverMapperException {
        if (mapper.isPresent()) {
            mapper.get().addOffersTo(offersIds, driverName);
        }
    }

    private static void persistRemoveOffers(List<String> offersIds, String driverName) throws StorageDriverMapperException {
        if (mapper.isPresent()) {
            mapper.get().removeOffersTo(offersIds, driverName);
        }
    }

    static {
        try {
            mapper = Optional.ofNullable(FileDriverMapper.getInstance());
        }
        catch (StorageDriverMapperException exc) {
            LOGGER.warn("The driver mapper is not initialize. Association driver and offer will not be load and modification will not be save. Change the mapper.");
        }
        URLClassLoader ucl = DriverManager.getUrlClassLoader();
        ServiceLoader<Driver> loadedDrivers = ucl != null ? ServiceLoader.load(Driver.class, ucl) : ServiceLoader.load(Driver.class);
        for (Driver driver : loadedDrivers) {
            DriverManager.addDriver(driver);
            DriverManager.loadOffersIdsFor(driver);
        }
    }
}

