/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.rest.writeprotection;

import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.server.application.resources.AdminStatusResource;
import fr.gouv.vitam.common.server.application.resources.ApplicationStatusResource;
import fr.gouv.vitam.storage.engine.server.rest.writeprotection.WriteProtection;
import fr.gouv.vitam.storage.engine.server.rest.writeprotection.WriteProtectionForbiddenFilter;
import javax.annotation.Priority;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;

@PreMatching
@Priority(value=3000)
public class WriteProtectionScanner
implements DynamicFeature {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(WriteProtectionScanner.class);
    private final AlertService alertService;
    private final boolean isReadOnly;

    public WriteProtectionScanner(AlertService alertService, boolean isReadOnly) {
        this.alertService = alertService;
        this.isReadOnly = isReadOnly;
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        LOGGER.debug("Scanning resource method " + resourceInfo.getResourceClass().getName() + " . " + resourceInfo.getResourceMethod().getName());
        if (resourceInfo.getResourceMethod().getDeclaringClass() == ApplicationStatusResource.class || resourceInfo.getResourceMethod().getDeclaringClass() == AdminStatusResource.class) {
            LOGGER.debug("Ignore write protection for " + resourceInfo.getResourceClass().getName() + "." + resourceInfo.getResourceMethod().getName());
            return;
        }
        WriteProtection writeProtection = resourceInfo.getResourceMethod().getAnnotation(WriteProtection.class);
        if (writeProtection == null) {
            throw new IllegalStateException("Missing @" + WriteProtection.class.getName() + " annotation for method " + resourceInfo.getResourceClass().getName() + " . " + resourceInfo.getResourceMethod().getName());
        }
        if (!writeProtection.value()) {
            LOGGER.debug("Operation does not require write protection  " + resourceInfo.getResourceClass().getName() + "." + resourceInfo.getResourceMethod().getName());
            return;
        }
        if (!this.isReadOnly) {
            LOGGER.debug("No write protection required since Write operations are allowed for method " + resourceInfo.getResourceClass().getName() + " . " + resourceInfo.getResourceMethod().getName());
            return;
        }
        LOGGER.debug(String.format("Filter API calls to method %s.%s", resourceInfo.getResourceClass().getName(), resourceInfo.getResourceMethod().getName()));
        context.register((Object)new WriteProtectionForbiddenFilter(this.alertService), 2000);
    }
}

