/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.rest.writeprotection;

import fr.gouv.vitam.common.ServerIdentity;
import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.error.VitamError;
import fr.gouv.vitam.common.logging.VitamLogLevel;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class WriteProtectionForbiddenFilter
implements ContainerRequestFilter {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(WriteProtectionForbiddenFilter.class);
    private final AlertService alertService;

    public WriteProtectionForbiddenFilter(AlertService alertService) {
        this.alertService = alertService;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String message = "SECURITY ALERT. Illegal Write API invocation on secondary site : " + requestContext.getMethod() + " " + requestContext.getUriInfo().getRequestUri();
        LOGGER.error(message);
        this.alertService.createAlert(VitamLogLevel.ERROR, message);
        VitamError vitamError = new VitamError(VitamCodeHelper.getCode((VitamCode)VitamCode.STORAGE_ILLEGAL_WRITE_ON_SECONDARY_SITE));
        vitamError.setContext(ServerIdentity.getInstance().getJsonIdentity()).setMessage(VitamCode.STORAGE_ILLEGAL_WRITE_ON_SECONDARY_SITE.getMessage()).setDescription(VitamCode.STORAGE_ILLEGAL_WRITE_ON_SECONDARY_SITE.getMessage()).setState(VitamCode.STORAGE_ILLEGAL_WRITE_ON_SECONDARY_SITE.name()).setHttpCode(VitamCode.STORAGE_ILLEGAL_WRITE_ON_SECONDARY_SITE.getStatus().getStatusCode());
        requestContext.abortWith(Response.status((int)vitamError.getHttpCode()).entity((Object)vitamError).type(MediaType.APPLICATION_JSON_TYPE).build());
    }
}

