/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.rest;

import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.alert.AlertService;
import fr.gouv.vitam.common.alert.AlertServiceImpl;
import fr.gouv.vitam.common.server.application.configuration.DefaultVitamApplicationConfiguration;
import fr.gouv.vitam.common.serverv2.application.AdminApplication;
import fr.gouv.vitam.security.internal.filter.AdminRequestIdFilter;
import fr.gouv.vitam.security.internal.filter.BasicAuthenticationFilter;
import fr.gouv.vitam.storage.engine.common.exception.StorageTechnicalException;
import fr.gouv.vitam.storage.engine.server.distribution.StorageDistribution;
import fr.gouv.vitam.storage.engine.server.distribution.impl.StorageDistributionFactory;
import fr.gouv.vitam.storage.engine.server.offerdiff.OfferDiffService;
import fr.gouv.vitam.storage.engine.server.rest.AdminOfferDiffResource;
import fr.gouv.vitam.storage.engine.server.rest.AdminOfferSyncResource;
import fr.gouv.vitam.storage.engine.server.rest.StorageConfiguration;
import fr.gouv.vitam.storage.engine.server.rest.writeprotection.WriteProtectionScanner;
import fr.gouv.vitam.storage.engine.server.storagelog.StorageLog;
import fr.gouv.vitam.storage.engine.server.storagelog.StorageLogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;

public class AdminStorageApplication
extends Application {
    private final AdminApplication adminApplication;
    private Set<Object> singletons;

    public AdminStorageApplication(@Context ServletConfig servletConfig) {
        String configurationFile = servletConfig.getInitParameter("vitam.configurationFile");
        try (InputStream yamlIS = PropertiesUtils.getConfigAsStream((String)configurationFile);){
            StorageConfiguration storageConfiguration = (StorageConfiguration)((Object)PropertiesUtils.readYaml((InputStream)yamlIS, StorageConfiguration.class));
            this.adminApplication = new AdminApplication();
            this.singletons = new HashSet<Object>();
            this.singletons.addAll(this.adminApplication.getSingletons());
            StorageLog storageLogService = StorageLogFactory.getInstance(storageConfiguration);
            StorageDistribution distribution = StorageDistributionFactory.createStorageDistribution(storageConfiguration, storageLogService, (AlertService)new AlertServiceImpl());
            this.singletons.add(new AdminOfferSyncResource(distribution, storageConfiguration));
            this.singletons.add(new AdminOfferDiffResource(new OfferDiffService(distribution)));
            this.singletons.add(new BasicAuthenticationFilter((DefaultVitamApplicationConfiguration)storageConfiguration));
            this.singletons.add(new AdminRequestIdFilter());
            this.singletons.add(new WriteProtectionScanner((AlertService)new AlertServiceImpl(), storageConfiguration.isReadOnly()));
        }
        catch (StorageTechnicalException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }
}

