/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.rest;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.AuthenticationLevel;
import fr.gouv.vitam.common.security.rest.VitamAuthentication;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.request.OfferPartialSyncItem;
import fr.gouv.vitam.storage.engine.common.model.request.OfferPartialSyncRequest;
import fr.gouv.vitam.storage.engine.common.model.request.OfferSyncRequest;
import fr.gouv.vitam.storage.engine.server.distribution.StorageDistribution;
import fr.gouv.vitam.storage.engine.server.offersynchronization.OfferSyncService;
import fr.gouv.vitam.storage.engine.server.offersynchronization.OfferSyncStatus;
import fr.gouv.vitam.storage.engine.server.rest.StorageConfiguration;
import fr.gouv.vitam.storage.engine.server.rest.writeprotection.WriteProtection;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.elasticsearch.common.Strings;

@Path(value="/storage/v1")
@Tag(name="Admin-Offer")
public class AdminOfferSyncResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(AdminOfferSyncResource.class);
    private static final String OFFER_SYNC_URI = "/offerSync";
    private static final String OFFER_PARTIAL_SYNC_URI = "/offerPartialSync";
    private OfferSyncService offerSyncService;

    public AdminOfferSyncResource(StorageDistribution distribution, StorageConfiguration storageConfiguration) {
        this(new OfferSyncService(distribution, storageConfiguration));
    }

    @VisibleForTesting
    public AdminOfferSyncResource(OfferSyncService offerSyncService) {
        this.offerSyncService = offerSyncService;
    }

    @Path(value="/offerPartialSync")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @WriteProtection(value=true)
    public Response startPartialSynchronization(OfferPartialSyncRequest offerPartialSyncRequest) {
        Response.Status status;
        ParametersChecker.checkParameter((String)"source offer is mandatory.", (String[])new String[]{offerPartialSyncRequest.getSourceOffer()});
        ParametersChecker.checkParameter((String)"target offer is mandatory.", (String[])new String[]{offerPartialSyncRequest.getTargetOffer()});
        if (offerPartialSyncRequest.getSourceOffer().equals(offerPartialSyncRequest.getTargetOffer())) {
            throw new IllegalArgumentException("Source offer cannot be the same as target offer");
        }
        VitamThreadUtils.getVitamSession().setTenantId(VitamConfiguration.getAdminTenant());
        VitamThreadUtils.getVitamSession().setRequestId(GUIDFactory.newRequestIdGUID((int)VitamConfiguration.getAdminTenant()));
        if (null == offerPartialSyncRequest.getItemsToSynchronize() || offerPartialSyncRequest.getItemsToSynchronize().isEmpty()) {
            LOGGER.info("Items to synchronize is empty");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).header("X-Request-Id", (Object)VitamThreadUtils.getVitamSession().getRequestId()).entity((Object)JsonHandler.unprettyPrint((Object)JsonHandler.createObjectNode().put("Error", "ItemsToSynchronize parameter is empty"))).build();
        }
        String validateRequestMsg = this.validateRequest(offerPartialSyncRequest);
        if (validateRequestMsg.length() > 0) {
            LOGGER.error(validateRequestMsg);
            throw new IllegalArgumentException(validateRequestMsg);
        }
        boolean started = this.offerSyncService.startSynchronization(offerPartialSyncRequest.getSourceOffer(), offerPartialSyncRequest.getTargetOffer(), offerPartialSyncRequest.getStrategyId(), offerPartialSyncRequest.getItemsToSynchronize());
        if (started) {
            LOGGER.info("Offer partial synchronization started");
            status = Response.Status.OK;
        } else {
            LOGGER.warn("Another synchronization process is already running");
            status = Response.Status.CONFLICT;
        }
        return Response.status((Response.Status)status).header("X-Request-Id", (Object)VitamThreadUtils.getVitamSession().getRequestId()).build();
    }

    private String validateRequest(OfferPartialSyncRequest offerPartialSyncRequest) {
        StringBuilder sb = new StringBuilder();
        for (OfferPartialSyncItem o : offerPartialSyncRequest.getItemsToSynchronize()) {
            if (!VitamConfiguration.getTenants().contains(o.getTenantId())) {
                sb.append("Invalid tenant ").append(o.getTenantId()).append(", ");
            }
            if (Strings.isNullOrEmpty((String)o.getContainer())) {
                sb.append("container required, ");
            }
            if (null == o.getFilenames() || o.getFilenames().isEmpty()) {
                sb.append("filenames is required; ");
                continue;
            }
            o.getFilenames().forEach(f -> {
                if (Strings.isNullOrEmpty((String)f)) {
                    sb.append("File is required; ");
                }
            });
        }
        return sb.toString();
    }

    @Path(value="/offerSync")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @VitamAuthentication(authentLevel=AuthenticationLevel.BASIC_AUTHENT)
    @Operation(summary="Start offer synchronization", description="D\u00e9marre la synchronisation des offres. Une seule synchronisation peut \u00eatre d\u00e9marr\u00e9 \u00e0 la fois.")
    @WriteProtection(value=true)
    public Response startSynchronization(OfferSyncRequest offerSyncRequest) {
        Response.Status status;
        ParametersChecker.checkParameter((String)"source offer is mandatory.", (String[])new String[]{offerSyncRequest.getSourceOffer()});
        ParametersChecker.checkParameter((String)"target offer is mandatory.", (String[])new String[]{offerSyncRequest.getTargetOffer()});
        if (offerSyncRequest.getSourceOffer().equals(offerSyncRequest.getTargetOffer())) {
            throw new IllegalArgumentException("Source offer cannot be the same as target offer");
        }
        ParametersChecker.checkParameter((String)"strategyId is mandatory.", (String[])new String[]{offerSyncRequest.getStrategyId()});
        ParametersChecker.checkParameter((String)"tenantId is mandatory.", (Object[])new Object[]{offerSyncRequest.getTenantId()});
        ParametersChecker.checkParameter((String)"container is mandatory.", (String[])new String[]{offerSyncRequest.getContainer()});
        if (!VitamConfiguration.getTenants().contains(offerSyncRequest.getTenantId())) {
            throw new IllegalArgumentException("Invalid tenant " + offerSyncRequest.getTenantId());
        }
        VitamThreadUtils.getVitamSession().setTenantId(offerSyncRequest.getTenantId());
        VitamThreadUtils.getVitamSession().setRequestId(GUIDFactory.newRequestIdGUID((int)offerSyncRequest.getTenantId()));
        DataCategory dataCategory = DataCategory.getByCollectionName((String)offerSyncRequest.getContainer());
        LOGGER.info(String.format("Starting %s offer synchronization from the %s source offer with %d%n offset.", offerSyncRequest.getTargetOffer(), offerSyncRequest.getSourceOffer(), offerSyncRequest.getOffset()));
        boolean started = this.offerSyncService.startSynchronization(offerSyncRequest.getSourceOffer(), offerSyncRequest.getTargetOffer(), offerSyncRequest.getStrategyId(), dataCategory, offerSyncRequest.getOffset());
        if (started) {
            LOGGER.info("Offer synchronization started");
            status = Response.Status.OK;
        } else {
            LOGGER.warn("Another synchronization process is already running");
            status = Response.Status.CONFLICT;
        }
        return Response.status((Response.Status)status).header("X-Request-Id", (Object)VitamThreadUtils.getVitamSession().getRequestId()).build();
    }

    @Path(value="/offerSync")
    @HEAD
    @VitamAuthentication(authentLevel=AuthenticationLevel.BASIC_AUTHENT)
    @Operation(summary="return if offer synchronization is running", description="Permet de r\u00e9cup\u00e9rer le status de la synchronisation des offres (en cours ou non)")
    @WriteProtection(value=true)
    public Response isOfferSynchronizationRunning() {
        return Response.ok().header("Running", (Object)this.offerSyncService.isRunning()).build();
    }

    @Path(value="/offerSync")
    @GET
    @Produces(value={"application/json"})
    @VitamAuthentication(authentLevel=AuthenticationLevel.BASIC_AUTHENT)
    @Operation(summary="return last offer synchronization status", description="Permet de r\u00e9cup\u00e9rer le status de la derni\u00e8re synchronisation des offres (termin\u00e9e ou en cours)")
    @WriteProtection(value=true)
    public Response getLastOfferSynchronizationStatus() {
        OfferSyncStatus lastSynchronizationStatus = this.offerSyncService.getLastSynchronizationStatus();
        if (lastSynchronizationStatus == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)lastSynchronizationStatus).build();
    }
}

