/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.offersynchronization;

import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.RequestResponseOK;
import fr.gouv.vitam.storage.engine.common.exception.StorageException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.OfferLog;
import fr.gouv.vitam.storage.engine.common.model.Order;
import fr.gouv.vitam.storage.engine.server.distribution.StorageDistribution;
import java.util.List;

public class RestoreOfferBackupService {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(RestoreOfferBackupService.class);
    private final StorageDistribution distribution;

    public RestoreOfferBackupService(StorageDistribution distribution) {
        this.distribution = distribution;
    }

    public List<OfferLog> getListing(String strategy, String offerId, DataCategory category, Long offset, int limit, Order order) throws StorageException {
        LOGGER.debug(String.format("[Offer synchronization]: Retrieve listing of {%s} dataCategory from {%s} offer, with {%s} Vitam strategy from {%s} offset with {%s} limit", category.name(), offerId, strategy, offset, limit));
        RequestResponse<OfferLog> result = this.distribution.getOfferLogsByOfferId(strategy, offerId, category, offset, limit, order);
        if (!result.isOk()) {
            throw new StorageException(String.format("ERROR: VitamError has been returned when using storage service: {%s}", result.toString()));
        }
        return ((RequestResponseOK)result).getResults();
    }
}

