/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.offersynchronization;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.thread.ExecutorUtils;
import fr.gouv.vitam.common.thread.VitamThreadPoolExecutor;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.request.OfferPartialSyncItem;
import fr.gouv.vitam.storage.engine.server.distribution.StorageDistribution;
import fr.gouv.vitam.storage.engine.server.offersynchronization.OfferSyncProcess;
import fr.gouv.vitam.storage.engine.server.offersynchronization.OfferSyncStatus;
import fr.gouv.vitam.storage.engine.server.offersynchronization.RestoreOfferBackupService;
import fr.gouv.vitam.storage.engine.server.rest.StorageConfiguration;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class OfferSyncService
implements AutoCloseable {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(OfferSyncService.class);
    private final RestoreOfferBackupService restoreOfferBackupService;
    private final StorageDistribution distribution;
    private final int bulkSize;
    private final int offerSyncNumberOfRetries;
    private final int offerSyncFirstAttemptWaitingTime;
    private final int offerSyncWaitingTime;
    private final int offerSyncAccessRequestCheckWaitingTime;
    private final ExecutorService executor;
    private final AtomicReference<OfferSyncProcess> lastOfferSyncService = new AtomicReference<Object>(null);

    public OfferSyncService(StorageDistribution distribution, StorageConfiguration storageConfiguration) {
        this(new RestoreOfferBackupService(distribution), distribution, storageConfiguration.getOfferSynchronizationBulkSize(), storageConfiguration.getOfferSyncThreadPoolSize(), storageConfiguration.getOfferSyncNumberOfRetries(), storageConfiguration.getOfferSyncFirstAttemptWaitingTime(), storageConfiguration.getOfferSyncWaitingTime(), storageConfiguration.getOfferSyncAccessRequestCheckWaitingTime());
    }

    @VisibleForTesting
    OfferSyncService(RestoreOfferBackupService restoreOfferBackupService, StorageDistribution distribution, int bulkSize, int offerSyncThreadPoolSize, int offerSyncNumberOfRetries, int offerSyncFirstAttemptWaitingTime, int offerSyncWaitingTime, int offerSyncAccessRequestCheckWaitingTime) {
        this.restoreOfferBackupService = restoreOfferBackupService;
        this.distribution = distribution;
        this.bulkSize = bulkSize;
        this.offerSyncNumberOfRetries = offerSyncNumberOfRetries;
        this.offerSyncFirstAttemptWaitingTime = offerSyncFirstAttemptWaitingTime;
        this.offerSyncWaitingTime = offerSyncWaitingTime;
        this.offerSyncAccessRequestCheckWaitingTime = offerSyncAccessRequestCheckWaitingTime;
        this.executor = ExecutorUtils.createScalableBatchExecutorService((int)offerSyncThreadPoolSize);
    }

    public boolean startSynchronization(String sourceOffer, String targetOffer, String strategyId, List<OfferPartialSyncItem> items) {
        OfferSyncProcess currentOfferSyncProcess;
        OfferSyncProcess offerSyncProcess = this.createOfferSyncProcess();
        if (offerSyncProcess != (currentOfferSyncProcess = this.lastOfferSyncService.updateAndGet(previousOfferSyncService -> {
            if (previousOfferSyncService != null && previousOfferSyncService.isRunning()) {
                return previousOfferSyncService;
            }
            return offerSyncProcess;
        }))) {
            LOGGER.error("Another synchronization workflow is already running " + currentOfferSyncProcess.toString());
            return false;
        }
        this.runSynchronizationAsync(sourceOffer, targetOffer, strategyId, items, offerSyncProcess);
        return true;
    }

    void runSynchronizationAsync(String sourceOffer, String targetOffer, String strategyId, List<OfferPartialSyncItem> items, OfferSyncProcess offerSyncProcess) {
        int tenantId = VitamThreadUtils.getVitamSession().getTenantId();
        String requestId = VitamThreadUtils.getVitamSession().getRequestId();
        VitamThreadPoolExecutor.getDefaultExecutor().execute(() -> {
            try {
                VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(tenantId));
                VitamThreadUtils.getVitamSession().setRequestId(requestId);
                offerSyncProcess.synchronize(this.executor, sourceOffer, targetOffer, strategyId, items);
            }
            catch (Exception e) {
                LOGGER.error("An error occurred during partial synchronization process execution", (Throwable)e);
            }
        });
    }

    public boolean startSynchronization(String sourceOffer, String targetOffer, String strategyId, DataCategory dataCategory, Long offset) {
        OfferSyncProcess currentOfferSyncProcess;
        OfferSyncProcess offerSyncProcess = this.createOfferSyncProcess();
        if (offerSyncProcess != (currentOfferSyncProcess = this.lastOfferSyncService.updateAndGet(previousOfferSyncService -> {
            if (previousOfferSyncService != null && previousOfferSyncService.isRunning()) {
                return previousOfferSyncService;
            }
            return offerSyncProcess;
        }))) {
            LOGGER.error("Another synchronization workflow is already running " + currentOfferSyncProcess.toString());
            return false;
        }
        LOGGER.info(String.format("Start the synchronization process of the new offer {%s} from the source offer {%s} fro category {%s}.", targetOffer, sourceOffer, dataCategory));
        this.runSynchronizationAsync(sourceOffer, targetOffer, strategyId, dataCategory, offset, offerSyncProcess);
        return true;
    }

    OfferSyncProcess createOfferSyncProcess() {
        return new OfferSyncProcess(this.restoreOfferBackupService, this.distribution, this.bulkSize, this.offerSyncNumberOfRetries, this.offerSyncFirstAttemptWaitingTime, this.offerSyncWaitingTime, this.offerSyncAccessRequestCheckWaitingTime);
    }

    void runSynchronizationAsync(String sourceOffer, String targetOffer, String strategyId, DataCategory dataCategory, Long offset, OfferSyncProcess offerSyncProcess) {
        int tenantId = VitamThreadUtils.getVitamSession().getTenantId();
        String requestId = VitamThreadUtils.getVitamSession().getRequestId();
        VitamThreadPoolExecutor.getDefaultExecutor().execute(() -> {
            try {
                VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(tenantId));
                VitamThreadUtils.getVitamSession().setRequestId(requestId);
                offerSyncProcess.synchronize(this.executor, sourceOffer, targetOffer, strategyId, dataCategory, offset);
            }
            catch (Exception e) {
                LOGGER.error("An error occurred during synchronization process execution", (Throwable)e);
            }
        });
    }

    public boolean isRunning() {
        OfferSyncProcess offerSyncProcess = this.lastOfferSyncService.get();
        return offerSyncProcess != null && offerSyncProcess.isRunning();
    }

    public OfferSyncStatus getLastSynchronizationStatus() {
        OfferSyncProcess offerSyncProcess = this.lastOfferSyncService.get();
        if (offerSyncProcess == null) {
            return null;
        }
        return offerSyncProcess.getOfferSyncStatus();
    }

    @VisibleForTesting
    public ExecutorService getExecutor() {
        return this.executor;
    }

    @Override
    public void close() throws Exception {
        if (null != this.executor) {
            this.executor.shutdown();
            this.executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
    }
}

