/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.offersynchronization;

import com.google.common.collect.Iterables;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.storage.AccessRequestStatus;
import fr.gouv.vitam.common.retryable.RetryableOnException;
import fr.gouv.vitam.common.retryable.RetryableParameters;
import fr.gouv.vitam.common.stream.StreamUtils;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.storage.engine.common.exception.StorageException;
import fr.gouv.vitam.storage.engine.common.exception.StorageNotFoundException;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.OfferLog;
import fr.gouv.vitam.storage.engine.common.model.OfferLogAction;
import fr.gouv.vitam.storage.engine.common.model.Order;
import fr.gouv.vitam.storage.engine.common.model.request.OfferPartialSyncItem;
import fr.gouv.vitam.storage.engine.server.distribution.StorageDistribution;
import fr.gouv.vitam.storage.engine.server.distribution.impl.DataContext;
import fr.gouv.vitam.storage.engine.server.exception.RuntimeStorageException;
import fr.gouv.vitam.storage.engine.server.offersynchronization.OfferSyncStatus;
import fr.gouv.vitam.storage.engine.server.offersynchronization.RestoreOfferBackupService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class OfferSyncProcess {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(OfferSyncProcess.class);
    public static final String OFFER_SYNC_ORIGIN = "offer_sync";
    private final RestoreOfferBackupService restoreOfferBackupService;
    private final StorageDistribution distribution;
    private final int bulkSize;
    private final RetryableParameters retryableParameters;
    private final int accessRequestCheckWaitingTime;
    private OfferSyncStatus offerSyncStatus;

    public OfferSyncProcess(RestoreOfferBackupService restoreOfferBackupService, StorageDistribution distribution, int bulkSize, int offerSyncNumberOfRetries, int offerSyncFirstAttemptWaitingTime, int offerSyncWaitingTime, int accessRequestCheckWaitingTime) {
        this.restoreOfferBackupService = restoreOfferBackupService;
        this.distribution = distribution;
        this.bulkSize = bulkSize;
        this.offerSyncStatus = new OfferSyncStatus(VitamThreadUtils.getVitamSession().getRequestId(), StatusCode.UNKNOWN, null, null, null, null, null, null, null);
        this.retryableParameters = new RetryableParameters(offerSyncNumberOfRetries, offerSyncFirstAttemptWaitingTime, offerSyncWaitingTime, 10, TimeUnit.SECONDS);
        this.accessRequestCheckWaitingTime = accessRequestCheckWaitingTime;
    }

    private static OfferLog getLastOfferLog(OfferLog offerLog1, OfferLog offerLog2) {
        return offerLog1.getSequence() > offerLog2.getSequence() ? offerLog1 : offerLog2;
    }

    private String getCurrentDate() {
        return LocalDateUtil.nowFormatted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronize(ExecutorService executor, String sourceOffer, String targetOffer, String strategyId, DataCategory dataCategory, Long startOffset) {
        this.offerSyncStatus = new OfferSyncStatus(VitamThreadUtils.getVitamSession().getRequestId(), StatusCode.UNKNOWN, this.getCurrentDate(), null, sourceOffer, targetOffer, dataCategory.getCollectionName(), startOffset, null);
        try {
            List<OfferLog> rawOfferLogs;
            LOGGER.info(String.format("Start the synchronization process of the target offer {%s} from the source offer {%s} for category {%s}.", targetOffer, sourceOffer, dataCategory));
            Long offset = startOffset;
            while (!(rawOfferLogs = this.restoreOfferBackupService.getListing(strategyId, sourceOffer, dataCategory, offset, this.bulkSize, Order.ASC)).isEmpty()) {
                long lastSequence = this.synchronizeOfferLogs(executor, sourceOffer, targetOffer, strategyId, dataCategory, rawOfferLogs, offset);
                this.offerSyncStatus.setCurrentOffset(lastSequence);
                offset = lastSequence + 1L;
                LOGGER.info(String.format("Offer synchronization safe point offset : %s (from %s to %s for category %s)", offset, sourceOffer, targetOffer, dataCategory));
                if (rawOfferLogs.size() >= this.bulkSize) continue;
                break;
            }
            LOGGER.info(String.format("The offers synchronization completed successfully. from %d to %d", startOffset, offset));
            this.offerSyncStatus.setStatusCode(StatusCode.OK);
        }
        catch (Exception e) {
            this.offerSyncStatus.setStatusCode(StatusCode.KO);
            LOGGER.error(String.format("[OfferSync]: An exception has been thrown when synchronizing {%s} offer from {%s} source offer with {%s} offset.", targetOffer, sourceOffer, startOffset), (Throwable)e);
        }
        finally {
            this.offerSyncStatus.setEndDate(this.getCurrentDate());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long synchronizeOfferLogs(Executor executor, String sourceOffer, String destinationOffer, String strategyId, DataCategory dataCategory, List<OfferLog> rawOfferLogs, Long offset) throws StorageException {
        int tenantId = VitamThreadUtils.getVitamSession().getTenantId();
        String requestId = VitamThreadUtils.getVitamSession().getRequestId();
        Collection<OfferLog> offerLogs = this.removeDuplicates(rawOfferLogs);
        Optional<String> optionalAccessRequest = this.awaitAccessRequestReadiness(strategyId, sourceOffer, dataCategory, offerLogs);
        try {
            ArrayList completableFutures = new ArrayList();
            block7: for (OfferLog offerLog : offerLogs) {
                switch (offerLog.getAction()) {
                    case WRITE: {
                        completableFutures.add(CompletableFuture.runAsync(() -> this.retryable().execute(() -> this.copyObject(sourceOffer, destinationOffer, dataCategory, offerLog.getContainer(), offerLog.getFileName(), tenantId, strategyId, requestId)), executor));
                        continue block7;
                    }
                    case DELETE: {
                        completableFutures.add(CompletableFuture.runAsync(() -> this.retryable().execute(() -> this.deleteObject(destinationOffer, dataCategory, offerLog.getContainer(), offerLog.getFileName(), tenantId, strategyId, requestId)), executor));
                        continue block7;
                    }
                }
                throw new UnsupportedOperationException("Unknown offer log action " + offerLog.getAction());
            }
            boolean allSucceeded = this.awaitCompletion(completableFutures);
            if (!allSucceeded) {
                throw new StorageException("Error(s) occurred during offer synchronization " + sourceOffer + " > " + destinationOffer + " for container " + dataCategory + " at start offset " + offset);
            }
            long lastSequence = ((OfferLog)Iterables.getLast(rawOfferLogs)).getSequence();
            LOGGER.info("[OfferSync]: successful synchronization of dataCategory : {}, tenant : {}, offset : {}", new Object[]{dataCategory, tenantId, lastSequence});
            long l = lastSequence;
            return l;
        }
        finally {
            optionalAccessRequest.ifPresent(accessRequestId -> this.removeAccessRequestQuietly(strategyId, sourceOffer, (String)accessRequestId));
        }
    }

    private Optional<String> awaitAccessRequestReadiness(String strategyId, String sourceOffer, DataCategory dataCategory, Collection<OfferLog> offerLogs) throws StorageException {
        List<String> objectNames = offerLogs.stream().filter(offerLog -> OfferLogAction.WRITE.equals((Object)offerLog.getAction())).map(OfferLog::getFileName).collect(Collectors.toList());
        Optional<String> optionalAccessRequest = this.createAccessRequestIfRequired(strategyId, sourceOffer, dataCategory, objectNames);
        if (optionalAccessRequest.isPresent()) {
            this.awaitAccessRequestReadiness(strategyId, sourceOffer, optionalAccessRequest.get());
        }
        return optionalAccessRequest;
    }

    private RetryableOnException<Void, RuntimeStorageException> retryable() {
        return new RetryableOnException(this.retryableParameters);
    }

    private <T> boolean awaitCompletion(List<CompletableFuture<T>> completableFutures) throws StorageException {
        boolean allSucceeded = true;
        for (CompletableFuture<T> completableFuture : completableFutures) {
            try {
                completableFuture.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new StorageException((Throwable)e);
            }
            catch (ExecutionException e) {
                LOGGER.error((Throwable)e);
                allSucceeded = false;
            }
        }
        return allSucceeded;
    }

    /*
     * Loose catch block
     */
    private void syncObject(String sourceOffer, String destinationOffer, DataCategory dataCategory, String container, String fileName, int tenant, String strategyId, String requestId) {
        VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(tenant));
        VitamThreadUtils.getVitamSession().setRequestId(requestId);
        Response resp = null;
        try {
            LOGGER.debug("Sync object " + container + "/" + fileName + " from offer " + sourceOffer + " to offer " + destinationOffer);
            resp = this.distribution.getContainerByCategory(strategyId, OFFER_SYNC_ORIGIN, fileName, dataCategory, sourceOffer);
            LOGGER.debug("Copy object " + container + "/" + fileName + " from offer " + sourceOffer + " to offer " + destinationOffer);
            this.distribution.storeDataInOffers(strategyId, OFFER_SYNC_ORIGIN, fileName, dataCategory, null, Collections.singletonList(destinationOffer), resp);
            StreamUtils.consumeAnyEntityAndClose((Response)resp);
        }
        catch (StorageNotFoundException e) {
            this.deleteObject(destinationOffer, dataCategory, container, fileName, tenant, strategyId, requestId);
        }
        catch (StorageException e2) {
            throw new RuntimeStorageException("An error occurred during copying '" + container + "/" + fileName + "' from " + sourceOffer + " to " + destinationOffer, e2);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            StreamUtils.consumeAnyEntityAndClose(resp);
        }
    }

    /*
     * Loose catch block
     */
    private void copyObject(String sourceOffer, String destinationOffer, DataCategory dataCategory, String container, String fileName, int tenant, String strategyId, String requestId) {
        VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(tenant));
        VitamThreadUtils.getVitamSession().setRequestId(requestId);
        Response resp = null;
        try {
            LOGGER.debug("Copying object " + container + "/" + fileName + " from offer " + sourceOffer + " to offer " + destinationOffer);
            resp = this.distribution.getContainerByCategory(strategyId, OFFER_SYNC_ORIGIN, fileName, dataCategory, sourceOffer);
            this.distribution.storeDataInOffers(strategyId, OFFER_SYNC_ORIGIN, fileName, dataCategory, null, Collections.singletonList(destinationOffer), resp);
            StreamUtils.consumeAnyEntityAndClose((Response)resp);
        }
        catch (StorageNotFoundException e) {
            LOGGER.debug("File not found", (Throwable)e);
            LOGGER.warn("File " + sourceOffer + " not found on " + sourceOffer + ". File deleted meanwhile?");
        }
        catch (StorageException e2) {
            throw new RuntimeStorageException("An error occurred during copying '" + container + "/" + fileName + "' from " + sourceOffer + " to " + destinationOffer, e2);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            StreamUtils.consumeAnyEntityAndClose(resp);
        }
    }

    private void deleteObject(String destinationOffer, DataCategory dataCategory, String container, String fileName, int tenant, String strategyId, String requestId) {
        VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(tenant));
        VitamThreadUtils.getVitamSession().setRequestId(requestId);
        try {
            LOGGER.debug("Deleting object " + container + "/" + fileName + " from offer " + destinationOffer);
            DataContext context = new DataContext(fileName, dataCategory, null, tenant, strategyId);
            this.distribution.deleteObjectInOffers(strategyId, context, Collections.singletonList(destinationOffer));
        }
        catch (Exception e) {
            throw new RuntimeStorageException("An error occurred during deleting '" + container + "/" + fileName + "' from " + destinationOffer, e);
        }
    }

    private Collection<OfferLog> removeDuplicates(List<OfferLog> rawOfferLogs) {
        return rawOfferLogs.stream().collect(Collectors.toMap(offerLog -> new ImmutablePair((Object)offerLog.getContainer(), (Object)offerLog.getFileName()), offerLog -> offerLog, OfferSyncProcess::getLastOfferLog)).values();
    }

    public boolean isRunning() {
        return this.offerSyncStatus.getEndDate() == null;
    }

    public OfferSyncStatus getOfferSyncStatus() {
        return this.offerSyncStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronize(Executor executor, String sourceOffer, String targetOffer, String strategyId, List<OfferPartialSyncItem> items) {
        String requestId = VitamThreadUtils.getVitamSession().getRequestId();
        this.offerSyncStatus = new OfferSyncStatus(VitamThreadUtils.getVitamSession().getRequestId(), StatusCode.UNKNOWN, this.getCurrentDate(), null, sourceOffer, targetOffer, null, null, null);
        try {
            for (OfferPartialSyncItem item : items) {
                DataCategory dataCategory = DataCategory.getByCollectionName((String)item.getContainer());
                int tenant = item.getTenantId();
                LOGGER.info(String.format("Start the partial synchronization process of the target offer {%s} from the source offer {%s} for category {%s} and tenant {%s}.", targetOffer, sourceOffer, dataCategory, tenant));
                List objectNameBulks = ListUtils.partition((List)item.getFilenames(), (int)this.bulkSize);
                for (List objectNames : objectNameBulks) {
                    this.synchronize(executor, sourceOffer, targetOffer, strategyId, requestId, dataCategory, tenant, objectNames, item.getContainer());
                }
            }
            this.offerSyncStatus.setStatusCode(StatusCode.OK);
        }
        catch (Exception e) {
            this.offerSyncStatus.setStatusCode(StatusCode.KO);
            LOGGER.error(String.format("[OfferSync]: An exception has been thrown when synchronizing {%s} offer from {%s} source offer :", targetOffer, sourceOffer), (Throwable)e);
        }
        finally {
            this.offerSyncStatus.setEndDate(this.getCurrentDate());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronize(Executor executor, String sourceOffer, String targetOffer, String strategyId, String requestId, DataCategory dataCategory, int tenant, List<String> objectNames, String container) throws StorageException {
        VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(tenant));
        Optional<String> optionalAccessRequest = this.awaitAccessRequestReadiness(strategyId, sourceOffer, dataCategory, objectNames);
        try {
            ArrayList completableFutureList = new ArrayList();
            for (String objectName : objectNames) {
                completableFutureList.add(CompletableFuture.runAsync(() -> this.retryable().execute(() -> this.syncObject(sourceOffer, targetOffer, dataCategory, container, objectName, tenant, strategyId, requestId)), executor));
            }
            boolean allSucceeded = this.awaitCompletion(completableFutureList);
            if (!allSucceeded) {
                throw new StorageException("Error(s) occurred during offer synchronization " + sourceOffer + " > " + targetOffer);
            }
        }
        finally {
            optionalAccessRequest.ifPresent(accessRequestId -> this.removeAccessRequestQuietly(strategyId, sourceOffer, (String)accessRequestId));
        }
    }

    private Optional<String> awaitAccessRequestReadiness(String strategyId, String sourceOffer, DataCategory dataCategory, List<String> objectNames) throws StorageException {
        Optional<String> optionalAccessRequest = this.createAccessRequestIfRequired(strategyId, sourceOffer, dataCategory, objectNames);
        if (optionalAccessRequest.isPresent()) {
            this.awaitAccessRequestReadiness(strategyId, sourceOffer, optionalAccessRequest.get());
        }
        return optionalAccessRequest;
    }

    private Optional<String> createAccessRequestIfRequired(String strategyId, String sourceOffer, DataCategory dataCategory, List<String> objectNames) throws StorageException {
        return (Optional)new RetryableOnException(this.retryableParameters).exec(() -> this.distribution.createAccessRequestIfRequired(strategyId, sourceOffer, dataCategory, objectNames));
    }

    private void awaitAccessRequestReadiness(String strategyId, String sourceOffer, String accessRequestId) throws StorageException {
        while (!this.isAccessRequestReady(strategyId, sourceOffer, accessRequestId)) {
            this.sleepBeforeAccessRequestReadinessCheckRetry();
        }
    }

    private boolean isAccessRequestReady(String strategyId, String sourceOffer, String accessRequestId) throws StorageException {
        Map accessRequestStatuses = (Map)new RetryableOnException(this.retryableParameters).exec(() -> this.distribution.checkAccessRequestStatuses(strategyId, sourceOffer, List.of(accessRequestId), false));
        if (!accessRequestStatuses.containsKey(accessRequestId)) {
            throw new IllegalStateException("Access request status missing from response for " + accessRequestId);
        }
        AccessRequestStatus accessRequestStatus = (AccessRequestStatus)accessRequestStatuses.get(accessRequestId);
        switch (accessRequestStatus) {
            case READY: {
                LOGGER.info("Access request " + accessRequestId + " is READY !");
                return true;
            }
            case NOT_READY: {
                LOGGER.info("Access request " + accessRequestId + " is NOT READY... Retrying later...");
                return false;
            }
            case EXPIRED: {
                throw new IllegalStateException("Access request Id " + accessRequestId + " already expired ?!");
            }
            case NOT_FOUND: {
                throw new IllegalStateException("Access request Id " + accessRequestId + " not found ?!");
            }
        }
        throw new IllegalStateException("Unexpected value: " + accessRequestStatus);
    }

    private void sleepBeforeAccessRequestReadinessCheckRetry() throws StorageException {
        try {
            TimeUnit.SECONDS.sleep(this.accessRequestCheckWaitingTime);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new StorageException("Offer sync process interrupted", (Throwable)e);
        }
    }

    private void removeAccessRequestQuietly(String strategyId, String sourceOffer, String accessRequestId) {
        try {
            new RetryableOnException(this.retryableParameters).execute(() -> this.distribution.removeAccessRequest(strategyId, sourceOffer, accessRequestId, false));
        }
        catch (StorageException e) {
            LOGGER.error("Could not remove access request " + accessRequestId + " from offer " + sourceOffer + " of strategy " + strategyId, (Throwable)e);
        }
    }
}

