/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.offerdiff.sort;

import fr.gouv.vitam.common.model.storage.ObjectEntry;
import fr.gouv.vitam.common.model.storage.ObjectEntryWriter;
import fr.gouv.vitam.storage.engine.server.offerdiff.sort.LargeFileWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;

public class ObjectEntryLargeFileWriter
implements LargeFileWriter<ObjectEntry> {
    private final OutputStream outputStream;
    private final ObjectEntryWriter objectEntryWriter;

    public ObjectEntryLargeFileWriter(File file) {
        try {
            this.outputStream = new FileOutputStream(file);
            this.objectEntryWriter = new ObjectEntryWriter(this.outputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void writeEntry(ObjectEntry entry) throws IOException {
        this.objectEntryWriter.write(entry);
    }

    @Override
    public void close() throws IOException {
        this.objectEntryWriter.writeEof();
        this.objectEntryWriter.close();
        this.outputStream.close();
    }
}

