/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.offerdiff.sort;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import fr.gouv.vitam.storage.engine.server.offerdiff.sort.LargeFileReader;
import fr.gouv.vitam.storage.engine.server.offerdiff.sort.LargeFileWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.io.FileUtils;

public class LargeFileSorter<T> {
    public static final int INITIAL_FILE_CHUNK_SIZE_TO_SORT_IN_MEMORY = 100000;
    public static final int NB_FILES_TO_MERGE_SORT = 10;
    private final int initialFileChunkSizeToSortInMemory;
    private final int nbFilesToMergeSort;
    private final Function<File, LargeFileReader<T>> fileReaderFactory;
    private final Function<File, LargeFileWriter<T>> fileWriterFactory;
    private final Comparator<T> entryComparator;
    private final Supplier<File> tempFileCreator;

    public LargeFileSorter(Function<File, LargeFileReader<T>> fileReaderFactory, Function<File, LargeFileWriter<T>> fileWriterFactory, Comparator<T> entryComparator, Supplier<File> tempFileCreator) {
        this(100000, 10, fileReaderFactory, fileWriterFactory, entryComparator, tempFileCreator);
    }

    @VisibleForTesting
    LargeFileSorter(int initialFileChunkSizeToSortInMemory, int nbFilesToMergeSort, Function<File, LargeFileReader<T>> fileReaderFactory, Function<File, LargeFileWriter<T>> fileWriterFactory, Comparator<T> entryComparator, Supplier<File> tempFileCreator) {
        this.initialFileChunkSizeToSortInMemory = initialFileChunkSizeToSortInMemory;
        this.nbFilesToMergeSort = nbFilesToMergeSort;
        this.fileReaderFactory = fileReaderFactory;
        this.fileWriterFactory = fileWriterFactory;
        this.entryComparator = entryComparator;
        this.tempFileCreator = tempFileCreator;
    }

    public File sortLargeFile(File inputFile) throws IOException {
        try (LargeFileReader<T> reader = this.fileReaderFactory.apply(inputFile);){
            List<File> filesToMerge = this.splitIntoInitialSortedChunkFiles(reader);
            File file = this.mergeSortFiles(filesToMerge);
            return file;
        }
    }

    private List<File> splitIntoInitialSortedChunkFiles(LargeFileReader<T> reader) throws IOException {
        ArrayList<File> filesToMerge = new ArrayList<File>();
        UnmodifiableIterator bulkIterator = Iterators.partition(reader, (int)this.initialFileChunkSizeToSortInMemory);
        while (bulkIterator.hasNext()) {
            List entries = (List)bulkIterator.next();
            Iterator entryIterator = entries.stream().sorted(this.entryComparator).iterator();
            File tempFile = this.writeToTempFile(entryIterator);
            filesToMerge.add(tempFile);
        }
        return filesToMerge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File mergeSortFiles(List<File> filesToMerge) throws IOException {
        if (filesToMerge.isEmpty()) {
            return this.writeEmptyFile();
        }
        LinkedList<File> remainingFilesToMerge = new LinkedList<File>(filesToMerge);
        while (remainingFilesToMerge.size() > 1) {
            ArrayList<File> currentFilesToMerge = new ArrayList<File>();
            while (currentFilesToMerge.size() < this.nbFilesToMergeSort && !remainingFilesToMerge.isEmpty()) {
                currentFilesToMerge.add((File)remainingFilesToMerge.poll());
            }
            ArrayList<LargeFileReader<T>> fileReadersToMerge = new ArrayList<LargeFileReader<T>>();
            try {
                for (File file : currentFilesToMerge) {
                    fileReadersToMerge.add(this.fileReaderFactory.apply(file));
                }
                UnmodifiableIterator sortedLinesIterator = Iterators.mergeSorted((Iterable)IteratorUtils.asIterable(fileReadersToMerge.iterator()), this.entryComparator);
                File file = this.writeToTempFile((Iterator<T>)sortedLinesIterator);
                remainingFilesToMerge.add(file);
            }
            finally {
                for (LargeFileReader largeFileReader : fileReadersToMerge) {
                    largeFileReader.close();
                }
                for (File file : currentFilesToMerge) {
                    FileUtils.deleteQuietly((File)file);
                }
            }
        }
        return (File)remainingFilesToMerge.poll();
    }

    private File writeToTempFile(Iterator<T> entryIterator) throws IOException {
        File tempFile = this.tempFileCreator.get();
        try (LargeFileWriter<T> writer = this.fileWriterFactory.apply(tempFile);){
            while (entryIterator.hasNext()) {
                writer.writeEntry(entryIterator.next());
            }
        }
        return tempFile;
    }

    private File writeEmptyFile() throws IOException {
        File tmpEmptyFile = this.tempFileCreator.get();
        LargeFileWriter<T> emptyWriter = this.fileWriterFactory.apply(tmpEmptyFile);
        if (emptyWriter != null) {
            emptyWriter.close();
        }
        return tmpEmptyFile;
    }
}

