/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.distribution.impl.bulk;

import fr.gouv.vitam.common.digest.Digest;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.stream.ExactSizeInputStream;
import fr.gouv.vitam.common.stream.MultiplexedStreamReader;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.storage.engine.server.distribution.impl.bulk.ObjectInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.IOUtils;

public class MultiplexedStreamObjectInfoListenerThread
implements Callable<List<ObjectInfo>> {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(MultiplexedStreamObjectInfoListenerThread.class);
    private final int tenantId;
    private final String requestId;
    private final InputStream inputStream;
    private final DigestType digestType;
    private final List<String> objectIds;

    public MultiplexedStreamObjectInfoListenerThread(int tenantId, String requestId, InputStream inputStream, DigestType digestType, List<String> objectIds) {
        this.tenantId = tenantId;
        this.requestId = requestId;
        this.inputStream = inputStream;
        this.digestType = digestType;
        this.objectIds = objectIds;
    }

    @Override
    public List<ObjectInfo> call() throws IOException, InvalidParseOperationException {
        String initialThreadId = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName(initialThreadId + "-BulkWriteDigestComputeThread");
            VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(this.tenantId));
            VitamThreadUtils.getVitamSession().setRequestId(this.requestId);
            List<ObjectInfo> list = this.computeDigests();
            return list;
        }
        catch (Exception ex) {
            LOGGER.error("An error occurred during digestion computation of bulk transfer", (Throwable)ex);
            throw ex;
        }
        finally {
            IOUtils.closeQuietly((InputStream)this.inputStream);
            Thread.currentThread().setName(initialThreadId);
        }
    }

    private List<ObjectInfo> computeDigests() throws IOException, InvalidParseOperationException {
        try (MultiplexedStreamReader multiplexedStreamReader = new MultiplexedStreamReader(this.inputStream);){
            Optional headerEntry = multiplexedStreamReader.readNextEntry();
            if (!headerEntry.isPresent()) {
                throw new IllegalStateException("Header entry not found");
            }
            List streamObjectIds = (List)JsonHandler.getFromInputStream((InputStream)((InputStream)headerEntry.get()), List.class);
            if (!ListUtils.isEqualList(this.objectIds, (Collection)streamObjectIds)) {
                throw new IllegalStateException("Invalid object ids");
            }
            ArrayList<ObjectInfo> objectInfo = new ArrayList<ObjectInfo>();
            for (String objectId : this.objectIds) {
                Optional entryInputStream = multiplexedStreamReader.readNextEntry();
                if (!entryInputStream.isPresent()) {
                    throw new IllegalStateException("No entry not found for object id " + objectId);
                }
                Digest digest = new Digest(this.digestType);
                digest.update((InputStream)entryInputStream.get());
                objectInfo.add(new ObjectInfo(objectId, digest.digestHex(), ((ExactSizeInputStream)entryInputStream.get()).getSize()));
            }
            if (multiplexedStreamReader.readNextEntry().isPresent()) {
                throw new IllegalStateException("No more entries expected");
            }
            ArrayList<ObjectInfo> arrayList = objectInfo;
            return arrayList;
        }
    }
}

