/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.distribution.impl;

public class TransfertTimeoutHelper {
    private final long millisecondsPerKB;
    private final int minObjectWriteTimeoutMs;
    private final int minBulkWriteTimeoutMsPerObject;

    public TransfertTimeoutHelper(long millisecondsPerKB, int minObjectWriteTimeoutMs, int minBulkWriteTimeoutMsPerObject) {
        this.millisecondsPerKB = millisecondsPerKB;
        this.minObjectWriteTimeoutMs = minObjectWriteTimeoutMs;
        this.minBulkWriteTimeoutMsPerObject = minBulkWriteTimeoutMsPerObject;
    }

    public long getTransferTimeout(long sizeToTransfer) {
        long timeout = sizeToTransfer / 1024L * this.millisecondsPerKB;
        if (timeout < (long)this.minObjectWriteTimeoutMs) {
            return this.minObjectWriteTimeoutMs;
        }
        return timeout;
    }

    public long getBulkTransferTimeout(long sizeToTransfer, int nbObjects) {
        long timeout = sizeToTransfer / 1024L * this.millisecondsPerKB + (long)nbObjects * (long)this.minBulkWriteTimeoutMsPerObject;
        if (timeout < (long)this.minObjectWriteTimeoutMs) {
            return this.minObjectWriteTimeoutMs;
        }
        return timeout;
    }
}

