/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.distribution.impl;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.digest.Digest;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.storage.driver.Connection;
import fr.gouv.vitam.storage.driver.Driver;
import fr.gouv.vitam.storage.driver.exception.StorageDriverException;
import fr.gouv.vitam.storage.driver.model.StorageObjectResult;
import fr.gouv.vitam.storage.driver.model.StoragePutRequest;
import fr.gouv.vitam.storage.driver.model.StoragePutResult;
import fr.gouv.vitam.storage.engine.common.exception.StorageException;
import fr.gouv.vitam.storage.engine.common.exception.StorageInconsistentStateException;
import fr.gouv.vitam.storage.engine.common.referential.StorageOfferProvider;
import fr.gouv.vitam.storage.engine.common.referential.StorageOfferProviderFactory;
import fr.gouv.vitam.storage.engine.common.referential.model.OfferReference;
import fr.gouv.vitam.storage.engine.common.referential.model.StorageOffer;
import fr.gouv.vitam.storage.engine.server.distribution.impl.ThreadResponseData;
import java.io.InputStream;
import java.util.concurrent.Callable;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;

public class TransferThread
implements Callable<ThreadResponseData> {
    public static final String TIMEOUT_TEST = "timeoutTest";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(TransferThread.class);
    private static final StorageOfferProvider OFFER_PROVIDER = StorageOfferProviderFactory.getDefaultProvider();
    private final int tenantId;
    private final String requestId;
    private final StorageOfferProvider offerProvider;
    private final Driver driver;
    private final OfferReference offerReference;
    private final StoragePutRequest request;
    private final Digest globalDigest;
    private final Long size;
    private static boolean IS_JUNIT_MODE = false;

    public TransferThread(int tenantId, String requestId, Driver driver, OfferReference offerReference, StoragePutRequest request, Digest globalDigest, long size) {
        this(tenantId, requestId, driver, offerReference, request, globalDigest, size, OFFER_PROVIDER);
    }

    @VisibleForTesting
    public TransferThread(int tenantId, String requestId, Driver driver, OfferReference offerReference, StoragePutRequest request, Digest globalDigest, long size, StorageOfferProvider offerProvider) {
        this.tenantId = tenantId;
        this.requestId = requestId;
        ParametersChecker.checkParameter((String)"Driver cannot be null", (Object[])new Object[]{driver});
        ParametersChecker.checkParameter((String)"OfferReference cannot be null", (Object[])new Object[]{offerReference});
        ParametersChecker.checkParameter((String)"PutObjectRequest cannot be null", (Object[])new Object[]{request});
        ParametersChecker.checkParameter((String)"GlobalDigest cannot be null", (Object[])new Object[]{globalDigest});
        this.driver = driver;
        this.offerReference = offerReference;
        this.request = request;
        this.globalDigest = globalDigest;
        this.size = size;
        this.offerProvider = offerProvider;
    }

    public static void setJunitMode(boolean mode) {
        IS_JUNIT_MODE = mode;
    }

    @Override
    public ThreadResponseData call() throws StorageException, StorageDriverException, InterruptedException {
        String initialThreadId = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName(initialThreadId + "-TransferThread-" + this.offerReference.getId());
            VitamThreadUtils.getVitamSession().setTenantId(Integer.valueOf(this.tenantId));
            VitamThreadUtils.getVitamSession().setRequestId(this.requestId);
            ThreadResponseData threadResponseData = this.storeInOffer();
            return threadResponseData;
        }
        catch (Exception ex) {
            LOGGER.error("An error occurred during transfer to offer " + this.offerReference.getId(), (Throwable)ex);
            throw ex;
        }
        finally {
            IOUtils.closeQuietly((InputStream)this.request.getDataStream());
            Thread.currentThread().setName(initialThreadId);
        }
    }

    private ThreadResponseData storeInOffer() throws StorageException, StorageDriverException, InterruptedException {
        ThreadResponseData response;
        if (IS_JUNIT_MODE && this.request.getGuid().equals(TIMEOUT_TEST) && this.request.getTenantId() == 0) {
            LOGGER.info("Sleep for Junit test");
            Thread.sleep(100L);
            return null;
        }
        LOGGER.debug(this.request.toString());
        StorageOffer offer = this.offerProvider.getStorageOffer(this.offerReference.getId());
        try (Connection connection = this.driver.connect(offer.getId());){
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            StoragePutRequest putObjectRequest = new StoragePutRequest(this.request.getTenantId(), this.request.getType(), this.request.getGuid(), this.request.getDigestAlgorithm(), this.request.getDataStream());
            putObjectRequest.setSize(this.size.longValue());
            StoragePutResult putObjectResult = connection.putObject(putObjectRequest);
            LOGGER.debug(putObjectRequest.toString());
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            if (!this.globalDigest.digestHex().equals(putObjectResult.getDigestHashBase16())) {
                LOGGER.error("Digest invalid for tenant: {} offer: {} id: {}", new Object[]{ParameterHelper.getTenantParameter(), offer.getId(), this.request.getGuid()});
                throw new StorageInconsistentStateException("[Driver:" + this.driver.getName() + "] Content digest invalid in offer id : '" + offer.getId() + "' for object " + this.request.getGuid() + " sent digest: " + this.globalDigest.digestHex() + " offer digest: " + putObjectResult.getDigestHashBase16());
            }
            response = new ThreadResponseData((StorageObjectResult)new StoragePutResult(putObjectResult.getTenantId(), putObjectResult.getType(), putObjectResult.getGuid(), putObjectResult.getDistantObjectId(), this.globalDigest.digestHex(), putObjectResult.getObjectSize()), Response.Status.CREATED, this.request.getGuid());
        }
        return response;
    }
}

