/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.storage.engine.server.distribution.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import fr.gouv.vitam.common.LocalDateUtil;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.accesslog.AccessLogInfoModel;
import fr.gouv.vitam.common.accesslog.AccessLogUtils;
import fr.gouv.vitam.common.client.DefaultClient;
import fr.gouv.vitam.common.client.VitamContext;
import fr.gouv.vitam.common.collection.CloseableIterator;
import fr.gouv.vitam.common.digest.Digest;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.error.VitamCode;
import fr.gouv.vitam.common.error.VitamCodeHelper;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.RequestResponse;
import fr.gouv.vitam.common.model.storage.AccessRequestStatus;
import fr.gouv.vitam.common.model.storage.ObjectEntry;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.retryable.DelegateRetry;
import fr.gouv.vitam.common.retryable.RetryableOnException;
import fr.gouv.vitam.common.retryable.RetryableOnResult;
import fr.gouv.vitam.common.retryable.RetryableParameters;
import fr.gouv.vitam.common.server.application.VitamHttpHeader;
import fr.gouv.vitam.common.stream.MultiplePipedInputStream;
import fr.gouv.vitam.common.stream.VitamAsyncInputStream;
import fr.gouv.vitam.common.thread.VitamThreadPoolExecutor;
import fr.gouv.vitam.common.thread.VitamThreadUtils;
import fr.gouv.vitam.storage.driver.Connection;
import fr.gouv.vitam.storage.driver.Driver;
import fr.gouv.vitam.storage.driver.exception.StorageDriverConflictException;
import fr.gouv.vitam.storage.driver.exception.StorageDriverException;
import fr.gouv.vitam.storage.driver.exception.StorageDriverPreconditionFailedException;
import fr.gouv.vitam.storage.driver.exception.StorageDriverServerErrorException;
import fr.gouv.vitam.storage.driver.exception.StorageDriverServiceUnavailableException;
import fr.gouv.vitam.storage.driver.exception.StorageDriverUnavailableDataFromAsyncOfferException;
import fr.gouv.vitam.storage.driver.model.StorageAccessRequestCreationRequest;
import fr.gouv.vitam.storage.driver.model.StorageBulkMetadataResult;
import fr.gouv.vitam.storage.driver.model.StorageBulkMetadataResultEntry;
import fr.gouv.vitam.storage.driver.model.StorageCheckObjectAvailabilityRequest;
import fr.gouv.vitam.storage.driver.model.StorageGetBulkMetadataRequest;
import fr.gouv.vitam.storage.driver.model.StorageGetMetadataRequest;
import fr.gouv.vitam.storage.driver.model.StorageGetResult;
import fr.gouv.vitam.storage.driver.model.StorageListRequest;
import fr.gouv.vitam.storage.driver.model.StorageMetadataResult;
import fr.gouv.vitam.storage.driver.model.StorageObjectRequest;
import fr.gouv.vitam.storage.driver.model.StorageOfferLogRequest;
import fr.gouv.vitam.storage.driver.model.StoragePutRequest;
import fr.gouv.vitam.storage.driver.model.StoragePutResult;
import fr.gouv.vitam.storage.driver.model.StorageRemoveRequest;
import fr.gouv.vitam.storage.driver.model.StorageRemoveResult;
import fr.gouv.vitam.storage.engine.common.exception.StorageAlreadyExistsException;
import fr.gouv.vitam.storage.engine.common.exception.StorageDriverNotFoundException;
import fr.gouv.vitam.storage.engine.common.exception.StorageException;
import fr.gouv.vitam.storage.engine.common.exception.StorageIllegalOperationException;
import fr.gouv.vitam.storage.engine.common.exception.StorageInconsistentStateException;
import fr.gouv.vitam.storage.engine.common.exception.StorageNotFoundException;
import fr.gouv.vitam.storage.engine.common.exception.StorageTechnicalException;
import fr.gouv.vitam.storage.engine.common.exception.StorageUnavailableDataFromAsyncOfferException;
import fr.gouv.vitam.storage.engine.common.metrics.DownloadCountingSizeMetricsResponse;
import fr.gouv.vitam.storage.engine.common.metrics.UploadCountingInputStreamMetrics;
import fr.gouv.vitam.storage.engine.common.model.DataCategory;
import fr.gouv.vitam.storage.engine.common.model.OfferLog;
import fr.gouv.vitam.storage.engine.common.model.Order;
import fr.gouv.vitam.storage.engine.common.model.request.BulkObjectStoreRequest;
import fr.gouv.vitam.storage.engine.common.model.request.ObjectDescription;
import fr.gouv.vitam.storage.engine.common.model.response.BatchObjectInformationResponse;
import fr.gouv.vitam.storage.engine.common.model.response.BulkObjectStoreResponse;
import fr.gouv.vitam.storage.engine.common.model.response.StoredInfoResult;
import fr.gouv.vitam.storage.engine.common.referential.StorageOfferProvider;
import fr.gouv.vitam.storage.engine.common.referential.StorageOfferProviderFactory;
import fr.gouv.vitam.storage.engine.common.referential.StorageStrategyProvider;
import fr.gouv.vitam.storage.engine.common.referential.StorageStrategyProviderFactory;
import fr.gouv.vitam.storage.engine.common.referential.model.OfferReference;
import fr.gouv.vitam.storage.engine.common.referential.model.StorageOffer;
import fr.gouv.vitam.storage.engine.common.referential.model.StorageStrategy;
import fr.gouv.vitam.storage.engine.server.distribution.StorageDistribution;
import fr.gouv.vitam.storage.engine.server.distribution.impl.DataContext;
import fr.gouv.vitam.storage.engine.server.distribution.impl.OffersToCopyIn;
import fr.gouv.vitam.storage.engine.server.distribution.impl.StreamAndInfo;
import fr.gouv.vitam.storage.engine.server.distribution.impl.ThreadResponseData;
import fr.gouv.vitam.storage.engine.server.distribution.impl.TimeoutStopwatch;
import fr.gouv.vitam.storage.engine.server.distribution.impl.TransferThread;
import fr.gouv.vitam.storage.engine.server.distribution.impl.TransfertTimeoutHelper;
import fr.gouv.vitam.storage.engine.server.distribution.impl.bulk.BulkStorageDistribution;
import fr.gouv.vitam.storage.engine.server.rest.StorageConfiguration;
import fr.gouv.vitam.storage.engine.server.spi.DriverManager;
import fr.gouv.vitam.storage.engine.server.storagelog.StorageLog;
import fr.gouv.vitam.storage.engine.server.storagelog.parameters.AccessLogParameters;
import fr.gouv.vitam.storage.engine.server.storagelog.parameters.StorageLogbookOutcome;
import fr.gouv.vitam.storage.engine.server.storagelog.parameters.StorageLogbookParameterName;
import fr.gouv.vitam.storage.engine.server.storagelog.parameters.StorageLogbookParameters;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageNotFoundException;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

public class StorageDistributionImpl
implements StorageDistribution {
    private static final String DEFAULT_SIZE_WHEN_UNKNOWN = "1000000";
    private static final String STRATEGY_ID_IS_MANDATORY = "Strategy id is mandatory";
    private static final String CATEGORY_IS_MANDATORY = "Category (object type) is mandatory";
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(StorageDistributionImpl.class);
    private static final StorageStrategyProvider STRATEGY_PROVIDER = StorageStrategyProviderFactory.getDefaultProvider();
    private static final StorageOfferProvider OFFER_PROVIDER = StorageOfferProviderFactory.getDefaultProvider();
    private static final String NOT_IMPLEMENTED_MSG = "Not yet implemented";
    public static final String NORMAL_ORIGIN = "normal";
    public static final String COPY_OBJECT_ORIGIN = "copy_object";
    private final RetryableParameters retryableParameters = new RetryableParameters(3, 1, 5, 3, TimeUnit.SECONDS);
    private final ExecutorService executor = new VitamThreadPoolExecutor();
    private static final String NO_OFFER_IDENTIFIER_SPECIFIED_THIS_IS_MANDATORY = "No offer identifier specified, this is mandatory";
    private static final String INTERRUPTED_ON_OFFER_ID = "Interrupted on offer ID ";
    private static final String OBJECT_ID_IS_MANDATORY = "Object id is mandatory";
    private static final String NO_MESSAGE_RETURNED = "No message returned";
    private static final String ERROR_ON_OFFER_ID = "Error on offer ID ";
    private static final String CANNOT_CREATE_MULTIPLE_INPUT_STREAM = "Cannot create multipleInputStream";
    private static final String ERROR_ENCOUNTERED_IS = "Error encountered is ";
    private static final String INTERRUPTED_AFTER_TIMEOUT_ON_OFFER_ID = "Interrupted after timeout on offer ID ";
    private static final String NO_NEED_TO_RETRY = ", no need to retry";
    private static final String ERROR_WITH_THE_STORAGE_OBJECT_NOT_FOUND_TAKE_NEXT_OFFER_IN_STRATEGY_BY_PRIORITY = "Error with the storage: object not found. Take next offer in strategy (by priority)";
    private static final String ERROR_WITH_THE_STORAGE_TAKE_THE_NEXT_OFFER_IN_THE_STRATEGY_BY_PRIORITY = "Error with the storage, take the next offer in the strategy (by priority)";
    private static final String OFFER_IDS_IS_MANDATORY = "Offer ids is mandatory";
    private static final String LENGTH_IS_EMPTY = "Length is empty";
    private static final String NO_LENGTH_RETURNED = "no Length returned";
    private static final String CONTAINER_GUID_IS_MANDATORY = "Container guid is mandatory";
    private static final String OBJECT_URI_IN_WORKSPACE_IS_MANDATORY = "Object URI in workspace is mandatory";
    private static final String OBJECT_ADDITIONAL_INFORMATION_GUID_IS_MANDATORY = "Object additional information guid is mandatory";
    private static final String OFFER_ID = "offerId";
    private static final String USABLE_SPACE = "usableSpace";
    private static final String NBC = "nbc";
    private static final String STORAGE_SERVICE_CONFIGURATION_IS_MANDATORY = "Storage service configuration is mandatory";
    private static final String CAPACITIES = "capacities";
    private static final String ATTEMPT = " attempt ";
    private static final String OFFERS_LIST_IS_MANDATORY = "Offers List is mandatory";
    public static final String DIGEST = "digest";
    private final String urlWorkspace;
    private final TransfertTimeoutHelper transfertTimeoutHelper;
    private final DigestType digestType;
    private final StorageLog storageLogService;
    private final WorkspaceClientFactory workspaceClientFactory;
    private final BulkStorageDistribution bulkStorageDistribution;

    StorageDistributionImpl(StorageConfiguration configuration, StorageLog storageLogService) throws StorageTechnicalException {
        ParametersChecker.checkParameter((String)STORAGE_SERVICE_CONFIGURATION_IS_MANDATORY, (Object[])new Object[]{configuration});
        this.urlWorkspace = configuration.getUrlWorkspace();
        WorkspaceClientFactory.changeMode((String)this.urlWorkspace, (WorkspaceType)WorkspaceType.VITAM);
        this.workspaceClientFactory = WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM);
        this.storageLogService = storageLogService;
        this.digestType = VitamConfiguration.getDefaultDigestType();
        this.transfertTimeoutHelper = new TransfertTimeoutHelper(configuration.getTimeoutMsPerKB().intValue(), configuration.getMinWriteTimeoutMs(), configuration.getMinBulkWriteTimeoutMsPerObject());
        this.bulkStorageDistribution = new BulkStorageDistribution(3, this.workspaceClientFactory, this.storageLogService, this.transfertTimeoutHelper);
        this.validateStrategyOffers();
    }

    @VisibleForTesting
    StorageDistributionImpl(WorkspaceClientFactory workspaceClientFactory, DigestType digestType, StorageLog storageLogService, BulkStorageDistribution bulkStorageDistribution) {
        this.urlWorkspace = null;
        this.transfertTimeoutHelper = new TransfertTimeoutHelper(100L, 60000, 10000);
        this.workspaceClientFactory = workspaceClientFactory;
        this.digestType = digestType;
        this.storageLogService = storageLogService;
        this.bulkStorageDistribution = bulkStorageDistribution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StoredInfoResult copyObjectFromOfferToOffer(DataContext context, String sourceOffer, String destinationOffer) throws StorageException {
        Response resp;
        block5: {
            StoredInfoResult storedInfoResult;
            JsonNode containerInformation = this.getContainerInformation(context.getStrategyId(), context.getCategory(), context.getObjectId(), Lists.newArrayList((Object[])new String[]{sourceOffer, destinationOffer}), false);
            boolean existsSourceOffer = containerInformation.get(sourceOffer) != null;
            boolean bl = existsSourceOffer = existsSourceOffer && containerInformation.get(sourceOffer).get(DIGEST) != null;
            if (!existsSourceOffer) {
                throw new StorageNotFoundException(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_OBJECT_NOT_FOUND, (Object[])new Object[]{context.getObjectId()}));
            }
            resp = null;
            try {
                resp = this.getContainerByCategory(context.getStrategyId(), COPY_OBJECT_ORIGIN, context.getObjectId(), context.getCategory(), sourceOffer);
                if (resp == null) {
                    throw new StorageTechnicalException(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR, (Object[])new Object[0]));
                }
                boolean existsDestinationOffer = containerInformation.get(destinationOffer) != null;
                boolean bl2 = existsDestinationOffer = existsDestinationOffer && containerInformation.get(destinationOffer).get(DIGEST) != null;
                if (existsDestinationOffer) {
                    this.deleteObjectInOffers(context.getStrategyId(), context, Collections.singletonList(destinationOffer));
                }
                if (resp.getStatus() != Response.Status.OK.getStatusCode()) break block5;
                storedInfoResult = this.storeDataInOffers(context.getStrategyId(), NORMAL_ORIGIN, context.getObjectId(), context.getCategory(), context.getRequester(), Collections.singletonList(destinationOffer), resp);
            }
            catch (Throwable throwable) {
                DefaultClient.staticConsumeAnyEntityAndClose(resp);
                throw throwable;
            }
            DefaultClient.staticConsumeAnyEntityAndClose((Response)resp);
            return storedInfoResult;
        }
        DefaultClient.staticConsumeAnyEntityAndClose((Response)resp);
        throw new StorageTechnicalException(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR, (Object[])new Object[0]));
    }

    private StorageLogbookParameters sendDataToOffersWithRetries(DataContext dataContext, OffersToCopyIn offersParams, ObjectDescription description) throws StorageException {
        AtomicInteger attempt = new AtomicInteger();
        AtomicBoolean needToRetry = new AtomicBoolean(true);
        DelegateRetry delegate = () -> {
            StreamAndInfo streamAndInfo = this.getInputStreamFromWorkspace(description);
            try {
                StorageLogbookParameters storageLogbookParameters = this.sendDataToOffers(streamAndInfo, dataContext, offersParams, NORMAL_ORIGIN, attempt.incrementAndGet(), needToRetry);
                if (streamAndInfo != null) {
                    streamAndInfo.close();
                }
                return storageLogbookParameters;
            }
            catch (Throwable throwable) {
                try {
                    if (streamAndInfo != null) {
                        try {
                            streamAndInfo.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (StorageNotFoundException e) {
                    needToRetry.set(false);
                    throw e;
                }
            }
        };
        RetryableOnResult retryable = new RetryableOnResult(this.retryableParameters, p -> needToRetry.get() && !offersParams.getKoOffers().isEmpty());
        return (StorageLogbookParameters)retryable.exec(delegate);
    }

    @Override
    public StoredInfoResult storeDataInOffers(String strategyId, String origin, String objectId, DataCategory category, String requester, List<String> offerIds, Response response) throws StorageException {
        Long size = Long.valueOf(response.getHeaderString(VitamHttpHeader.X_CONTENT_LENGTH.getName()));
        try (StreamAndInfo streamAndInfo = new StreamAndInfo((InputStream)new VitamAsyncInputStream(response), size);){
            StoredInfoResult storedInfoResult = this.storeDataInOffers(strategyId, origin, streamAndInfo, objectId, category, requester, offerIds);
            return storedInfoResult;
        }
    }

    @Override
    public StoredInfoResult storeDataInOffers(String strategyId, String origin, StreamAndInfo streamAndInfo, String objectId, DataCategory category, String requester, List<String> offerIds) throws StorageException {
        Integer tenantId = ParameterHelper.getTenantParameter();
        ParametersChecker.checkParameter((String)STRATEGY_ID_IS_MANDATORY, (String[])new String[]{strategyId});
        ParametersChecker.checkParameter((String)OBJECT_ID_IS_MANDATORY, (String[])new String[]{objectId});
        ParametersChecker.checkParameter((String)CATEGORY_IS_MANDATORY, (Object[])new Object[]{category});
        StorageStrategy storageStrategy = this.checkStrategy(strategyId);
        List strategyOfferIds = storageStrategy.getOffers().stream().map(OfferReference::getId).collect(Collectors.toList());
        ArrayList<StorageOffer> offers = new ArrayList<StorageOffer>();
        if (offerIds != null) {
            for (String offerId : offerIds) {
                if (strategyOfferIds.contains(offerId)) {
                    offers.add(OFFER_PROVIDER.getStorageOffer(offerId));
                    continue;
                }
                LOGGER.error("Offer {} ignored : not found in strategy {}", (Object)offerId, (Object)strategyId);
            }
        } else {
            for (String offerId : strategyOfferIds) {
                offers.add(OFFER_PROVIDER.getStorageOffer(offerId));
            }
        }
        OffersToCopyIn offersToCopyIn = new OffersToCopyIn(offers);
        DataContext dataContext = new DataContext(objectId, category, requester, tenantId, strategyId);
        StorageLogbookParameters parameters = this.sendDataToOffers(streamAndInfo, dataContext, offersToCopyIn, origin, 1, new AtomicBoolean(false));
        try {
            this.logStorage(tenantId, parameters);
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
        }
        return this.buildStoreDataResponse(objectId, category, parameters.getMapParameters().get((Object)StorageLogbookParameterName.digest), strategyId, offersToCopyIn.getGlobalOfferResult());
    }

    private StorageStrategy checkStrategy(String strategyId) throws StorageTechnicalException, StorageNotFoundException {
        StorageStrategy storageStrategy = STRATEGY_PROVIDER.getStorageStrategy(strategyId);
        if (storageStrategy == null) {
            throw new StorageNotFoundException(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_STRATEGY_NOT_FOUND, (Object[])new Object[0]));
        }
        return storageStrategy;
    }

    private StorageLogbookParameters startCopyToOffers(DataContext dataContext, OffersToCopyIn data, String origin, int attempt, Long size, Digest globalDigest, MultiplePipedInputStream streams, Map<String, Future<ThreadResponseData>> futureMap) {
        int tenantId = VitamThreadUtils.getVitamSession().getTenantId();
        String requestId = VitamThreadUtils.getVitamSession().getRequestId();
        String offerIdString = null;
        StorageLogbookParameters parameters = null;
        int rank = 0;
        try {
            for (int i = 0; i < data.getKoOffers().size(); ++i) {
                offerIdString = data.getKoOffers().get(i);
                OfferReference offerReference = new OfferReference(offerIdString);
                Driver driver = this.retrieveDriverInternal(offerIdString);
                BufferedInputStream inputStream = new BufferedInputStream(streams.getInputStream(rank));
                UploadCountingInputStreamMetrics offerInputStream = new UploadCountingInputStreamMetrics(dataContext.getTenantId(), dataContext.getStrategyId(), offerIdString, origin, dataContext.getCategory(), attempt, (InputStream)inputStream);
                StoragePutRequest request = new StoragePutRequest(dataContext.getTenantId(), dataContext.getCategory().getFolder(), dataContext.getObjectId(), this.digestType.getName(), (InputStream)offerInputStream);
                futureMap.put(offerIdString, this.executor.submit(new TransferThread(tenantId, requestId, driver, offerReference, request, globalDigest, size)));
                ++rank;
            }
        }
        catch (StorageException e) {
            LOGGER.error(INTERRUPTED_ON_OFFER_ID + offerIdString, (Throwable)e);
            parameters = this.setLogbookStorageParameters(null, offerIdString, null, dataContext.getRequester(), attempt, Response.Status.INTERNAL_SERVER_ERROR, dataContext.getCategory().getFolder());
        }
        return parameters;
    }

    @Override
    public StoredInfoResult storeDataInAllOffers(String strategyId, String objectId, ObjectDescription createObjectDescription, DataCategory category, String requester) throws StorageException {
        Integer tenantId = ParameterHelper.getTenantParameter();
        this.checkStoreDataParams(createObjectDescription, strategyId, objectId, category);
        List<StorageOffer> storageOffers = this.getStorageOffers(strategyId);
        OffersToCopyIn offersToCopyIn = new OffersToCopyIn(storageOffers);
        DataContext dataContext = new DataContext(objectId, category, requester, tenantId, strategyId);
        StorageLogbookParameters parameters = this.sendDataToOffersWithRetries(dataContext, offersToCopyIn, createObjectDescription);
        try {
            this.logStorage(tenantId, parameters);
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
        }
        return this.buildStoreDataResponse(objectId, category, parameters.getMapParameters().get((Object)StorageLogbookParameterName.digest), strategyId, offersToCopyIn.getGlobalOfferResult());
    }

    private List<StorageOffer> getStorageOffers(String strategyId) throws StorageTechnicalException, StorageNotFoundException {
        StorageStrategy storageStrategy = this.checkStrategy(strategyId);
        List<OfferReference> offerReferences = this.getOfferListFromHotStrategy(storageStrategy);
        return offerReferences.stream().map(StorageDistributionImpl::apply).collect(Collectors.toList());
    }

    @Override
    public BulkObjectStoreResponse bulkCreateFromWorkspace(String strategyId, BulkObjectStoreRequest bulkObjectStoreRequest, String requester) throws StorageException {
        Integer tenantId = ParameterHelper.getTenantParameter();
        List<String> offerIds = this.getStorageOffers(strategyId).stream().map(StorageOffer::getId).collect(Collectors.toList());
        HashMap<String, Driver> storageDrivers = new HashMap<String, Driver>();
        for (String string : offerIds) {
            storageDrivers.put(string, this.retrieveDriverInternal(string));
        }
        HashMap<String, StorageOffer> storageOffers = new HashMap<String, StorageOffer>();
        for (String offerId : offerIds) {
            storageOffers.put(offerId, OFFER_PROVIDER.getStorageOffer(offerId));
        }
        Map<String, String> map = this.bulkStorageDistribution.bulkCreateFromWorkspaceWithRetries(strategyId, tenantId, offerIds, storageDrivers, storageOffers, bulkObjectStoreRequest.getType(), bulkObjectStoreRequest.getWorkspaceContainerGUID(), bulkObjectStoreRequest.getWorkspaceObjectURIs(), bulkObjectStoreRequest.getObjectNames(), requester);
        return new BulkObjectStoreResponse(offerIds, this.digestType.getName(), map);
    }

    @Override
    public List<String> getOfferIds(String strategyId) throws StorageException {
        StorageStrategy storageStrategy = this.checkStrategy(strategyId);
        return storageStrategy.getOffers().stream().map(OfferReference::getId).collect(Collectors.toList());
    }

    @Override
    public Map<String, StorageStrategy> getStrategies() throws StorageException {
        return STRATEGY_PROVIDER.getStorageStrategies();
    }

    @Override
    public Optional<String> createAccessRequestIfRequired(String strategyId, String optionalOfferId, DataCategory dataCategory, List<String> objectsNames) throws StorageException {
        Optional<String> optional;
        block10: {
            if (objectsNames.isEmpty()) {
                LOGGER.debug("No access request required. Empty objectsNames");
                return Optional.empty();
            }
            OfferReference offerReference = this.selectFirstOffer(strategyId, optionalOfferId);
            StorageOffer offer = OFFER_PROVIDER.getStorageOffer(offerReference.getId(), false);
            if (!offer.isAsyncRead()) {
                LOGGER.debug("Offer {} is synchronous, no access request required", (Object)offer.getId());
                return Optional.empty();
            }
            LOGGER.debug("Offer {} is asynchronous, creating access request", (Object)offer.getId());
            Driver driver = this.retrieveDriverInternal(offerReference.getId());
            Connection connection = driver.connect(offer.getId());
            try {
                String accessRequestId = connection.createAccessRequest(new StorageAccessRequestCreationRequest(VitamThreadUtils.getVitamSession().getTenantId(), dataCategory.getFolder(), objectsNames));
                LOGGER.debug("AccessRequestId '{}' created for asynchronous offer {}", (Object)accessRequestId, (Object)offer.getId());
                optional = Optional.of(accessRequestId);
                if (connection == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (StorageDriverException | RuntimeException e) {
                    throw new StorageTechnicalException("Could not create AccessRequest", e);
                }
            }
            connection.close();
        }
        return optional;
    }

    @Override
    public Map<String, AccessRequestStatus> checkAccessRequestStatuses(String strategyId, String optionalOfferId, List<String> accessRequestIds, boolean adminCrossTenantAccessRequestAllowed) throws StorageException {
        Map map;
        block9: {
            OfferReference offerReference = this.selectFirstOffer(strategyId, optionalOfferId);
            StorageOffer offer = OFFER_PROVIDER.getStorageOffer(offerReference.getId(), false);
            if (!offer.isAsyncRead()) {
                throw new StorageIllegalOperationException("Expected offer " + offerReference.getId() + " to be asynchronous.");
            }
            LOGGER.debug("Checking access request ids for offer {}", (Object)offerReference.getId());
            Driver driver = this.retrieveDriverInternal(offerReference.getId());
            Connection connection = driver.connect(offer.getId());
            try {
                Map accessRequestStatuses = connection.checkAccessRequestStatuses(accessRequestIds, VitamThreadUtils.getVitamSession().getTenantId().intValue(), adminCrossTenantAccessRequestAllowed);
                LOGGER.debug("Access request statuses {}", (Object)accessRequestStatuses);
                map = accessRequestStatuses;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (StorageDriverException | RuntimeException e) {
                    throw new StorageTechnicalException("Could not check access request ids", e);
                }
            }
            connection.close();
        }
        return map;
    }

    @Override
    public void removeAccessRequest(String strategyId, String optionalOfferId, String accessRequestId, boolean adminCrossTenantAccessRequestAllowed) throws StorageException {
        OfferReference offerReference = this.selectFirstOffer(strategyId, optionalOfferId);
        StorageOffer offer = OFFER_PROVIDER.getStorageOffer(offerReference.getId(), false);
        if (!offer.isAsyncRead()) {
            throw new StorageIllegalOperationException("Expected offer " + offerReference.getId() + " to be asynchronous.");
        }
        LOGGER.debug("Deleting access request id {} from offer {}", (Object)accessRequestId, (Object)offerReference.getId());
        Driver driver = this.retrieveDriverInternal(offerReference.getId());
        try (Connection connection = driver.connect(offer.getId());){
            connection.removeAccessRequest(accessRequestId, VitamThreadUtils.getVitamSession().getTenantId().intValue(), adminCrossTenantAccessRequestAllowed);
            LOGGER.debug("Access request removed successfully {}", (Object)accessRequestId);
        }
        catch (StorageDriverException | RuntimeException e) {
            throw new StorageTechnicalException("Could not remove access request " + accessRequestId, e);
        }
    }

    @Override
    public boolean checkObjectAvailability(String strategyId, String optionalOfferId, DataCategory dataCategory, List<String> objectsNames) throws StorageException {
        boolean bl;
        block12: {
            if (objectsNames.isEmpty()) {
                LOGGER.debug("No objects to check.");
                return true;
            }
            OfferReference offerReference = this.selectFirstOffer(strategyId, optionalOfferId);
            StorageOffer offer = OFFER_PROVIDER.getStorageOffer(offerReference.getId(), false);
            if (!offer.isAsyncRead()) {
                LOGGER.debug("Offer {} is synchronous, objects {} are availability for immediate access", (Object)offer.getId(), objectsNames);
                return true;
            }
            LOGGER.debug("Offer {} is asynchronous, checking object availability", (Object)offer.getId());
            Driver driver = this.retrieveDriverInternal(offerReference.getId());
            Connection connection = driver.connect(offer.getId());
            try {
                boolean areObjectsAvailable = connection.checkObjectAvailability(new StorageCheckObjectAvailabilityRequest(VitamThreadUtils.getVitamSession().getTenantId(), dataCategory.getFolder(), objectsNames));
                if (areObjectsAvailable) {
                    LOGGER.debug("Objects {} are AVAILABLE", objectsNames);
                } else {
                    LOGGER.debug("Objects {} are NOT AVAILABLE", objectsNames);
                }
                bl = areObjectsAvailable;
                if (connection == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (StorageDriverException | RuntimeException e) {
                    throw new StorageTechnicalException("Could not check object availability", e);
                }
            }
            connection.close();
        }
        return bl;
    }

    @Override
    public String getReferentOffer(String strategyId) throws StorageTechnicalException, StorageNotFoundException {
        StorageStrategy storageStrategy = this.checkStrategy(strategyId);
        return this.chooseReferentOffer(storageStrategy).getId();
    }

    @Override
    public Response launchOfferLogCompaction(String offerReferenceId, Integer tenantId) throws StorageException {
        Response response;
        block9: {
            Driver driver = this.retrieveDriverInternal(offerReferenceId);
            StorageOffer offer = OFFER_PROVIDER.getStorageOffer(offerReferenceId);
            Connection connection = driver.connect(offer.getId());
            try {
                response = connection.launchOfferLogCompaction(new VitamContext(tenantId));
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (StorageDriverException | RuntimeException e) {
                    if (e instanceof StorageDriverPreconditionFailedException) {
                        LOGGER.error(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_BAD_REQUEST, (Object[])new Object[0]), e);
                        throw new IllegalArgumentException(e);
                    }
                    LOGGER.error(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR, (Object[])new Object[0]), e);
                    throw new StorageTechnicalException(e);
                }
            }
            connection.close();
        }
        return response;
    }

    private OfferReference selectFirstOffer(String strategyId, String optionalOfferId) throws StorageTechnicalException, StorageNotFoundException, StorageDriverNotFoundException {
        ParametersChecker.checkParameter((String)STRATEGY_ID_IS_MANDATORY, (String[])new String[]{strategyId});
        StorageStrategy storageStrategy = this.checkStrategy(strategyId);
        if (optionalOfferId == null) {
            return (OfferReference)storageStrategy.getOffers().stream().findFirst().orElseThrow(() -> new StorageDriverNotFoundException("No active offer found in strategy " + strategyId));
        }
        return storageStrategy.getOffers().stream().filter(offerRef -> optionalOfferId.equals(offerRef.getId())).findFirst().orElseThrow(() -> new StorageDriverNotFoundException("No active offer found with Id '" + optionalOfferId + "' in strategy " + strategyId));
    }

    private StorageLogbookParameters sendDataToOffers(StreamAndInfo streamAndInfo, DataContext dataContext, OffersToCopyIn offersParams, String origin, int attempt, AtomicBoolean needToRetry) throws StorageTechnicalException {
        StorageLogbookParameters parameters;
        Digest globalDigest = new Digest(this.digestType);
        try (InputStream digestInputStream = globalDigest.getDigestInputStream(streamAndInfo.getStream());
             MultiplePipedInputStream streams = new MultiplePipedInputStream(digestInputStream, offersParams.getKoOffers().size());){
            HashMap<String, Future<ThreadResponseData>> futureMap = new HashMap<String, Future<ThreadResponseData>>();
            long finalTimeout = this.transfertTimeoutHelper.getTransferTimeout(streamAndInfo.getSize());
            TimeoutStopwatch timeoutStopwatch = new TimeoutStopwatch(finalTimeout);
            parameters = this.startCopyToOffers(dataContext, offersParams, origin, attempt, streamAndInfo.getSize(), globalDigest, streams, futureMap);
            for (Map.Entry entry : futureMap.entrySet()) {
                Future future = (Future)entry.getValue();
                streams.throwLastException();
                String offerId = (String)entry.getKey();
                try {
                    ThreadResponseData threadResponseData = (ThreadResponseData)future.get(timeoutStopwatch.getRemainingDelayInMilliseconds(), TimeUnit.MILLISECONDS);
                    if (threadResponseData == null) {
                        LOGGER.error(ERROR_ON_OFFER_ID + offerId);
                        parameters = this.setLogbookStorageParameters(parameters, offerId, null, dataContext.getRequester(), attempt, Response.Status.INTERNAL_SERVER_ERROR, dataContext.getCategory().getFolder());
                        throw new StorageTechnicalException(NO_MESSAGE_RETURNED);
                    }
                    parameters = this.setLogbookStorageParameters(parameters, offerId, threadResponseData, dataContext.getRequester(), attempt, threadResponseData.getStatus(), dataContext.getCategory().getFolder());
                    offersParams.koListToOkList(offerId);
                }
                catch (TimeoutException e) {
                    LOGGER.info("Timeout on offer ID {} TimeOut: {}", new Object[]{offerId, finalTimeout, e});
                    future.cancel(true);
                    LOGGER.error(INTERRUPTED_AFTER_TIMEOUT_ON_OFFER_ID + offerId);
                    parameters = this.setLogbookStorageParameters(parameters, offerId, null, dataContext.getRequester(), attempt, null, dataContext.getCategory().getFolder());
                }
                catch (InterruptedException e) {
                    LOGGER.error(INTERRUPTED_ON_OFFER_ID + offerId, (Throwable)e);
                    parameters = this.setLogbookStorageParameters(parameters, offerId, null, dataContext.getRequester(), attempt, null, dataContext.getCategory().getFolder());
                }
                catch (ExecutionException e) {
                    StorageDriverException ex;
                    LOGGER.error(ERROR_ON_OFFER_ID + offerId, (Throwable)e);
                    Response.Status status = Response.Status.INTERNAL_SERVER_ERROR;
                    if (e.getCause() instanceof StorageDriverConflictException) {
                        status = Response.Status.CONFLICT;
                        offersParams.changeStatus(offerId, status);
                    }
                    parameters = this.setLogbookStorageParameters(parameters, offerId, null, dataContext.getRequester(), attempt, status, dataContext.getCategory().getFolder());
                    if (e.getCause() instanceof StorageInconsistentStateException) {
                        LOGGER.error(ERROR_ENCOUNTERED_IS + e.getCause().getClass() + NO_NEED_TO_RETRY, (Throwable)e);
                        needToRetry.set(false);
                        continue;
                    }
                    if (!(e.getCause() instanceof StorageDriverException) || (ex = (StorageDriverException)e.getCause()).isShouldRetry()) continue;
                    LOGGER.error(ERROR_ENCOUNTERED_IS + e.getCause().getClass() + NO_NEED_TO_RETRY, (Throwable)ex);
                    needToRetry.set(false);
                }
            }
            streams.throwLastException();
        }
        catch (IOException e) {
            LOGGER.error(CANNOT_CREATE_MULTIPLE_INPUT_STREAM, (Throwable)e);
            throw new StorageTechnicalException(CANNOT_CREATE_MULTIPLE_INPUT_STREAM, (Throwable)e);
        }
        return parameters;
    }

    private StreamAndInfo getInputStreamFromWorkspace(ObjectDescription createObjectDescription) throws StorageTechnicalException, StorageNotFoundException {
        try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
            StreamAndInfo streamAndInfo = this.retrieveDataFromWorkspace(createObjectDescription.getWorkspaceContainerGUID(), createObjectDescription.getWorkspaceObjectURI(), workspaceClient);
            return streamAndInfo;
        }
    }

    private StorageLogbookParameters setLogbookStorageParameters(StorageLogbookParameters parameters, String offerId, ThreadResponseData res, String requester, int attempt, Response.Status status, String dataCategoty) {
        if (status == null) {
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        if (parameters == null) {
            parameters = this.getParameters(res != null ? res.getObjectGuid() : null, dataCategoty, res != null ? (StoragePutResult)res.getResponse() : null, offerId, res != null ? res.getStatus() : status, requester, attempt);
        } else {
            this.updateStorageLogbookParameters(parameters, offerId, res != null ? res.getStatus() : status, attempt);
        }
        return parameters;
    }

    private void logStorage(Integer tenant, StorageLogbookParameters parameters) throws IOException {
        this.storageLogService.appendWriteLog(tenant, parameters);
    }

    private StoredInfoResult buildStoreDataResponse(String objectId, DataCategory category, String digest, String strategy, Map<String, Response.Status> offerResults) throws StorageTechnicalException, StorageAlreadyExistsException {
        String offerIds = String.join((CharSequence)", ", offerResults.keySet());
        boolean allWithoutInternalServerError = offerResults.values().stream().noneMatch(arg_0 -> Response.Status.INTERNAL_SERVER_ERROR.equals(arg_0));
        boolean allWithoutAlreadyExists = offerResults.values().stream().noneMatch(arg_0 -> Response.Status.CONFLICT.equals(arg_0));
        if (!allWithoutInternalServerError) {
            LOGGER.error(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_CANT_STORE_OBJECT, (Object[])new Object[]{objectId, offerIds}));
            throw new StorageTechnicalException(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_CANT_STORE_OBJECT, (Object[])new Object[]{objectId, offerIds}));
        }
        if (!allWithoutAlreadyExists) {
            LOGGER.error(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_DRIVER_OBJECT_ALREADY_EXISTS, (Object[])new Object[]{objectId, offerIds}));
            throw new StorageAlreadyExistsException(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_DRIVER_OBJECT_ALREADY_EXISTS, (Object[])new Object[]{objectId, offerIds}));
        }
        StoredInfoResult result = new StoredInfoResult();
        String now = LocalDateUtil.nowFormatted();
        StringBuilder description = new StringBuilder();
        switch (category) {
            case UNIT: {
                description.append("Unit ");
                break;
            }
            case OBJECTGROUP: {
                description.append("ObjectGroup ");
                break;
            }
            case LOGBOOK: {
                description.append("Logbook ");
                break;
            }
            case OBJECT: {
                description.append("Object ");
                break;
            }
            case REPORT: {
                description.append("Report ");
                break;
            }
            case MANIFEST: {
                description.append("Manifest ");
                break;
            }
            case PROFILE: {
                description.append("Profile ");
                break;
            }
            case STORAGELOG: {
                description.append("Storagelog ");
                break;
            }
            case STORAGEACCESSLOG: {
                description.append("StorageAccessLog ");
                break;
            }
            case STORAGETRACEABILITY: {
                description.append("STORAGETRACEABILITY");
                break;
            }
            case RULES: {
                description.append("Rules ");
                break;
            }
            case DIP: {
                description.append("DIP ");
                break;
            }
            case AGENCIES: {
                description.append("Agencies ");
                break;
            }
            case BACKUP: {
                description.append("Backup ");
                break;
            }
            case BACKUP_OPERATION: {
                description.append("Backup Operation ");
                break;
            }
            case UNIT_GRAPH: {
                description.append("UNIT_GRAPH ");
                break;
            }
            case OBJECTGROUP_GRAPH: {
                description.append("OBJECTGROUP_GRAPH ");
                break;
            }
            case ACCESSION_REGISTER_DETAIL: {
                description.append("ACCESSION_REGISTER_DETAIL ");
                break;
            }
            case ACCESSION_REGISTER_SYMBOLIC: {
                description.append("ACCESSION_REGISTER_SYMBOLIC ");
                break;
            }
            case DISTRIBUTIONREPORTS: {
                description.append("DISTRIBUTION_REPORTS ");
                break;
            }
            case ARCHIVAL_TRANSFER_REPLY: {
                description.append("ARCHIVAL_TRANSFER_REPLY ");
                break;
            }
            case TMP: {
                description.append("TMP ");
                break;
            }
            default: {
                throw new UnsupportedOperationException(NOT_IMPLEMENTED_MSG);
            }
        }
        description.append("with id '");
        description.append(objectId);
        description.append("' stored successfully");
        result.setId(objectId);
        result.setInfo(description.toString());
        result.setCreationTime(now);
        result.setLastAccessTime(now);
        result.setLastCheckedTime(now);
        result.setLastModifiedTime(now);
        result.setNbCopy(offerResults.size());
        result.setStrategy(strategy);
        result.setOfferIds(Arrays.asList(offerResults.keySet().toArray(new String[0])));
        result.setDigestType(this.digestType.getName());
        result.setDigest(digest);
        LOGGER.debug("DEBUG result: {}", (Object)result);
        return result;
    }

    private StorageLogbookParameters getParameters(String objectGuid, String dataCategory, StoragePutResult putObjectResult, String offerId, Response.Status objectStored, String requester, int attempt) {
        String objectIdentifier = objectGuid != null ? objectGuid : "objectRequest NA";
        String messageDig = putObjectResult != null ? putObjectResult.getDigestHashBase16() : "messageDigest NA";
        String size = putObjectResult != null ? String.valueOf(putObjectResult.getObjectSize()) : "Size NA";
        boolean error = objectStored == Response.Status.INTERNAL_SERVER_ERROR;
        StorageLogbookOutcome outcome = error ? StorageLogbookOutcome.KO : StorageLogbookOutcome.OK;
        return StorageLogbookParameters.createLogParameters(objectIdentifier, dataCategory, messageDig, this.digestType.getName(), size, this.getAttemptLog(offerId, attempt, error), requester, outcome);
    }

    private String getAttemptLog(String offerId, int attempt, boolean error) {
        return offerId + ATTEMPT + attempt + " : " + (error ? "KO" : "OK");
    }

    private void updateStorageLogbookParameters(StorageLogbookParameters parameters, String offerId, Response.Status status, int attempt) {
        Object offers = parameters.getMapParameters().get((Object)StorageLogbookParameterName.agentIdentifiers);
        if (Response.Status.INTERNAL_SERVER_ERROR.equals((Object)status) || Response.Status.CONFLICT.equals((Object)status)) {
            parameters.getMapParameters().put(StorageLogbookParameterName.outcome, StorageLogbookOutcome.KO.name());
            offers = (String)offers + ", " + offerId + ATTEMPT + attempt + " : KO - " + status.name();
        } else {
            offers = (String)offers + ", " + offerId + ATTEMPT + attempt + " : OK";
            parameters.setStatus(StorageLogbookOutcome.OK);
        }
        parameters.getMapParameters().put(StorageLogbookParameterName.agentIdentifiers, (String)offers);
    }

    private Driver retrieveDriverInternal(String offerId) throws StorageTechnicalException {
        try {
            return DriverManager.getDriverFor(offerId);
        }
        catch (StorageDriverNotFoundException e) {
            throw new StorageTechnicalException((Throwable)e);
        }
    }

    private void checkStoreDataParams(ObjectDescription createObjectDescription, String strategyId, String dataId, DataCategory category) {
        ParametersChecker.checkParameter((String)STRATEGY_ID_IS_MANDATORY, (String[])new String[]{strategyId});
        ParametersChecker.checkParameter((String)OBJECT_ID_IS_MANDATORY, (String[])new String[]{dataId});
        ParametersChecker.checkParameter((String)CATEGORY_IS_MANDATORY, (Object[])new Object[]{category});
        ParametersChecker.checkParameter((String)OBJECT_ADDITIONAL_INFORMATION_GUID_IS_MANDATORY, (Object[])new Object[]{createObjectDescription});
        ParametersChecker.checkParameter((String)CONTAINER_GUID_IS_MANDATORY, (String[])new String[]{createObjectDescription.getWorkspaceContainerGUID()});
        ParametersChecker.checkParameter((String)OBJECT_URI_IN_WORKSPACE_IS_MANDATORY, (String[])new String[]{createObjectDescription.getWorkspaceObjectURI()});
    }

    private StreamAndInfo retrieveDataFromWorkspace(String containerGUID, String objectURI, WorkspaceClient workspaceClient) throws StorageNotFoundException, StorageTechnicalException {
        try {
            Response response = workspaceClient.getObject(containerGUID, objectURI);
            String length = response.getHeaderString(VitamHttpHeader.X_CONTENT_LENGTH.getName());
            Object entity = response.getEntity();
            if (entity == null) {
                LOGGER.error(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_OBJECT_NOT_FOUND, (Object[])new Object[]{containerGUID}));
                throw new StorageNotFoundException(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_OBJECT_NOT_FOUND, (Object[])new Object[]{containerGUID}));
            }
            try {
                ParametersChecker.checkParameter((String)LENGTH_IS_EMPTY, (String[])new String[]{length});
                Long.valueOf(length);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn(NO_LENGTH_RETURNED, (Throwable)e);
                length = DEFAULT_SIZE_WHEN_UNKNOWN;
            }
            return new StreamAndInfo((InputStream)new VitamAsyncInputStream(response), Long.valueOf(length));
        }
        catch (ContentAddressableStorageNotFoundException e) {
            LOGGER.error(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_OBJECT_NOT_FOUND, (Object[])new Object[]{containerGUID}), (Throwable)e);
            throw new StorageNotFoundException((Throwable)e);
        }
        catch (ContentAddressableStorageServerException e) {
            LOGGER.error(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR, (Object[])new Object[0]), (Throwable)e);
            throw new StorageTechnicalException((Throwable)e);
        }
    }

    @Override
    public JsonNode getContainerInformation(String strategyId) throws StorageException {
        Integer tenantId = ParameterHelper.getTenantParameter();
        ParametersChecker.checkParameter((String)STRATEGY_ID_IS_MANDATORY, (String[])new String[]{strategyId});
        StorageStrategy storageStrategy = this.checkStrategy(strategyId);
        List<OfferReference> offerReferences = this.getOfferListFromHotStrategy(storageStrategy);
        ArrayNode resultArray = JsonHandler.createArrayNode();
        for (OfferReference offerReference : offerReferences) {
            resultArray.add(this.getOfferInformation(offerReference, tenantId, offerReferences.size()));
        }
        return JsonHandler.createObjectNode().set(CAPACITIES, (JsonNode)resultArray);
    }

    private List<OfferReference> checkCoherentOfferRanksAndSort(List<OfferReference> offerReferences) throws StorageTechnicalException {
        if ((long)offerReferences.size() != offerReferences.stream().filter(elmt -> null != elmt.getRank()).map(OfferReference::getRank).distinct().count()) {
            throw new StorageTechnicalException(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_OFFER_EXCEPTION_RANK, (Object[])new Object[0]));
        }
        return offerReferences.stream().sorted(Comparator.comparing(OfferReference::getRank)).collect(Collectors.toList());
    }

    private JsonNode getOfferInformation(OfferReference offerReference, Integer tenantId, int nbCopy) throws StorageException {
        ObjectNode objectNode;
        block9: {
            Driver driver = this.retrieveDriverInternal(offerReference.getId());
            StorageOffer offer = OFFER_PROVIDER.getStorageOffer(offerReference.getId());
            Connection connection = driver.connect(offer.getId());
            try {
                ObjectNode ret = JsonHandler.createObjectNode();
                ret.put(OFFER_ID, offerReference.getId());
                ret.put(USABLE_SPACE, connection.getStorageCapacity(tenantId).getUsableSpace());
                ret.put(NBC, nbCopy);
                objectNode = ret;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (StorageDriverException | RuntimeException e) {
                    if (e instanceof StorageDriverPreconditionFailedException) {
                        LOGGER.error(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_BAD_REQUEST, (Object[])new Object[0]), e);
                        throw new IllegalArgumentException(e);
                    }
                    LOGGER.error(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR, (Object[])new Object[0]), e);
                    throw new StorageTechnicalException(e);
                }
            }
            connection.close();
        }
        return objectNode;
    }

    private List<OfferReference> getOfferListFromHotStrategy(StorageStrategy storageStrategy) throws StorageTechnicalException {
        ArrayList<OfferReference> declaredOffers = new ArrayList<OfferReference>();
        if (storageStrategy != null && !storageStrategy.getOffers().isEmpty()) {
            declaredOffers.addAll(storageStrategy.getOffers());
        }
        if (declaredOffers.isEmpty()) {
            LOGGER.error(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_OFFER_NOT_FOUND, (Object[])new Object[0]));
            throw new StorageTechnicalException(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_OFFER_NOT_FOUND, (Object[])new Object[0]));
        }
        return declaredOffers;
    }

    private OfferReference chooseReferentOffer(StorageStrategy storageStrategy) {
        if (storageStrategy != null && !storageStrategy.getOffers().isEmpty()) {
            List offerReferences = storageStrategy.getOffers().stream().filter(OfferReference::isReferent).collect(Collectors.toList());
            return (OfferReference)Iterables.getOnlyElement(offerReferences);
        }
        throw new IllegalArgumentException("Exactly one offer should be declared as 'referent' in hot strategy");
    }

    @Override
    public CloseableIterator<ObjectEntry> listContainerObjects(String strategyId, DataCategory category) throws StorageException {
        ParametersChecker.checkParameter((String)STRATEGY_ID_IS_MANDATORY, (String[])new String[]{strategyId});
        ParametersChecker.checkParameter((String)CATEGORY_IS_MANDATORY, (Object[])new Object[]{category});
        StorageStrategy storageStrategy = STRATEGY_PROVIDER.getStorageStrategy(strategyId);
        if (storageStrategy != null) {
            List<OfferReference> orderedOffersByPriority = this.getOfferListFromHotStrategy(storageStrategy);
            if (orderedOffersByPriority.isEmpty()) {
                LOGGER.error("No offer found");
                throw new StorageTechnicalException("No offer found");
            }
            return this.listContainerObjectsForOffer(category, orderedOffersByPriority.get(0).getId(), false);
        }
        LOGGER.error(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_STRATEGY_NOT_FOUND, (Object[])new Object[0]));
        throw new StorageNotFoundException(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_STRATEGY_NOT_FOUND, (Object[])new Object[0]));
    }

    @Override
    public CloseableIterator<ObjectEntry> listContainerObjectsForOffer(DataCategory category, String offerId, boolean includeDisabled) throws StorageException {
        CloseableIterator closeableIterator;
        block9: {
            OFFER_PROVIDER.getStorageOffer(offerId, includeDisabled);
            Driver driver = this.retrieveDriverInternal(offerId);
            Connection connection = driver.connect(offerId);
            try {
                Integer tenantId = ParameterHelper.getTenantParameter();
                StorageListRequest request = new StorageListRequest(tenantId, category.getFolder());
                closeableIterator = connection.listObjects(request);
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (fr.gouv.vitam.storage.driver.exception.StorageDriverNotFoundException exc) {
                    throw new StorageDriverNotFoundException((Throwable)exc);
                }
                catch (StorageDriverException exc) {
                    LOGGER.error(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR, (Object[])new Object[0]), (Throwable)exc);
                    throw new StorageTechnicalException((Throwable)exc);
                }
            }
            connection.close();
        }
        return closeableIterator;
    }

    @Override
    public RequestResponse<OfferLog> getOfferLogs(String strategyId, DataCategory category, Long offset, int limit, Order order) throws StorageException {
        return this.getOfferLogRequestResponse(strategyId, null, category, offset, limit, order);
    }

    @Override
    public RequestResponse<OfferLog> getOfferLogsByOfferId(String strategyId, String offerId, DataCategory category, Long offset, int limit, Order order) throws StorageException {
        ParametersChecker.checkParameter((String)NO_OFFER_IDENTIFIER_SPECIFIED_THIS_IS_MANDATORY, (String[])new String[]{offerId});
        return this.getOfferLogRequestResponse(strategyId, offerId, category, offset, limit, order);
    }

    private RequestResponse<OfferLog> getOfferLogRequestResponse(String strategyId, String offerId, DataCategory category, Long offset, int limit, Order order) throws StorageException {
        RequestResponse requestResponse;
        block12: {
            Integer tenantId = ParameterHelper.getTenantParameter();
            ParametersChecker.checkParameter((String)STRATEGY_ID_IS_MANDATORY, (String[])new String[]{strategyId});
            ParametersChecker.checkParameter((String)CATEGORY_IS_MANDATORY, (Object[])new Object[]{category});
            StorageStrategy storageStrategy = STRATEGY_PROVIDER.getStorageStrategy(strategyId);
            if (storageStrategy == null) {
                LOGGER.error(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_STRATEGY_NOT_FOUND, (Object[])new Object[0]));
                throw new StorageNotFoundException(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_STRATEGY_NOT_FOUND, (Object[])new Object[0]));
            }
            if (offerId == null) {
                OfferReference priorizedOffer = this.selectFirstOffer(storageStrategy.getId(), null);
                if (priorizedOffer != null) {
                    offerId = priorizedOffer.getId();
                } else {
                    LOGGER.error(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_OFFER_NOT_FOUND, (Object[])new Object[0]));
                    throw new StorageTechnicalException(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_OFFER_NOT_FOUND, (Object[])new Object[0]));
                }
            }
            StorageOffer offer = OFFER_PROVIDER.getStorageOffer(offerId);
            Driver driver = this.retrieveDriverInternal(offer.getId());
            Connection connection = driver.connect(offer.getId());
            try {
                StorageOfferLogRequest request = new StorageOfferLogRequest(tenantId, category.getFolder(), offset, limit, order);
                requestResponse = connection.getOfferLogs(request);
                if (connection == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (StorageDriverException e) {
                    LOGGER.error(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_TECHNICAL_INTERNAL_ERROR, (Object[])new Object[0]), (Throwable)e);
                    throw new StorageTechnicalException((Throwable)e);
                }
            }
            connection.close();
        }
        return requestResponse;
    }

    @Override
    public Response getContainerByCategory(String strategyId, String origin, String objectId, DataCategory category, AccessLogInfoModel logInformation) throws StorageException {
        return this.getContainerByCategoryResponse(strategyId, origin, objectId, category, null, logInformation);
    }

    @Override
    public Response getContainerByCategory(String strategyId, String origin, String objectId, DataCategory category, String offerId) throws StorageException {
        return this.getContainerByCategoryResponse(strategyId, origin, objectId, category, offerId, AccessLogUtils.getNoLogAccessLog());
    }

    private Response getContainerByCategoryResponse(String strategyId, String origin, String objectId, DataCategory category, String offerId, AccessLogInfoModel logInformation) throws StorageException {
        Integer tenantId = ParameterHelper.getTenantParameter();
        ParametersChecker.checkParameter((String)STRATEGY_ID_IS_MANDATORY, (String[])new String[]{strategyId});
        ParametersChecker.checkParameter((String)OBJECT_ID_IS_MANDATORY, (String[])new String[]{objectId});
        StorageStrategy storageStrategy = this.checkStrategy(strategyId);
        List<Object> storageOffers = new ArrayList();
        if (StringUtils.isBlank((CharSequence)offerId)) {
            List<OfferReference> offerReferences = this.getOfferListFromHotStrategy(storageStrategy);
            List collect = offerReferences.stream().map(StorageDistributionImpl::apply).collect(Collectors.toList());
            storageOffers.addAll(collect);
        } else {
            StorageOffer offer = OFFER_PROVIDER.getStorageOffer(offerId);
            storageOffers = Collections.singletonList(offer);
        }
        if (DataCategory.OBJECT.equals((Object)category)) {
            try {
                if (AccessLogUtils.mustLog((AccessLogInfoModel)logInformation).booleanValue()) {
                    AccessLogParameters params = this.createParamsForAccessLog(logInformation, objectId);
                    this.storageLogService.appendAccessLog(tenantId, params);
                }
            }
            catch (IOException e) {
                LOGGER.error((Throwable)e);
            }
        }
        return this.getObjectResult(tenantId, strategyId, origin, objectId, category, storageOffers);
    }

    private static StorageOffer apply(OfferReference offerReference) {
        StorageOffer storageOffer = null;
        try {
            storageOffer = OFFER_PROVIDER.getStorageOffer(offerReference.getId());
        }
        catch (StorageException e) {
            LOGGER.error((Throwable)e);
        }
        return storageOffer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response getObjectResult(Integer tenantId, String strategyId, String origin, String objectId, DataCategory type, List<StorageOffer> storageOffers) throws StorageException {
        Iterator<StorageOffer> iterator = storageOffers.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                LOGGER.error(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_OFFER_NOT_FOUND, (Object[])new Object[0]));
                throw new StorageTechnicalException(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_OFFER_NOT_FOUND, (Object[])new Object[0]));
            }
            StorageOffer storageOffer = iterator.next();
            Driver driver = this.retrieveDriverInternal(storageOffer.getId());
            try {
                Connection connection = driver.connect(storageOffer.getId());
                try {
                    RetryableOnException retryable = new RetryableOnException(this.retryableParameters, exception -> exception instanceof StorageDriverServiceUnavailableException || exception instanceof StorageDriverServerErrorException);
                    StorageObjectRequest request = new StorageObjectRequest(tenantId, type.getFolder(), objectId);
                    StorageGetResult result = (StorageGetResult)retryable.exec(() -> connection.getObject(request));
                    Response response = result.getObject();
                    if (response == null) continue;
                    DownloadCountingSizeMetricsResponse downloadCountingSizeMetricsResponse = new DownloadCountingSizeMetricsResponse(tenantId, strategyId, storageOffer.getId(), origin, type, response);
                    return downloadCountingSizeMetricsResponse;
                }
                finally {
                    if (connection == null) continue;
                    connection.close();
                    continue;
                }
            }
            catch (fr.gouv.vitam.storage.driver.exception.StorageDriverNotFoundException exc) {
                throw new StorageNotFoundException(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_OBJECT_NOT_FOUND, (Object[])new Object[]{objectId}), (Throwable)exc);
            }
            catch (StorageDriverUnavailableDataFromAsyncOfferException exc) {
                throw new StorageUnavailableDataFromAsyncOfferException("Access not acceptable for object '" + type.getFolder() + "/" + objectId + "' from offer " + storageOffer.getId() + " of strategy " + strategyId, (Throwable)exc);
            }
            catch (StorageDriverException exc) {
                LOGGER.warn(ERROR_WITH_THE_STORAGE_TAKE_THE_NEXT_OFFER_IN_THE_STRATEGY_BY_PRIORITY, (Throwable)exc);
                continue;
            }
            break;
        }
    }

    @Override
    public JsonNode getContainerInformation(String strategyId, DataCategory type, String objectId, List<String> offerIds, boolean noCache) throws StorageException {
        ObjectNode offerIdToMetadata = JsonHandler.createObjectNode();
        Integer tenantId = ParameterHelper.getTenantParameter();
        ParametersChecker.checkParameter((String)STRATEGY_ID_IS_MANDATORY, (String[])new String[]{strategyId});
        ParametersChecker.checkParameter((String)OBJECT_ID_IS_MANDATORY, (String[])new String[]{objectId});
        StorageStrategy storageStrategy = this.checkStrategy(strategyId);
        this.getOfferListFromHotStrategy(storageStrategy);
        for (String offerId : offerIds) {
            Driver driver = this.retrieveDriverInternal(offerId);
            StorageOffer offer = OFFER_PROVIDER.getStorageOffer(offerId);
            try {
                Connection connection = driver.connect(offer.getId());
                try {
                    StorageGetMetadataRequest request = new StorageGetMetadataRequest(tenantId, type.getFolder(), objectId, noCache);
                    StorageMetadataResult metaData = connection.getMetadatas(request);
                    offerIdToMetadata.set(offerId, JsonHandler.toJsonNode((Object)metaData));
                }
                finally {
                    if (connection == null) continue;
                    connection.close();
                }
            }
            catch (StorageDriverException exc) {
                LOGGER.warn(ERROR_WITH_THE_STORAGE_TAKE_THE_NEXT_OFFER_IN_THE_STRATEGY_BY_PRIORITY, (Throwable)exc);
            }
            catch (InvalidParseOperationException e) {
                LOGGER.warn((Throwable)e);
            }
        }
        return offerIdToMetadata;
    }

    @Override
    public Map<String, Boolean> checkObjectExisting(String strategyId, String objectId, DataCategory category, List<String> offerIds) throws StorageException {
        Integer tenantId = ParameterHelper.getTenantParameter();
        ParametersChecker.checkParameter((String)STRATEGY_ID_IS_MANDATORY, (String[])new String[]{strategyId});
        ParametersChecker.checkParameter((String)OBJECT_ID_IS_MANDATORY, (String[])new String[]{objectId});
        ParametersChecker.checkParameter((String)OFFER_IDS_IS_MANDATORY, (Object[])new Object[]{offerIds});
        HashMap<String, Boolean> resultByOffer = new HashMap<String, Boolean>();
        StorageStrategy storageStrategy = this.checkStrategy(strategyId);
        List<OfferReference> offerReferences = this.getOfferListFromHotStrategy(storageStrategy);
        List offerReferencesIds = offerReferences.stream().map(OfferReference::getId).collect(Collectors.toList());
        resultByOffer.putAll(offerIds.stream().filter(offer -> !offerReferencesIds.contains(offer)).collect(Collectors.toMap(offerId -> offerId, offerId -> Boolean.FALSE)));
        for (String offerId2 : offerIds) {
            if (resultByOffer.containsKey(offerId2)) continue;
            Driver driver = this.retrieveDriverInternal(offerId2);
            StorageOffer offer2 = OFFER_PROVIDER.getStorageOffer(offerId2);
            try {
                Connection connection = driver.connect(offer2.getId());
                try {
                    StorageObjectRequest request = new StorageObjectRequest(tenantId, category.getFolder(), objectId);
                    if (!connection.objectExistsInOffer(request)) {
                        resultByOffer.put(offerId2, Boolean.FALSE);
                        continue;
                    }
                    resultByOffer.put(offerId2, Boolean.TRUE);
                }
                finally {
                    if (connection == null) continue;
                    connection.close();
                }
            }
            catch (fr.gouv.vitam.storage.driver.exception.StorageDriverNotFoundException e) {
                LOGGER.warn(ERROR_WITH_THE_STORAGE_OBJECT_NOT_FOUND_TAKE_NEXT_OFFER_IN_STRATEGY_BY_PRIORITY, (Throwable)e);
                resultByOffer.put(offerId2, Boolean.FALSE);
            }
            catch (StorageDriverException e) {
                LOGGER.warn(ERROR_WITH_THE_STORAGE_TAKE_THE_NEXT_OFFER_IN_THE_STRATEGY_BY_PRIORITY, (Throwable)e);
                resultByOffer.put(offerId2, Boolean.FALSE);
            }
        }
        return resultByOffer;
    }

    @Override
    public void deleteObjectInAllOffers(String strategyId, DataContext context) throws StorageException {
        ParametersChecker.checkParameter((String)STRATEGY_ID_IS_MANDATORY, (String[])new String[]{strategyId});
        ParametersChecker.checkParameter((String)OBJECT_ID_IS_MANDATORY, (String[])new String[]{context.getObjectId()});
        StorageStrategy storageStrategy = this.checkStrategy(strategyId);
        List<OfferReference> offerReferences = this.getOfferListFromHotStrategy(storageStrategy);
        this.deleteObject(context, offerReferences);
    }

    @Override
    public void deleteObjectInOffers(String strategyId, DataContext context, List<String> offers) throws StorageException {
        ParametersChecker.checkParameter((String)STRATEGY_ID_IS_MANDATORY, (String[])new String[]{strategyId});
        ParametersChecker.checkParameter((String)OFFERS_LIST_IS_MANDATORY, (Object[])new Object[]{offers});
        if (offers.isEmpty()) {
            LOGGER.error(OFFERS_LIST_IS_MANDATORY);
            throw new StorageTechnicalException(OFFERS_LIST_IS_MANDATORY);
        }
        StorageStrategy storageStrategy = this.checkStrategy(strategyId);
        List<OfferReference> offerReferences = this.getOfferListFromHotStrategy(storageStrategy);
        ArrayList<OfferReference> offerReferencesToDelete = new ArrayList<OfferReference>();
        for (String offerId : offers) {
            Optional<OfferReference> found = offerReferences.stream().filter(offerReference -> offerReference.getId().equals(offerId)).findFirst();
            found.ifPresent(offerReferencesToDelete::add);
            if (!found.isEmpty()) continue;
            throw new StorageTechnicalException(VitamCodeHelper.getLogMessage((VitamCode)VitamCode.STORAGE_OFFER_NOT_FOUND, (Object[])new Object[0]));
        }
        this.deleteObject(context, offerReferencesToDelete);
    }

    private void deleteObject(DataContext context, List<OfferReference> offerReferences) throws StorageException {
        HashMap<String, StorageLogbookOutcome> deleteOutcomeByOfferId = new HashMap<String, StorageLogbookOutcome>();
        for (OfferReference offerReference : offerReferences) {
            Driver driver = this.retrieveDriverInternal(offerReference.getId());
            StorageOffer offer = OFFER_PROVIDER.getStorageOffer(offerReference.getId());
            try {
                RetryableOnException retryable = new RetryableOnException(this.retryableParameters, e -> e instanceof StorageTechnicalException);
                retryable.execute(() -> this.deleteObject(context.getObjectId(), context.getTenantId(), driver, offer, context.getCategory()));
                deleteOutcomeByOfferId.put(driver.getName(), StorageLogbookOutcome.OK);
            }
            catch (Exception e2) {
                LOGGER.error(String.format("An error occurred during object delete %s/%s from offer %s", context.getCategory(), context.getObjectId(), driver.getName()), (Throwable)e2);
                deleteOutcomeByOfferId.put(driver.getName(), StorageLogbookOutcome.KO);
            }
        }
        String offerDetails = deleteOutcomeByOfferId.entrySet().stream().map(entry -> (String)entry.getKey() + ": " + entry.getValue()).collect(Collectors.joining(", "));
        StorageLogbookOutcome globalOutcome = deleteOutcomeByOfferId.values().stream().max(Enum::compareTo).orElse(StorageLogbookOutcome.KO);
        StorageLogbookParameters deleteLogParameters = this.buildDeleteLogParameters(context.getObjectId(), context.getCategory().getFolder(), offerDetails, context.getRequester(), globalOutcome);
        try {
            this.logStorage(context.getTenantId(), deleteLogParameters);
        }
        catch (IOException e3) {
            LOGGER.error((Throwable)e3);
        }
        if (globalOutcome != StorageLogbookOutcome.OK) {
            throw new StorageException(String.format("Could not delete object %s/%s. %s", context.getCategory(), context.getObjectId(), offerDetails));
        }
    }

    private void deleteObject(String objectId, Integer tenantId, Driver driver, StorageOffer offer, DataCategory category) throws StorageTechnicalException {
        try (Connection connection = driver.connect(offer.getId());){
            StorageRemoveRequest request = new StorageRemoveRequest(tenantId, category.getFolder(), objectId);
            StorageRemoveResult result = connection.removeObject(request);
            if (!result.isObjectDeleted()) {
                LOGGER.warn("Not found " + objectId + ". Already deleted?");
            }
        }
        catch (fr.gouv.vitam.storage.driver.exception.StorageDriverNotFoundException e) {
            LOGGER.warn("Not found " + objectId + ". Already deleted?", (Throwable)e);
        }
        catch (StorageDriverException | RuntimeException e) {
            if (e instanceof StorageDriverPreconditionFailedException) {
                throw new IllegalArgumentException(e);
            }
            throw new StorageTechnicalException(e);
        }
    }

    private StorageLogbookParameters buildDeleteLogParameters(String objectIdentifier, String dataCategory, String agentIdentifiers, String agentIdentifierRequester, StorageLogbookOutcome outcome) {
        TreeMap<StorageLogbookParameterName, String> mandatoryParameters = new TreeMap<StorageLogbookParameterName, String>();
        mandatoryParameters.put(StorageLogbookParameterName.eventDateTime, LocalDateUtil.nowFormatted());
        mandatoryParameters.put(StorageLogbookParameterName.outcome, outcome.name());
        mandatoryParameters.put(StorageLogbookParameterName.objectIdentifier, objectIdentifier);
        mandatoryParameters.put(StorageLogbookParameterName.dataCategory, dataCategory);
        mandatoryParameters.put(StorageLogbookParameterName.eventType, "DELETE");
        mandatoryParameters.put(StorageLogbookParameterName.xRequestId, VitamThreadUtils.getVitamSession().getRequestId());
        mandatoryParameters.put(StorageLogbookParameterName.agentIdentifiers, agentIdentifiers);
        mandatoryParameters.put(StorageLogbookParameterName.tenantId, ParameterHelper.getTenantParameter().toString());
        mandatoryParameters.put(StorageLogbookParameterName.agentIdentifierRequester, agentIdentifierRequester);
        return StorageLogbookParameters.buildDeleteLogParameters(mandatoryParameters);
    }

    @Override
    public List<BatchObjectInformationResponse> getBatchObjectInformation(String strategyId, DataCategory type, List<String> objectIds, List<String> offerIds) throws StorageException {
        Integer tenantId = ParameterHelper.getTenantParameter();
        ParametersChecker.checkParameter((String)STRATEGY_ID_IS_MANDATORY, (String[])new String[]{strategyId});
        StorageStrategy storageStrategy = this.checkStrategy(strategyId);
        List<OfferReference> offerReferences = this.getOfferListFromHotStrategy(storageStrategy);
        List offerReferencesIds = offerReferences.stream().map(OfferReference::getId).collect(Collectors.toList());
        if (!offerReferencesIds.containsAll(offerIds)) {
            List missingOfferIds = offerIds.stream().filter(id -> !offerReferencesIds.contains(id)).collect(Collectors.toList());
            throw new StorageException("Invalid offer ids " + missingOfferIds + "for strategy " + strategyId);
        }
        HashMap<String, Driver> driverByOfferId = new HashMap<String, Driver>();
        HashMap<String, StorageOffer> storageOfferByOfferId = new HashMap<String, StorageOffer>();
        for (String string : offerIds) {
            driverByOfferId.put(string, this.retrieveDriverInternal(string));
            storageOfferByOfferId.put(string, OFFER_PROVIDER.getStorageOffer(string));
        }
        HashMap<String, CompletableFuture<List>> completableFutures = new HashMap<String, CompletableFuture<List>>();
        for (String offerId : offerIds) {
            CompletableFuture<List> objectInformationCompletableFuture = CompletableFuture.supplyAsync(() -> this.getBatchObjectInformation(type, tenantId, objectIds, (Driver)driverByOfferId.get(offerId), (StorageOffer)storageOfferByOfferId.get(offerId)));
            completableFutures.put(offerId, objectInformationCompletableFuture);
        }
        try {
            HashMap<String, Map> hashMap = new HashMap<String, Map>();
            for (String offerId : completableFutures.keySet()) {
                List storageBulkMetadataResultEntries = (List)((CompletableFuture)completableFutures.get(offerId)).get();
                for (StorageBulkMetadataResultEntry storageBulkMetadataResultEntry : storageBulkMetadataResultEntries) {
                    hashMap.computeIfAbsent(storageBulkMetadataResultEntry.getObjectName(), objectId -> new HashMap()).put(offerId, storageBulkMetadataResultEntry.getDigest());
                }
            }
            return hashMap.keySet().stream().map(objectId -> new BatchObjectInformationResponse(type, objectId, (Map)offerDigestsByObjectId.get(objectId))).collect(Collectors.toList());
        }
        catch (InterruptedException | ExecutionException exception) {
            completableFutures.values().forEach(future -> future.cancel(false));
            throw new StorageException("Batch object information failed", (Throwable)exception);
        }
    }

    private List<StorageBulkMetadataResultEntry> getBatchObjectInformation(DataCategory type, Integer tenantId, List<String> objectIds, Driver driver, StorageOffer offer) {
        List list;
        block8: {
            Connection connection = driver.connect(offer.getId());
            try {
                StorageGetBulkMetadataRequest request = new StorageGetBulkMetadataRequest(tenantId, type.getFolder(), objectIds, false);
                StorageBulkMetadataResult metaData = connection.getBulkMetadata(request);
                list = metaData.getObjectMetadata();
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidParseOperationException | StorageDriverException e) {
                    throw new VitamRuntimeException("Could not retrieve batch object information for offer " + offer.getId(), e);
                }
            }
            connection.close();
        }
        return list;
    }

    private AccessLogParameters createParamsForAccessLog(AccessLogInfoModel logInfo, String objectId) {
        HashMap<StorageLogbookParameterName, String> mapParameters = new HashMap<StorageLogbookParameterName, String>();
        mapParameters.put(StorageLogbookParameterName.objectIdentifier, objectId);
        if (logInfo.getContextId() != null) {
            mapParameters.put(StorageLogbookParameterName.contextId, logInfo.getContextId());
        }
        if (logInfo.getContractId() != null) {
            mapParameters.put(StorageLogbookParameterName.contractId, logInfo.getContractId());
        }
        if (logInfo.getRequestId() != null) {
            mapParameters.put(StorageLogbookParameterName.xRequestId, logInfo.getRequestId());
        }
        if (logInfo.getApplicationId() != null) {
            mapParameters.put(StorageLogbookParameterName.applicationId, logInfo.getApplicationId());
        }
        if (logInfo.getArchiveId() != null) {
            mapParameters.put(StorageLogbookParameterName.archivesId, logInfo.getArchiveId());
        }
        if (logInfo.getQualifier() != null) {
            mapParameters.put(StorageLogbookParameterName.qualifier, logInfo.getQualifier());
        }
        if (logInfo.getVersion() != null) {
            mapParameters.put(StorageLogbookParameterName.version, logInfo.getVersion().toString());
        }
        if (logInfo.getSize() != null) {
            mapParameters.put(StorageLogbookParameterName.size, logInfo.getSize().toString());
        }
        mapParameters.put(StorageLogbookParameterName.eventDateTime, LocalDateUtil.nowFormatted());
        return new AccessLogParameters(mapParameters);
    }

    private void validateStrategyOffers() throws StorageTechnicalException {
        for (Map.Entry strategyEntry : this.getStrategyProvider().getStorageStrategies().entrySet()) {
            ((StorageStrategy)strategyEntry.getValue()).setOffers(this.checkCoherentOfferRanksAndSort(((StorageStrategy)strategyEntry.getValue()).getOffers()));
        }
    }

    protected StorageStrategyProvider getStrategyProvider() {
        return STRATEGY_PROVIDER;
    }

    public void close() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.warn((Throwable)e);
        }
        this.executor.shutdownNow();
    }
}

