/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.time;

import fr.gouv.vitam.common.LocalDateUtil;
import java.io.Serializable;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import org.junit.rules.ExternalResource;

public class LogicalClockRule
extends ExternalResource {
    protected void after() {
        LocalDateUtil.resetClock();
    }

    public void logicalSleep(int amount, ChronoUnit unit) {
        if (LocalDateUtil.getClock() instanceof OffsetClock) {
            OffsetClock previousOffsetClock = (OffsetClock)LocalDateUtil.getClock();
            LocalDateUtil.setClock((Clock)new OffsetClock(previousOffsetClock.baseClock, previousOffsetClock.offset.plus((long)amount, unit)));
        } else {
            LocalDateUtil.setClock((Clock)new OffsetClock(LocalDateUtil.getClock(), Duration.of(amount, unit)));
        }
    }

    public void freezeTime() {
        LocalDateUtil.setClock((Clock)Clock.fixed(LocalDateUtil.now().toInstant(ZoneOffset.UTC), ZoneOffset.UTC));
    }

    public void freezeTime(LocalDateTime localDateTime) {
        LocalDateUtil.setClock((Clock)Clock.fixed(localDateTime.toInstant(ZoneOffset.UTC), ZoneOffset.UTC));
    }

    public void resumeTime() {
        Duration shift = Duration.between(Clock.systemUTC().instant(), LocalDateUtil.getClock().instant());
        LocalDateUtil.setClock((Clock)new OffsetClock(Clock.systemUTC(), shift));
    }

    private static final class OffsetClock
    extends Clock
    implements Serializable {
        private final Clock baseClock;
        private final Duration offset;

        OffsetClock(Clock baseClock, Duration offset) {
            this.baseClock = baseClock;
            this.offset = offset;
        }

        @Override
        public ZoneId getZone() {
            return this.baseClock.getZone();
        }

        @Override
        public Clock withZone(ZoneId zone) {
            if (zone.equals(this.baseClock.getZone())) {
                return this;
            }
            return new OffsetClock(this.baseClock.withZone(zone), this.offset);
        }

        @Override
        public Instant instant() {
            return this.baseClock.instant().plus(this.offset);
        }
    }
}

