/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.junit;

import com.google.common.collect.Sets;
import com.google.common.testing.GcFinalization;
import fr.gouv.vitam.common.SystemPropertyUtil;
import fr.gouv.vitam.common.logging.SysErrLogger;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashSet;
import java.util.Set;
import javax.net.ServerSocketFactory;
import org.apache.shiro.util.Assert;
import org.junit.rules.ExternalResource;

public class JunitHelper
extends ExternalResource {
    private static final int WAIT_BETWEEN_TRY = 10;
    private static final int WAIT_AFTER_FULL_GC = 100;
    public static final int MIN_PORT = 11112;
    private static final int MAX_PORT = 65535;
    private static final int BUFFER_SIZE = 65536;
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(JunitHelper.class);
    private final Set<Integer> portAlreadyUsed = new HashSet<Integer>();
    private static final String PARAMETER_JETTY_SERVER_PORT = "jetty.port";
    public static final String PARAMETER_JETTY_SERVER_PORT_ADMIN = "jetty.port.admin";
    private static final JunitHelper JUNIT_HELPER = new JunitHelper();
    private static final Set<Integer> usedPort = Sets.newConcurrentHashSet();

    private JunitHelper() {
    }

    public static final JunitHelper getInstance() {
        return JUNIT_HELPER;
    }

    public final synchronized int findAvailablePort() {
        return this.findAvailablePort(PARAMETER_JETTY_SERVER_PORT);
    }

    public final synchronized int findAvailablePort(String environmentVariable) {
        int port = this.getAvailablePort();
        if (PARAMETER_JETTY_SERVER_PORT.equals(environmentVariable) || PARAMETER_JETTY_SERVER_PORT_ADMIN.equals(environmentVariable)) {
            JunitHelper.setJettyPortSystemProperty(environmentVariable, port);
        }
        return port;
    }

    private final int getAvailablePort() {
        while (true) {
            Integer port;
            if (!this.portAlreadyUsed.contains(port = Integer.valueOf(this.getPort()))) {
                this.portAlreadyUsed.add(port);
                LOGGER.debug("Available port: " + port);
                return port;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)e);
                continue;
            }
            break;
        }
    }

    public final synchronized void releasePort(int port) {
        LOGGER.debug("Relaese port: " + port);
        this.portAlreadyUsed.remove(port);
        JunitHelper.unsetJettyPortSystemProperty();
    }

    private final int getPort() {
        return SocketType.TCP.findAvailablePort(11112, 65535);
    }

    public final boolean isListeningOn(int port) {
        return this.isListeningOn(null, port);
    }

    public final boolean isListeningOn(String host, int port) {
        boolean bl;
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Port must be between 1 and 65535");
        }
        Socket socket = new Socket(host, port);
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.warn("The server is not listening on specified port", (Throwable)e);
                return false;
            }
        }
        socket.close();
        return bl;
    }

    public static final long consumeInputStream(InputStream inputStream) {
        long read = 0L;
        if (inputStream == null) {
            return read;
        }
        byte[] buffer = new byte[65536];
        try {
            int len = 0;
            while ((len = inputStream.read(buffer)) >= 0) {
                read += (long)len;
            }
        }
        catch (IOException e) {
            SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)e);
        }
        try {
            inputStream.close();
        }
        catch (IOException e) {
            SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)e);
        }
        return read;
    }

    public static final long consumeInputStreamPerByte(InputStream inputStream) {
        long read = 0L;
        if (inputStream == null) {
            return read;
        }
        try {
            while (inputStream.read() >= 0) {
                ++read;
            }
        }
        catch (IOException e) {
            LOGGER.debug((Throwable)e);
        }
        try {
            inputStream.close();
        }
        catch (IOException e) {
            SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)e);
        }
        return read;
    }

    public static InputStream getPerByteInputStream(final InputStream inputStream) {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                return inputStream.read();
            }

            @Override
            public int read(byte[] b) throws IOException {
                return this.read(b, 0, b.length);
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                if (len == 0) {
                    return 0;
                }
                int read = this.read();
                if (read == -1) {
                    return -1;
                }
                b[off] = (byte)read;
                return 1;
            }
        };
    }

    public static final void awaitFullGc() {
        GcFinalization.awaitFullGc();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)e);
        }
    }

    public static final void setJettyPortSystemProperty(String environmentVariable, int port) {
        if (!PARAMETER_JETTY_SERVER_PORT.equals(environmentVariable) && !PARAMETER_JETTY_SERVER_PORT_ADMIN.equals(environmentVariable)) {
            throw new IllegalArgumentException("JunitHelper setJettyPortSystemProperty method, accept only [jetty.port or jetty.port.admin] params");
        }
        SystemPropertyUtil.set((String)environmentVariable, (String)Integer.toString(port));
    }

    public static final void unsetJettyPortSystemProperty() {
        SystemPropertyUtil.clear((String)PARAMETER_JETTY_SERVER_PORT);
        SystemPropertyUtil.clear((String)PARAMETER_JETTY_SERVER_PORT_ADMIN);
    }

    public static final void testPrivateConstructor(Class<?> clasz) {
        try {
            Constructor<?> c = clasz.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            c.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | UnsupportedOperationException | InvocationTargetException e) {
            SysErrLogger.FAKE_LOGGER.ignoreLog((Throwable)e);
        }
    }

    private static enum SocketType {
        TCP{

            @Override
            protected boolean isPortAvailable(int port) {
                if (usedPort.contains(port)) {
                    return false;
                }
                try {
                    ServerSocket serverSocket = ServerSocketFactory.getDefault().createServerSocket(port, 1, InetAddress.getByName("localhost"));
                    serverSocket.close();
                    return true;
                }
                catch (Exception ex) {
                    return false;
                }
            }
        }
        ,
        UDP{

            @Override
            protected boolean isPortAvailable(int port) {
                if (usedPort.contains(port)) {
                    return false;
                }
                try {
                    DatagramSocket socket = new DatagramSocket(port, InetAddress.getByName("localhost"));
                    socket.close();
                    return true;
                }
                catch (Exception ex) {
                    return false;
                }
            }
        };


        protected abstract boolean isPortAvailable(int var1);

        int findAvailablePort(int minPort, int maxPort) {
            Assert.isTrue((minPort > 0 ? 1 : 0) != 0, (String)"'minPort' must be greater than 0");
            Assert.isTrue((maxPort >= minPort ? 1 : 0) != 0, (String)"'maxPort' must be greater than or equal to 'minPort'");
            Assert.isTrue((maxPort <= 65535 ? 1 : 0) != 0, (String)"'maxPort' must be less than or equal to 65535");
            Integer candidatePort = null;
            for (int port = minPort; port <= maxPort; ++port) {
                if (!this.isPortAvailable(port)) continue;
                usedPort.add(port);
                candidatePort = port;
                break;
            }
            if (candidatePort == null) {
                throw new IllegalStateException(String.format("Could not find an available %s port in the range [%d, %d] after %d attempts", this.name(), minPort, maxPort, usedPort.size()));
            }
            return candidatePort;
        }
    }
}

