/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.elasticsearch;

import com.google.common.collect.Sets;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.HttpHost;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.XContentType;
import org.junit.rules.ExternalResource;

public class ElasticsearchRule
extends ExternalResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ElasticsearchRule.class);
    public static final int PORT = 9200;
    public static String HOST = "localhost";
    public static final String VITAM_CLUSTER = "elasticsearch-data";
    private boolean clientClosed = false;
    private final RestHighLevelClient client;
    private Set<String> indexesToBePurged = new HashSet<String>();

    public ElasticsearchRule(String ... indexesToBePurged) {
        this.client = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(HOST, 9200)}));
        if (null != indexesToBePurged) {
            this.indexesToBePurged = Sets.newHashSet((Object[])indexesToBePurged);
        }
    }

    protected void after() {
        if (!this.clientClosed) {
            this.purge(this.client, this.indexesToBePurged);
        }
    }

    private void purge(RestHighLevelClient client, Collection<String> indexesToBePurged) {
        for (String indexName : indexesToBePurged) {
            this.purge(client, indexName);
        }
    }

    public void purge(RestHighLevelClient client, String indexName) {
        this.handlePurge(client, indexName, (QueryBuilder)QueryBuilders.matchAllQuery());
    }

    public void handlePurge(RestHighLevelClient client, String index, QueryBuilder qb) {
        try {
            DeleteByQueryRequest request = new DeleteByQueryRequest(new String[]{index});
            request.setConflicts("proceed");
            request.setQuery(qb);
            request.setBatchSize(VitamConfiguration.getMaxElasticsearchBulk());
            request.setScroll(TimeValue.timeValueMillis((long)VitamConfiguration.getElasticSearchScrollTimeoutInMilliseconds().intValue()));
            request.setTimeout(TimeValue.timeValueMillis((long)VitamConfiguration.getElasticSearchTimeoutWaitRequestInMilliseconds().intValue()));
            request.setRefresh(true);
            BulkByScrollResponse bulkResponse = client.deleteByQuery(request, RequestOptions.DEFAULT);
            TimeValue timeTaken = bulkResponse.getTook();
            boolean timedOut = bulkResponse.isTimedOut();
            long totalDocs = bulkResponse.getTotal();
            long deletedDocs = bulkResponse.getDeleted();
            long batches = bulkResponse.getBatches();
            long noops = bulkResponse.getNoops();
            long versionConflicts = bulkResponse.getVersionConflicts();
            long bulkRetries = bulkResponse.getBulkRetries();
            long searchRetries = bulkResponse.getSearchRetries();
            TimeValue throttledMillis = bulkResponse.getStatus().getThrottled();
            TimeValue throttledUntilMillis = bulkResponse.getStatus().getThrottledUntil();
            LOGGER.debug("Purge : timeTaken (" + timeTaken + "), timedOut (" + timedOut + "), totalDocs (" + totalDocs + "), deletedDocs (" + deletedDocs + "), batches (" + batches + "), noops (" + noops + "), versionConflicts (" + versionConflicts + ")bulkRetries (" + bulkRetries + "), searchRetries (" + searchRetries + "),  throttledMillis(" + throttledMillis + "), throttledUntilMillis(" + throttledUntilMillis + ")");
            List searchFailures = bulkResponse.getSearchFailures();
            if (CollectionUtils.isNotEmpty((Collection)searchFailures)) {
                throw new RuntimeException("ES purge errors : in search phase");
            }
            List bulkFailures = bulkResponse.getBulkFailures();
            if (CollectionUtils.isNotEmpty((Collection)bulkFailures)) {
                throw new RuntimeException("ES purge errors : in bulk phase");
            }
            LOGGER.info("Deleted : " + bulkResponse.getDeleted());
        }
        catch (ElasticsearchException e) {
            if (e.status() == RestStatus.NOT_FOUND) {
                return;
            }
            throw new RuntimeException("Purge Exception", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Purge Exception", e);
        }
    }

    public boolean existsIndex(String indexName) throws IOException {
        GetIndexRequest request = new GetIndexRequest(new String[]{indexName.toLowerCase()});
        request.humanReadable(true);
        request.includeDefaults(false);
        request.indicesOptions(IndicesOptions.STRICT_EXPAND_OPEN);
        return this.getClient().indices().exists(request, RequestOptions.DEFAULT);
    }

    public boolean createIndex(String aliasName, String indexName, String mapping) throws IOException {
        boolean existsIndex = this.existsIndex(indexName);
        if (Boolean.TRUE.equals(existsIndex)) {
            LOGGER.debug("Index (" + existsIndex + ") already exists");
            return true;
        }
        CreateIndexRequest request = new CreateIndexRequest(indexName).mapping(mapping, XContentType.JSON).alias(new Alias(aliasName));
        request.setTimeout(TimeValue.timeValueMillis((long)VitamConfiguration.getElasticSearchTimeoutWaitRequestInMilliseconds().intValue()));
        request.setMasterTimeout(TimeValue.timeValueMinutes((long)1L));
        request.waitForActiveShards(ActiveShardCount.DEFAULT);
        CreateIndexResponse response = this.getClient().indices().create(request, RequestOptions.DEFAULT);
        boolean acknowledged = response.isAcknowledged();
        boolean shardsAcknowledged = response.isShardsAcknowledged();
        LOGGER.debug("Alias (" + aliasName + ") and index (" + indexName + ") create response acknowledged (" + acknowledged + ") and shardsAcknowledged (" + shardsAcknowledged + ") ");
        return acknowledged && shardsAcknowledged;
    }

    public final void purgeIndex(RestHighLevelClient client, String indexName) {
        this.purge(client, indexName);
    }

    public void deleteIndexesWithoutClose() {
        for (String indexName : this.indexesToBePurged) {
            this.purgeIndex(this.client, indexName);
        }
        this.indexesToBePurged = new HashSet<String>();
    }

    public void purgeIndices() {
        for (String indexName : this.indexesToBePurged) {
            this.purgeIndex(this.client, indexName);
        }
        this.indexesToBePurged = new HashSet<String>();
        this.close();
    }

    public ElasticsearchRule addIndexToBePurged(String indexName) {
        this.indexesToBePurged.add(indexName);
        return this;
    }

    public void handleAfter() {
        this.after();
    }

    public void handleAfter(Set<String> indexesToBePurged) {
        this.purge(this.client, indexesToBePurged);
    }

    public static String getClusterName() {
        return VITAM_CLUSTER;
    }

    public static int getPort() {
        return 9200;
    }

    public static String getHost() {
        return HOST;
    }

    public RestHighLevelClient getClient() {
        return this.client;
    }

    public void close() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.clientClosed = true;
    }
}

