/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.engine.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Stopwatch;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.InvalidGuidOperationException;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.guid.GUIDReader;
import fr.gouv.vitam.common.i18n.VitamLogbookMessages;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.StatusCode;
import fr.gouv.vitam.common.model.processing.Action;
import fr.gouv.vitam.common.model.processing.PauseOrCancelAction;
import fr.gouv.vitam.common.model.processing.Step;
import fr.gouv.vitam.common.parameter.ParameterHelper;
import fr.gouv.vitam.common.performance.PerformanceLogger;
import fr.gouv.vitam.common.thread.VitamThreadPoolExecutor;
import fr.gouv.vitam.logbook.common.MessageLogbookEngineHelper;
import fr.gouv.vitam.logbook.common.exception.LogbookClientBadRequestException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientNotFoundException;
import fr.gouv.vitam.logbook.common.exception.LogbookClientServerException;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationParameters;
import fr.gouv.vitam.logbook.common.parameters.LogbookOperationsClientHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterHelper;
import fr.gouv.vitam.logbook.common.parameters.LogbookParameterName;
import fr.gouv.vitam.logbook.common.parameters.LogbookTypeProcess;
import fr.gouv.vitam.logbook.common.server.database.collections.LogbookMongoDbName;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClient;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.processing.common.automation.IEventsProcessEngine;
import fr.gouv.vitam.processing.common.exception.ProcessingEngineException;
import fr.gouv.vitam.processing.common.metrics.CommonProcessingMetrics;
import fr.gouv.vitam.processing.common.model.ProcessStep;
import fr.gouv.vitam.processing.common.parameter.WorkerParameterName;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.processing.distributor.api.ProcessDistributor;
import fr.gouv.vitam.processing.engine.api.ProcessEngine;
import fr.gouv.vitam.workspace.api.exception.ContentAddressableStorageServerException;
import fr.gouv.vitam.workspace.client.WorkspaceClient;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import io.prometheus.client.Histogram;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.Strings;

public class ProcessEngineImpl
implements ProcessEngine {
    private static final PerformanceLogger PERFORMANCE_LOGGER = PerformanceLogger.getInstance();
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ProcessEngineImpl.class);
    private static final String AGENCY_DETAIL = "agIdExt";
    private static final String ORIGIN_AGENCY_NAME = "OriginatingAgency";
    private static final String OBJECTS_LIST_EMPTY = "OBJECTS_LIST_EMPTY";
    private String messageIdentifier;
    private String originatingAgency;
    private final WorkerParameters workerParameters;
    private IEventsProcessEngine stateMachineCallback;
    private final ProcessDistributor processDistributor;
    private final LogbookOperationsClientFactory logbookOperationsClientFactory;
    private final WorkspaceClientFactory workspaceClientFactory;

    public ProcessEngineImpl(WorkerParameters workerParameters, ProcessDistributor processDistributor, LogbookOperationsClientFactory logbookOperationsClientFactory, WorkspaceClientFactory workspaceClientFactory) {
        this.processDistributor = processDistributor;
        this.workerParameters = workerParameters;
        this.logbookOperationsClientFactory = logbookOperationsClientFactory;
        this.workspaceClientFactory = workspaceClientFactory;
    }

    @Override
    public void setStateMachineCallback(IEventsProcessEngine stateMachineCallback) {
        this.stateMachineCallback = stateMachineCallback;
    }

    @Override
    public CompletableFuture<ItemStatus> start(ProcessStep step, WorkerParameters workerParameters) throws ProcessingEngineException {
        if (null == this.stateMachineCallback) {
            throw new ProcessingEngineException("IEventsProcessEngine is required");
        }
        if (null == step) {
            throw new ProcessingEngineException("The parameter step cannot be null");
        }
        if (null != workerParameters) {
            for (WorkerParameterName key : workerParameters.getMapParameters().keySet()) {
                if (this.workerParameters.getParameterValue(key) != null) continue;
                this.workerParameters.putParameterValue(key, (String)workerParameters.getMapParameters().get(key));
            }
        }
        String operationId = this.workerParameters.getContainerName();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Start Workflow: " + step.getId() + " Step:" + step.getStepName());
        }
        int tenantId = ParameterHelper.getTenantParameter();
        LogbookTypeProcess logbookTypeProcess = this.workerParameters.getLogbookTypeProcess();
        LogbookOperationParameters logbookParameter = this.logbookBeforeDistributorCall(step, this.workerParameters, tenantId, logbookTypeProcess);
        if (!PauseOrCancelAction.ACTION_RECOVER.equals((Object)step.getPauseOrCancelAction()) && !PauseOrCancelAction.ACTION_REPLAY.equals((Object)step.getPauseOrCancelAction())) {
            this.stateMachineCallback.onUpdate(StatusCode.STARTED);
        }
        this.workerParameters.setCurrentStep(step.getStepName());
        this.workerParameters.putParameterValue(WorkerParameterName.workflowStatusKo, this.stateMachineCallback.getCurrentProcessWorkflowStatus().name());
        Stopwatch stopwatch = Stopwatch.createStarted();
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.runAsync(() -> this.waitForStep(step, operationId, stopwatch), (Executor)VitamThreadPoolExecutor.getDefaultExecutor()).thenApplyAsync(e -> this.callDistributor(step, this.workerParameters, operationId), (Executor)VitamThreadPoolExecutor.getDefaultExecutor())).thenApply(distributorResponse -> {
            try {
                if (step.getPauseOrCancelAction() == PauseOrCancelAction.ACTION_PAUSE) {
                    return distributorResponse;
                }
                this.logbookAfterDistributorCall(step, this.workerParameters, tenantId, logbookTypeProcess, logbookParameter, (ItemStatus)distributorResponse);
                return distributorResponse;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        })).thenApply(distributorResponse -> {
            try {
                if (step.getPauseOrCancelAction() == PauseOrCancelAction.ACTION_CANCEL) {
                    this.stateMachineCallback.onProcessEngineCancel(this.workerParameters);
                    ItemStatus itemStatus = distributorResponse;
                    return itemStatus;
                }
                this.stateMachineCallback.onProcessEngineCompleteStep(distributorResponse, this.workerParameters);
            }
            finally {
                PERFORMANCE_LOGGER.log(step.getStepName(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
            }
            return distributorResponse;
        })).exceptionally(e -> {
            this.stateMachineCallback.onError(e);
            PERFORMANCE_LOGGER.log(step.getStepName(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
            throw new CompletionException((Throwable)e);
        });
    }

    private void waitForStep(ProcessStep step, String operationId, Stopwatch stopwatch) {
        if (step.getWaitFor() != null) {
            try (WorkspaceClient workspaceClient = this.workspaceClientFactory.getClient();){
                int sleepDelay = 1;
                int maxSleepDelay = 60;
                while (!workspaceClient.isExistingObject(operationId, step.getWaitFor()) && stopwatch.elapsed(TimeUnit.SECONDS) < (long)VitamConfiguration.getProcessEngineWaitForStepTimeout()) {
                    TimeUnit.SECONDS.sleep(sleepDelay);
                    sleepDelay = Math.min(sleepDelay * 2, 60);
                }
                if (stopwatch.elapsed(TimeUnit.SECONDS) > (long)VitamConfiguration.getProcessEngineWaitForStepTimeout()) {
                    throw new RuntimeException("The file " + step.getWaitFor() + " was not found in workspace!");
                }
            }
            catch (ContentAddressableStorageServerException | InterruptedException e) {
                LOGGER.error(e.getMessage());
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LogbookOperationParameters logbookBeforeDistributorCall(ProcessStep step, WorkerParameters workParams, int tenantId, LogbookTypeProcess logbookTypeProcess) throws ProcessingEngineException {
        try (LogbookOperationsClient logbookClient = this.logbookOperationsClientFactory.getClient();){
            MessageLogbookEngineHelper messageLogbookEngineHelper = new MessageLogbookEngineHelper(logbookTypeProcess);
            LogbookOperationParameters parameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)GUIDFactory.newEventGUID((int)tenantId), (String)step.getStepName(), (GUID)GUIDReader.getGUID((String)workParams.getContainerName()), (LogbookTypeProcess)logbookTypeProcess, (StatusCode)StatusCode.OK, (String)messageLogbookEngineHelper.getLabelOp(step.getStepName(), StatusCode.OK, new Object[0]), (GUID)GUIDReader.getGUID((String)workParams.getRequestId()));
            parameters.putParameterValue(LogbookParameterName.outcomeDetail, messageLogbookEngineHelper.getOutcomeDetail(step.getStepName(), StatusCode.OK));
            if (PauseOrCancelAction.ACTION_RECOVER.equals((Object)step.getPauseOrCancelAction()) || PauseOrCancelAction.ACTION_REPLAY.equals((Object)step.getPauseOrCancelAction())) {
                LogbookOperationParameters logbookOperationParameters2 = parameters;
                return logbookOperationParameters2;
            }
            String eventType = VitamLogbookMessages.getEventTypeStarted((String)step.getStepName());
            LogbookOperationParameters startedParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)GUIDFactory.newEventGUID((int)tenantId), (String)eventType, (GUID)GUIDReader.getGUID((String)workParams.getContainerName()), (LogbookTypeProcess)logbookTypeProcess, (StatusCode)StatusCode.OK, (String)messageLogbookEngineHelper.getLabelOp(eventType, StatusCode.OK, new Object[0]), (GUID)GUIDReader.getGUID((String)workParams.getRequestId()));
            startedParameters.putParameterValue(LogbookParameterName.outcomeDetail, messageLogbookEngineHelper.getOutcomeDetail(eventType, StatusCode.OK));
            logbookClient.update(new LogbookOperationParameters[]{startedParameters});
            LogbookOperationParameters logbookOperationParameters = parameters;
            return logbookOperationParameters;
        }
        catch (InvalidGuidOperationException | LogbookClientBadRequestException | LogbookClientNotFoundException | LogbookClientServerException e) {
            throw new ProcessingEngineException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ItemStatus callDistributor(ProcessStep step, WorkerParameters workParams, String operationId) {
        Histogram.Timer stepExecutionDurationTimer = ((Histogram.Child)CommonProcessingMetrics.PROCESS_WORKFLOW_STEP_EXECUTION_DURATION_HISTOGRAM.labels(new String[]{workParams.getLogbookTypeProcess().name(), step.getStepName()})).startTimer();
        try {
            ItemStatus itemStatus = this.processDistributor.distribute(workParams, (Step)step, operationId);
            return itemStatus;
        }
        finally {
            stepExecutionDurationTimer.observeDuration();
        }
    }

    private void logbookAfterDistributorCall(ProcessStep step, WorkerParameters workParams, int tenantId, LogbookTypeProcess logbookTypeProcess, LogbookOperationParameters parameters, ItemStatus stepResponse) throws InvalidGuidOperationException, LogbookClientNotFoundException, LogbookClientBadRequestException, LogbookClientServerException, InvalidParseOperationException {
        ObjectNode agIdExt;
        Object node;
        String stepEventIdentifier;
        LogbookOperationsClientHelper helper;
        MessageLogbookEngineHelper messageLogbookEngineHelper;
        block25: {
            messageLogbookEngineHelper = new MessageLogbookEngineHelper(logbookTypeProcess);
            helper = new LogbookOperationsClientHelper();
            stepEventIdentifier = parameters.getParameterValue(LogbookParameterName.eventIdentifier);
            if (Strings.isNullOrEmpty((String)this.messageIdentifier) && stepResponse.getData("MessageIdentifier") != null) {
                this.messageIdentifier = stepResponse.getData("MessageIdentifier").toString();
            }
            node = stepResponse.getData(AGENCY_DETAIL) == null ? JsonHandler.createObjectNode() : JsonHandler.getFromString((String)((String)stepResponse.getData(AGENCY_DETAIL)));
            try {
                JsonHandler.validate((String)node.asText());
                agIdExt = (ObjectNode)JsonHandler.getFromString((String)node.asText());
            }
            catch (InvalidParseOperationException e) {
                agIdExt = JsonHandler.createObjectNode();
                if (!LOGGER.isDebugEnabled()) break block25;
                LOGGER.debug("Invalid Json");
            }
        }
        String rightsStatementIdentifier = (String)stepResponse.getData(LogbookMongoDbName.rightsStatementIdentifier.getDbname());
        if (rightsStatementIdentifier != null) {
            parameters.putParameterValue(LogbookParameterName.rightsStatementIdentifier, rightsStatementIdentifier);
        }
        if (this.originatingAgency == null && stepResponse.getData(AGENCY_DETAIL) != null && node.get(ORIGIN_AGENCY_NAME) != null) {
            this.originatingAgency = node.get(ORIGIN_AGENCY_NAME).asText();
        }
        if (!Strings.isNullOrEmpty((String)this.messageIdentifier)) {
            this.stateMachineCallback.onUpdate(this.messageIdentifier, null);
            parameters.putParameterValue(LogbookParameterName.objectIdentifierIncome, this.messageIdentifier);
        }
        if (!Strings.isNullOrEmpty((String)this.originatingAgency)) {
            this.stateMachineCallback.onUpdate(null, this.originatingAgency);
            agIdExt.put(ORIGIN_AGENCY_NAME, this.originatingAgency);
        }
        if (agIdExt != null && agIdExt.elements().hasNext()) {
            parameters.putParameterValue(LogbookParameterName.agIdExt, agIdExt.toString());
        }
        parameters.putParameterValue(LogbookParameterName.eventIdentifier, stepEventIdentifier);
        parameters.putParameterValue(LogbookParameterName.eventType, step.getStepName());
        parameters.putParameterValue(LogbookParameterName.outcome, stepResponse.getGlobalStatus().name());
        parameters.putParameterValue(LogbookParameterName.outcomeDetail, messageLogbookEngineHelper.getOutcomeDetail(step.getStepName(), stepResponse.getGlobalStatus()));
        parameters.putParameterValue(LogbookParameterName.outcomeDetailMessage, messageLogbookEngineHelper.getLabelOp(stepResponse.getItemId(), stepResponse.getGlobalStatus(), new Object[0]));
        helper.updateDelegate(parameters);
        for (Action action : step.getActions()) {
            String handlerId = action.getActionDefinition().getActionKey();
            ItemStatus itemStatus = (ItemStatus)stepResponse.getItemsStatus().get(handlerId);
            if (itemStatus == null) continue;
            GUID actionEventIdentifier = GUIDFactory.newEventGUID((int)tenantId);
            LogbookOperationParameters actionLogBookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)actionEventIdentifier, (String)handlerId, (GUID)GUIDReader.getGUID((String)workParams.getContainerName()), (LogbookTypeProcess)logbookTypeProcess, (StatusCode)itemStatus.getGlobalStatus(), null, (String)(" Detail= " + itemStatus.computeStatusMeterMessage()), (GUID)GUIDReader.getGUID((String)workParams.getRequestId()));
            actionLogBookParameters.putParameterValue(LogbookParameterName.parentEventIdentifier, stepEventIdentifier);
            if (itemStatus.getGlobalOutcomeDetailSubcode() != null) {
                actionLogBookParameters.putParameterValue(LogbookParameterName.outcomeDetail, messageLogbookEngineHelper.getOutcomeDetail(handlerId + "." + itemStatus.getGlobalOutcomeDetailSubcode(), itemStatus.getGlobalStatus()));
                actionLogBookParameters.putParameterValue(LogbookParameterName.outcomeDetailMessage, messageLogbookEngineHelper.getLabelOp(handlerId + "." + itemStatus.getGlobalOutcomeDetailSubcode(), itemStatus.getGlobalStatus(), new Object[0]) + " Detail= " + itemStatus.computeStatusMeterMessage());
            }
            if (itemStatus.getMasterData() != null) {
                JsonNode value = JsonHandler.toJsonNode((Object)itemStatus.getMasterData());
                actionLogBookParameters.putParameterValue(LogbookParameterName.masterData, JsonHandler.writeAsString((Object)value));
            }
            if (itemStatus.getEvDetailData() != null) {
                String eventDetailData = itemStatus.getEvDetailData();
                actionLogBookParameters.putParameterValue(LogbookParameterName.eventDetailData, eventDetailData);
            }
            helper.updateDelegate(actionLogBookParameters);
            for (ItemStatus sub : itemStatus.getItemsStatus().values()) {
                LogbookOperationParameters subLogBookParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)GUIDFactory.newEventGUID((int)tenantId), (String)(handlerId + "." + sub.getItemId()), (GUID)GUIDReader.getGUID((String)workParams.getContainerName()), (LogbookTypeProcess)logbookTypeProcess, (StatusCode)sub.getGlobalStatus(), null, (String)(" Detail= " + sub.computeStatusMeterMessage()), (GUID)GUIDReader.getGUID((String)workParams.getRequestId()));
                subLogBookParameters.putParameterValue(LogbookParameterName.parentEventIdentifier, actionEventIdentifier.getId());
                if (sub.getGlobalOutcomeDetailSubcode() != null) {
                    subLogBookParameters.putParameterValue(LogbookParameterName.outcomeDetail, messageLogbookEngineHelper.getOutcomeDetail(handlerId + "." + sub.getItemId() + "." + sub.getGlobalOutcomeDetailSubcode(), sub.getGlobalStatus()));
                    subLogBookParameters.putParameterValue(LogbookParameterName.outcomeDetailMessage, messageLogbookEngineHelper.getLabelOp(handlerId + "." + sub.getItemId() + "." + sub.getGlobalOutcomeDetailSubcode(), sub.getGlobalStatus(), new Object[0]) + " Detail= " + sub.computeStatusMeterMessage());
                }
                if (sub.getData(LogbookMongoDbName.rightsStatementIdentifier.getDbname()) != null) {
                    subLogBookParameters.putParameterValue(LogbookParameterName.rightsStatementIdentifier, sub.getData(LogbookMongoDbName.rightsStatementIdentifier.getDbname()).toString());
                }
                if (sub.getData(AGENCY_DETAIL) != null) {
                    subLogBookParameters.putParameterValue(LogbookParameterName.agIdExt, sub.getData(AGENCY_DETAIL).toString());
                }
                helper.updateDelegate(subLogBookParameters);
            }
        }
        ItemStatus itemStatusObjectListEmpty = (ItemStatus)stepResponse.getItemsStatus().get(OBJECTS_LIST_EMPTY);
        if (itemStatusObjectListEmpty != null) {
            LogbookOperationParameters actionParameters = LogbookParameterHelper.newLogbookOperationParameters((GUID)GUIDFactory.newEventGUID((int)tenantId), (String)OBJECTS_LIST_EMPTY, (GUID)GUIDReader.getGUID((String)workParams.getContainerName()), (LogbookTypeProcess)logbookTypeProcess, (StatusCode)itemStatusObjectListEmpty.getGlobalStatus(), (String)messageLogbookEngineHelper.getLabelOp(OBJECTS_LIST_EMPTY, itemStatusObjectListEmpty.getGlobalStatus(), new Object[0]), (GUID)GUIDReader.getGUID((String)workParams.getRequestId()));
            actionParameters.putParameterValue(LogbookParameterName.parentEventIdentifier, stepEventIdentifier);
            helper.updateDelegate(actionParameters);
        }
        if (Boolean.TRUE.equals(step.getLastStep())) {
            String eventType = workParams.getWorkflowIdentifier();
            GUID operationGuid = GUIDReader.getGUID((String)workParams.getContainerName());
            GUID eventIdentifier = GUIDFactory.newEventGUID((GUID)operationGuid);
            StatusCode statusCode = this.stateMachineCallback.getCurrentProcessWorkflowStatus().compareTo((Enum)stepResponse.getGlobalStatus()) < 0 || StatusCode.FATAL.equals((Object)this.stateMachineCallback.getCurrentProcessWorkflowStatus()) ? stepResponse.getGlobalStatus() : this.stateMachineCallback.getCurrentProcessWorkflowStatus();
            GUID requestId = GUIDReader.getGUID((String)workParams.getRequestId());
            LogbookOperationParameters parametersFinal = LogbookParameterHelper.newLogbookOperationParameters((GUID)eventIdentifier, (String)eventType, (GUID)operationGuid, (LogbookTypeProcess)logbookTypeProcess, (StatusCode)statusCode, (String)messageLogbookEngineHelper.getLabelOp(eventType, statusCode, new Object[0]), (GUID)requestId);
            parameters.putParameterValue(LogbookParameterName.outcomeDetail, messageLogbookEngineHelper.getOutcomeDetail(eventType, statusCode));
            helper.updateDelegate(parametersFinal);
        }
        try (LogbookOperationsClient logbookClient = this.logbookOperationsClientFactory.getClient();){
            logbookClient.update(workParams.getContainerName(), (Iterable)helper.removeUpdateDelegate(workParams.getContainerName()));
        }
        this.stateMachineCallback.onUpdate(stepResponse.getGlobalStatus());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("End Workflow: " + step.getId() + " Step:" + step.getStepName());
        }
    }
}

