/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.engine.core;

import com.google.common.annotations.VisibleForTesting;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.logbook.operations.client.LogbookOperationsClientFactory;
import fr.gouv.vitam.processing.common.parameter.WorkerParameters;
import fr.gouv.vitam.processing.distributor.api.ProcessDistributor;
import fr.gouv.vitam.processing.engine.core.ProcessEngineImpl;
import fr.gouv.vitam.workspace.client.WorkspaceClientFactory;
import fr.gouv.vitam.workspace.client.WorkspaceType;

public final class ProcessEngineFactory {
    private static final ProcessEngineFactory INSTANCE = new ProcessEngineFactory();

    private ProcessEngineFactory() {
    }

    public static ProcessEngineFactory get() {
        return INSTANCE;
    }

    public ProcessEngineImpl create(WorkerParameters workParams, ProcessDistributor processDistributor) {
        ParametersChecker.checkParameter((String)"ProcessDistributor cannot be null", (Object[])new Object[]{processDistributor});
        return new ProcessEngineImpl(workParams, processDistributor, LogbookOperationsClientFactory.getInstance(), WorkspaceClientFactory.getInstance((WorkspaceType)WorkspaceType.VITAM));
    }

    @VisibleForTesting
    public ProcessEngineImpl create(WorkerParameters workParams, ProcessDistributor processDistributor, LogbookOperationsClientFactory logbookOperationsClientFactory, WorkspaceClientFactory workspaceClientFactory) {
        ParametersChecker.checkParameter((String)"Params cannot be null", (Object[])new Object[]{processDistributor, logbookOperationsClientFactory});
        return new ProcessEngineImpl(workParams, processDistributor, logbookOperationsClientFactory, workspaceClientFactory);
    }
}

