/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.model.processing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.processing.Action;
import fr.gouv.vitam.common.model.processing.Distribution;
import fr.gouv.vitam.common.model.processing.LifecycleState;
import fr.gouv.vitam.common.model.processing.PauseOrCancelAction;
import fr.gouv.vitam.common.model.processing.ProcessBehavior;
import java.util.Collections;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Step {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="workerGroupId")
    private String workerGroupId = "DefaultWorker";
    @JsonProperty(value="stepName")
    private String stepName;
    @JsonProperty(value="behavior")
    private ProcessBehavior behavior;
    @JsonProperty(value="distribution")
    private Distribution distribution;
    @JsonProperty(value="actions")
    private List<Action> actions;
    @JsonProperty(value="waitFor")
    private String waitFor;
    @JsonIgnore
    private ItemStatus stepResponses;
    private volatile PauseOrCancelAction pauseOrCancelAction = PauseOrCancelAction.ACTION_RUN;

    public Step() {
    }

    @JsonCreator
    public Step(@JsonProperty(value="id") String id, @JsonProperty(value="workerGroupId") String workerGroupId, @JsonProperty(value="stepName") String stepName, @JsonProperty(value="behavior") ProcessBehavior behavior, @JsonProperty(value="distribution") Distribution distribution, @JsonProperty(value="actions") List<Action> actions, @JsonProperty(value="waitFor") String waitFor) {
        this.id = id;
        this.workerGroupId = workerGroupId;
        this.stepName = stepName;
        this.behavior = behavior;
        this.distribution = distribution;
        this.actions = actions;
        this.waitFor = waitFor;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<Action> getActions() {
        if (this.actions == null) {
            return Collections.emptyList();
        }
        return this.actions;
    }

    public Step setActions(List<Action> actions) {
        this.actions = actions;
        return this;
    }

    public String getWorkerGroupId() {
        if (this.workerGroupId == null) {
            return "";
        }
        return this.workerGroupId;
    }

    public Step setWorkerGroupId(String workerGroupId) {
        this.workerGroupId = workerGroupId;
        return this;
    }

    public String getStepName() {
        if (this.stepName == null) {
            return "";
        }
        return this.stepName;
    }

    public Step setStepName(String stepName) {
        this.stepName = stepName;
        return this;
    }

    public Distribution getDistribution() {
        if (this.distribution == null) {
            return new Distribution();
        }
        return this.distribution;
    }

    public Step setDistribution(Distribution distribution) {
        this.distribution = distribution;
        return this;
    }

    public ProcessBehavior getBehavior() {
        return this.behavior;
    }

    public Step setBehavior(ProcessBehavior behavior) {
        this.behavior = behavior;
        return this;
    }

    public ItemStatus getStepResponses() {
        return this.stepResponses;
    }

    public Step setStepResponses(ItemStatus stepResponses) {
        this.stepResponses = stepResponses;
        return this;
    }

    @JsonIgnore
    public boolean isBlocking() {
        return this.getBehavior().equals((Object)ProcessBehavior.BLOCKING);
    }

    @JsonIgnore
    public boolean isFinally() {
        return this.getBehavior().equals((Object)ProcessBehavior.FINALLY);
    }

    public PauseOrCancelAction getPauseOrCancelAction() {
        return this.pauseOrCancelAction;
    }

    public Step setPauseOrCancelAction(PauseOrCancelAction pauseOrCancelAction) {
        this.pauseOrCancelAction = pauseOrCancelAction;
        return this;
    }

    public void defaultLifecycleLog(LifecycleState lifecycleLog) {
        this.actions.forEach(action -> {
            boolean distributed = this.distribution.getKind().isDistributed();
            if (distributed) {
                action.getActionDefinition().defaultLifecycleLog(lifecycleLog);
            } else {
                action.getActionDefinition().defaultLifecycleLog(LifecycleState.DISABLED);
            }
        });
    }

    public String getWaitFor() {
        return this.waitFor;
    }

    public void setWaitFor(String waitFor) {
        this.waitFor = waitFor;
    }
}

