/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common.guid;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import fr.gouv.vitam.common.BaseXx;
import fr.gouv.vitam.common.exception.InvalidGuidOperationException;
import fr.gouv.vitam.common.guid.GUID;
import fr.gouv.vitam.common.guid.GUIDAbstract;
import java.util.Arrays;

class GUIDImpl
extends GUIDAbstract {
    private static final String ATTEMPTED_TO_PARSE_MALFORMED_ARK_GUID = "Attempted to parse malformed ARK GUID: ";
    static final int KEYSIZE = 22;
    static final int KEYB64SIZE = 30;
    static final int KEYB32SIZE = 36;
    static final int KEYB16SIZE = 44;
    static final int HEADER_POS = 0;
    static final int HEADER_SIZE = 2;
    static final int TENANT_POS = 2;
    static final int TENANT_SIZE = 4;
    static final int PLATFORM_POS = 6;
    static final int PLATFORM_SIZE = 4;
    static final int PID_POS = 10;
    static final int PID_SIZE = 3;
    static final int TIME_POS = 13;
    static final int TIME_SIZE = 6;
    static final int COUNTER_POS = 19;
    static final int COUNTER_SIZE = 3;
    static final int VERSION = 1;
    static final int BYTE_SIZE = 8;

    GUIDImpl() {
        super(22);
    }

    GUIDImpl(byte[] bytes) throws InvalidGuidOperationException {
        super(22);
        this.setBytes(bytes, 22);
        if (this.getVersion() != 1) {
            throw new InvalidGuidOperationException("Version is incorrect: " + this.getVersion());
        }
    }

    GUIDImpl(String idsource) throws InvalidGuidOperationException {
        super(22);
        this.setString(idsource);
        if (this.getVersion() != 1) {
            throw new InvalidGuidOperationException("Version is incorrect: " + this.getVersion());
        }
    }

    public static int getKeySize() {
        return 22;
    }

    @JsonSetter(value="id")
    GUIDImpl setString(String idsource) throws InvalidGuidOperationException {
        block11: {
            if (idsource == null) {
                throw new InvalidGuidOperationException("Empty argument");
            }
            String id = idsource.trim();
            if (idsource.startsWith("ark:/")) {
                int tenantId;
                String ids = idsource;
                int separator = (ids = ids.substring("ark:/".length())).indexOf(47);
                if (separator <= 0) {
                    throw new InvalidGuidOperationException(ATTEMPTED_TO_PARSE_MALFORMED_ARK_GUID + id);
                }
                try {
                    tenantId = Integer.parseInt(ids.substring(0, separator));
                }
                catch (NumberFormatException e) {
                    throw new InvalidGuidOperationException(ATTEMPTED_TO_PARSE_MALFORMED_ARK_GUID + id);
                }
                ids = ids.substring(separator + 1);
                byte[] base32 = BaseXx.getFromBase32(ids);
                if (base32.length != 18) {
                    throw new InvalidGuidOperationException(ATTEMPTED_TO_PARSE_MALFORMED_ARK_GUID + id);
                }
                System.arraycopy(base32, 0, this.guid, 0, 2);
                this.guid[5] = (byte)(tenantId & 0xFF);
                this.guid[4] = (byte)((tenantId >>>= 8) & 0xFF);
                this.guid[3] = (byte)((tenantId >>>= 8) & 0xFF);
                this.guid[2] = (byte)((tenantId >>>= 8) & 0x3F);
                System.arraycopy(base32, 2, this.guid, 6, 16);
                return this;
            }
            int len = id.length();
            try {
                if (len == 44) {
                    System.arraycopy(BaseXx.getFromBase16(idsource), 0, this.guid, 0, 22);
                    break block11;
                }
                if (len == 36) {
                    System.arraycopy(BaseXx.getFromBase32(idsource), 0, this.guid, 0, 22);
                    break block11;
                }
                if (len == 30) {
                    System.arraycopy(BaseXx.getFromBase64UrlWithoutPadding(idsource), 0, this.guid, 0, 22);
                    break block11;
                }
                throw new InvalidGuidOperationException("Attempted to parse malformed GUID: (" + len + ") " + id);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidGuidOperationException("Attempted to parse malformed GUID: " + id, e);
            }
        }
        return this;
    }

    @Override
    @JsonIgnore
    public final int getVersion() {
        return this.guid[0] & 0xFF;
    }

    @Override
    @JsonIgnore
    public final int getObjectId() {
        return this.guid[1] & 0xFF;
    }

    @Override
    @JsonIgnore
    public final int getTenantId() {
        return (this.guid[2] & 0x3F) << 24 | (this.guid[3] & 0xFF) << 16 | (this.guid[4] & 0xFF) << 8 | this.guid[5] & 0xFF;
    }

    @Override
    @JsonIgnore
    public final boolean isWorm() {
        return (this.guid[6] & 0x80) != 0;
    }

    @Override
    @JsonIgnore
    public final int getPlatformId() {
        return (this.guid[6] & 0x7F) << 24 | (this.guid[7] & 0xFF) << 16 | (this.guid[8] & 0xFF) << 8 | this.guid[9] & 0xFF;
    }

    @Override
    @JsonIgnore
    public final byte[] getMacFragment() {
        if (this.getVersion() != 1) {
            return new byte[0];
        }
        byte[] x = new byte[]{0, 0, (byte)(this.guid[6] & 0x7F), this.guid[7], this.guid[8], this.guid[9]};
        return x;
    }

    @Override
    @JsonIgnore
    public final int getProcessId() {
        if (this.getVersion() != 1) {
            return -1;
        }
        return (this.guid[10] & 0xFF) << 16 | (this.guid[11] & 0xFF) << 8 | this.guid[12] & 0xFF;
    }

    @Override
    @JsonIgnore
    public final long getTimestamp() {
        if (this.getVersion() != 1) {
            return -1L;
        }
        long time = 0L;
        for (int i = 0; i < 6; ++i) {
            time <<= 8;
            time |= (long)(this.guid[13 + i] & 0xFF);
        }
        return time;
    }

    @Override
    @JsonIgnore
    public final int getCounter() {
        return (this.guid[19] & 0xFF) << 16 | (this.guid[20] & 0xFF) << 8 | this.guid[21] & 0xFF;
    }

    @Override
    @JsonIgnore
    public final String toArkName() {
        byte[] temp = new byte[18];
        System.arraycopy(this.guid, 0, temp, 0, 2);
        System.arraycopy(this.guid, 6, temp, 2, 16);
        return BaseXx.getBase32(temp);
    }

    @Override
    public int compareTo(GUID arg1) {
        long ts2;
        int id2;
        int id = this.getTenantId();
        if (id != (id2 = arg1.getTenantId())) {
            return id < id2 ? -1 : 1;
        }
        id = this.getObjectId();
        if (id != (id2 = arg1.getObjectId())) {
            return id < id2 ? -1 : 1;
        }
        long ts = this.getTimestamp();
        if (ts == (ts2 = arg1.getTimestamp())) {
            int ct2;
            int ct = this.getCounter();
            if (ct == (ct2 = arg1.getCounter())) {
                return Arrays.equals(this.guid, arg1.getBytes()) ? 0 : -1;
            }
            return ct < ct2 ? -1 : 1;
        }
        return ts < ts2 ? -1 : 1;
    }
}

