/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.SystemPropertyUtil;
import fr.gouv.vitam.common.VitamConfigurationParameters;
import fr.gouv.vitam.common.configuration.ClassificationLevel;
import fr.gouv.vitam.common.configuration.EliminationReportConfiguration;
import fr.gouv.vitam.common.digest.DigestType;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.logging.SysErrLogger;
import fr.gouv.vitam.common.model.dip.BinarySizePlatformThreshold;
import fr.gouv.vitam.common.model.dip.BinarySizeTenantThreshold;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public class VitamConfiguration {
    private static final VitamConfiguration DEFAULT_CONFIGURATION = new VitamConfiguration();
    public static final String ADMIN_PATH = "/admin/v1";
    public static final String AUTOTEST_URL = "/autotest";
    public static final String VERSION_URL = "/version";
    public static final String METRIC_URL = "/metrics";
    public static final String STATUS_URL = "/status";
    public static final String TENANTS_URL = "/tenants";
    public static final String LOGIN_URL = "/login";
    public static final String LOGOUT_URL = "/logout";
    public static final String MESSAGES_LOGBOOK_URL = "/messages/logbook";
    public static final String OBJECT_DOWNLOAD_URL = "/archiveunit/objects/download";
    public static final String DIP_EXPORT_URL = "/archiveunit/dipexport";
    public static final String SECURE_MODE_URL = "/securemode";
    public static final String ADMIN_TENANT_URL = "/admintenant";
    public static final String PERMISSIONS_URL = "permissions";
    protected static final String VITAM_CONFIG_PROPERTY = "vitam.config.folder";
    protected static final String VITAM_DATA_PROPERTY = "vitam.data.folder";
    protected static final String VITAM_LOG_PROPERTY = "vitam.log.folder";
    protected static final String VITAM_TMP_PROPERTY = "vitam.tmp.folder";
    private static final String VITAM_JUNIT_PROPERTY = "vitam.test.junit";
    private static final Integer CONNECT_TIMEOUT = 10000;
    private static final long SWIFT_FILE_LIMIT = 4000000000L;
    private static final long MAX_SHUTDOWN_TIMEOUT = 120000L;
    private static final String DEFAULT_STRATEGY = "default";
    private static String vitamConfigFolderDefault = "/vitam/conf";
    private static String vitamDataFolderDefault = "/vitam/data";
    private static String vitamLogFolderDefault = "/vitam/log";
    private static String vitamTmpFolderDefault = "/vitam/data/tmp";
    private static String vitamGriffinExecFolder = "/vitam/bin/worker/griffins";
    private static String vitamGriffinInputFilesFolder = "/vitam/tmp/worker/griffins";
    private static String workspaceWorkflowsFolder = "workflows";
    private static Integer vitamCleanPeriod = 1;
    private static Integer elasticSearchScrollTimeoutInMilliseconds = 300000;
    private static Integer elasticSearchTimeoutWaitRequestInMilliseconds = 120000;
    private static Integer elasticSearchScrollLimit = 10000;
    private static Integer chunkSize = 65536;
    private static Integer recvBufferSize = 0;
    private static Integer readTimeout = 86400000;
    private static Integer maxTotalClient = 1000;
    private static Integer maxClientPerHost = 200;
    private static Integer delayValidationAfterInactivity = 60000;
    private static Integer delayMultipleInputstream = 60000;
    private static Integer delayMultipleSubinputstream = 6000;
    private static Integer minimumThreadPoolSize = 100;
    private static Integer noValidationAfterInactivity = -1;
    private static Integer delayGetClient = 60000;
    private static int intervalDelayCheckIdle = 300000;
    private static int intervalDelayLogInProgressWorker = 600000;
    private static int maxDelayUnusedConnection = 300000;
    private static Boolean useNewJaxrClient = false;
    private static DigestType securityDigestType = DigestType.SHA256;
    private static DigestType defaultDigestType = DigestType.SHA512;
    private static DigestType defaultTimestampDigestType = DigestType.SHA512;
    private static int acceptableRequestTime = 10;
    private static int criticalRequestTime = 60;
    private static int requestTimeAlertThrottlingDelay = 60;
    private static int httpClientRetry = 3;
    private static int httpClientFirstAttemptWaitingTime = 10;
    private static int httpClientWaitingTime = 20;
    private static int httpClientRandomWaitingSleep = 5;
    private static Integer retryNumber = 3;
    private static Integer retryDelay = 30000;
    private static Integer waitingDelay = 1000;
    private static Boolean allowGzipEncoding = false;
    private static Boolean allowGzipDecoding = false;
    private static Integer bufferNumber = 4;
    private static Integer maxConcurrentMultipleInputstreamHandler = 200;
    private static boolean exportScore = false;
    private static int distributeurBatchSize = 800;
    private static int workerBulkSize = 10;
    private static int restoreBulkSize = 10000;
    private static int cacheControlDelay = 60;
    private static int maxCacheEntries = 25000;
    private static int expireCacheEntriesDelay = 300;
    private static int maxElasticsearchBulk = 1000;
    private static int batchSize = 1000;
    private static int storeGraphElementsPerFile = 10000;
    private static int storeGraphOverlapDelay = 300;
    private static int migrationBulkSize = 10000;
    private static int deleteIncompleteReconstructedUnitDelay = 2592000;
    private static int optimisticLockRetryNumber = 50;
    private static int optimisticLockSleepTime = 20;
    private static BinarySizePlatformThreshold binarySizePlatformThreshold = new BinarySizePlatformThreshold(1L, BinarySizePlatformThreshold.SizeUnit.GIGABYTE);
    private static List<BinarySizeTenantThreshold> binarySizeTenantThreshold = new ArrayList<BinarySizeTenantThreshold>();
    private static int keywordMaxLength = 32766;
    private static int textMaxLength = 32766;
    private static int textContentMaxLength = 320000;
    private static final int defaultOffset = 0;
    private static int numberDbClientThread = 200;
    private static int numberEsQueue = 5000;
    private static long distributionThreshold = 100000L;
    private static long queriesThreshold = 100000L;
    private static int bulkAtomicUpdateBatchSize = 100;
    private static int bulkAtomicUpdateThreadPoolSize = 8;
    private static int bulkAtomicUpdateThreadPoolQueueSize = 16;
    private static long eliminationAnalysisThreshold = 100000L;
    private static long eliminationActionThreshold = 10000L;
    private static long computedInheritedRulesThreshold = 100000000L;
    private static int ontologyCacheMaxEntries = 100;
    private static int ontologyCacheTimeoutInSeconds = 300;
    private static final String DEFAULT_ORIGINATING_AGENCY_FOR_EXPORT = "Export VITAM";
    private static Map<Integer, String> defaultOriginatingAgencyByTenant = new HashMap<Integer, String>();
    private static String vitamDefaultTransferringAgency = "VITAM";
    private static Map<String, String> vitamDefaultCodeListVersion = new HashMap<String, String>();
    private static String DEFAULT_LANG = Locale.FRENCH.toString();
    private static final short DIFF_VERSION = 1;
    private static int workspaceFreespaceThreshold = 25;
    private String config;
    private String log;
    private String data;
    private String tmp;
    private static String secret;
    private static boolean purgeTemporaryLFC;
    private static Boolean filterActivation;
    private Integer connectTimeout = CONNECT_TIMEOUT;
    private static int asyncWorkspaceQueueSize;
    private static Boolean forceChunkModeInputStream;
    private static int maxResultWindow;
    private static List<Integer> TENANTS;
    private static int ADMIN_TENANT;
    private static String environmentName;
    private static int reclassificationMaxBulkThreshold;
    private static int reclassificationMaxUnitsThreshold;
    private static int reclassificationMaxGuildListSizeInLogbookOperation;
    private static ClassificationLevel classificationLevel;
    private static List<String> indexInheritedRulesWithRulesIdByTenant;
    private static List<String> indexInheritedRulesWithAPIV2OutputByTenant;
    private static long operationMaxSizeForExternal;
    private static int processEngineWaitForStepTimeout;
    private static Map<Integer, List<String>> eliminationReportExtraFields;

    VitamConfiguration() {
    }

    VitamConfiguration(String config, String log, String data, String tmp) {
        this.setConfig(config).setData(data).setLog(log).setTmp(tmp);
        this.checkValues();
    }

    public static VitamConfiguration getConfiguration() {
        return DEFAULT_CONFIGURATION;
    }

    public static Integer getAdminTenant() {
        return ADMIN_TENANT;
    }

    public static void setAdminTenant(Integer adminTenant) {
        ADMIN_TENANT = adminTenant;
    }

    public static List<Integer> getTenants() {
        return TENANTS;
    }

    public static void setTenants(List<Integer> tenants) {
        TENANTS = tenants;
    }

    public static boolean isPurgeTemporaryLFC() {
        return purgeTemporaryLFC;
    }

    public static void setPurgeTemporaryLFC(boolean purgeTemporaryLFC) {
        VitamConfiguration.purgeTemporaryLFC = purgeTemporaryLFC;
    }

    public static int getIntervalDelayLogInProgressWorker() {
        return intervalDelayLogInProgressWorker;
    }

    public static void setIntervalDelayLogInProgressWorker(int intervalDelayLogInProgressWorker) {
        VitamConfiguration.intervalDelayLogInProgressWorker = intervalDelayLogInProgressWorker;
    }

    public static int getOntologyCacheMaxEntries() {
        return ontologyCacheMaxEntries;
    }

    public static void setOntologyCacheMaxEntries(int ontologyCacheMaxEntries) {
        VitamConfiguration.ontologyCacheMaxEntries = ontologyCacheMaxEntries;
    }

    public static int getOntologyCacheTimeoutInSeconds() {
        return ontologyCacheTimeoutInSeconds;
    }

    public static void setOntologyCacheTimeoutInSeconds(int ontologyCacheTimeoutInSeconds) {
        VitamConfiguration.ontologyCacheTimeoutInSeconds = ontologyCacheTimeoutInSeconds;
    }

    public static int getHttpClientRetry() {
        return httpClientRetry;
    }

    public static void setHttpClientRetry(int httpClientRetry) {
        VitamConfiguration.httpClientRetry = httpClientRetry;
    }

    public static int getHttpClientFirstAttemptWaitingTime() {
        return httpClientFirstAttemptWaitingTime;
    }

    public static void setHttpClientFirstAttemptWaitingTime(int httpClientFirstAttemptWaitingTime) {
        VitamConfiguration.httpClientFirstAttemptWaitingTime = httpClientFirstAttemptWaitingTime;
    }

    public static int getHttpClientWaitingTime() {
        return httpClientWaitingTime;
    }

    public static void setHttpClientWaitingTime(int httpClientWaitingTime) {
        VitamConfiguration.httpClientWaitingTime = httpClientWaitingTime;
    }

    public static int getHttpClientRandomWaitingSleep() {
        return httpClientRandomWaitingSleep;
    }

    public static void setHttpClientRandomWaitingSleep(int httpClientRandomWaitingSleep) {
        VitamConfiguration.httpClientRandomWaitingSleep = httpClientRandomWaitingSleep;
    }

    public static int getTextContentMaxLength() {
        return textContentMaxLength;
    }

    public static void setTextContentMaxLength(int textContentMaxLength) {
        VitamConfiguration.textContentMaxLength = textContentMaxLength;
    }

    public static int getProcessEngineWaitForStepTimeout() {
        return processEngineWaitForStepTimeout;
    }

    public static void setProcessEngineWaitForStepTimeout(int processEngineWaitForStepTimeout) {
        VitamConfiguration.processEngineWaitForStepTimeout = processEngineWaitForStepTimeout;
    }

    public static int getWorkspaceFreespaceThreshold() {
        return workspaceFreespaceThreshold;
    }

    public static void setWorkspaceFreespaceThreshold(int workspaceFreespaceThreshold) {
        VitamConfiguration.workspaceFreespaceThreshold = workspaceFreespaceThreshold;
    }

    void setInternalConfiguration(VitamConfiguration vitamConfiguration) {
        this.setConfig(vitamConfiguration.getConfig()).setData(vitamConfiguration.getData()).setLog(vitamConfiguration.getLog()).setTmp(vitamConfiguration.getTmp()).checkValues();
    }

    static void setConfiguration(VitamConfiguration vitamConfiguration) {
        DEFAULT_CONFIGURATION.setConfig(vitamConfiguration.getConfig()).setData(vitamConfiguration.getData()).setLog(vitamConfiguration.getLog()).setTmp(vitamConfiguration.getTmp()).checkValues();
    }

    static void setConfiguration(String config, String log, String data, String tmp) {
        DEFAULT_CONFIGURATION.setConfig(config).setData(data).setLog(log).setTmp(tmp).checkValues();
    }

    private VitamConfiguration setDefault() {
        this.connectTimeout = CONNECT_TIMEOUT;
        VitamConfiguration.checkVitamConfiguration();
        this.checkValues();
        return this;
    }

    public String getConfig() {
        return this.config;
    }

    public VitamConfiguration setConfig(String config) {
        ParametersChecker.checkParameter("Config directory", config);
        this.config = config;
        return this;
    }

    public String getLog() {
        return this.log;
    }

    public VitamConfiguration setLog(String log) {
        ParametersChecker.checkParameter("Log directory", log);
        this.log = log;
        return this;
    }

    public String getData() {
        return this.data;
    }

    public VitamConfiguration setData(String data) {
        ParametersChecker.checkParameter("Data directory", data);
        this.data = data;
        return this;
    }

    public String getTmp() {
        return this.tmp;
    }

    public VitamConfiguration setTmp(String tmp) {
        ParametersChecker.checkParameter("Tmp directory", tmp);
        this.tmp = tmp;
        return this;
    }

    public static void importConfigurationParameters(VitamConfigurationParameters parameters) {
        DigestType digestType;
        if (null != parameters.getVitamConfigFolderDefault()) {
            VitamConfiguration.setVitamConfigFolderDefault(parameters.getVitamConfigFolderDefault());
        }
        if (null != parameters.getVitamDataFolderDefault()) {
            VitamConfiguration.setVitamDataFolderDefault(parameters.getVitamDataFolderDefault());
        }
        if (null != parameters.getVitamLogFolderDefault()) {
            VitamConfiguration.setVitamLogFolderDefault(parameters.getVitamLogFolderDefault());
        }
        if (null != parameters.getVitamTmpFolderDefault()) {
            VitamConfiguration.setVitamTmpFolderDefault(parameters.getVitamTmpFolderDefault());
        }
        if (null != parameters.getChunkSize()) {
            VitamConfiguration.setChunkSize(parameters.getChunkSize());
        }
        if (null != parameters.getRecvBufferSize()) {
            VitamConfiguration.setRecvBufferSize(parameters.getRecvBufferSize());
        }
        if (null != parameters.getRecvBufferSize()) {
            VitamConfiguration.setRecvBufferSize(parameters.getRecvBufferSize());
        }
        if (null != parameters.getConnectTimeout()) {
            VitamConfiguration.setConnectTimeout(parameters.getConnectTimeout());
        }
        if (null != parameters.getReadTimeout()) {
            VitamConfiguration.setReadTimeout(parameters.getReadTimeout());
        }
        if (null != parameters.getMaxTotalClient()) {
            VitamConfiguration.setMaxTotalClient(parameters.getMaxTotalClient());
        }
        if (null != parameters.getMaxClientPerHost()) {
            VitamConfiguration.setMaxClientPerHost(parameters.getMaxClientPerHost());
        }
        if (null != parameters.getDelayValidationAfterInactivity()) {
            VitamConfiguration.setDelayValidationAfterInactivity(parameters.getDelayValidationAfterInactivity());
        }
        if (null != parameters.getDelayMultipleInputstream()) {
            VitamConfiguration.setDelayMultipleInputstream(parameters.getDelayMultipleInputstream());
        }
        if (null != parameters.getDelayMultipleSubinputstream()) {
            VitamConfiguration.setDelayMultipleSubinputstream(parameters.getDelayMultipleSubinputstream());
        }
        if (null != parameters.getMinimumThreadPoolSize()) {
            VitamConfiguration.setMinimumThreadPoolSize(parameters.getMinimumThreadPoolSize());
        }
        if (null != parameters.getNoValidationAfterInactivity()) {
            VitamConfiguration.setNoValidationAfterInactivity(parameters.getNoValidationAfterInactivity());
        }
        if (null != parameters.getDelayGetClient()) {
            VitamConfiguration.setDelayGetClient(parameters.getDelayGetClient());
        }
        if (null != parameters.getIntervalDelayCheckIdle()) {
            VitamConfiguration.setIntervalDelayCheckIdle(parameters.getIntervalDelayCheckIdle());
        }
        if (null != parameters.getIntervalDelayLogInProgressWorker()) {
            VitamConfiguration.setIntervalDelayLogInProgressWorker(parameters.getIntervalDelayLogInProgressWorker());
        }
        if (null != parameters.getMaxDelayUnusedConnection()) {
            VitamConfiguration.setMaxDelayUnusedConnection(parameters.getMaxDelayUnusedConnection());
        }
        if (null != parameters.getSecurityDigestType()) {
            digestType = DigestType.valueOf(parameters.getSecurityDigestType());
            VitamConfiguration.setSecurityDigestType(digestType);
        }
        if (null != parameters.getDefaultDigestType()) {
            digestType = DigestType.valueOf(parameters.getDefaultDigestType());
            VitamConfiguration.setDefaultDigestType(digestType);
        }
        if (null != parameters.getDefaultTimestampDigestType()) {
            digestType = DigestType.valueOf(parameters.getDefaultTimestampDigestType());
            VitamConfiguration.setDefaultTimestampDigestType(digestType);
        }
        if (null != parameters.getAcceptableRequestTime()) {
            VitamConfiguration.setAcceptableRequestTime(parameters.getAcceptableRequestTime());
        }
        if (null != parameters.getCriticalRequestTime()) {
            VitamConfiguration.setCriticalRequestTime(parameters.getCriticalRequestTime());
        }
        if (null != parameters.getRequestTimeAlertThrottlingDelay()) {
            VitamConfiguration.setRequestTimeAlertThrottlingDelay(parameters.getRequestTimeAlertThrottlingDelay());
        }
        if (null != parameters.getRetryNumber()) {
            VitamConfiguration.setRetryNumber(parameters.getRetryNumber());
        }
        if (null != parameters.getRetryDelay()) {
            VitamConfiguration.setRetryDelay(parameters.getRetryDelay());
        }
        if (null != parameters.getWaitingDelay()) {
            VitamConfiguration.setWaitingDelay(parameters.getWaitingDelay());
        }
        if (null != parameters.getBufferNumber()) {
            VitamConfiguration.setBufferNumber(parameters.getBufferNumber());
        }
        if (null != parameters.isAllowGzipEncoding()) {
            VitamConfiguration.setAllowGzipEncoding(parameters.isAllowGzipEncoding());
        }
        if (null != parameters.isAllowGzipDecoding()) {
            VitamConfiguration.setAllowGzipDecoding(parameters.isAllowGzipDecoding());
        }
        if (null != parameters.isUseNewJaxrClient()) {
            VitamConfiguration.setUseNewJaxrClient(parameters.isUseNewJaxrClient());
        }
        if (null != parameters.isFilterActivation()) {
            VitamConfiguration.setFilterActivation(parameters.isFilterActivation());
        }
        if (null != parameters.getMaxConcurrentMultipleInputstreamHandler()) {
            VitamConfiguration.setMaxConcurrentMultipleInputstreamHandler(parameters.getMaxConcurrentMultipleInputstreamHandler());
        }
        if (null != parameters.getVitamCleanPeriod()) {
            VitamConfiguration.setVitamCleanPeriod(parameters.getVitamCleanPeriod());
        }
        if (null != parameters.isExportScore()) {
            VitamConfiguration.setExportScore(parameters.isExportScore());
        }
        if (null != parameters.getDistributeurBatchSize()) {
            VitamConfiguration.setDistributeurBatchSize(parameters.getDistributeurBatchSize());
        }
        if (null != parameters.getWorkerBulkSize()) {
            VitamConfiguration.setWorkerBulkSize(parameters.getWorkerBulkSize());
        }
        if (null != parameters.getRestoreBulkSize()) {
            VitamConfiguration.setRestoreBulkSize(parameters.getRestoreBulkSize());
        }
        if (null != parameters.getMaxElasticsearchBulk()) {
            VitamConfiguration.setMaxElasticsearchBulk(parameters.getMaxElasticsearchBulk());
        }
        if (null != parameters.getNumberDbClientThread()) {
            VitamConfiguration.setNumberDbClientThread(parameters.getNumberDbClientThread());
        }
        if (null != parameters.getNumberEsQueue()) {
            VitamConfiguration.setNumberEsQueue(parameters.getNumberEsQueue());
        }
        if (null != parameters.getDistributionThreshold()) {
            VitamConfiguration.setDistributionThreshold(parameters.getDistributionThreshold());
        }
        if (null != parameters.getBulkAtomicUpdateBatchSize()) {
            VitamConfiguration.setBulkAtomicUpdateBatchSize(parameters.getBulkAtomicUpdateBatchSize());
        }
        if (null != parameters.getBulkAtomicUpdateThreadPoolSize()) {
            VitamConfiguration.setBulkAtomicUpdateThreadPoolSize(parameters.getBulkAtomicUpdateThreadPoolSize());
        }
        if (null != parameters.getBulkAtomicUpdateThreadPoolQueueSize()) {
            VitamConfiguration.setBulkAtomicUpdateThreadPoolQueueSize(parameters.getBulkAtomicUpdateThreadPoolQueueSize());
        }
        if (null != parameters.getQueriesThreshold()) {
            VitamConfiguration.setQueriesThreshold(parameters.getQueriesThreshold());
        }
        if (null != parameters.getEliminationAnalysisThreshold()) {
            VitamConfiguration.setEliminationAnalysisThreshold(parameters.getEliminationAnalysisThreshold());
        }
        if (null != parameters.getEliminationActionThreshold()) {
            VitamConfiguration.setEliminationActionThreshold(parameters.getEliminationActionThreshold());
        }
        if (null != parameters.getComputedInheritedRulesThreshold()) {
            VitamConfiguration.setComputedInheritedRulesThreshold(parameters.getComputedInheritedRulesThreshold());
        }
        if (null != parameters.getCacheControlDelay()) {
            VitamConfiguration.setCacheControlDelay(parameters.getCacheControlDelay());
        }
        if (null != parameters.getMaxCacheEntries()) {
            VitamConfiguration.setMaxCacheEntries(parameters.getMaxCacheEntries());
        }
        if (null != parameters.getBinarySizePlatformThreshold()) {
            VitamConfiguration.setBinarySizePlatformThreshold(parameters.getBinarySizePlatformThreshold());
        }
        if (null != parameters.getBinarySizeTenantThreshold()) {
            VitamConfiguration.setBinarySizeTenantThreshold(parameters.getBinarySizeTenantThreshold());
        }
        if (null != parameters.getExpireCacheEntriesDelay()) {
            VitamConfiguration.setExpireCacheEntriesDelay(parameters.getExpireCacheEntriesDelay());
        }
        if (null != parameters.getAdminTenant()) {
            VitamConfiguration.setAdminTenant(parameters.getAdminTenant());
        }
        if (null != parameters.getTenants()) {
            VitamConfiguration.setTenants(parameters.getTenants());
        }
        if (null != parameters.getDefaultOriginatingAgencyForExport()) {
            VitamConfiguration.setDefaultOriginatingAgencyByTenant(parameters.getDefaultOriginatingAgencyForExport());
        }
        if (null != parameters.getVitamDefaultTransferringAgency()) {
            VitamConfiguration.setVitamDefaultTransferringAgency(parameters.getVitamDefaultTransferringAgency());
        }
        if (null != parameters.getVitamDefaultCodeListVersion()) {
            VitamConfiguration.setVitamDefaultCodeListVersion(parameters.getVitamDefaultCodeListVersion());
        }
        if (null != parameters.getStoreGraphElementsPerFile()) {
            VitamConfiguration.setStoreGraphElementsPerFile(parameters.getStoreGraphElementsPerFile());
        }
        if (null != parameters.getStoreGraphOverlapDelay()) {
            VitamConfiguration.setStoreGraphOverlapDelay(parameters.getStoreGraphOverlapDelay());
        }
        if (null != parameters.getMigrationBulkSize()) {
            VitamConfiguration.setMigrationBulkSize(parameters.getMigrationBulkSize());
        }
        if (null != parameters.getDeleteIncompleteReconstructedUnitDelay()) {
            VitamConfiguration.setDeleteIncompleteReconstructedUnitDelay(parameters.getDeleteIncompleteReconstructedUnitDelay());
        }
        if (null != parameters.getOptimisticLockRetryNumber()) {
            VitamConfiguration.setOptimisticLockRetryNumber(parameters.getOptimisticLockRetryNumber());
        }
        if (null != parameters.getOptimisticLockSleepTime()) {
            VitamConfiguration.setOptimisticLockSleepTime(parameters.getOptimisticLockSleepTime());
        }
        if (null != parameters.isForceChunkModeInputStream()) {
            VitamConfiguration.setForceChunkModeInputStream(parameters.isForceChunkModeInputStream());
        }
        if (null != parameters.getReclassificationMaxBulkThreshold()) {
            VitamConfiguration.setReclassificationMaxBulkThreshold(parameters.getReclassificationMaxBulkThreshold());
        }
        if (null != parameters.getReclassificationMaxUnitsThreshold()) {
            VitamConfiguration.setReclassificationMaxUnitsThreshold(parameters.getReclassificationMaxUnitsThreshold());
        }
        if (null != parameters.getReclassificationMaxGuildListSizeInLogbookOperation()) {
            VitamConfiguration.setReclassificationMaxGuildListSizeInLogbookOperation(parameters.getReclassificationMaxGuildListSizeInLogbookOperation());
        }
        if (null != parameters.getKeywordMaxLength()) {
            VitamConfiguration.setKeywordMaxLength(parameters.getKeywordMaxLength());
        }
        if (null != parameters.getTextMaxLength()) {
            VitamConfiguration.setTextMaxLength(parameters.getTextMaxLength());
        }
        if (null != parameters.getTextContentMaxLength()) {
            VitamConfiguration.setTextContentMaxLength(parameters.getTextContentMaxLength());
        }
        if (null != parameters.getClassificationLevel()) {
            VitamConfiguration.setClassificationLevel(parameters.getClassificationLevel());
        }
        if (null != parameters.getEnvironmentName()) {
            VitamConfiguration.setEnvironmentName(parameters.getEnvironmentName());
        }
        if (null != parameters.getOperationMaxSizeForExternal()) {
            VitamConfiguration.setOperationMaxSizeForExternal(parameters.getOperationMaxSizeForExternal());
        }
        if (null != parameters.getIndexInheritedRulesWithAPIV2OutputByTenant()) {
            VitamConfiguration.setIndexInheritedRulesWithAPIV2OutputByTenant(parameters.getIndexInheritedRulesWithAPIV2OutputByTenant());
        }
        if (null != parameters.getIndexInheritedRulesWithRulesIdByTenant()) {
            VitamConfiguration.setIndexInheritedRulesWithRulesIdByTenant(parameters.getIndexInheritedRulesWithRulesIdByTenant());
        }
        if (null != parameters.getOntologyCacheMaxEntries()) {
            VitamConfiguration.setOntologyCacheMaxEntries(parameters.getOntologyCacheMaxEntries());
        }
        if (null != parameters.getOntologyCacheTimeoutInSeconds()) {
            VitamConfiguration.setOntologyCacheTimeoutInSeconds(parameters.getOntologyCacheTimeoutInSeconds());
        }
        if (null != parameters.getHttpClientRetry()) {
            VitamConfiguration.setHttpClientRetry(parameters.getHttpClientRetry());
        }
        if (null != parameters.getHttpClientFirstAttemptWaitingTime()) {
            VitamConfiguration.setHttpClientFirstAttemptWaitingTime(parameters.getHttpClientFirstAttemptWaitingTime());
        }
        if (null != parameters.getHttpClientRandomWaitingSleep()) {
            VitamConfiguration.setHttpClientRandomWaitingSleep(parameters.getHttpClientRandomWaitingSleep());
        }
        if (null != parameters.getHttpClientWaitingTime()) {
            VitamConfiguration.setHttpClientWaitingTime(parameters.getHttpClientWaitingTime());
        }
        if (null != parameters.getElasticSearchScrollTimeoutInMilliseconds()) {
            VitamConfiguration.setElasticSearchScrollTimeoutInMilliseconds(parameters.getElasticSearchScrollTimeoutInMilliseconds());
        }
        if (null != parameters.getElasticSearchTimeoutWaitRequestInMilliseconds()) {
            VitamConfiguration.setElasticSearchTimeoutWaitRequestInMilliseconds(parameters.getElasticSearchTimeoutWaitRequestInMilliseconds());
        }
        if (null != parameters.getElasticSearchScrollLimit()) {
            VitamConfiguration.setElasticSearchScrollLimit(parameters.getElasticSearchScrollLimit());
        }
        if (null != parameters.getProcessEngineWaitForStepTimeout()) {
            VitamConfiguration.setProcessEngineWaitForStepTimeout(parameters.getProcessEngineWaitForStepTimeout());
        }
        if (null != parameters.getWorkspaceFreespaceThreshold()) {
            VitamConfiguration.setWorkspaceFreespaceThreshold(parameters.getWorkspaceFreespaceThreshold());
        }
        if (null != parameters.getEliminationReportExtraFields()) {
            VitamConfiguration.checkEliminationReportExtraFieldsValues(parameters.getEliminationReportExtraFields());
            VitamConfiguration.setEliminationReportExtraFields(parameters.getEliminationReportExtraFields().stream().collect(Collectors.toMap(EliminationReportConfiguration::getTenant, EliminationReportConfiguration::getMetadataFields)));
        }
    }

    private static void checkEliminationReportExtraFieldsValues(List<EliminationReportConfiguration> eliminationReportExtraFields) {
        for (EliminationReportConfiguration eliminationReportExtraField : eliminationReportExtraFields) {
            ArrayList<String> metadataFields = new ArrayList<String>(eliminationReportExtraField.getMetadataFields());
            metadataFields.removeAll(EliminationReportConfiguration.WHITELISTED_FIELDS);
            if (metadataFields.isEmpty()) continue;
            throw new VitamRuntimeException(String.format("Unexpected value(s) : %s for tenant %d", String.join((CharSequence)",", metadataFields), eliminationReportExtraField.getTenant()));
        }
    }

    private void checkValues() {
        ParametersChecker.checkParameter("Check directories", this.tmp, this.data, this.log, this.config);
        File tmpDir = new File(this.tmp);
        File logDir = new File(this.log);
        File dataDir = new File(this.data);
        File configDir = new File(this.config);
        if (!tmpDir.isDirectory()) {
            tmpDir.mkdirs();
        }
        if (!(tmpDir.isDirectory() && logDir.isDirectory() && dataDir.isDirectory() && configDir.isDirectory())) {
            SysErrLogger.FAKE_LOGGER.syserr("One of the directories in the VitamConfiguration is not correct");
        }
    }

    @VisibleForTesting
    public static void reinit() {
        VitamConfiguration.checkVitamConfiguration();
    }

    static void checkVitamConfiguration() {
        if (!(SystemPropertyUtil.contains(VITAM_TMP_PROPERTY) && SystemPropertyUtil.contains(VITAM_CONFIG_PROPERTY) && SystemPropertyUtil.contains(VITAM_DATA_PROPERTY) && SystemPropertyUtil.contains(VITAM_LOG_PROPERTY))) {
            SysErrLogger.FAKE_LOGGER.syserr("One of the directives is not specified: -Dxxx=path where xxx is one of -Dvitam.tmp.folder -Dvitam.config.folder -Dvitam.data.folder -Dvitam.log.folder");
        }
        String data = vitamDataFolderDefault;
        if (SystemPropertyUtil.contains(VITAM_DATA_PROPERTY)) {
            data = SystemPropertyUtil.get(VITAM_DATA_PROPERTY);
        }
        String tmp = vitamTmpFolderDefault;
        if (SystemPropertyUtil.contains(VITAM_TMP_PROPERTY)) {
            tmp = SystemPropertyUtil.get(VITAM_TMP_PROPERTY);
        }
        String config = vitamConfigFolderDefault;
        if (SystemPropertyUtil.contains(VITAM_CONFIG_PROPERTY)) {
            config = SystemPropertyUtil.get(VITAM_CONFIG_PROPERTY);
        }
        String log = vitamLogFolderDefault;
        if (SystemPropertyUtil.contains(VITAM_LOG_PROPERTY)) {
            log = SystemPropertyUtil.get(VITAM_LOG_PROPERTY);
        }
        VitamConfiguration.setConfiguration(config, log, data, tmp);
    }

    public static String getVitamTmpFolder() {
        if (SystemPropertyUtil.contains(VITAM_TMP_PROPERTY)) {
            return SystemPropertyUtil.get(VITAM_TMP_PROPERTY);
        }
        return VitamConfiguration.getConfiguration().getTmp();
    }

    public static String getVitamLogFolder() {
        return VitamConfiguration.getConfiguration().getLog();
    }

    public static String getVitamDataFolder() {
        return VitamConfiguration.getConfiguration().getData();
    }

    public static String getVitamConfigFolder() {
        return VitamConfiguration.getConfiguration().getConfig();
    }

    public static Integer getChunkSize() {
        return chunkSize;
    }

    public static Integer getConnectTimeout() {
        return VitamConfiguration.getConfiguration().connectTimeout;
    }

    public static void setConnectTimeout(int timeout) {
        VitamConfiguration.getConfiguration().connectTimeout = timeout;
    }

    public static Integer getReadTimeout() {
        return readTimeout;
    }

    public static long getShutdownTimeout() {
        return 120000L;
    }

    public static String getDefaultStrategy() {
        return DEFAULT_STRATEGY;
    }

    public static Integer getMaxTotalClient() {
        return maxTotalClient;
    }

    public static Integer getMaxClientPerHost() {
        return maxClientPerHost;
    }

    public static Integer getDelayValidationAfterInactivity() {
        return delayValidationAfterInactivity;
    }

    public static Integer getDelayGetClient() {
        return delayGetClient;
    }

    public static Integer getIntervalDelayCheckIdle() {
        return intervalDelayCheckIdle;
    }

    public static Integer getMaxDelayUnusedConnection() {
        return maxDelayUnusedConnection;
    }

    public static String getSecret() {
        if (Strings.isNullOrEmpty((String)secret)) {
            return "";
        }
        return secret;
    }

    public static void setSecret(String secretValue) {
        ParametersChecker.checkParameter("Platform secret", secretValue);
        secret = secretValue;
    }

    public static Boolean isFilterActivation() {
        return filterActivation;
    }

    public static void setFilterActivation(Boolean filterActivationValue) {
        filterActivation = filterActivationValue;
    }

    public static int getAcceptableRequestTime() {
        return acceptableRequestTime;
    }

    public static int getCriticalRequestTime() {
        return criticalRequestTime;
    }

    public static int getRequestTimeAlertThrottlingDelay() {
        return requestTimeAlertThrottlingDelay;
    }

    public static DigestType getSecurityDigestType() {
        return securityDigestType;
    }

    public static DigestType getDefaultDigestType() {
        return defaultDigestType;
    }

    public static DigestType getDefaultTimestampDigestType() {
        return defaultTimestampDigestType;
    }

    public static Integer getRetryNumber() {
        return retryNumber;
    }

    public static Integer getRetryDelay() {
        return retryDelay;
    }

    public static Integer getWaitingDelay() {
        return waitingDelay;
    }

    public static Integer getAsyncWorkspaceQueueSize() {
        return asyncWorkspaceQueueSize;
    }

    public static Integer getRecvBufferSize() {
        return recvBufferSize;
    }

    public static Boolean isUseNewJaxrClient() {
        return useNewJaxrClient;
    }

    public static boolean isIntegrationTest() {
        return SystemPropertyUtil.get(VITAM_JUNIT_PROPERTY, false);
    }

    public static void setIntegrationTest(boolean value) {
        SystemPropertyUtil.set(VITAM_JUNIT_PROPERTY, value);
    }

    public static String getVitamConfigProperty() {
        return VITAM_CONFIG_PROPERTY;
    }

    public static String getVitamDataProperty() {
        return VITAM_DATA_PROPERTY;
    }

    public static String getVitamLogProperty() {
        return VITAM_LOG_PROPERTY;
    }

    public static String getVitamTmpProperty() {
        return VITAM_TMP_PROPERTY;
    }

    public static String getVitamConfigFolderDefault() {
        return vitamConfigFolderDefault;
    }

    private static void setVitamConfigFolderDefault(String vitamConfigFolderDefault) {
        VitamConfiguration.vitamConfigFolderDefault = vitamConfigFolderDefault;
    }

    public static String getVitamDataFolderDefault() {
        return vitamDataFolderDefault;
    }

    private static void setVitamDataFolderDefault(String vitamDataFolderDefault) {
        VitamConfiguration.vitamDataFolderDefault = vitamDataFolderDefault;
    }

    public static String getVitamLogFolderDefault() {
        return vitamLogFolderDefault;
    }

    private static void setVitamLogFolderDefault(String vitamLogFolderDefault) {
        VitamConfiguration.vitamLogFolderDefault = vitamLogFolderDefault;
    }

    public static Integer getVitamCleanPeriod() {
        return vitamCleanPeriod;
    }

    private static void setVitamCleanPeriod(Integer vitamCleanPeriod) {
        VitamConfiguration.vitamCleanPeriod = vitamCleanPeriod;
    }

    public static String getVitamTmpFolderDefault() {
        return vitamTmpFolderDefault;
    }

    private static void setVitamTmpFolderDefault(String vitamTmpFolderDefault) {
        VitamConfiguration.vitamTmpFolderDefault = vitamTmpFolderDefault;
    }

    private static void setChunkSize(int chunkSize) {
        VitamConfiguration.chunkSize = chunkSize;
    }

    public static void setAsyncWorkspaceQueueSize(int queueSize) {
        asyncWorkspaceQueueSize = queueSize;
    }

    private static void setRecvBufferSize(int recvBufferSize) {
        VitamConfiguration.recvBufferSize = recvBufferSize;
    }

    private static void setReadTimeout(int readTimeout) {
        VitamConfiguration.readTimeout = readTimeout;
    }

    private static void setMaxTotalClient(int maxTotalClient) {
        VitamConfiguration.maxTotalClient = maxTotalClient;
    }

    private static void setMaxClientPerHost(int maxClientPerHost) {
        VitamConfiguration.maxClientPerHost = maxClientPerHost;
    }

    private static void setDelayValidationAfterInactivity(int delayValidationAfterInactivity) {
        VitamConfiguration.delayValidationAfterInactivity = delayValidationAfterInactivity;
    }

    public static Integer getDelayMultipleInputstream() {
        return delayMultipleInputstream;
    }

    public static void setDelayMultipleInputstream(int delayMultipleInputstream) {
        VitamConfiguration.delayMultipleInputstream = delayMultipleInputstream;
    }

    public static Integer getDelayMultipleSubinputstream() {
        return delayMultipleSubinputstream;
    }

    private static void setDelayMultipleSubinputstream(int delayMultipleSubinputstream) {
        VitamConfiguration.delayMultipleSubinputstream = delayMultipleSubinputstream;
    }

    public static Integer getMinimumThreadPoolSize() {
        return minimumThreadPoolSize;
    }

    private static void setMinimumThreadPoolSize(int minimumThreadPoolSize) {
        VitamConfiguration.minimumThreadPoolSize = minimumThreadPoolSize;
    }

    public static Integer getNoValidationAfterInactivity() {
        return noValidationAfterInactivity;
    }

    private static void setNoValidationAfterInactivity(int noValidationAfterInactivity) {
        VitamConfiguration.noValidationAfterInactivity = noValidationAfterInactivity;
    }

    private static void setDelayGetClient(int delayGetClient) {
        VitamConfiguration.delayGetClient = delayGetClient;
    }

    private static void setIntervalDelayCheckIdle(int intervalDelayCheckIdle) {
        VitamConfiguration.intervalDelayCheckIdle = intervalDelayCheckIdle;
    }

    private static void setMaxDelayUnusedConnection(int maxDelayUnusedConnection) {
        VitamConfiguration.maxDelayUnusedConnection = maxDelayUnusedConnection;
    }

    private static void setUseNewJaxrClient(Boolean useNewJaxrClient) {
        VitamConfiguration.useNewJaxrClient = useNewJaxrClient;
    }

    private static void setSecurityDigestType(DigestType securityDigestType) {
        VitamConfiguration.securityDigestType = securityDigestType;
    }

    private static void setDefaultDigestType(DigestType defaultDigestType) {
        VitamConfiguration.defaultDigestType = defaultDigestType;
    }

    private static void setDefaultTimestampDigestType(DigestType defaultTimestampDigestType) {
        VitamConfiguration.defaultTimestampDigestType = defaultTimestampDigestType;
    }

    private static void setAcceptableRequestTime(int acceptableRequestTime) {
        VitamConfiguration.acceptableRequestTime = acceptableRequestTime;
    }

    private static void setCriticalRequestTime(int criticalRequestTime) {
        VitamConfiguration.criticalRequestTime = criticalRequestTime;
    }

    public static void setRequestTimeAlertThrottlingDelay(int requestTimeAlertThrottlingDelay) {
        VitamConfiguration.requestTimeAlertThrottlingDelay = requestTimeAlertThrottlingDelay;
    }

    private static void setRetryNumber(int retryNumber) {
        VitamConfiguration.retryNumber = retryNumber;
    }

    private static void setRetryDelay(int retryDelay) {
        VitamConfiguration.retryDelay = retryDelay;
    }

    private static void setWaitingDelay(int waitingDelay) {
        VitamConfiguration.waitingDelay = waitingDelay;
    }

    public static Boolean isAllowGzipEncoding() {
        return allowGzipEncoding;
    }

    private static void setAllowGzipEncoding(Boolean allowGzipEncoding) {
        VitamConfiguration.allowGzipEncoding = allowGzipEncoding;
    }

    public static Boolean isForceChunkModeInputStream() {
        return forceChunkModeInputStream;
    }

    private static void setForceChunkModeInputStream(Boolean forceChunkModeInputStream) {
        VitamConfiguration.forceChunkModeInputStream = forceChunkModeInputStream;
    }

    public static Boolean isAllowGzipDecoding() {
        return allowGzipDecoding;
    }

    private static void setAllowGzipDecoding(Boolean allowGzipDecoding) {
        VitamConfiguration.allowGzipDecoding = allowGzipDecoding;
    }

    public static Integer getBufferNumber() {
        return bufferNumber;
    }

    private static void setBufferNumber(int bufferNumber) {
        VitamConfiguration.bufferNumber = bufferNumber;
    }

    public static Integer getMaxConcurrentMultipleInputstreamHandler() {
        return maxConcurrentMultipleInputstreamHandler;
    }

    private static void setMaxConcurrentMultipleInputstreamHandler(int maxConcurrentMultipleInputstreamHandler) {
        VitamConfiguration.maxConcurrentMultipleInputstreamHandler = maxConcurrentMultipleInputstreamHandler;
    }

    public static String getDefaultLang() {
        return DEFAULT_LANG;
    }

    public static void setDefaultLang(String defaultLang) {
        DEFAULT_LANG = defaultLang;
    }

    public static int getDistributeurBatchSize() {
        return distributeurBatchSize;
    }

    public static void setDistributeurBatchSize(int distributeurBatchSize) {
        VitamConfiguration.distributeurBatchSize = distributeurBatchSize;
    }

    public static int getWorkerBulkSize() {
        return workerBulkSize;
    }

    public static void setWorkerBulkSize(int workerBulkSize) {
        VitamConfiguration.workerBulkSize = workerBulkSize;
    }

    public static int getRestoreBulkSize() {
        return restoreBulkSize;
    }

    public static void setRestoreBulkSize(int restoreBulkSize) {
        VitamConfiguration.restoreBulkSize = restoreBulkSize;
    }

    public static int getCacheControlDelay() {
        return cacheControlDelay;
    }

    public static void setCacheControlDelay(int cacheControlDelay) {
        VitamConfiguration.cacheControlDelay = cacheControlDelay;
    }

    public static int getMaxCacheEntries() {
        return maxCacheEntries;
    }

    public static void setMaxCacheEntries(int maxCacheEntries) {
        VitamConfiguration.maxCacheEntries = maxCacheEntries;
    }

    public static int getExpireCacheEntriesDelay() {
        return expireCacheEntriesDelay;
    }

    public static void setExpireCacheEntriesDelay(int expireCacheEntriesDelay) {
        VitamConfiguration.expireCacheEntriesDelay = expireCacheEntriesDelay;
    }

    public static boolean isExportScore() {
        return exportScore;
    }

    private static void setExportScore(boolean exportScore) {
        VitamConfiguration.exportScore = exportScore;
    }

    public static int getMaxElasticsearchBulk() {
        return maxElasticsearchBulk;
    }

    private static void setMaxElasticsearchBulk(int maxElasticsearchBulk) {
        VitamConfiguration.maxElasticsearchBulk = maxElasticsearchBulk;
    }

    public static int getNumberDbClientThread() {
        return numberDbClientThread;
    }

    private static void setNumberDbClientThread(int numberDbClientThread) {
        VitamConfiguration.numberDbClientThread = numberDbClientThread;
    }

    public static Integer getNumberEsQueue() {
        return numberEsQueue;
    }

    private static void setNumberEsQueue(int numberEsQueue) {
        VitamConfiguration.numberEsQueue = numberEsQueue;
    }

    public static long getDistributionThreshold() {
        return distributionThreshold;
    }

    public static void setDistributionThreshold(long distributionThreshold) {
        VitamConfiguration.distributionThreshold = distributionThreshold;
    }

    public static long getQueriesThreshold() {
        return queriesThreshold;
    }

    public static void setQueriesThreshold(long queriesThreshold) {
        VitamConfiguration.queriesThreshold = queriesThreshold;
    }

    public static int getBulkAtomicUpdateBatchSize() {
        return bulkAtomicUpdateBatchSize;
    }

    public static void setBulkAtomicUpdateBatchSize(int bulkAtomicUpdateBatchSize) {
        VitamConfiguration.bulkAtomicUpdateBatchSize = bulkAtomicUpdateBatchSize;
    }

    public static int getBulkAtomicUpdateThreadPoolSize() {
        return bulkAtomicUpdateThreadPoolSize;
    }

    public static void setBulkAtomicUpdateThreadPoolSize(int bulkAtomicUpdateThreadPoolSize) {
        VitamConfiguration.bulkAtomicUpdateThreadPoolSize = bulkAtomicUpdateThreadPoolSize;
    }

    public static int getBulkAtomicUpdateThreadPoolQueueSize() {
        return bulkAtomicUpdateThreadPoolQueueSize;
    }

    public static void setBulkAtomicUpdateThreadPoolQueueSize(int bulkAtomicUpdateThreadPoolQueueSize) {
        VitamConfiguration.bulkAtomicUpdateThreadPoolQueueSize = bulkAtomicUpdateThreadPoolQueueSize;
    }

    public static long getEliminationAnalysisThreshold() {
        return eliminationAnalysisThreshold;
    }

    public static void setEliminationAnalysisThreshold(long eliminationAnalysisThreshold) {
        VitamConfiguration.eliminationAnalysisThreshold = eliminationAnalysisThreshold;
    }

    public static long getEliminationActionThreshold() {
        return eliminationActionThreshold;
    }

    public static void setEliminationActionThreshold(long eliminationActionThreshold) {
        VitamConfiguration.eliminationActionThreshold = eliminationActionThreshold;
    }

    public static long getComputedInheritedRulesThreshold() {
        return computedInheritedRulesThreshold;
    }

    public static void setComputedInheritedRulesThreshold(long computedInheritedRulesThreshold) {
        VitamConfiguration.computedInheritedRulesThreshold = computedInheritedRulesThreshold;
    }

    public static long getOperationMaxSizeForExternal() {
        return operationMaxSizeForExternal;
    }

    public static void setOperationMaxSizeForExternal(long operationMaxSizeForExternal) {
        VitamConfiguration.operationMaxSizeForExternal = operationMaxSizeForExternal;
    }

    public static String getDefaultOriginatingAgencyForExport(Integer tenant) {
        if (defaultOriginatingAgencyByTenant.containsKey(tenant)) {
            return defaultOriginatingAgencyByTenant.get(tenant);
        }
        return DEFAULT_ORIGINATING_AGENCY_FOR_EXPORT;
    }

    public static void setDefaultOriginatingAgencyByTenant(Map<Integer, String> defaultOriginatingAgencyForExport) {
        defaultOriginatingAgencyByTenant = defaultOriginatingAgencyForExport;
    }

    public static void setVitamDefaultTransferringAgency(String vitamDefaultTransferringAgency) {
        VitamConfiguration.vitamDefaultTransferringAgency = vitamDefaultTransferringAgency;
    }

    public static String getVitamDefaultTransferringAgency() {
        return vitamDefaultTransferringAgency;
    }

    public static Map<String, String> getVitamDefaultCodeListVersion() {
        return vitamDefaultCodeListVersion;
    }

    public static void setVitamDefaultCodeListVersion(Map<String, String> vitamDefaultCodeListVersion) {
        VitamConfiguration.vitamDefaultCodeListVersion = vitamDefaultCodeListVersion;
    }

    public static int getMaxResultWindow() {
        return maxResultWindow;
    }

    public static void setMaxResultWindow(int maxResultWindow) {
        VitamConfiguration.maxResultWindow = maxResultWindow;
    }

    public static int getBatchSize() {
        return batchSize;
    }

    public static int getStoreGraphElementsPerFile() {
        return storeGraphElementsPerFile;
    }

    public static void setStoreGraphElementsPerFile(Integer storeGraphElementsPerFile) {
        VitamConfiguration.storeGraphElementsPerFile = storeGraphElementsPerFile;
    }

    public static Integer getStoreGraphOverlapDelay() {
        return storeGraphOverlapDelay;
    }

    public static void setStoreGraphOverlapDelay(Integer storeGraphOverlapDelay) {
        VitamConfiguration.storeGraphOverlapDelay = storeGraphOverlapDelay;
    }

    public static int getDeleteIncompleteReconstructedUnitDelay() {
        return deleteIncompleteReconstructedUnitDelay;
    }

    public static void setDeleteIncompleteReconstructedUnitDelay(int deleteIncompleteReconstructedUnitDelay) {
        VitamConfiguration.deleteIncompleteReconstructedUnitDelay = deleteIncompleteReconstructedUnitDelay;
    }

    public static int getOptimisticLockRetryNumber() {
        return optimisticLockRetryNumber;
    }

    public static void setOptimisticLockRetryNumber(int optimisticLockRetryNumber) {
        VitamConfiguration.optimisticLockRetryNumber = optimisticLockRetryNumber;
    }

    public static int getOptimisticLockSleepTime() {
        return optimisticLockSleepTime;
    }

    public static void setOptimisticLockSleepTime(int optimisticLockSleepTime) {
        VitamConfiguration.optimisticLockSleepTime = optimisticLockSleepTime;
    }

    public static int getKeywordMaxLength() {
        return keywordMaxLength;
    }

    public static void setKeywordMaxLength(int keywordMaxLength) {
        VitamConfiguration.keywordMaxLength = keywordMaxLength;
    }

    public static int getTextMaxLength() {
        return textMaxLength;
    }

    public static void setTextMaxLength(int textMaxLength) {
        VitamConfiguration.textMaxLength = textMaxLength;
    }

    public static int getDefaultOffset() {
        return 0;
    }

    public static void setBatchSize(int batchSize) {
        VitamConfiguration.batchSize = batchSize;
    }

    public static long getSwiftFileLimit() {
        return 4000000000L;
    }

    public static int getMigrationBulkSize() {
        return migrationBulkSize;
    }

    public static void setMigrationBulkSize(int migrationBulkSize) {
        VitamConfiguration.migrationBulkSize = migrationBulkSize;
    }

    public static String getWorkspaceWorkflowsFolder() {
        return workspaceWorkflowsFolder;
    }

    public static void setWorkspaceWorkflowsFolder(String workspaceWorkflowsFolder) {
        VitamConfiguration.workspaceWorkflowsFolder = workspaceWorkflowsFolder;
    }

    public static BinarySizePlatformThreshold getBinarySizePlatformThreshold() {
        return binarySizePlatformThreshold;
    }

    public static void setBinarySizePlatformThreshold(BinarySizePlatformThreshold binarySizePlatformThreshold) {
        VitamConfiguration.binarySizePlatformThreshold = binarySizePlatformThreshold;
    }

    public static List<BinarySizeTenantThreshold> getBinarySizeTenantThreshold() {
        return binarySizeTenantThreshold;
    }

    public static void setBinarySizeTenantThreshold(List<BinarySizeTenantThreshold> binarySizeTenantThreshold) {
        VitamConfiguration.binarySizeTenantThreshold = binarySizeTenantThreshold;
    }

    public static String getEnvironmentName() {
        return environmentName;
    }

    public static void setEnvironmentName(String environmentName) {
        VitamConfiguration.environmentName = environmentName;
    }

    public static int getReclassificationMaxBulkThreshold() {
        return reclassificationMaxBulkThreshold;
    }

    public static void setReclassificationMaxBulkThreshold(int reclassificationMaxBulkThreshold) {
        VitamConfiguration.reclassificationMaxBulkThreshold = reclassificationMaxBulkThreshold;
    }

    public static int getReclassificationMaxUnitsThreshold() {
        return reclassificationMaxUnitsThreshold;
    }

    public static void setReclassificationMaxUnitsThreshold(int reclassificationMaxUnitsThreshold) {
        VitamConfiguration.reclassificationMaxUnitsThreshold = reclassificationMaxUnitsThreshold;
    }

    public static int getReclassificationMaxGuildListSizeInLogbookOperation() {
        return reclassificationMaxGuildListSizeInLogbookOperation;
    }

    public static void setReclassificationMaxGuildListSizeInLogbookOperation(int reclassificationMaxGuildListSizeInLogbookOperation) {
        VitamConfiguration.reclassificationMaxGuildListSizeInLogbookOperation = reclassificationMaxGuildListSizeInLogbookOperation;
    }

    public static ClassificationLevel getClassificationLevel() {
        return classificationLevel;
    }

    public static void setClassificationLevel(ClassificationLevel classificationLevel) {
        VitamConfiguration.classificationLevel = classificationLevel;
    }

    public static String getVitamGriffinExecFolder() {
        return vitamGriffinExecFolder;
    }

    public static void setVitamGriffinExecFolder(String vitamGriffinExecFolder) {
        VitamConfiguration.vitamGriffinExecFolder = vitamGriffinExecFolder;
    }

    public static String getVitamGriffinInputFilesFolder() {
        return vitamGriffinInputFilesFolder;
    }

    public static void setVitamGriffinInputFilesFolder(String vitamGriffinInputFilesFolder) {
        VitamConfiguration.vitamGriffinInputFilesFolder = vitamGriffinInputFilesFolder;
    }

    public static List<String> getIndexInheritedRulesWithRulesIdByTenant() {
        return indexInheritedRulesWithRulesIdByTenant;
    }

    public static void setIndexInheritedRulesWithRulesIdByTenant(List<String> indexInheritedRulesWithRulesIdByTenant) {
        VitamConfiguration.indexInheritedRulesWithRulesIdByTenant = indexInheritedRulesWithRulesIdByTenant;
    }

    public static List<String> getIndexInheritedRulesWithAPIV2OutputByTenant() {
        return indexInheritedRulesWithAPIV2OutputByTenant;
    }

    public static void setIndexInheritedRulesWithAPIV2OutputByTenant(List<String> indexInheritedRulesWithAPIV2OutputByTenant) {
        VitamConfiguration.indexInheritedRulesWithAPIV2OutputByTenant = indexInheritedRulesWithAPIV2OutputByTenant;
    }

    public static Integer getElasticSearchScrollTimeoutInMilliseconds() {
        return elasticSearchScrollTimeoutInMilliseconds;
    }

    public static void setElasticSearchScrollTimeoutInMilliseconds(Integer elasticSearchScrollTimeoutInMilliseconds) {
        VitamConfiguration.elasticSearchScrollTimeoutInMilliseconds = elasticSearchScrollTimeoutInMilliseconds;
    }

    public static Integer getElasticSearchTimeoutWaitRequestInMilliseconds() {
        return elasticSearchTimeoutWaitRequestInMilliseconds;
    }

    public static void setElasticSearchTimeoutWaitRequestInMilliseconds(Integer elasticSearchTimeoutWaitRequestInMilliseconds) {
        VitamConfiguration.elasticSearchTimeoutWaitRequestInMilliseconds = elasticSearchTimeoutWaitRequestInMilliseconds;
    }

    public static Integer getElasticSearchScrollLimit() {
        return elasticSearchScrollLimit;
    }

    public static void setElasticSearchScrollLimit(Integer elasticSearchScrollLimit) {
        VitamConfiguration.elasticSearchScrollLimit = elasticSearchScrollLimit;
    }

    public static Map<Integer, List<String>> getEliminationReportExtraFields() {
        return eliminationReportExtraFields;
    }

    public static void setEliminationReportExtraFields(Map<Integer, List<String>> eliminationReportExtraFields) {
        VitamConfiguration.eliminationReportExtraFields = eliminationReportExtraFields;
    }

    public static short getDiffVersion() {
        return 1;
    }

    static {
        purgeTemporaryLFC = true;
        asyncWorkspaceQueueSize = 10;
        forceChunkModeInputStream = false;
        maxResultWindow = 10000;
        TENANTS = new ArrayList<Integer>();
        ADMIN_TENANT = -1;
        reclassificationMaxBulkThreshold = 1000;
        reclassificationMaxUnitsThreshold = 10000;
        reclassificationMaxGuildListSizeInLogbookOperation = 1000;
        indexInheritedRulesWithRulesIdByTenant = new ArrayList<String>();
        indexInheritedRulesWithAPIV2OutputByTenant = new ArrayList<String>();
        operationMaxSizeForExternal = 0xF00000L;
        processEngineWaitForStepTimeout = 172800;
        eliminationReportExtraFields = new HashMap<Integer, List<String>>();
        VitamConfiguration.getConfiguration().setDefault();
    }
}

