/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.common;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.VitamRuntimeException;
import fr.gouv.vitam.common.logging.SysErrLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;

public final class PropertiesUtils {
    private static final String FILE_NOT_FOUND_IN_RESOURCES = "File not found in Resources: ";
    private static final String ARGUMENTS_MUST_BE_NON_NULL = "Arguments must be non null";

    private PropertiesUtils() {
    }

    public static InputStream getConfigAsStream(String resourcesFile) throws FileNotFoundException {
        File file = new File(resourcesFile);
        if (!file.canRead()) {
            file = PropertiesUtils.fileFromConfigFolder(resourcesFile);
        }
        return file.canRead() ? new FileInputStream(file) : PropertiesUtils.getResourceAsStream(resourcesFile);
    }

    public static File getConfigFile(String resourcesFile) throws FileNotFoundException {
        File file = new File(resourcesFile);
        if (!file.canRead()) {
            file = PropertiesUtils.fileFromConfigFolder(resourcesFile);
        }
        return file.canRead() ? file : PropertiesUtils.getResourceFile(resourcesFile);
    }

    public static InputStream getResourceAsStream(String resourcesFile) throws FileNotFoundException {
        if (resourcesFile == null) {
            throw new FileNotFoundException(FILE_NOT_FOUND_IN_RESOURCES);
        }
        InputStream stream = null;
        try {
            stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcesFile);
        }
        catch (SecurityException e) {
            SysErrLogger.FAKE_LOGGER.ignoreLog(e);
        }
        if (stream == null) {
            try {
                stream = PropertiesUtils.class.getClassLoader().getResourceAsStream(resourcesFile);
            }
            catch (SecurityException e) {
                SysErrLogger.FAKE_LOGGER.ignoreLog(e);
            }
        }
        if (stream == null) {
            throw new FileNotFoundException(FILE_NOT_FOUND_IN_RESOURCES + resourcesFile);
        }
        return stream;
    }

    public static File getResourceFile(String resourcesFile) throws FileNotFoundException {
        File file;
        URL url;
        if (resourcesFile == null) {
            throw new FileNotFoundException(FILE_NOT_FOUND_IN_RESOURCES + resourcesFile);
        }
        try {
            url = PropertiesUtils.class.getClassLoader().getResource(resourcesFile);
        }
        catch (SecurityException e) {
            SysErrLogger.FAKE_LOGGER.ignoreLog(e);
            throw new FileNotFoundException(FILE_NOT_FOUND_IN_RESOURCES + resourcesFile);
        }
        if (url == null) {
            url = Thread.currentThread().getContextClassLoader().getResource(resourcesFile);
        }
        if (url == null) {
            throw new FileNotFoundException(FILE_NOT_FOUND_IN_RESOURCES + resourcesFile);
        }
        try {
            file = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            SysErrLogger.FAKE_LOGGER.ignoreLog(e);
            file = new File(URLDecoder.decode(url.getFile(), StandardCharsets.UTF_8));
        }
        if (file.exists()) {
            return file;
        }
        throw new FileNotFoundException(FILE_NOT_FOUND_IN_RESOURCES + resourcesFile);
    }

    public static Path getResourcePath(String resourcesFile) throws FileNotFoundException {
        return PropertiesUtils.getResourceFile(resourcesFile).toPath();
    }

    public static Stream<String> getResourceListing(Class clazz, String path) throws URISyntaxException, IOException {
        URL dirURL = clazz.getClassLoader().getResource(path);
        if (dirURL != null && dirURL.getProtocol().equals("file")) {
            return Arrays.stream(new File(dirURL.toURI()).list());
        }
        if (dirURL == null) {
            String me = clazz.getName().replace(".", "/") + ".class";
            dirURL = clazz.getClassLoader().getResource(me);
        }
        if (dirURL != null && dirURL.getProtocol().equals("jar")) {
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf(33));
            try (JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));){
                Enumeration<JarEntry> entries = jar.entries();
                HashSet<String> result = new HashSet<String>();
                while (entries.hasMoreElements()) {
                    String name = entries.nextElement().getName();
                    if (!name.startsWith(path)) continue;
                    String entry = name.substring(path.length());
                    int checkSubdir = entry.indexOf(47);
                    if (checkSubdir >= 0) {
                        entry = entry.substring(0, checkSubdir);
                    }
                    result.add(entry);
                }
                Stream<String> stream = result.stream();
                return stream;
            }
        }
        throw new UnsupportedOperationException("Cannot list files for URL " + dirURL);
    }

    public static File findFile(String filename) throws FileNotFoundException {
        File file = new File(filename);
        try {
            if (!file.exists() && !(file = PropertiesUtils.fileFromConfigFolder(filename)).exists()) {
                file = PropertiesUtils.getResourceFile(filename);
            }
        }
        catch (FileNotFoundException e) {
            SysErrLogger.FAKE_LOGGER.ignoreLog(e);
            throw new FileNotFoundException("File not found: " + filename);
        }
        if (!file.exists()) {
            throw new FileNotFoundException("File not found: " + filename);
        }
        return file;
    }

    public static File fileFromConfigFolder(String subpath) {
        return new File(VitamConfiguration.getVitamConfigFolder(), subpath);
    }

    public static File fileFromDataFolder(String subpath) {
        return new File(VitamConfiguration.getVitamDataFolder(), subpath);
    }

    static File fileFromLogFolder(String subpath) {
        return new File(VitamConfiguration.getVitamLogFolder(), subpath);
    }

    public static File fileFromTmpFolder(String subpath) {
        try {
            String canonicalPath = new File(VitamConfiguration.getVitamTmpFolder()).getCanonicalPath();
            File file = new File(VitamConfiguration.getVitamTmpFolder(), subpath);
            String fileCanonicalPath = file.getCanonicalPath();
            if (!fileCanonicalPath.startsWith(canonicalPath)) {
                throw new VitamRuntimeException(String.format("invalid path with subpath: %s", subpath));
            }
            return file;
        }
        catch (IOException e) {
            throw new VitamRuntimeException(e);
        }
    }

    public static Properties readProperties(File propertiesFile) throws IOException {
        if (propertiesFile == null) {
            throw new FileNotFoundException(FILE_NOT_FOUND_IN_RESOURCES + propertiesFile);
        }
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(propertiesFile);){
            properties.load(inputStream);
        }
        return properties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <C> C readYaml(File yamlFile, Class<C> clasz) throws IOException {
        if (yamlFile == null) throw new FileNotFoundException(ARGUMENTS_MUST_BE_NON_NULL);
        if (clasz == null) {
            throw new FileNotFoundException(ARGUMENTS_MUST_BE_NON_NULL);
        }
        try (FileReader yamlFileReader = new FileReader(yamlFile);){
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            C c = clasz.cast(mapper.readValue((Reader)yamlFileReader, clasz));
            return c;
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <C> C readYaml(File yamlFile, TypeReference<C> typeReference) throws IOException {
        if (yamlFile == null) throw new FileNotFoundException(ARGUMENTS_MUST_BE_NON_NULL);
        if (typeReference == null) {
            throw new FileNotFoundException(ARGUMENTS_MUST_BE_NON_NULL);
        }
        try (FileReader yamlFileReader = new FileReader(yamlFile);){
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            Object object = mapper.readValue((Reader)yamlFileReader, typeReference);
            return (C)object;
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
    }

    public static <C> C readYaml(InputStream yamlInputStream, Class<C> clasz) throws IOException {
        if (yamlInputStream == null || clasz == null) {
            throw new FileNotFoundException(ARGUMENTS_MUST_BE_NON_NULL);
        }
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        try {
            return clasz.cast(mapper.readValue(yamlInputStream, clasz));
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
    }

    public static <C> C readYaml(Path yamlPath, Class<C> clasz) throws IOException {
        if (yamlPath == null || clasz == null) {
            throw new FileNotFoundException(ARGUMENTS_MUST_BE_NON_NULL);
        }
        File file = yamlPath.toFile();
        return PropertiesUtils.readYaml(file, clasz);
    }

    public static void writeYaml(File destination, Object config) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(destination);){
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            mapper.writeValue((OutputStream)outputStream, config);
        }
    }

    public static String getResourceAsString(String resourcesFile) throws FileNotFoundException {
        if (resourcesFile == null) {
            throw new FileNotFoundException(FILE_NOT_FOUND_IN_RESOURCES);
        }
        String fileAsString = null;
        try {
            fileAsString = new String(Files.readAllBytes(PropertiesUtils.getResourcePath(resourcesFile)));
        }
        catch (SecurityException e) {
            SysErrLogger.FAKE_LOGGER.ignoreLog(e);
        }
        catch (IOException e) {
            throw new FileNotFoundException(FILE_NOT_FOUND_IN_RESOURCES + resourcesFile);
        }
        return fileAsString;
    }
}

