/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.distributor.rest;

import fr.gouv.vitam.common.database.parser.request.GlobalDatasParser;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.security.SanityChecker;
import fr.gouv.vitam.processing.common.exception.ProcessingBadRequestException;
import fr.gouv.vitam.processing.common.exception.WorkerFamilyNotFoundException;
import fr.gouv.vitam.processing.common.model.WorkerBean;
import fr.gouv.vitam.processing.distributor.api.IWorkerManager;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;

@Path(value="/processing/v1/worker_family")
@Tag(name="Processing")
public class ProcessDistributorResource {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(ProcessDistributorResource.class);
    private final IWorkerManager workerManager;

    public ProcessDistributorResource(IWorkerManager workerManager) {
        this.workerManager = workerManager;
        LOGGER.info("init Process Distributor Resource server");
    }

    @Path(value="/{id_family}/workers/{id_worker}")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response registerWorker(@Context HttpHeaders headers, @PathParam(value="id_family") String idFamily, @PathParam(value="id_worker") String idWorker, WorkerBean workerInformation) {
        try {
            String asString = JsonHandler.unprettyPrint((Object)workerInformation);
            SanityChecker.checkJsonAll((String)asString);
            GlobalDatasParser.sanityRequestCheck((String)asString);
            this.workerManager.registerWorker(idFamily, idWorker, workerInformation);
        }
        catch (InvalidParseOperationException | ProcessingBadRequestException | IllegalArgumentException exc) {
            LOGGER.error(exc);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{\"error\":\"" + exc.getMessage() + "\"}")).build();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"error\":\"" + e.getMessage() + "\"}")).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)("{\"success\" :\"Worker " + idWorker + " created \"}")).build();
    }

    @Path(value="/{id_family}/workers/{id_worker}")
    @DELETE
    @Produces(value={"application/json"})
    public Response unregisterWorker(@Context HttpHeaders headers, @PathParam(value="id_family") String idFamily, @PathParam(value="id_worker") String idWorker) {
        try {
            this.workerManager.unregisterWorker(idFamily, idWorker);
        }
        catch (WorkerFamilyNotFoundException exc) {
            LOGGER.error((Throwable)exc);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"error\":\"" + exc.getMessage() + "\"}")).build();
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"error\":\"" + e.getMessage() + "\"}")).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)("{\"success\" :\"Worker " + idWorker + " deleted \"}")).build();
    }
}

