/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.distributor.core;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.guid.GUIDFactory;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.common.model.ItemStatus;
import fr.gouv.vitam.common.model.processing.Step;
import fr.gouv.vitam.processing.common.async.AccessRequestContext;
import fr.gouv.vitam.processing.common.async.ProcessingRetryAsyncException;
import fr.gouv.vitam.processing.common.metrics.CommonProcessingMetrics;
import fr.gouv.vitam.processing.common.model.WorkerBean;
import fr.gouv.vitam.processing.distributor.core.WorkerTaskResult;
import fr.gouv.vitam.worker.client.WorkerClient;
import fr.gouv.vitam.worker.client.WorkerClientFactory;
import fr.gouv.vitam.worker.client.exception.WorkerClientException;
import fr.gouv.vitam.worker.client.exception.WorkerNotFoundClientException;
import fr.gouv.vitam.worker.client.exception.WorkerServerClientException;
import fr.gouv.vitam.worker.client.exception.WorkerUnreachableException;
import fr.gouv.vitam.worker.common.DescriptionStep;
import io.prometheus.client.Histogram;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class WorkerTask
implements Supplier<WorkerTaskResult> {
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(WorkerTask.class);
    private final DescriptionStep descriptionStep;
    private final int tenantId;
    private final String requestId;
    private final String taskId;
    private final String contractId;
    private final String contextId;
    private final String applicationId;
    private final WorkerClientFactory workerClientFactory;
    private final Histogram.Timer taskWaitingTimeDuration;

    public WorkerTask(DescriptionStep descriptionStep, int tenantId, String requestId, String contractId, String contextId, String applicationId, WorkerClientFactory workerClientFactory) {
        ParametersChecker.checkParameter((String)"Params are required", (Object[])new Object[]{descriptionStep, requestId});
        this.descriptionStep = descriptionStep;
        this.tenantId = tenantId;
        this.requestId = requestId;
        this.taskId = GUIDFactory.newGUID().getId();
        this.contractId = contractId;
        this.contextId = contextId;
        this.applicationId = applicationId;
        this.workerClientFactory = workerClientFactory;
        this.taskWaitingTimeDuration = ((Histogram.Child)CommonProcessingMetrics.WORKER_TASKS_IDLE_DURATION_IN_QUEUE.labels(new String[]{this.getStep().getWorkerGroupId(), descriptionStep.getWorkParams().getLogbookTypeProcess().name(), descriptionStep.getStep().getStepName()})).startTimer();
    }

    /*
     * Exception decompiling
     */
    @Override
    public WorkerTaskResult get() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 9[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkWorkerAvailability(WorkerBean workerBean, WorkerClient workerClient, WorkerClientException e) {
        for (int numberCallCheckStatus = 0; numberCallCheckStatus < 3; ++numberCallCheckStatus) {
            boolean checkStatus = this.checkStatusWorker(workerClient, workerBean.getConfiguration().getServerHost(), workerBean.getConfiguration().getServerPort());
            if (checkStatus) {
                return;
            }
            try {
                TimeUnit.MILLISECONDS.sleep(1000L);
                continue;
            }
            catch (InterruptedException e1) {
                LOGGER.warn((Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        throw new WorkerUnreachableException(workerBean.getWorkerId(), (Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkerTaskResult callWorker(WorkerBean workerBean, WorkerClient workerClient) throws WorkerNotFoundClientException, WorkerServerClientException {
        Histogram.Timer workerTaskTimer = ((Histogram.Child)CommonProcessingMetrics.WORKER_TASKS_EXECUTION_DURATION_HISTOGRAM.labels(new String[]{workerBean.getFamily(), workerBean.getName(), this.descriptionStep.getWorkParams().getLogbookTypeProcess().name(), this.descriptionStep.getStep().getStepName()})).startTimer();
        try {
            ItemStatus itemStatus = workerClient.submitStep(this.descriptionStep);
            WorkerTaskResult workerTaskResult = WorkerTaskResult.ofProceededTask(this, itemStatus);
            return workerTaskResult;
        }
        catch (ProcessingRetryAsyncException prae) {
            LOGGER.warn((Throwable)prae);
            HashMap<String, AccessRequestContext> asyncResources = new HashMap<String, AccessRequestContext>();
            for (AccessRequestContext context : prae.getAccessRequestIdByContext().keySet()) {
                for (String accessRequestId : (List)prae.getAccessRequestIdByContext().get(context)) {
                    asyncResources.put(accessRequestId, context);
                }
            }
            WorkerTaskResult workerTaskResult = WorkerTaskResult.ofTaskRequiringAsyncResourceAvailability(this, asyncResources);
            return workerTaskResult;
        }
        finally {
            workerTaskTimer.observeDuration();
        }
    }

    boolean checkStatusWorker(WorkerClient workerClient, String serverHost, int serverPort) {
        try {
            workerClient.checkStatus();
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Worker server [" + serverHost + ":" + serverPort + "] is not active.", (Throwable)e);
            return false;
        }
    }

    public Step getStep() {
        return this.descriptionStep.getStep();
    }

    public List<String> getObjectNameList() {
        return this.descriptionStep.getWorkParams().getObjectNameList();
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getRequestId() {
        return this.requestId;
    }
}

