/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.distributor.core;

import fr.gouv.vitam.common.ParametersChecker;
import fr.gouv.vitam.common.PropertiesUtils;
import fr.gouv.vitam.common.VitamConfiguration;
import fr.gouv.vitam.common.exception.InvalidParseOperationException;
import fr.gouv.vitam.common.json.JsonHandler;
import fr.gouv.vitam.common.logging.VitamLogger;
import fr.gouv.vitam.common.logging.VitamLoggerFactory;
import fr.gouv.vitam.processing.common.exception.ProcessingBadRequestException;
import fr.gouv.vitam.processing.common.exception.WorkerFamilyNotFoundException;
import fr.gouv.vitam.processing.common.model.WorkerBean;
import fr.gouv.vitam.processing.distributor.api.IWorkerManager;
import fr.gouv.vitam.processing.distributor.core.WorkerExecutor;
import fr.gouv.vitam.processing.distributor.core.WorkerFamilyManager;
import fr.gouv.vitam.worker.client.WorkerClient;
import fr.gouv.vitam.worker.client.WorkerClientConfiguration;
import fr.gouv.vitam.worker.client.WorkerClientFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class WorkerManager
implements IWorkerManager {
    public static final int QUEUE_SIZE = 15;
    private static final VitamLogger LOGGER = VitamLoggerFactory.getInstance(WorkerManager.class);
    private final ConcurrentMap<String, WorkerFamilyManager> workersFamily = new ConcurrentHashMap<String, WorkerFamilyManager>();
    private WorkerClientFactory workerClientFactory = null;

    public WorkerManager() {
    }

    public WorkerManager(WorkerClientFactory workerClientFactory) {
        this.workerClientFactory = workerClientFactory;
    }

    @Override
    public synchronized void marshallToDB() throws IOException {
        if (!this.getWorkerDbFile().exists()) {
            if (Files.notExists(Paths.get(VitamConfiguration.getVitamDataFolder(), new String[0]), new LinkOption[0])) {
                Files.createDirectories(Paths.get(VitamConfiguration.getVitamDataFolder(), new String[0]), new FileAttribute[0]);
            }
            Files.createFile(this.getWorkerDbFile().toPath(), new FileAttribute[0]);
        }
        ArrayList<WorkerBean> registeredWorkers = new ArrayList<WorkerBean>();
        for (Map.Entry family : this.workersFamily.entrySet()) {
            for (Map.Entry<String, WorkerExecutor> worker : ((WorkerFamilyManager)family.getValue()).getWorkers().entrySet()) {
                WorkerBean workerBean = worker.getValue().getWorkerBean();
                registeredWorkers.add(workerBean);
            }
        }
        try {
            JsonHandler.writeAsFile(registeredWorkers, (File)this.getWorkerDbFile());
        }
        catch (InvalidParseOperationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void registerWorker(String familyId, String workerId, WorkerBean workerInformation) throws ProcessingBadRequestException, IOException {
        ParametersChecker.checkParameter((String)"All arguments are required", (Object[])new Object[]{familyId, workerId, workerInformation});
        if (!workerInformation.getFamily().equals(familyId)) {
            throw new ProcessingBadRequestException("Cannot register a worker of another family!");
        }
        workerInformation.setWorkerId(workerId);
        this.registerWorker(workerInformation);
    }

    @Override
    public void registerWorker(WorkerBean workerBean) throws IOException {
        this.workersFamily.compute(workerBean.getFamily(), (key, workerManager) -> {
            if (workerManager == null) {
                workerManager = new WorkerFamilyManager(workerBean.getFamily(), 15);
            }
            workerManager.registerWorker(workerBean);
            return workerManager;
        });
        this.marshallToDB();
    }

    @Override
    public void unregisterWorker(String workerFamily, String worker) throws WorkerFamilyNotFoundException, IOException {
        WorkerFamilyManager workerManager = (WorkerFamilyManager)this.workersFamily.get(workerFamily);
        if (workerManager == null) {
            throw new WorkerFamilyNotFoundException("Worker : " + worker + " not found in the family :" + workerFamily);
        }
        workerManager.unregisterWorker(worker);
        this.marshallToDB();
    }

    @Override
    public boolean checkStatusWorker(String serverHost, int serverPort) {
        if (null == this.workerClientFactory) {
            WorkerClientConfiguration workerClientConfiguration = new WorkerClientConfiguration(serverHost, serverPort);
            WorkerClientFactory.changeMode((WorkerClientConfiguration)workerClientConfiguration);
            return this.checkStatus(serverHost, serverPort, WorkerClientFactory.getInstance((WorkerClientConfiguration)workerClientConfiguration));
        }
        return this.checkStatus(serverHost, serverPort, this.workerClientFactory);
    }

    private boolean checkStatus(String serverHost, int serverPort, WorkerClientFactory workerClientFactory) {
        boolean bl;
        block8: {
            WorkerClient workerClient = workerClientFactory.getClient();
            try {
                workerClient.checkStatus();
                bl = true;
                if (workerClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (workerClient != null) {
                        try {
                            workerClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error("Worker server [" + serverHost + ":" + serverPort + "] is not active.", (Throwable)e);
                    return false;
                }
            }
            workerClient.close();
        }
        return bl;
    }

    @Override
    public WorkerFamilyManager findWorkerBy(String workerFamily) {
        return (WorkerFamilyManager)this.workersFamily.get(workerFamily);
    }

    @Override
    public File getWorkerDbFile() {
        return PropertiesUtils.fileFromDataFolder((String)"worker.db");
    }
}

