/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.processing.distributor.core;

import fr.gouv.vitam.common.thread.VitamThreadFactory;
import fr.gouv.vitam.processing.common.metrics.CommonProcessingMetrics;
import fr.gouv.vitam.processing.common.model.WorkerBean;
import fr.gouv.vitam.processing.distributor.core.PriorityTaskQueue;
import fr.gouv.vitam.processing.distributor.core.WorkerExecutor;
import io.prometheus.client.Gauge;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;

public class WorkerFamilyManager {
    private final String family;
    private final PriorityTaskQueue<Runnable> queue;
    private final Map<String, WorkerExecutor> workers = new ConcurrentHashMap<String, WorkerExecutor>();

    public WorkerFamilyManager(String family, int queueSize) {
        if (queueSize < 2) {
            throw new IllegalArgumentException("queue size must be greater than 2");
        }
        this.family = family;
        this.queue = new PriorityTaskQueue(queueSize);
    }

    public void registerWorker(WorkerBean workerBean) {
        this.workers.computeIfAbsent(workerBean.getWorkerId(), key -> {
            WorkerExecutor executor = new WorkerExecutor(this.queue, workerBean);
            for (int i = 0; i < workerBean.getCapacity(); ++i) {
                Thread thread = VitamThreadFactory.getInstance().newThread((Runnable)executor);
                thread.setName("WorkerExecutor_" + workerBean.getWorkerId() + "_" + i);
                thread.start();
            }
            ((Gauge.Child)CommonProcessingMetrics.REGISTERED_WORKERS.labels(new String[]{this.family})).inc();
            return executor;
        });
    }

    public void unregisterWorker(String workerId) {
        WorkerExecutor workerExecutor = this.workers.get(workerId);
        if (workerExecutor != null) {
            workerExecutor.stop();
            this.workers.remove(workerId);
            ((Gauge.Child)CommonProcessingMetrics.REGISTERED_WORKERS.labels(new String[]{this.family})).dec();
        }
    }

    public Executor getExecutor(boolean isHighPriorityTask) {
        return command -> {
            try {
                ((Gauge.Child)CommonProcessingMetrics.WORKER_TASKS_IN_QUEUE.labels(new String[]{this.family})).inc();
                if (isHighPriorityTask) {
                    this.queue.addHighPriorityEntry(command);
                } else {
                    this.queue.addRegularEntry(command);
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public Map<String, WorkerExecutor> getWorkers() {
        return this.workers;
    }

    public String getFamily() {
        return this.family;
    }
}

